/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.epic.debug.ui.PerlConsoleHyperlink;

public class PerlConsoleTracker
implements IPatternMatchListenerDelegate {
    private final Pattern FILE_LINE_PATTERN = Pattern.compile(".*? at ((\\S+) line (\\d+))\\.");
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        block4: {
            try {
                int line;
                int offset = event.getOffset();
                int length = event.getLength();
                String matchText = this.console.getDocument().get(offset, length);
                Matcher m = this.FILE_LINE_PATTERN.matcher(matchText);
                if (!m.matches()) break block4;
                String path = m.group(2);
                try {
                    line = Integer.parseInt(m.group(3));
                }
                catch (NumberFormatException numberFormatException) {
                    line = 1;
                }
                PerlConsoleHyperlink link = new PerlConsoleHyperlink(path, line);
                this.console.addHyperlink((IHyperlink)link, offset + m.start(1), m.end(1) - m.start(1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

