/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.ui.ArgumentsBlock;
import org.epic.debug.ui.PerlDebugImages;
import org.epic.debug.ui.WorkingDirectoryBlock;

public class LaunchConfigurationArgumentsTab
extends AbstractLaunchConfigurationTab {
    private ArgumentsBlock fPerlArgumentsBlock = this.createPerlArgsBlock();
    private ArgumentsBlock fProgramArgumentsBlock;
    private WorkingDirectoryBlock fWorkingDirectoryBlock;

    public LaunchConfigurationArgumentsTab(boolean perlArgumentsOnly) {
        if (!perlArgumentsOnly) {
            this.fProgramArgumentsBlock = this.createProgramArgsBlock();
            this.fWorkingDirectoryBlock = this.createWorkingDirBlock();
        }
    }

    protected ArgumentsBlock createPerlArgsBlock() {
        return new ArgumentsBlock("Perl ar&guments:", "ATTR_PERL_PARAMETERS");
    }

    protected ArgumentsBlock createProgramArgsBlock() {
        return new ArgumentsBlock("Program &arguments:", "ATTR_PROGRAM_PARAMETERS");
    }

    protected WorkingDirectoryBlock createWorkingDirBlock() {
        return new WorkingDirectoryBlock();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        if (this.fProgramArgumentsBlock != null) {
            this.fProgramArgumentsBlock.createControl(comp);
        }
        if (this.fPerlArgumentsBlock != null) {
            this.fPerlArgumentsBlock.createControl(comp);
        }
        if (this.fWorkingDirectoryBlock != null) {
            this.fWorkingDirectoryBlock.createControl(comp);
        }
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock != null ? this.fWorkingDirectoryBlock.isValid(config) : true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.fProgramArgumentsBlock != null) {
            this.fProgramArgumentsBlock.setDefaults(config);
        }
        if (this.fPerlArgumentsBlock != null) {
            this.fPerlArgumentsBlock.setDefaults(config);
        }
        if (this.fWorkingDirectoryBlock != null) {
            this.fWorkingDirectoryBlock.setDefaults(config);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fProgramArgumentsBlock != null) {
            this.fProgramArgumentsBlock.initializeFrom(configuration);
        }
        if (this.fPerlArgumentsBlock != null) {
            this.fPerlArgumentsBlock.initializeFrom(configuration);
        }
        if (this.fWorkingDirectoryBlock != null) {
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fProgramArgumentsBlock != null) {
            this.fProgramArgumentsBlock.performApply(configuration);
        }
        if (this.fPerlArgumentsBlock != null) {
            this.fPerlArgumentsBlock.performApply(configuration);
        }
        if (this.fWorkingDirectoryBlock != null) {
            this.fWorkingDirectoryBlock.performApply(configuration);
        }
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        return content.length() > 0 ? content : null;
    }

    public String getName() {
        return "Arguments";
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        if (this.fWorkingDirectoryBlock != null) {
            this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        }
        if (this.fProgramArgumentsBlock != null) {
            this.fProgramArgumentsBlock.setLaunchConfigurationDialog(dialog);
        }
        if (this.fPerlArgumentsBlock != null) {
            this.fPerlArgumentsBlock.setLaunchConfigurationDialog(dialog);
        }
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null && this.fWorkingDirectoryBlock != null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null && this.fWorkingDirectoryBlock != null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_LaunchTabArguments);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

