require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NET80211_IEEE80211_H_)) {
    eval 'sub _NET80211_IEEE80211_H_ () {1;}' unless defined(&_NET80211_IEEE80211_H_);
    eval 'sub IEEE80211_ADDR_LEN () {6;}' unless defined(&IEEE80211_ADDR_LEN);
    eval 'sub IEEE80211_IS_MULTICAST {
        my($_a) = @_;
	    eval q((*($_a) & 0x1));
    }' unless defined(&IEEE80211_IS_MULTICAST);
    eval 'sub IEEE80211_FC0_VERSION_MASK () {0x3;}' unless defined(&IEEE80211_FC0_VERSION_MASK);
    eval 'sub IEEE80211_FC0_VERSION_SHIFT () {0;}' unless defined(&IEEE80211_FC0_VERSION_SHIFT);
    eval 'sub IEEE80211_FC0_VERSION_0 () {0x;}' unless defined(&IEEE80211_FC0_VERSION_0);
    eval 'sub IEEE80211_FC0_TYPE_MASK () {0xc;}' unless defined(&IEEE80211_FC0_TYPE_MASK);
    eval 'sub IEEE80211_FC0_TYPE_SHIFT () {2;}' unless defined(&IEEE80211_FC0_TYPE_SHIFT);
    eval 'sub IEEE80211_FC0_TYPE_MGT () {0x;}' unless defined(&IEEE80211_FC0_TYPE_MGT);
    eval 'sub IEEE80211_FC0_TYPE_CTL () {0x4;}' unless defined(&IEEE80211_FC0_TYPE_CTL);
    eval 'sub IEEE80211_FC0_TYPE_DATA () {0x8;}' unless defined(&IEEE80211_FC0_TYPE_DATA);
    eval 'sub IEEE80211_FC0_SUBTYPE_MASK () {0xf0;}' unless defined(&IEEE80211_FC0_SUBTYPE_MASK);
    eval 'sub IEEE80211_FC0_SUBTYPE_SHIFT () {4;}' unless defined(&IEEE80211_FC0_SUBTYPE_SHIFT);
    eval 'sub IEEE80211_FC0_SUBTYPE_ASSOC_REQ () {0x;}' unless defined(&IEEE80211_FC0_SUBTYPE_ASSOC_REQ);
    eval 'sub IEEE80211_FC0_SUBTYPE_ASSOC_RESP () {0x10;}' unless defined(&IEEE80211_FC0_SUBTYPE_ASSOC_RESP);
    eval 'sub IEEE80211_FC0_SUBTYPE_REASSOC_REQ () {0x20;}' unless defined(&IEEE80211_FC0_SUBTYPE_REASSOC_REQ);
    eval 'sub IEEE80211_FC0_SUBTYPE_REASSOC_RESP () {0x30;}' unless defined(&IEEE80211_FC0_SUBTYPE_REASSOC_RESP);
    eval 'sub IEEE80211_FC0_SUBTYPE_PROBE_REQ () {0x40;}' unless defined(&IEEE80211_FC0_SUBTYPE_PROBE_REQ);
    eval 'sub IEEE80211_FC0_SUBTYPE_PROBE_RESP () {0x50;}' unless defined(&IEEE80211_FC0_SUBTYPE_PROBE_RESP);
    eval 'sub IEEE80211_FC0_SUBTYPE_BEACON () {0x80;}' unless defined(&IEEE80211_FC0_SUBTYPE_BEACON);
    eval 'sub IEEE80211_FC0_SUBTYPE_ATIM () {0x90;}' unless defined(&IEEE80211_FC0_SUBTYPE_ATIM);
    eval 'sub IEEE80211_FC0_SUBTYPE_DISASSOC () {0xa0;}' unless defined(&IEEE80211_FC0_SUBTYPE_DISASSOC);
    eval 'sub IEEE80211_FC0_SUBTYPE_AUTH () {0xb0;}' unless defined(&IEEE80211_FC0_SUBTYPE_AUTH);
    eval 'sub IEEE80211_FC0_SUBTYPE_DEAUTH () {0xc0;}' unless defined(&IEEE80211_FC0_SUBTYPE_DEAUTH);
    eval 'sub IEEE80211_FC0_SUBTYPE_ACTION () {0xd0;}' unless defined(&IEEE80211_FC0_SUBTYPE_ACTION);
    eval 'sub IEEE80211_FC0_SUBTYPE_ACTION_NOACK () {0xe0;}' unless defined(&IEEE80211_FC0_SUBTYPE_ACTION_NOACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_WRAPPER () {0x70;}' unless defined(&IEEE80211_FC0_SUBTYPE_WRAPPER);
    eval 'sub IEEE80211_FC0_SUBTYPE_BAR () {0x80;}' unless defined(&IEEE80211_FC0_SUBTYPE_BAR);
    eval 'sub IEEE80211_FC0_SUBTYPE_BA () {0x90;}' unless defined(&IEEE80211_FC0_SUBTYPE_BA);
    eval 'sub IEEE80211_FC0_SUBTYPE_PS_POLL () {0xa0;}' unless defined(&IEEE80211_FC0_SUBTYPE_PS_POLL);
    eval 'sub IEEE80211_FC0_SUBTYPE_RTS () {0xb0;}' unless defined(&IEEE80211_FC0_SUBTYPE_RTS);
    eval 'sub IEEE80211_FC0_SUBTYPE_CTS () {0xc0;}' unless defined(&IEEE80211_FC0_SUBTYPE_CTS);
    eval 'sub IEEE80211_FC0_SUBTYPE_ACK () {0xd0;}' unless defined(&IEEE80211_FC0_SUBTYPE_ACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_END () {0xe0;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_END);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_END_ACK () {0xf0;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_END_ACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_DATA () {0x;}' unless defined(&IEEE80211_FC0_SUBTYPE_DATA);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_ACK () {0x10;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_ACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_POLL () {0x20;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_POLL);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_ACPL () {0x30;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_ACPL);
    eval 'sub IEEE80211_FC0_SUBTYPE_NODATA () {0x40;}' unless defined(&IEEE80211_FC0_SUBTYPE_NODATA);
    eval 'sub IEEE80211_FC0_SUBTYPE_CFACK () {0x50;}' unless defined(&IEEE80211_FC0_SUBTYPE_CFACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_CFPOLL () {0x60;}' unless defined(&IEEE80211_FC0_SUBTYPE_CFPOLL);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_ACK_CF_ACK () {0x70;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_ACK_CF_ACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_QOS () {0x80;}' unless defined(&IEEE80211_FC0_SUBTYPE_QOS);
    eval 'sub IEEE80211_FC1_DIR_MASK () {0x3;}' unless defined(&IEEE80211_FC1_DIR_MASK);
    eval 'sub IEEE80211_FC1_DIR_NODS () {0x;}' unless defined(&IEEE80211_FC1_DIR_NODS);
    eval 'sub IEEE80211_FC1_DIR_TODS () {0x1;}' unless defined(&IEEE80211_FC1_DIR_TODS);
    eval 'sub IEEE80211_FC1_DIR_FROMDS () {0x2;}' unless defined(&IEEE80211_FC1_DIR_FROMDS);
    eval 'sub IEEE80211_FC1_DIR_DSTODS () {0x3;}' unless defined(&IEEE80211_FC1_DIR_DSTODS);
    eval 'sub IEEE80211_FC1_MORE_FRAG () {0x4;}' unless defined(&IEEE80211_FC1_MORE_FRAG);
    eval 'sub IEEE80211_FC1_RETRY () {0x8;}' unless defined(&IEEE80211_FC1_RETRY);
    eval 'sub IEEE80211_FC1_PWR_MGT () {0x10;}' unless defined(&IEEE80211_FC1_PWR_MGT);
    eval 'sub IEEE80211_FC1_MORE_DATA () {0x20;}' unless defined(&IEEE80211_FC1_MORE_DATA);
    eval 'sub IEEE80211_FC1_PROTECTED () {0x40;}' unless defined(&IEEE80211_FC1_PROTECTED);
    eval 'sub IEEE80211_FC1_WEP () {0x40;}' unless defined(&IEEE80211_FC1_WEP);
    eval 'sub IEEE80211_FC1_ORDER () {0x80;}' unless defined(&IEEE80211_FC1_ORDER);
    eval 'sub IEEE80211_FC1_BITS () {"\\20\\03MORE_FRAG\\04RETRY\\05PWR_MGT\\06MORE_DATA" "\\07PROTECTED\\08ORDER";}' unless defined(&IEEE80211_FC1_BITS);
    eval 'sub IEEE80211_SEQ_FRAG_MASK () {0xf;}' unless defined(&IEEE80211_SEQ_FRAG_MASK);
    eval 'sub IEEE80211_SEQ_FRAG_SHIFT () {0;}' unless defined(&IEEE80211_SEQ_FRAG_SHIFT);
    eval 'sub IEEE80211_SEQ_SEQ_MASK () {0xfff0;}' unless defined(&IEEE80211_SEQ_SEQ_MASK);
    eval 'sub IEEE80211_SEQ_SEQ_SHIFT () {4;}' unless defined(&IEEE80211_SEQ_SEQ_SHIFT);
    eval 'sub IEEE80211_NWID_LEN () {32;}' unless defined(&IEEE80211_NWID_LEN);
    eval 'sub IEEE80211_MMIE_LEN () {18;}' unless defined(&IEEE80211_MMIE_LEN);
    eval 'sub IEEE80211_QOS_TXOP () {0xff00;}' unless defined(&IEEE80211_QOS_TXOP);
    eval 'sub IEEE80211_QOS_AMSDU () {0x80;}' unless defined(&IEEE80211_QOS_AMSDU);
    eval 'sub IEEE80211_QOS_ACK_POLICY_NORMAL () {0x;}' unless defined(&IEEE80211_QOS_ACK_POLICY_NORMAL);
    eval 'sub IEEE80211_QOS_ACK_POLICY_NOACK () {0x20;}' unless defined(&IEEE80211_QOS_ACK_POLICY_NOACK);
    eval 'sub IEEE80211_QOS_ACK_POLICY_NOEXPLACK () {0x40;}' unless defined(&IEEE80211_QOS_ACK_POLICY_NOEXPLACK);
    eval 'sub IEEE80211_QOS_ACK_POLICY_BA () {0x60;}' unless defined(&IEEE80211_QOS_ACK_POLICY_BA);
    eval 'sub IEEE80211_QOS_ACK_POLICY_MASK () {0x60;}' unless defined(&IEEE80211_QOS_ACK_POLICY_MASK);
    eval 'sub IEEE80211_QOS_ACK_POLICY_SHIFT () {5;}' unless defined(&IEEE80211_QOS_ACK_POLICY_SHIFT);
    eval 'sub IEEE80211_QOS_EOSP () {0x10;}' unless defined(&IEEE80211_QOS_EOSP);
    eval 'sub IEEE80211_QOS_TID () {0xf;}' unless defined(&IEEE80211_QOS_TID);
    if(defined(&_KERNEL)) {
	eval 'sub ieee80211_has_seq {
	    my($wh) = @_;
    	    eval q({ ( ($wh->{i_fc[0]}) &  &IEEE80211_FC0_TYPE_MASK) !=  &IEEE80211_FC0_TYPE_CTL; });
	}' unless defined(&ieee80211_has_seq);
	eval 'sub ieee80211_has_addr4 {
	    my($wh) = @_;
    	    eval q({ ( ($wh->{i_fc[1]}) &  &IEEE80211_FC1_DIR_MASK) ==  &IEEE80211_FC1_DIR_DSTODS; });
	}' unless defined(&ieee80211_has_addr4);
	eval 'sub ieee80211_has_qos {
	    my($wh) = @_;
    	    eval q({ ( ($wh->{i_fc[0]}) & ( &IEEE80211_FC0_TYPE_MASK |  &IEEE80211_FC0_SUBTYPE_QOS)) == ( &IEEE80211_FC0_TYPE_DATA |  &IEEE80211_FC0_SUBTYPE_QOS); });
	}' unless defined(&ieee80211_has_qos);
	eval 'sub ieee80211_has_htc {
	    my($wh) = @_;
    	    eval q({ ( ($wh->{i_fc[1]}) &  &IEEE80211_FC1_ORDER)  && ( &ieee80211_has_qos($wh) || ( ($wh->{i_fc[0]}) &  &IEEE80211_FC0_TYPE_MASK) ==  &IEEE80211_FC0_TYPE_MGT); });
	}' unless defined(&ieee80211_has_htc);
	eval 'sub ieee80211_get_qos {
	    my($wh) = @_;
    	    eval q({  &const  &u_int8_t * &frm;  &if ( &ieee80211_has_addr4($wh))  &frm = (( &const \'struct ieee80211_qosframe_addr4\' *)$wh)-> &i_qos;  &else  &frm = (( &const \'struct ieee80211_qosframe\' *)$wh)-> &i_qos;  &letoh16(*( &const  &u_int16_t *) &frm); });
	}' unless defined(&ieee80211_get_qos);
    }
    eval 'sub IEEE80211_CAPINFO_ESS () {0x1;}' unless defined(&IEEE80211_CAPINFO_ESS);
    eval 'sub IEEE80211_CAPINFO_IBSS () {0x2;}' unless defined(&IEEE80211_CAPINFO_IBSS);
    eval 'sub IEEE80211_CAPINFO_CF_POLLABLE () {0x4;}' unless defined(&IEEE80211_CAPINFO_CF_POLLABLE);
    eval 'sub IEEE80211_CAPINFO_CF_POLLREQ () {0x8;}' unless defined(&IEEE80211_CAPINFO_CF_POLLREQ);
    eval 'sub IEEE80211_CAPINFO_PRIVACY () {0x10;}' unless defined(&IEEE80211_CAPINFO_PRIVACY);
    eval 'sub IEEE80211_CAPINFO_SHORT_PREAMBLE () {0x20;}' unless defined(&IEEE80211_CAPINFO_SHORT_PREAMBLE);
    eval 'sub IEEE80211_CAPINFO_PBCC () {0x40;}' unless defined(&IEEE80211_CAPINFO_PBCC);
    eval 'sub IEEE80211_CAPINFO_CHNL_AGILITY () {0x80;}' unless defined(&IEEE80211_CAPINFO_CHNL_AGILITY);
    eval 'sub IEEE80211_CAPINFO_SPECTRUM_MGMT () {0x100;}' unless defined(&IEEE80211_CAPINFO_SPECTRUM_MGMT);
    eval 'sub IEEE80211_CAPINFO_QOS () {0x200;}' unless defined(&IEEE80211_CAPINFO_QOS);
    eval 'sub IEEE80211_CAPINFO_SHORT_SLOTTIME () {0x400;}' unless defined(&IEEE80211_CAPINFO_SHORT_SLOTTIME);
    eval 'sub IEEE80211_CAPINFO_APSD () {0x800;}' unless defined(&IEEE80211_CAPINFO_APSD);
    eval 'sub IEEE80211_CAPINFO_RADIO_MEASUREMENT () {0x1000;}' unless defined(&IEEE80211_CAPINFO_RADIO_MEASUREMENT);
    eval 'sub IEEE80211_CAPINFO_DSSSOFDM () {0x2000;}' unless defined(&IEEE80211_CAPINFO_DSSSOFDM);
    eval 'sub IEEE80211_CAPINFO_DELAYED_B_ACK () {0x4000;}' unless defined(&IEEE80211_CAPINFO_DELAYED_B_ACK);
    eval 'sub IEEE80211_CAPINFO_IMMEDIATE_B_ACK () {0x8000;}' unless defined(&IEEE80211_CAPINFO_IMMEDIATE_B_ACK);
    eval 'sub IEEE80211_CAPINFO_BITS () {"\\10\\01ESS\\02IBSS\\03CF_POLLABLE\\04CF_POLLREQ" "\\05PRIVACY\\06SHORT_PREAMBLE\\07PBCC\\10CHNL_AGILITY" "\\11SPECTRUM_MGMT\\12QOS\\13SHORT_SLOTTIME\\14APSD" "\\15RADIO_MEASUREMENT\\16DSSSOFDM\\17DELAYED_B_ACK\\20IMMEDIATE_B_ACK";}' unless defined(&IEEE80211_CAPINFO_BITS);
    eval("sub IEEE80211_ELEMID_SSID () { 0; }") unless defined(&IEEE80211_ELEMID_SSID);
    eval("sub IEEE80211_ELEMID_RATES () { 1; }") unless defined(&IEEE80211_ELEMID_RATES);
    eval("sub IEEE80211_ELEMID_FHPARMS () { 2; }") unless defined(&IEEE80211_ELEMID_FHPARMS);
    eval("sub IEEE80211_ELEMID_DSPARMS () { 3; }") unless defined(&IEEE80211_ELEMID_DSPARMS);
    eval("sub IEEE80211_ELEMID_CFPARMS () { 4; }") unless defined(&IEEE80211_ELEMID_CFPARMS);
    eval("sub IEEE80211_ELEMID_TIM () { 5; }") unless defined(&IEEE80211_ELEMID_TIM);
    eval("sub IEEE80211_ELEMID_IBSSPARMS () { 6; }") unless defined(&IEEE80211_ELEMID_IBSSPARMS);
    eval("sub IEEE80211_ELEMID_COUNTRY () { 7; }") unless defined(&IEEE80211_ELEMID_COUNTRY);
    eval("sub IEEE80211_ELEMID_HOPPING_PARMS () { 8; }") unless defined(&IEEE80211_ELEMID_HOPPING_PARMS);
    eval("sub IEEE80211_ELEMID_HOPPING_PATTERN () { 9; }") unless defined(&IEEE80211_ELEMID_HOPPING_PATTERN);
    eval("sub IEEE80211_ELEMID_REQUEST () { 10; }") unless defined(&IEEE80211_ELEMID_REQUEST);
    eval("sub IEEE80211_ELEMID_QBSS_LOAD () { 11; }") unless defined(&IEEE80211_ELEMID_QBSS_LOAD);
    eval("sub IEEE80211_ELEMID_EDCAPARMS () { 12; }") unless defined(&IEEE80211_ELEMID_EDCAPARMS);
    eval("sub IEEE80211_ELEMID_TSPEC () { 13; }") unless defined(&IEEE80211_ELEMID_TSPEC);
    eval("sub IEEE80211_ELEMID_TCLASS () { 14; }") unless defined(&IEEE80211_ELEMID_TCLASS);
    eval("sub IEEE80211_ELEMID_SCHEDULE () { 15; }") unless defined(&IEEE80211_ELEMID_SCHEDULE);
    eval("sub IEEE80211_ELEMID_CHALLENGE () { 16; }") unless defined(&IEEE80211_ELEMID_CHALLENGE);
    eval("sub IEEE80211_ELEMID_POWER_CONSTRAINT () { 32; }") unless defined(&IEEE80211_ELEMID_POWER_CONSTRAINT);
    eval("sub IEEE80211_ELEMID_POWER_CAP () { 33; }") unless defined(&IEEE80211_ELEMID_POWER_CAP);
    eval("sub IEEE80211_ELEMID_TPC_REQUEST () { 34; }") unless defined(&IEEE80211_ELEMID_TPC_REQUEST);
    eval("sub IEEE80211_ELEMID_TPC_REPORT () { 35; }") unless defined(&IEEE80211_ELEMID_TPC_REPORT);
    eval("sub IEEE80211_ELEMID_SUPP_CHNLS () { 35; }") unless defined(&IEEE80211_ELEMID_SUPP_CHNLS);
    eval("sub IEEE80211_ELEMID_CSA () { 37; }") unless defined(&IEEE80211_ELEMID_CSA);
    eval("sub IEEE80211_ELEMID_MEASUREMENT_REQUEST () { 38; }") unless defined(&IEEE80211_ELEMID_MEASUREMENT_REQUEST);
    eval("sub IEEE80211_ELEMID_MEASUREMENT_REPORT () { 39; }") unless defined(&IEEE80211_ELEMID_MEASUREMENT_REPORT);
    eval("sub IEEE80211_ELEMID_QUIET () { 40; }") unless defined(&IEEE80211_ELEMID_QUIET);
    eval("sub IEEE80211_ELEMID_IBSS_DFS () { 41; }") unless defined(&IEEE80211_ELEMID_IBSS_DFS);
    eval("sub IEEE80211_ELEMID_ERP () { 42; }") unless defined(&IEEE80211_ELEMID_ERP);
    eval("sub IEEE80211_ELEMID_TS_DELAY () { 43; }") unless defined(&IEEE80211_ELEMID_TS_DELAY);
    eval("sub IEEE80211_ELEMID_TCLAS () { 44; }") unless defined(&IEEE80211_ELEMID_TCLAS);
    eval("sub IEEE80211_ELEMID_HTCAPS () { 45; }") unless defined(&IEEE80211_ELEMID_HTCAPS);
    eval("sub IEEE80211_ELEMID_QOS_CAP () { 46; }") unless defined(&IEEE80211_ELEMID_QOS_CAP);
    eval("sub IEEE80211_ELEMID_RSN () { 48; }") unless defined(&IEEE80211_ELEMID_RSN);
    eval("sub IEEE80211_ELEMID_XRATES () { 50; }") unless defined(&IEEE80211_ELEMID_XRATES);
    eval("sub IEEE80211_ELEMID_AP_CHNL_REPORT () { 51; }") unless defined(&IEEE80211_ELEMID_AP_CHNL_REPORT);
    eval("sub IEEE80211_ELEMID_NBR_REPORT () { 52; }") unless defined(&IEEE80211_ELEMID_NBR_REPORT);
    eval("sub IEEE80211_ELEMID_RCPI () { 53; }") unless defined(&IEEE80211_ELEMID_RCPI);
    eval("sub IEEE80211_ELEMID_MDE () { 54; }") unless defined(&IEEE80211_ELEMID_MDE);
    eval("sub IEEE80211_ELEMID_FTE () { 55; }") unless defined(&IEEE80211_ELEMID_FTE);
    eval("sub IEEE80211_ELEMID_TIE () { 56; }") unless defined(&IEEE80211_ELEMID_TIE);
    eval("sub IEEE80211_ELEMID_RDE () { 57; }") unless defined(&IEEE80211_ELEMID_RDE);
    eval("sub IEEE80211_ELEMID_DSE () { 58; }") unless defined(&IEEE80211_ELEMID_DSE);
    eval("sub IEEE80211_ELEMID_SUPP_OPCLASS () { 59; }") unless defined(&IEEE80211_ELEMID_SUPP_OPCLASS);
    eval("sub IEEE80211_ELEMID_XCSA () { 60; }") unless defined(&IEEE80211_ELEMID_XCSA);
    eval("sub IEEE80211_ELEMID_HTOP () { 61; }") unless defined(&IEEE80211_ELEMID_HTOP);
    eval("sub IEEE80211_ELEMID_SECONDARY_CHANL_OFFSET () { 62; }") unless defined(&IEEE80211_ELEMID_SECONDARY_CHANL_OFFSET);
    eval("sub IEEE80211_ELEMID_AVG_ACCESS_DELAY () { 63; }") unless defined(&IEEE80211_ELEMID_AVG_ACCESS_DELAY);
    eval("sub IEEE80211_ELEMID_ANTENNA () { 64; }") unless defined(&IEEE80211_ELEMID_ANTENNA);
    eval("sub IEEE80211_ELEMID_RSNI () { 65; }") unless defined(&IEEE80211_ELEMID_RSNI);
    eval("sub IEEE80211_ELEMID_MEASUREMENT_PILOT_TX () { 66; }") unless defined(&IEEE80211_ELEMID_MEASUREMENT_PILOT_TX);
    eval("sub IEEE80211_ELEMID_AVAIL_CAPACITY () { 67; }") unless defined(&IEEE80211_ELEMID_AVAIL_CAPACITY);
    eval("sub IEEE80211_ELEMID_AC_ACCESS_DELAY () { 68; }") unless defined(&IEEE80211_ELEMID_AC_ACCESS_DELAY);
    eval("sub IEEE80211_ELEMID_TIME_ADVERT () { 69; }") unless defined(&IEEE80211_ELEMID_TIME_ADVERT);
    eval("sub IEEE80211_ELEMID_RM () { 70; }") unless defined(&IEEE80211_ELEMID_RM);
    eval("sub IEEE80211_ELEMID_MULTI_BSSID () { 71; }") unless defined(&IEEE80211_ELEMID_MULTI_BSSID);
    eval("sub IEEE80211_ELEMID_20_40_CBW_COEX () { 72; }") unless defined(&IEEE80211_ELEMID_20_40_CBW_COEX);
    eval("sub IEEE80211_ELEMID_20_40_CBW_INTOLERANT () { 73; }") unless defined(&IEEE80211_ELEMID_20_40_CBW_INTOLERANT);
    eval("sub IEEE80211_ELEMID_SCAN_PARAM_OVERLAP () { 74; }") unless defined(&IEEE80211_ELEMID_SCAN_PARAM_OVERLAP);
    eval("sub IEEE80211_ELEMID_RIC () { 75; }") unless defined(&IEEE80211_ELEMID_RIC);
    eval("sub IEEE80211_ELEMID_MMIE () { 76; }") unless defined(&IEEE80211_ELEMID_MMIE);
    eval("sub IEEE80211_ELEMID_EVENT_REQUEST () { 78; }") unless defined(&IEEE80211_ELEMID_EVENT_REQUEST);
    eval("sub IEEE80211_ELEMID_EVENT_REPORT () { 79; }") unless defined(&IEEE80211_ELEMID_EVENT_REPORT);
    eval("sub IEEE80211_ELEMID_DIAG_REQUEST () { 80; }") unless defined(&IEEE80211_ELEMID_DIAG_REQUEST);
    eval("sub IEEE80211_ELEMID_DIAG_REPORT () { 81; }") unless defined(&IEEE80211_ELEMID_DIAG_REPORT);
    eval("sub IEEE80211_ELEMID_LOCATION_PARMS () { 82; }") unless defined(&IEEE80211_ELEMID_LOCATION_PARMS);
    eval("sub IEEE80211_ELEMID_NONTX_BSSID () { 83; }") unless defined(&IEEE80211_ELEMID_NONTX_BSSID);
    eval("sub IEEE80211_ELEMID_SSID_LIST () { 84; }") unless defined(&IEEE80211_ELEMID_SSID_LIST);
    eval("sub IEEE80211_ELEMID_MULTI_BSSID_IDX () { 85; }") unless defined(&IEEE80211_ELEMID_MULTI_BSSID_IDX);
    eval("sub IEEE80211_ELEMID_FMS_DESC () { 86; }") unless defined(&IEEE80211_ELEMID_FMS_DESC);
    eval("sub IEEE80211_ELEMID_FMS_REQUEST () { 87; }") unless defined(&IEEE80211_ELEMID_FMS_REQUEST);
    eval("sub IEEE80211_ELEMID_FMS_RESPONSE () { 88; }") unless defined(&IEEE80211_ELEMID_FMS_RESPONSE);
    eval("sub IEEE80211_ELEMID_QOS_TRAFFIC_CAP () { 89; }") unless defined(&IEEE80211_ELEMID_QOS_TRAFFIC_CAP);
    eval("sub IEEE80211_ELEMID_MAX_IDLE_PERIOD () { 90; }") unless defined(&IEEE80211_ELEMID_MAX_IDLE_PERIOD);
    eval("sub IEEE80211_ELEMID_TFS_REQUEST () { 91; }") unless defined(&IEEE80211_ELEMID_TFS_REQUEST);
    eval("sub IEEE80211_ELEMID_TFS_RESPONSE () { 92; }") unless defined(&IEEE80211_ELEMID_TFS_RESPONSE);
    eval("sub IEEE80211_ELEMID_WNM_SLEEP () { 93; }") unless defined(&IEEE80211_ELEMID_WNM_SLEEP);
    eval("sub IEEE80211_ELEMID_TIM_BCAST_REQUEST () { 94; }") unless defined(&IEEE80211_ELEMID_TIM_BCAST_REQUEST);
    eval("sub IEEE80211_ELEMID_TIM_BCAST_RESPONSE () { 95; }") unless defined(&IEEE80211_ELEMID_TIM_BCAST_RESPONSE);
    eval("sub IEEE80211_ELEMID_INTERFERENCE_REPORT () { 96; }") unless defined(&IEEE80211_ELEMID_INTERFERENCE_REPORT);
    eval("sub IEEE80211_ELEMID_CHNL_USAGE () { 97; }") unless defined(&IEEE80211_ELEMID_CHNL_USAGE);
    eval("sub IEEE80211_ELEMID_TIME_ZONE () { 98; }") unless defined(&IEEE80211_ELEMID_TIME_ZONE);
    eval("sub IEEE80211_ELEMID_DMS_REQUEST () { 99; }") unless defined(&IEEE80211_ELEMID_DMS_REQUEST);
    eval("sub IEEE80211_ELEMID_DMS_RESPONSE () { 100; }") unless defined(&IEEE80211_ELEMID_DMS_RESPONSE);
    eval("sub IEEE80211_ELEMID_LINK_ID () { 101; }") unless defined(&IEEE80211_ELEMID_LINK_ID);
    eval("sub IEEE80211_ELEMID_WAKE_SCHED () { 102; }") unless defined(&IEEE80211_ELEMID_WAKE_SCHED);
    eval("sub IEEE80211_ELEMID_CHNL_SWITCH_TIMING () { 104; }") unless defined(&IEEE80211_ELEMID_CHNL_SWITCH_TIMING);
    eval("sub IEEE80211_ELEMID_PTI_CTRL () { 105; }") unless defined(&IEEE80211_ELEMID_PTI_CTRL);
    eval("sub IEEE80211_ELEMID_TPU_BUF_STATUS () { 106; }") unless defined(&IEEE80211_ELEMID_TPU_BUF_STATUS);
    eval("sub IEEE80211_ELEMID_INTERWORKING () { 107; }") unless defined(&IEEE80211_ELEMID_INTERWORKING);
    eval("sub IEEE80211_ELEMID_ADVERT_PROTOCOL () { 108; }") unless defined(&IEEE80211_ELEMID_ADVERT_PROTOCOL);
    eval("sub IEEE80211_ELEMID_EXPEDITED_BW_REQUEST () { 109; }") unless defined(&IEEE80211_ELEMID_EXPEDITED_BW_REQUEST);
    eval("sub IEEE80211_ELEMID_QOS_MAP_SET () { 110; }") unless defined(&IEEE80211_ELEMID_QOS_MAP_SET);
    eval("sub IEEE80211_ELEMID_ROAMING_CONSORTIUM () { 111; }") unless defined(&IEEE80211_ELEMID_ROAMING_CONSORTIUM);
    eval("sub IEEE80211_ELEMID_EMERGENCY_ALERT_ID () { 112; }") unless defined(&IEEE80211_ELEMID_EMERGENCY_ALERT_ID);
    eval("sub IEEE80211_ELEMID_MESHCONF () { 113; }") unless defined(&IEEE80211_ELEMID_MESHCONF);
    eval("sub IEEE80211_ELEMID_MESHID () { 114; }") unless defined(&IEEE80211_ELEMID_MESHID);
    eval("sub IEEE80211_ELEMID_MESHLINK () { 115; }") unless defined(&IEEE80211_ELEMID_MESHLINK);
    eval("sub IEEE80211_ELEMID_MESHCNGST () { 116; }") unless defined(&IEEE80211_ELEMID_MESHCNGST);
    eval("sub IEEE80211_ELEMID_MESHPEER () { 117; }") unless defined(&IEEE80211_ELEMID_MESHPEER);
    eval("sub IEEE80211_ELEMID_MESHCSA () { 118; }") unless defined(&IEEE80211_ELEMID_MESHCSA);
    eval("sub IEEE80211_ELEMID_MESHAWAKEW () { 119; }") unless defined(&IEEE80211_ELEMID_MESHAWAKEW);
    eval("sub IEEE80211_ELEMID_MESHBEACONT () { 120; }") unless defined(&IEEE80211_ELEMID_MESHBEACONT);
    eval("sub IEEE80211_ELEMID_MCCAOP_SETUP_REQUEST () { 121; }") unless defined(&IEEE80211_ELEMID_MCCAOP_SETUP_REQUEST);
    eval("sub IEEE80211_ELEMID_MCCAOP_SETUP_REPLY () { 122; }") unless defined(&IEEE80211_ELEMID_MCCAOP_SETUP_REPLY);
    eval("sub IEEE80211_ELEMID_MCCAOP_ADVERT () { 123; }") unless defined(&IEEE80211_ELEMID_MCCAOP_ADVERT);
    eval("sub IEEE80211_ELEMID_MCCAOP_TEARDOWN () { 124; }") unless defined(&IEEE80211_ELEMID_MCCAOP_TEARDOWN);
    eval("sub IEEE80211_ELEMID_MESHGANN () { 125; }") unless defined(&IEEE80211_ELEMID_MESHGANN);
    eval("sub IEEE80211_ELEMID_MESHRANN () { 126; }") unless defined(&IEEE80211_ELEMID_MESHRANN);
    eval("sub IEEE80211_ELEMID_XCAPS () { 127; }") unless defined(&IEEE80211_ELEMID_XCAPS);
    eval("sub IEEE80211_ELEMID_MESHPREQ () { 130; }") unless defined(&IEEE80211_ELEMID_MESHPREQ);
    eval("sub IEEE80211_ELEMID_MESHPREP () { 131; }") unless defined(&IEEE80211_ELEMID_MESHPREP);
    eval("sub IEEE80211_ELEMID_MESHPERR () { 132; }") unless defined(&IEEE80211_ELEMID_MESHPERR);
    eval("sub IEEE80211_ELEMID_MESHPXU () { 137; }") unless defined(&IEEE80211_ELEMID_MESHPXU);
    eval("sub IEEE80211_ELEMID_MESHPXUC () { 138; }") unless defined(&IEEE80211_ELEMID_MESHPXUC);
    eval("sub IEEE80211_ELEMID_AUTH_MESH_PEERING_XCHG () { 139; }") unless defined(&IEEE80211_ELEMID_AUTH_MESH_PEERING_XCHG);
    eval("sub IEEE80211_ELEMID_MIC () { 140; }") unless defined(&IEEE80211_ELEMID_MIC);
    eval("sub IEEE80211_ELEMID_DEST_URI () { 141; }") unless defined(&IEEE80211_ELEMID_DEST_URI);
    eval("sub IEEE80211_ELEMID_U_APSD_COEX () { 142; }") unless defined(&IEEE80211_ELEMID_U_APSD_COEX);
    eval("sub IEEE80211_ELEMID_MCCAOP_ADVERT_OVIEW () { 174; }") unless defined(&IEEE80211_ELEMID_MCCAOP_ADVERT_OVIEW);
    eval("sub IEEE80211_ELEMID_VENDOR () { 221; }") unless defined(&IEEE80211_ELEMID_VENDOR);
    eval("sub IEEE80211_CATEG_SPECTRUM () { 0; }") unless defined(&IEEE80211_CATEG_SPECTRUM);
    eval("sub IEEE80211_CATEG_QOS () { 1; }") unless defined(&IEEE80211_CATEG_QOS);
    eval("sub IEEE80211_CATEG_DLS () { 2; }") unless defined(&IEEE80211_CATEG_DLS);
    eval("sub IEEE80211_CATEG_BA () { 3; }") unless defined(&IEEE80211_CATEG_BA);
    eval("sub IEEE80211_CATEG_PUB () { 4; }") unless defined(&IEEE80211_CATEG_PUB);
    eval("sub IEEE80211_CATEG_RADIO_MSRMNT () { 5; }") unless defined(&IEEE80211_CATEG_RADIO_MSRMNT);
    eval("sub IEEE80211_CATEG_FAST_BSS_TRANS () { 6; }") unless defined(&IEEE80211_CATEG_FAST_BSS_TRANS);
    eval("sub IEEE80211_CATEG_HT () { 7; }") unless defined(&IEEE80211_CATEG_HT);
    eval("sub IEEE80211_CATEG_SA_QUERY () { 8; }") unless defined(&IEEE80211_CATEG_SA_QUERY);
    eval("sub IEEE80211_CATEG_PROT_DUAL_PUBLIC_ACTION () { 9; }") unless defined(&IEEE80211_CATEG_PROT_DUAL_PUBLIC_ACTION);
    eval("sub IEEE80211_CATEG_WNM () { 10; }") unless defined(&IEEE80211_CATEG_WNM);
    eval("sub IEEE80211_CATEG_UNPROT_WNM () { 11; }") unless defined(&IEEE80211_CATEG_UNPROT_WNM);
    eval("sub IEEE80211_CATEG_TDLS () { 12; }") unless defined(&IEEE80211_CATEG_TDLS);
    eval("sub IEEE80211_CATEG_MESH () { 13; }") unless defined(&IEEE80211_CATEG_MESH);
    eval("sub IEEE80211_CATEG_MULTIHOP () { 14; }") unless defined(&IEEE80211_CATEG_MULTIHOP);
    eval("sub IEEE80211_CATEG_SELF_PROT () { 15; }") unless defined(&IEEE80211_CATEG_SELF_PROT);
    eval("sub IEEE80211_CATEG_PROT_VENDOR () { 126; }") unless defined(&IEEE80211_CATEG_PROT_VENDOR);
    eval("sub IEEE80211_CATEG_VENDOR () { 127; }") unless defined(&IEEE80211_CATEG_VENDOR);
    eval 'sub IEEE80211_ACTION_ADDBA_REQ () {0;}' unless defined(&IEEE80211_ACTION_ADDBA_REQ);
    eval 'sub IEEE80211_ACTION_ADDBA_RESP () {1;}' unless defined(&IEEE80211_ACTION_ADDBA_RESP);
    eval 'sub IEEE80211_ACTION_DELBA () {2;}' unless defined(&IEEE80211_ACTION_DELBA);
    eval 'sub IEEE80211_ACTION_SA_QUERY_REQ () {0;}' unless defined(&IEEE80211_ACTION_SA_QUERY_REQ);
    eval 'sub IEEE80211_ACTION_SA_QUERY_RESP () {1;}' unless defined(&IEEE80211_ACTION_SA_QUERY_RESP);
    eval 'sub IEEE80211_ACTION_NOTIFYCW () {0;}' unless defined(&IEEE80211_ACTION_NOTIFYCW);
    eval 'sub IEEE80211_ACTION_SM_PWRSAVE () {1;}' unless defined(&IEEE80211_ACTION_SM_PWRSAVE);
    eval 'sub IEEE80211_ACTION_PSMP () {2;}' unless defined(&IEEE80211_ACTION_PSMP);
    eval 'sub IEEE80211_ACTION_SET_PCO_PHASE () {3;}' unless defined(&IEEE80211_ACTION_SET_PCO_PHASE);
    eval 'sub IEEE80211_ACTION_CSI () {4;}' unless defined(&IEEE80211_ACTION_CSI);
    eval 'sub IEEE80211_ACTION_NONCOMPRESSED_BF () {5;}' unless defined(&IEEE80211_ACTION_NONCOMPRESSED_BF);
    eval 'sub IEEE80211_ACTION_COMPRESSED_BF () {6;}' unless defined(&IEEE80211_ACTION_COMPRESSED_BF);
    eval 'sub IEEE80211_ACTION_ASEL_IDX_FEEDBACK () {7;}' unless defined(&IEEE80211_ACTION_ASEL_IDX_FEEDBACK);
    eval 'sub IEEE80211_RATE_BASIC () {0x80;}' unless defined(&IEEE80211_RATE_BASIC);
    eval 'sub IEEE80211_RATE_VAL () {0x7f;}' unless defined(&IEEE80211_RATE_VAL);
    eval 'sub IEEE80211_RATE_SIZE () {8;}' unless defined(&IEEE80211_RATE_SIZE);
    eval 'sub IEEE80211_RATE_MAXSIZE () {15;}' unless defined(&IEEE80211_RATE_MAXSIZE);
    eval 'sub IEEE80211_HT_NUM_MCS () {77;}' unless defined(&IEEE80211_HT_NUM_MCS);
    eval 'sub IEEE80211_BA_ACK_POLICY () {0x1;}' unless defined(&IEEE80211_BA_ACK_POLICY);
    eval 'sub IEEE80211_BA_MULTI_TID () {0x2;}' unless defined(&IEEE80211_BA_MULTI_TID);
    eval 'sub IEEE80211_BA_COMPRESSED () {0x4;}' unless defined(&IEEE80211_BA_COMPRESSED);
    eval 'sub IEEE80211_BA_TID_INFO_MASK () {0xf000;}' unless defined(&IEEE80211_BA_TID_INFO_MASK);
    eval 'sub IEEE80211_BA_TID_INFO_SHIFT () {12;}' unless defined(&IEEE80211_BA_TID_INFO_SHIFT);
    eval 'sub IEEE80211_ADDBA_AMSDU () {0x1;}' unless defined(&IEEE80211_ADDBA_AMSDU);
    eval 'sub IEEE80211_ADDBA_BA_POLICY () {0x2;}' unless defined(&IEEE80211_ADDBA_BA_POLICY);
    eval 'sub IEEE80211_ADDBA_TID_MASK () {0x3c;}' unless defined(&IEEE80211_ADDBA_TID_MASK);
    eval 'sub IEEE80211_ADDBA_TID_SHIFT () {2;}' unless defined(&IEEE80211_ADDBA_TID_SHIFT);
    eval 'sub IEEE80211_ADDBA_BUFSZ_MASK () {0xffc0;}' unless defined(&IEEE80211_ADDBA_BUFSZ_MASK);
    eval 'sub IEEE80211_ADDBA_BUFSZ_SHIFT () {6;}' unless defined(&IEEE80211_ADDBA_BUFSZ_SHIFT);
    eval 'sub IEEE80211_DELBA_INITIATOR () {0x800;}' unless defined(&IEEE80211_DELBA_INITIATOR);
    eval 'sub IEEE80211_DELBA_TID_INFO_MASK () {0xf000;}' unless defined(&IEEE80211_DELBA_TID_INFO_MASK);
    eval 'sub IEEE80211_DELBA_TID_INFO_SHIFT () {12;}' unless defined(&IEEE80211_DELBA_TID_INFO_SHIFT);
    eval 'sub IEEE80211_ERP_NON_ERP_PRESENT () {0x1;}' unless defined(&IEEE80211_ERP_NON_ERP_PRESENT);
    eval 'sub IEEE80211_ERP_USE_PROTECTION () {0x2;}' unless defined(&IEEE80211_ERP_USE_PROTECTION);
    eval 'sub IEEE80211_ERP_BARKER_MODE () {0x4;}' unless defined(&IEEE80211_ERP_BARKER_MODE);
    eval 'sub IEEE80211_RSNCAP_PREAUTH () {0x1;}' unless defined(&IEEE80211_RSNCAP_PREAUTH);
    eval 'sub IEEE80211_RSNCAP_NOPAIRWISE () {0x2;}' unless defined(&IEEE80211_RSNCAP_NOPAIRWISE);
    eval 'sub IEEE80211_RSNCAP_PTKSA_RCNT_MASK () {0xc;}' unless defined(&IEEE80211_RSNCAP_PTKSA_RCNT_MASK);
    eval 'sub IEEE80211_RSNCAP_PTKSA_RCNT_SHIFT () {2;}' unless defined(&IEEE80211_RSNCAP_PTKSA_RCNT_SHIFT);
    eval 'sub IEEE80211_RSNCAP_GTKSA_RCNT_MASK () {0x30;}' unless defined(&IEEE80211_RSNCAP_GTKSA_RCNT_MASK);
    eval 'sub IEEE80211_RSNCAP_GTKSA_RCNT_SHIFT () {4;}' unless defined(&IEEE80211_RSNCAP_GTKSA_RCNT_SHIFT);
    eval 'sub IEEE80211_RSNCAP_RCNT1 () {0;}' unless defined(&IEEE80211_RSNCAP_RCNT1);
    eval 'sub IEEE80211_RSNCAP_RCNT2 () {1;}' unless defined(&IEEE80211_RSNCAP_RCNT2);
    eval 'sub IEEE80211_RSNCAP_RCNT4 () {2;}' unless defined(&IEEE80211_RSNCAP_RCNT4);
    eval 'sub IEEE80211_RSNCAP_RCNT16 () {3;}' unless defined(&IEEE80211_RSNCAP_RCNT16);
    eval 'sub IEEE80211_RSNCAP_MFPR () {0x40;}' unless defined(&IEEE80211_RSNCAP_MFPR);
    eval 'sub IEEE80211_RSNCAP_MFPC () {0x80;}' unless defined(&IEEE80211_RSNCAP_MFPC);
    eval 'sub IEEE80211_RSNCAP_PEERKEYENA () {0x200;}' unless defined(&IEEE80211_RSNCAP_PEERKEYENA);
    eval 'sub IEEE80211_RSNCAP_SPPAMSDUC () {0x400;}' unless defined(&IEEE80211_RSNCAP_SPPAMSDUC);
    eval 'sub IEEE80211_RSNCAP_SPPAMSDUR () {0x800;}' unless defined(&IEEE80211_RSNCAP_SPPAMSDUR);
    eval 'sub IEEE80211_RSNCAP_PBAC () {0x1000;}' unless defined(&IEEE80211_RSNCAP_PBAC);
    eval 'sub IEEE80211_RSNCAP_EXTENDED_KEYID () {0x2000;}' unless defined(&IEEE80211_RSNCAP_EXTENDED_KEYID);
    eval 'sub IEEE80211_HTCAP_LDPC () {0x1;}' unless defined(&IEEE80211_HTCAP_LDPC);
    eval 'sub IEEE80211_HTCAP_CBW20_40 () {0x2;}' unless defined(&IEEE80211_HTCAP_CBW20_40);
    eval 'sub IEEE80211_HTCAP_SMPS_MASK () {0xc;}' unless defined(&IEEE80211_HTCAP_SMPS_MASK);
    eval 'sub IEEE80211_HTCAP_SMPS_SHIFT () {2;}' unless defined(&IEEE80211_HTCAP_SMPS_SHIFT);
    eval 'sub IEEE80211_HTCAP_SMPS_STA () {0;}' unless defined(&IEEE80211_HTCAP_SMPS_STA);
    eval 'sub IEEE80211_HTCAP_SMPS_DYN () {1;}' unless defined(&IEEE80211_HTCAP_SMPS_DYN);
    eval 'sub IEEE80211_HTCAP_SMPS_DIS () {3;}' unless defined(&IEEE80211_HTCAP_SMPS_DIS);
    eval 'sub IEEE80211_HTCAP_GF () {0x10;}' unless defined(&IEEE80211_HTCAP_GF);
    eval 'sub IEEE80211_HTCAP_SGI20 () {0x20;}' unless defined(&IEEE80211_HTCAP_SGI20);
    eval 'sub IEEE80211_HTCAP_SGI40 () {0x40;}' unless defined(&IEEE80211_HTCAP_SGI40);
    eval 'sub IEEE80211_HTCAP_TXSTBC () {0x80;}' unless defined(&IEEE80211_HTCAP_TXSTBC);
    eval 'sub IEEE80211_HTCAP_RXSTBC_MASK () {0x300;}' unless defined(&IEEE80211_HTCAP_RXSTBC_MASK);
    eval 'sub IEEE80211_HTCAP_RXSTBC_SHIFT () {8;}' unless defined(&IEEE80211_HTCAP_RXSTBC_SHIFT);
    eval 'sub IEEE80211_HTCAP_DELAYEDBA () {0x400;}' unless defined(&IEEE80211_HTCAP_DELAYEDBA);
    eval 'sub IEEE80211_HTCAP_AMSDU7935 () {0x800;}' unless defined(&IEEE80211_HTCAP_AMSDU7935);
    eval 'sub IEEE80211_HTCAP_DSSSCCK40 () {0x1000;}' unless defined(&IEEE80211_HTCAP_DSSSCCK40);
    eval 'sub IEEE80211_HTCAP_PSMP () {0x2000;}' unless defined(&IEEE80211_HTCAP_PSMP);
    eval 'sub IEEE80211_HTCAP_40INTOLERANT () {0x4000;}' unless defined(&IEEE80211_HTCAP_40INTOLERANT);
    eval 'sub IEEE80211_HTCAP_LSIGTXOPPROT () {0x8000;}' unless defined(&IEEE80211_HTCAP_LSIGTXOPPROT);
    eval 'sub IEEE80211_AMPDU_PARAM_LE () {0x3;}' unless defined(&IEEE80211_AMPDU_PARAM_LE);
    eval 'sub IEEE80211_AMPDU_PARAM_SS () {0x1c;}' unless defined(&IEEE80211_AMPDU_PARAM_SS);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_NONE () {(0<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_NONE);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_0_25 () {(1<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_0_25);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_0_5 () {(2<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_0_5);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_1 () {(3<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_1);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_2 () {(4<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_2);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_4 () {(5<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_4);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_8 () {(6<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_8);
    eval 'sub IEEE80211_AMPDU_PARAM_SS_16 () {(7<< 2);}' unless defined(&IEEE80211_AMPDU_PARAM_SS_16);
    eval 'sub IEEE80211_MCS_RX_RATE_HIGH () {0x3ff;}' unless defined(&IEEE80211_MCS_RX_RATE_HIGH);
    eval 'sub IEEE80211_TX_MCS_SET_DEFINED () {0x1;}' unless defined(&IEEE80211_TX_MCS_SET_DEFINED);
    eval 'sub IEEE80211_TX_RX_MCS_NOT_EQUAL () {0x2;}' unless defined(&IEEE80211_TX_RX_MCS_NOT_EQUAL);
    eval 'sub IEEE80211_TX_SPATIAL_STREAMS () {0x18;}' unless defined(&IEEE80211_TX_SPATIAL_STREAMS);
    eval 'sub IEEE80211_TX_UNEQUAL_MODULATION () {0x20;}' unless defined(&IEEE80211_TX_UNEQUAL_MODULATION);
    eval 'sub IEEE80211_HTXCAP_PCO () {0x1;}' unless defined(&IEEE80211_HTXCAP_PCO);
    eval 'sub IEEE80211_HTXCAP_PCOTT_MASK () {0x6;}' unless defined(&IEEE80211_HTXCAP_PCOTT_MASK);
    eval 'sub IEEE80211_HTXCAP_PCOTT_SHIFT () {1;}' unless defined(&IEEE80211_HTXCAP_PCOTT_SHIFT);
    eval 'sub IEEE80211_HTXCAP_PCOTT_400 () {1;}' unless defined(&IEEE80211_HTXCAP_PCOTT_400);
    eval 'sub IEEE80211_HTXCAP_PCOTT_1500 () {2;}' unless defined(&IEEE80211_HTXCAP_PCOTT_1500);
    eval 'sub IEEE80211_HTXCAP_PCOTT_5000 () {3;}' unless defined(&IEEE80211_HTXCAP_PCOTT_5000);
    eval 'sub IEEE80211_HTXCAP_MFB_MASK () {0x300;}' unless defined(&IEEE80211_HTXCAP_MFB_MASK);
    eval 'sub IEEE80211_HTXCAP_MFB_SHIFT () {8;}' unless defined(&IEEE80211_HTXCAP_MFB_SHIFT);
    eval 'sub IEEE80211_HTXCAP_MFB_NONE () {0;}' unless defined(&IEEE80211_HTXCAP_MFB_NONE);
    eval 'sub IEEE80211_HTXCAP_MFB_UNSOL () {2;}' unless defined(&IEEE80211_HTXCAP_MFB_UNSOL);
    eval 'sub IEEE80211_HTXCAP_MFB_BOTH () {3;}' unless defined(&IEEE80211_HTXCAP_MFB_BOTH);
    eval 'sub IEEE80211_HTXCAP_HTC () {0x400;}' unless defined(&IEEE80211_HTXCAP_HTC);
    eval 'sub IEEE80211_HTXCAP_RDRESP () {0x800;}' unless defined(&IEEE80211_HTXCAP_RDRESP);
    eval 'sub IEEE80211_TXBFCAP_IMPLICIT_RX () {0x1;}' unless defined(&IEEE80211_TXBFCAP_IMPLICIT_RX);
    eval 'sub IEEE80211_TXBFCAP_RSSC () {0x2;}' unless defined(&IEEE80211_TXBFCAP_RSSC);
    eval 'sub IEEE80211_TXBFCAP_TSSC () {0x4;}' unless defined(&IEEE80211_TXBFCAP_TSSC);
    eval 'sub IEEE80211_TXBFCAP_RNDP () {0x8;}' unless defined(&IEEE80211_TXBFCAP_RNDP);
    eval 'sub IEEE80211_TXBFCAP_TNDP () {0x10;}' unless defined(&IEEE80211_TXBFCAP_TNDP);
    eval 'sub IEEE80211_TXBFCAP_IMPLICIT_TX () {0x20;}' unless defined(&IEEE80211_TXBFCAP_IMPLICIT_TX);
    eval 'sub IEEE80211_TXBFCAP_CALIB_MASK () {0xc0;}' unless defined(&IEEE80211_TXBFCAP_CALIB_MASK);
    eval 'sub IEEE80211_TXBFCAP_CALIB_SHIFT () {6;}' unless defined(&IEEE80211_TXBFCAP_CALIB_SHIFT);
    eval 'sub IEEE80211_TXBFCAP_TX_CSI () {0x100;}' unless defined(&IEEE80211_TXBFCAP_TX_CSI);
    eval 'sub IEEE80211_TXBFCAP_EXPLICIT_NSC () {0x200;}' unless defined(&IEEE80211_TXBFCAP_EXPLICIT_NSC);
    eval 'sub IEEE80211_TXBFCAP_EXPLICIT_CSC () {0x400;}' unless defined(&IEEE80211_TXBFCAP_EXPLICIT_CSC);
    eval 'sub IEEE80211_TXBFCAP_CSI_FB_DELAYED () {0x800;}' unless defined(&IEEE80211_TXBFCAP_CSI_FB_DELAYED);
    eval 'sub IEEE80211_TXBFCAP_CSI_FB_IMMEDIATE () {0x1000;}' unless defined(&IEEE80211_TXBFCAP_CSI_FB_IMMEDIATE);
    eval 'sub IEEE80211_TXBFCAP_EXPLICIT_NB_FB_DELAYED () {0x2000;}' unless defined(&IEEE80211_TXBFCAP_EXPLICIT_NB_FB_DELAYED);
    eval 'sub IEEE80211_TXBFCAP_EXPLICIT_NB_FB_IMMEDIATE () {0x4000;}' unless defined(&IEEE80211_TXBFCAP_EXPLICIT_NB_FB_IMMEDIATE);
    eval 'sub IEEE80211_TXBFCAP_EXPLICIT_CB_FB_DELAYED () {0x8000;}' unless defined(&IEEE80211_TXBFCAP_EXPLICIT_CB_FB_DELAYED);
    eval 'sub IEEE80211_TXBFCAP_EXPLICIT_CB_FB_IMMEDIATE () {0x10000;}' unless defined(&IEEE80211_TXBFCAP_EXPLICIT_CB_FB_IMMEDIATE);
    eval 'sub IEEE80211_TXBFCAP_MINIMAL_GROUPING_1_2 () {0x20000;}' unless defined(&IEEE80211_TXBFCAP_MINIMAL_GROUPING_1_2);
    eval 'sub IEEE80211_TXBFCAP_MINIMAL_GROUPING_1_4 () {0x40000;}' unless defined(&IEEE80211_TXBFCAP_MINIMAL_GROUPING_1_4);
    eval 'sub IEEE80211_TXBFCAP_CSI_NUM_ANT_MASK () {0x180000;}' unless defined(&IEEE80211_TXBFCAP_CSI_NUM_ANT_MASK);
    eval 'sub IEEE80211_TXBFCAP_CSI_NUM_ANT_SHIFT () {19;}' unless defined(&IEEE80211_TXBFCAP_CSI_NUM_ANT_SHIFT);
    eval 'sub IEEE80211_TXBFCAP_NS_NUM_ANT_MASK () {0x600000;}' unless defined(&IEEE80211_TXBFCAP_NS_NUM_ANT_MASK);
    eval 'sub IEEE80211_TXBFCAP_NS_NUM_ANT_SHIFT () {21;}' unless defined(&IEEE80211_TXBFCAP_NS_NUM_ANT_SHIFT);
    eval 'sub IEEE80211_TXBFCAP_CS_NUM_ANT_MASK () {0x1800000;}' unless defined(&IEEE80211_TXBFCAP_CS_NUM_ANT_MASK);
    eval 'sub IEEE80211_TXBFCAP_CS_NUM_ANT_SHIFT () {23;}' unless defined(&IEEE80211_TXBFCAP_CS_NUM_ANT_SHIFT);
    eval 'sub IEEE80211_TXBFCAP_CSI_NUM_ROWS_MASK () {0x6000000;}' unless defined(&IEEE80211_TXBFCAP_CSI_NUM_ROWS_MASK);
    eval 'sub IEEE80211_TXBFCAP_CSI_NUM_ROWS_SHIFT () {25;}' unless defined(&IEEE80211_TXBFCAP_CSI_NUM_ROWS_SHIFT);
    eval 'sub IEEE80211_TXBFCAP_CHANL_ESTIMATE_MASK () {0x18000000;}' unless defined(&IEEE80211_TXBFCAP_CHANL_ESTIMATE_MASK);
    eval 'sub IEEE80211_TXBFCAP_CHANL_ESTIMATE_SHIFT () {27;}' unless defined(&IEEE80211_TXBFCAP_CHANL_ESTIMATE_SHIFT);
    eval 'sub IEEE80211_ASELCAP_ASEL () {0x1;}' unless defined(&IEEE80211_ASELCAP_ASEL);
    eval 'sub IEEE80211_ASELCAP_CSIFB_TX () {0x2;}' unless defined(&IEEE80211_ASELCAP_CSIFB_TX);
    eval 'sub IEEE80211_ASELCAP_ANT_IDX_FB_TX () {0x4;}' unless defined(&IEEE80211_ASELCAP_ANT_IDX_FB_TX);
    eval 'sub IEEE80211_ASELCAP_CSIFB () {0x8;}' unless defined(&IEEE80211_ASELCAP_CSIFB);
    eval 'sub IEEE80211_ASELCAP_ANT_IDX_FB () {0x10;}' unless defined(&IEEE80211_ASELCAP_ANT_IDX_FB);
    eval 'sub IEEE80211_ASELCAP_ASEL_RX () {0x20;}' unless defined(&IEEE80211_ASELCAP_ASEL_RX);
    eval 'sub IEEE80211_ASELCAP_TX_SOUND_PPDU () {0x20;}' unless defined(&IEEE80211_ASELCAP_TX_SOUND_PPDU);
    eval 'sub IEEE80211_HTOP0_SCO_MASK () {0x3;}' unless defined(&IEEE80211_HTOP0_SCO_MASK);
    eval 'sub IEEE80211_HTOP0_SCO_SHIFT () {0;}' unless defined(&IEEE80211_HTOP0_SCO_SHIFT);
    eval 'sub IEEE80211_HTOP0_SCO_SCN () {0;}' unless defined(&IEEE80211_HTOP0_SCO_SCN);
    eval 'sub IEEE80211_HTOP0_SCO_SCA () {1;}' unless defined(&IEEE80211_HTOP0_SCO_SCA);
    eval 'sub IEEE80211_HTOP0_SCO_SCB () {3;}' unless defined(&IEEE80211_HTOP0_SCO_SCB);
    eval 'sub IEEE80211_HTOP0_CHW () {0x4;}' unless defined(&IEEE80211_HTOP0_CHW);
    eval 'sub IEEE80211_HTOP0_RIFS () {0x8;}' unless defined(&IEEE80211_HTOP0_RIFS);
    eval 'sub IEEE80211_HTOP1_PROT_MASK () {0x3;}' unless defined(&IEEE80211_HTOP1_PROT_MASK);
    eval 'sub IEEE80211_HTOP1_PROT_SHIFT () {0;}' unless defined(&IEEE80211_HTOP1_PROT_SHIFT);
    eval 'sub IEEE80211_HTOP1_NONGF_STA () {0x4;}' unless defined(&IEEE80211_HTOP1_NONGF_STA);
    eval 'sub IEEE80211_HTOP1_OBSS_NONHT_STA () {0x10;}' unless defined(&IEEE80211_HTOP1_OBSS_NONHT_STA);
    eval 'sub IEEE80211_HTOP2_DUALBEACON () {0x40;}' unless defined(&IEEE80211_HTOP2_DUALBEACON);
    eval 'sub IEEE80211_HTOP2_DUALCTSPROT () {0x80;}' unless defined(&IEEE80211_HTOP2_DUALCTSPROT);
    eval 'sub IEEE80211_HTOP2_STBCBEACON () {0x100;}' unless defined(&IEEE80211_HTOP2_STBCBEACON);
    eval 'sub IEEE80211_HTOP2_LSIGTXOP () {0x200;}' unless defined(&IEEE80211_HTOP2_LSIGTXOP);
    eval 'sub IEEE80211_HTOP2_PCOACTIVE () {0x400;}' unless defined(&IEEE80211_HTOP2_PCOACTIVE);
    eval 'sub IEEE80211_HTOP2_PCOPHASE40 () {0x800;}' unless defined(&IEEE80211_HTOP2_PCOPHASE40);
    eval("sub EDCA_AC_BK () { 1; }") unless defined(&EDCA_AC_BK);
    eval("sub EDCA_AC_BE () { 0; }") unless defined(&EDCA_AC_BE);
    eval("sub EDCA_AC_VI () { 2; }") unless defined(&EDCA_AC_VI);
    eval("sub EDCA_AC_VO () { 3; }") unless defined(&EDCA_AC_VO);
    eval 'sub EDCA_NUM_AC () {4;}' unless defined(&EDCA_NUM_AC);
    eval 'sub IEEE80211_NUM_TID () {16;}' unless defined(&IEEE80211_NUM_TID);
    eval 'sub ATHEROS_CAP_TURBO_PRIME () {0x1;}' unless defined(&ATHEROS_CAP_TURBO_PRIME);
    eval 'sub ATHEROS_CAP_COMPRESSION () {0x2;}' unless defined(&ATHEROS_CAP_COMPRESSION);
    eval 'sub ATHEROS_CAP_FAST_FRAME () {0x4;}' unless defined(&ATHEROS_CAP_FAST_FRAME);
    eval 'sub ATHEROS_CAP_BOOST () {0x80;}' unless defined(&ATHEROS_CAP_BOOST);
    eval 'sub ATHEROS_OUI () {(( &const  $u_int8_t[]){ 0x, 0x3, 0x7f });}' unless defined(&ATHEROS_OUI);
    eval 'sub BROADCOM_OUI () {(( &const  $u_int8_t[]){ 0x, 0x90, 0x4c });}' unless defined(&BROADCOM_OUI);
    eval 'sub IEEE80211_OUI () {(( &const  $u_int8_t[]){ 0x, 0xf, 0xac });}' unless defined(&IEEE80211_OUI);
    eval 'sub MICROSOFT_OUI () {(( &const  $u_int8_t[]){ 0x, 0x50, 0xf2 });}' unless defined(&MICROSOFT_OUI);
    eval 'sub IEEE80211_AUTH_ALGORITHM {
        my($auth) = @_;
	    eval q((($auth)[0] | (($auth)[1] << 8)));
    }' unless defined(&IEEE80211_AUTH_ALGORITHM);
    eval 'sub IEEE80211_AUTH_TRANSACTION {
        my($auth) = @_;
	    eval q((($auth)[2] | (($auth)[3] << 8)));
    }' unless defined(&IEEE80211_AUTH_TRANSACTION);
    eval 'sub IEEE80211_AUTH_STATUS {
        my($auth) = @_;
	    eval q((($auth)[4] | (($auth)[5] << 8)));
    }' unless defined(&IEEE80211_AUTH_STATUS);
    eval 'sub IEEE80211_AUTH_ALG_OPEN () {0x;}' unless defined(&IEEE80211_AUTH_ALG_OPEN);
    eval 'sub IEEE80211_AUTH_ALG_SHARED () {0x1;}' unless defined(&IEEE80211_AUTH_ALG_SHARED);
    eval 'sub IEEE80211_AUTH_ALG_LEAP () {0x80;}' unless defined(&IEEE80211_AUTH_ALG_LEAP);
    eval("sub IEEE80211_AUTH_OPEN_REQUEST () { 1; }") unless defined(&IEEE80211_AUTH_OPEN_REQUEST);
    eval("sub IEEE80211_AUTH_OPEN_RESPONSE () { 2; }") unless defined(&IEEE80211_AUTH_OPEN_RESPONSE);
    eval("sub IEEE80211_AUTH_SHARED_REQUEST () { 1; }") unless defined(&IEEE80211_AUTH_SHARED_REQUEST);
    eval("sub IEEE80211_AUTH_SHARED_CHALLENGE () { 2; }") unless defined(&IEEE80211_AUTH_SHARED_CHALLENGE);
    eval("sub IEEE80211_AUTH_SHARED_RESPONSE () { 3; }") unless defined(&IEEE80211_AUTH_SHARED_RESPONSE);
    eval("sub IEEE80211_AUTH_SHARED_PASS () { 4; }") unless defined(&IEEE80211_AUTH_SHARED_PASS);
    eval("sub IEEE80211_REASON_UNSPECIFIED () { 1; }") unless defined(&IEEE80211_REASON_UNSPECIFIED);
    eval("sub IEEE80211_REASON_AUTH_EXPIRE () { 2; }") unless defined(&IEEE80211_REASON_AUTH_EXPIRE);
    eval("sub IEEE80211_REASON_AUTH_LEAVE () { 3; }") unless defined(&IEEE80211_REASON_AUTH_LEAVE);
    eval("sub IEEE80211_REASON_ASSOC_EXPIRE () { 4; }") unless defined(&IEEE80211_REASON_ASSOC_EXPIRE);
    eval("sub IEEE80211_REASON_ASSOC_TOOMANY () { 5; }") unless defined(&IEEE80211_REASON_ASSOC_TOOMANY);
    eval("sub IEEE80211_REASON_NOT_AUTHED () { 6; }") unless defined(&IEEE80211_REASON_NOT_AUTHED);
    eval("sub IEEE80211_REASON_NOT_ASSOCED () { 7; }") unless defined(&IEEE80211_REASON_NOT_ASSOCED);
    eval("sub IEEE80211_REASON_ASSOC_LEAVE () { 8; }") unless defined(&IEEE80211_REASON_ASSOC_LEAVE);
    eval("sub IEEE80211_REASON_ASSOC_NOT_AUTHED () { 9; }") unless defined(&IEEE80211_REASON_ASSOC_NOT_AUTHED);
    eval("sub IEEE80211_REASON_RSN_REQUIRED () { 11; }") unless defined(&IEEE80211_REASON_RSN_REQUIRED);
    eval("sub IEEE80211_REASON_RSN_INCONSISTENT () { 12; }") unless defined(&IEEE80211_REASON_RSN_INCONSISTENT);
    eval("sub IEEE80211_REASON_IE_INVALID () { 13; }") unless defined(&IEEE80211_REASON_IE_INVALID);
    eval("sub IEEE80211_REASON_MIC_FAILURE () { 14; }") unless defined(&IEEE80211_REASON_MIC_FAILURE);
    eval("sub IEEE80211_REASON_4WAY_TIMEOUT () { 15; }") unless defined(&IEEE80211_REASON_4WAY_TIMEOUT);
    eval("sub IEEE80211_REASON_GROUP_TIMEOUT () { 16; }") unless defined(&IEEE80211_REASON_GROUP_TIMEOUT);
    eval("sub IEEE80211_REASON_RSN_DIFFERENT_IE () { 17; }") unless defined(&IEEE80211_REASON_RSN_DIFFERENT_IE);
    eval("sub IEEE80211_REASON_BAD_GROUP_CIPHER () { 18; }") unless defined(&IEEE80211_REASON_BAD_GROUP_CIPHER);
    eval("sub IEEE80211_REASON_BAD_PAIRWISE_CIPHER () { 19; }") unless defined(&IEEE80211_REASON_BAD_PAIRWISE_CIPHER);
    eval("sub IEEE80211_REASON_BAD_AKMP () { 20; }") unless defined(&IEEE80211_REASON_BAD_AKMP);
    eval("sub IEEE80211_REASON_RSN_IE_VER_UNSUP () { 21; }") unless defined(&IEEE80211_REASON_RSN_IE_VER_UNSUP);
    eval("sub IEEE80211_REASON_RSN_IE_BAD_CAP () { 22; }") unless defined(&IEEE80211_REASON_RSN_IE_BAD_CAP);
    eval("sub IEEE80211_REASON_CIPHER_REJ_POLICY () { 24; }") unless defined(&IEEE80211_REASON_CIPHER_REJ_POLICY);
    eval("sub IEEE80211_REASON_SETUP_REQUIRED () { 38; }") unless defined(&IEEE80211_REASON_SETUP_REQUIRED);
    eval("sub IEEE80211_REASON_TIMEOUT () { 39; }") unless defined(&IEEE80211_REASON_TIMEOUT);
    eval("sub IEEE80211_STATUS_SUCCESS () { 0; }") unless defined(&IEEE80211_STATUS_SUCCESS);
    eval("sub IEEE80211_STATUS_UNSPECIFIED () { 1; }") unless defined(&IEEE80211_STATUS_UNSPECIFIED);
    eval("sub IEEE80211_STATUS_CAPINFO () { 10; }") unless defined(&IEEE80211_STATUS_CAPINFO);
    eval("sub IEEE80211_STATUS_NOT_ASSOCED () { 11; }") unless defined(&IEEE80211_STATUS_NOT_ASSOCED);
    eval("sub IEEE80211_STATUS_OTHER () { 12; }") unless defined(&IEEE80211_STATUS_OTHER);
    eval("sub IEEE80211_STATUS_ALG () { 13; }") unless defined(&IEEE80211_STATUS_ALG);
    eval("sub IEEE80211_STATUS_SEQUENCE () { 14; }") unless defined(&IEEE80211_STATUS_SEQUENCE);
    eval("sub IEEE80211_STATUS_CHALLENGE () { 15; }") unless defined(&IEEE80211_STATUS_CHALLENGE);
    eval("sub IEEE80211_STATUS_TIMEOUT () { 16; }") unless defined(&IEEE80211_STATUS_TIMEOUT);
    eval("sub IEEE80211_STATUS_TOOMANY () { 17; }") unless defined(&IEEE80211_STATUS_TOOMANY);
    eval("sub IEEE80211_STATUS_BASIC_RATE () { 18; }") unless defined(&IEEE80211_STATUS_BASIC_RATE);
    eval("sub IEEE80211_STATUS_SP_REQUIRED () { 19; }") unless defined(&IEEE80211_STATUS_SP_REQUIRED);
    eval("sub IEEE80211_STATUS_PBCC_REQUIRED () { 20; }") unless defined(&IEEE80211_STATUS_PBCC_REQUIRED);
    eval("sub IEEE80211_STATUS_CA_REQUIRED () { 21; }") unless defined(&IEEE80211_STATUS_CA_REQUIRED);
    eval("sub IEEE80211_STATUS_TOO_MANY_STATIONS () { 22; }") unless defined(&IEEE80211_STATUS_TOO_MANY_STATIONS);
    eval("sub IEEE80211_STATUS_RATES () { 23; }") unless defined(&IEEE80211_STATUS_RATES);
    eval("sub IEEE80211_STATUS_SHORTSLOT_REQUIRED () { 25; }") unless defined(&IEEE80211_STATUS_SHORTSLOT_REQUIRED);
    eval("sub IEEE80211_STATUS_DSSSOFDM_REQUIRED () { 26; }") unless defined(&IEEE80211_STATUS_DSSSOFDM_REQUIRED);
    eval("sub IEEE80211_STATUS_TRY_AGAIN_LATER () { 30; }") unless defined(&IEEE80211_STATUS_TRY_AGAIN_LATER);
    eval("sub IEEE80211_STATUS_MFP_POLICY () { 31; }") unless defined(&IEEE80211_STATUS_MFP_POLICY);
    eval("sub IEEE80211_STATUS_REFUSED () { 37; }") unless defined(&IEEE80211_STATUS_REFUSED);
    eval("sub IEEE80211_STATUS_INVALID_PARAM () { 38; }") unless defined(&IEEE80211_STATUS_INVALID_PARAM);
    eval("sub IEEE80211_STATUS_IE_INVALID () { 40; }") unless defined(&IEEE80211_STATUS_IE_INVALID);
    eval("sub IEEE80211_STATUS_BAD_GROUP_CIPHER () { 41; }") unless defined(&IEEE80211_STATUS_BAD_GROUP_CIPHER);
    eval("sub IEEE80211_STATUS_BAD_PAIRWISE_CIPHER () { 42; }") unless defined(&IEEE80211_STATUS_BAD_PAIRWISE_CIPHER);
    eval("sub IEEE80211_STATUS_BAD_AKMP () { 43; }") unless defined(&IEEE80211_STATUS_BAD_AKMP);
    eval("sub IEEE80211_STATUS_RSN_IE_VER_UNSUP () { 44; }") unless defined(&IEEE80211_STATUS_RSN_IE_VER_UNSUP);
    eval("sub IEEE80211_STATUS_CIPHER_REJ_POLICY () { 46; }") unless defined(&IEEE80211_STATUS_CIPHER_REJ_POLICY);
    eval 'sub IEEE80211_WEP_KEYLEN () {5;}' unless defined(&IEEE80211_WEP_KEYLEN);
    eval 'sub IEEE80211_WEP_NKID () {4;}' unless defined(&IEEE80211_WEP_NKID);
    eval 'sub IEEE80211_CHALLENGE_LEN () {128;}' unless defined(&IEEE80211_CHALLENGE_LEN);
    eval 'sub IEEE80211_WEP_IVLEN () {3;}' unless defined(&IEEE80211_WEP_IVLEN);
    eval 'sub IEEE80211_WEP_KIDLEN () {1;}' unless defined(&IEEE80211_WEP_KIDLEN);
    eval 'sub IEEE80211_WEP_CRCLEN () {4;}' unless defined(&IEEE80211_WEP_CRCLEN);
    eval 'sub IEEE80211_CRC_LEN () {4;}' unless defined(&IEEE80211_CRC_LEN);
    eval 'sub IEEE80211_WEP_TOTLEN () {( &IEEE80211_WEP_IVLEN +  &IEEE80211_WEP_KIDLEN +  &IEEE80211_WEP_CRCLEN);}' unless defined(&IEEE80211_WEP_TOTLEN);
    eval 'sub IEEE80211_WEP_EXTIV () {0x20;}' unless defined(&IEEE80211_WEP_EXTIV);
    eval 'sub IEEE80211_WEP_EXTIVLEN () {4;}' unless defined(&IEEE80211_WEP_EXTIVLEN);
    eval 'sub IEEE80211_WEP_MICLEN () {8;}' unless defined(&IEEE80211_WEP_MICLEN);
    eval 'sub IEEE80211_MTU_MAX () {2290;}' unless defined(&IEEE80211_MTU_MAX);
    eval 'sub IEEE80211_MTU_MIN () {32;}' unless defined(&IEEE80211_MTU_MIN);
    eval 'sub IEEE80211_MAX_LEN () {(2300+  &IEEE80211_CRC_LEN + ( &IEEE80211_WEP_IVLEN +  &IEEE80211_WEP_KIDLEN +  &IEEE80211_WEP_CRCLEN));}' unless defined(&IEEE80211_MAX_LEN);
    eval 'sub IEEE80211_ACK_LEN () {($sizeof{\'struct ieee80211_frame_ack\'} +  &IEEE80211_CRC_LEN);}' unless defined(&IEEE80211_ACK_LEN);
    eval 'sub IEEE80211_MIN_LEN () {($sizeof{\'struct ieee80211_frame_min\'} +  &IEEE80211_CRC_LEN);}' unless defined(&IEEE80211_MIN_LEN);
    eval 'sub IEEE80211_AID_MAX () {2007;}' unless defined(&IEEE80211_AID_MAX);
    eval 'sub IEEE80211_AID_DEF () {1800;}' unless defined(&IEEE80211_AID_DEF);
    eval 'sub IEEE80211_AID {
        my($b) = @_;
	    eval q((($b) &~ 0xc000));
    }' unless defined(&IEEE80211_AID);
    eval 'sub IEEE80211_RTS_DEFAULT () {512;}' unless defined(&IEEE80211_RTS_DEFAULT);
    eval 'sub IEEE80211_RTS_MIN () {1;}' unless defined(&IEEE80211_RTS_MIN);
    eval 'sub IEEE80211_RTS_MAX () { &IEEE80211_MAX_LEN;}' unless defined(&IEEE80211_RTS_MAX);
    eval 'sub IEEE80211_PLCP_SERVICE () {0x;}' unless defined(&IEEE80211_PLCP_SERVICE);
    eval 'sub IEEE80211_PLCP_SERVICE_PBCC () {0x8;}' unless defined(&IEEE80211_PLCP_SERVICE_PBCC);
    eval 'sub IEEE80211_PLCP_SERVICE_LENEXT () {0x80;}' unless defined(&IEEE80211_PLCP_SERVICE_LENEXT);
    eval 'sub IEEE80211_DUR_TU () {1024;}' unless defined(&IEEE80211_DUR_TU);
    eval 'sub IEEE80211_DUR_DS_LONG_PREAMBLE () {144;}' unless defined(&IEEE80211_DUR_DS_LONG_PREAMBLE);
    eval 'sub IEEE80211_DUR_DS_SHORT_PREAMBLE () {72;}' unless defined(&IEEE80211_DUR_DS_SHORT_PREAMBLE);
    eval 'sub IEEE80211_DUR_DS_PREAMBLE_DIFFERENCE () {( &IEEE80211_DUR_DS_LONG_PREAMBLE -  &IEEE80211_DUR_DS_SHORT_PREAMBLE);}' unless defined(&IEEE80211_DUR_DS_PREAMBLE_DIFFERENCE);
    eval 'sub IEEE80211_DUR_DS_FAST_PLCPHDR () {24;}' unless defined(&IEEE80211_DUR_DS_FAST_PLCPHDR);
    eval 'sub IEEE80211_DUR_DS_SLOW_PLCPHDR () {48;}' unless defined(&IEEE80211_DUR_DS_SLOW_PLCPHDR);
    eval 'sub IEEE80211_DUR_DS_PLCPHDR_DIFFERENCE () {( &IEEE80211_DUR_DS_SLOW_PLCPHDR -  &IEEE80211_DUR_DS_FAST_PLCPHDR);}' unless defined(&IEEE80211_DUR_DS_PLCPHDR_DIFFERENCE);
    eval 'sub IEEE80211_DUR_DS_SLOW_ACK () {112;}' unless defined(&IEEE80211_DUR_DS_SLOW_ACK);
    eval 'sub IEEE80211_DUR_DS_FAST_ACK () {56;}' unless defined(&IEEE80211_DUR_DS_FAST_ACK);
    eval 'sub IEEE80211_DUR_DS_SLOW_CTS () {112;}' unless defined(&IEEE80211_DUR_DS_SLOW_CTS);
    eval 'sub IEEE80211_DUR_DS_FAST_CTS () {56;}' unless defined(&IEEE80211_DUR_DS_FAST_CTS);
    eval 'sub IEEE80211_DUR_DS_SLOT () {20;}' unless defined(&IEEE80211_DUR_DS_SLOT);
    eval 'sub IEEE80211_DUR_DS_SIFS () {10;}' unless defined(&IEEE80211_DUR_DS_SIFS);
    eval 'sub IEEE80211_DUR_DS_PIFS () {( &IEEE80211_DUR_DS_SIFS +  &IEEE80211_DUR_DS_SLOT);}' unless defined(&IEEE80211_DUR_DS_PIFS);
    eval 'sub IEEE80211_DUR_DS_DIFS () {( &IEEE80211_DUR_DS_SIFS + 2*  &IEEE80211_DUR_DS_SLOT);}' unless defined(&IEEE80211_DUR_DS_DIFS);
    eval 'sub IEEE80211_DUR_DS_EIFS () {( &IEEE80211_DUR_DS_SIFS +  &IEEE80211_DUR_DS_SLOW_ACK +  &IEEE80211_DUR_DS_LONG_PREAMBLE +  &IEEE80211_DUR_DS_SLOW_PLCPHDR +  &IEEE80211_DUR_DIFS);}' unless defined(&IEEE80211_DUR_DS_EIFS);
    eval 'sub EAPOL_KEY_NONCE_LEN () {32;}' unless defined(&EAPOL_KEY_NONCE_LEN);
    eval 'sub EAPOL_KEY_IV_LEN () {16;}' unless defined(&EAPOL_KEY_IV_LEN);
    eval 'sub EAPOL_KEY_MIC_LEN () {16;}' unless defined(&EAPOL_KEY_MIC_LEN);
    eval 'sub EAPOL_VERSION () {1;}' unless defined(&EAPOL_VERSION);
    eval 'sub EAP_PACKET () {0;}' unless defined(&EAP_PACKET);
    eval 'sub EAPOL_START () {1;}' unless defined(&EAPOL_START);
    eval 'sub EAPOL_LOGOFF () {2;}' unless defined(&EAPOL_LOGOFF);
    eval 'sub EAPOL_KEY () {3;}' unless defined(&EAPOL_KEY);
    eval 'sub EAPOL_ASF_ALERT () {4;}' unless defined(&EAPOL_ASF_ALERT);
    eval 'sub EAPOL_KEY_DESC_RC4 () {1;}' unless defined(&EAPOL_KEY_DESC_RC4);
    eval 'sub EAPOL_KEY_DESC_IEEE80211 () {2;}' unless defined(&EAPOL_KEY_DESC_IEEE80211);
    eval 'sub EAPOL_KEY_DESC_WPA () {254;}' unless defined(&EAPOL_KEY_DESC_WPA);
    eval 'sub EAPOL_KEY_VERSION_MASK () {0x7;}' unless defined(&EAPOL_KEY_VERSION_MASK);
    eval 'sub EAPOL_KEY_DESC_V1 () {1;}' unless defined(&EAPOL_KEY_DESC_V1);
    eval 'sub EAPOL_KEY_DESC_V2 () {2;}' unless defined(&EAPOL_KEY_DESC_V2);
    eval 'sub EAPOL_KEY_DESC_V3 () {3;}' unless defined(&EAPOL_KEY_DESC_V3);
    eval 'sub EAPOL_KEY_PAIRWISE () {(1<< 3);}' unless defined(&EAPOL_KEY_PAIRWISE);
    eval 'sub EAPOL_KEY_INSTALL () {(1<< 6);}' unless defined(&EAPOL_KEY_INSTALL);
    eval 'sub EAPOL_KEY_KEYACK () {(1<< 7);}' unless defined(&EAPOL_KEY_KEYACK);
    eval 'sub EAPOL_KEY_KEYMIC () {(1<< 8);}' unless defined(&EAPOL_KEY_KEYMIC);
    eval 'sub EAPOL_KEY_SECURE () {(1<< 9);}' unless defined(&EAPOL_KEY_SECURE);
    eval 'sub EAPOL_KEY_ERROR () {(1<< 10);}' unless defined(&EAPOL_KEY_ERROR);
    eval 'sub EAPOL_KEY_REQUEST () {(1<< 11);}' unless defined(&EAPOL_KEY_REQUEST);
    eval 'sub EAPOL_KEY_ENCRYPTED () {(1<< 12);}' unless defined(&EAPOL_KEY_ENCRYPTED);
    eval 'sub EAPOL_KEY_SMK () {(1<< 13);}' unless defined(&EAPOL_KEY_SMK);
    eval 'sub EAPOL_KEY_WPA_KID_MASK () {0x3;}' unless defined(&EAPOL_KEY_WPA_KID_MASK);
    eval 'sub EAPOL_KEY_WPA_KID_SHIFT () {4;}' unless defined(&EAPOL_KEY_WPA_KID_SHIFT);
    eval 'sub EAPOL_KEY_WPA_TX () { &EAPOL_KEY_INSTALL;}' unless defined(&EAPOL_KEY_WPA_TX);
    eval 'sub IEEE80211_PMKID_LEN () {16;}' unless defined(&IEEE80211_PMKID_LEN);
    eval 'sub IEEE80211_SMKID_LEN () {16;}' unless defined(&IEEE80211_SMKID_LEN);
    eval("sub IEEE80211_KDE_GTK () { 1; }") unless defined(&IEEE80211_KDE_GTK);
    eval("sub IEEE80211_KDE_MACADDR () { 3; }") unless defined(&IEEE80211_KDE_MACADDR);
    eval("sub IEEE80211_KDE_PMKID () { 4; }") unless defined(&IEEE80211_KDE_PMKID);
    eval("sub IEEE80211_KDE_SMK () { 5; }") unless defined(&IEEE80211_KDE_SMK);
    eval("sub IEEE80211_KDE_NONCE () { 6; }") unless defined(&IEEE80211_KDE_NONCE);
    eval("sub IEEE80211_KDE_LIFETIME () { 7; }") unless defined(&IEEE80211_KDE_LIFETIME);
    eval("sub IEEE80211_KDE_ERROR () { 8; }") unless defined(&IEEE80211_KDE_ERROR);
    eval("sub IEEE80211_KDE_IGTK () { 9; }") unless defined(&IEEE80211_KDE_IGTK);
    eval("sub IEEE80211_HTPROT_NONE () { 0; }") unless defined(&IEEE80211_HTPROT_NONE);
    eval("sub IEEE80211_HTPROT_NONMEMBER () { 1; }") unless defined(&IEEE80211_HTPROT_NONMEMBER);
    eval("sub IEEE80211_HTPROT_20MHZ () { 2; }") unless defined(&IEEE80211_HTPROT_20MHZ);
    eval("sub IEEE80211_HTPROT_NONHT_MIXED () { 3; }") unless defined(&IEEE80211_HTPROT_NONHT_MIXED);
}
1;
