require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PMAP_H_)) {
    eval 'sub _MACHINE_PMAP_H_ () {1;}' unless defined(&_MACHINE_PMAP_H_);
    require 'uvm/uvm_object.ph';
    require 'sys/mutex.ph';
    if(defined(&_KERNEL)) {
	require 'machine/pte.ph';
	eval 'sub HPPA_MAX_PID () {0xfffa;}' unless defined(&HPPA_MAX_PID);
	eval 'sub HPPA_SID_MAX () {0x7ffd;}' unless defined(&HPPA_SID_MAX);
	eval 'sub HPPA_SID_KERNEL () {0;}' unless defined(&HPPA_SID_KERNEL);
	eval 'sub HPPA_PID_KERNEL () {2;}' unless defined(&HPPA_PID_KERNEL);
	eval 'sub KERNEL_ACCESS_ID () {1;}' unless defined(&KERNEL_ACCESS_ID);
	eval 'sub KERNEL_TEXT_PROT () {( &TLB_AR_KRX | ( &KERNEL_ACCESS_ID << 1));}' unless defined(&KERNEL_TEXT_PROT);
	eval 'sub KERNEL_DATA_PROT () {( &TLB_AR_KRW | ( &KERNEL_ACCESS_ID << 1));}' unless defined(&KERNEL_DATA_PROT);
	if(defined(&HP7100LC_CPU) || defined(&HP7300LC_CPU)) {
	}
	eval 'sub pmap_map_direct {
	    my($pg) = @_;
    	    eval q((( &vaddr_t) &VM_PAGE_TO_PHYS($pg)));
	}' unless defined(&pmap_map_direct);
	eval 'sub __HAVE_PMAP_DIRECT () {1;}' unless defined(&__HAVE_PMAP_DIRECT);
	eval 'sub PMAP_PREFER {
	    my($o,$h) = @_;
    	    eval q( &pmap_prefer($o, $h));
	}' unless defined(&PMAP_PREFER);
	eval 'sub PMAP_PREFER_ALIGN () {
	    eval q(( &HPPA_PGALIAS));
	}' unless defined(&PMAP_PREFER_ALIGN);
	eval 'sub PMAP_PREFER_OFFSET {
	    my($of) = @_;
    	    eval q((($of) &  &HPPA_PGAOFF));
	}' unless defined(&PMAP_PREFER_OFFSET);
	eval 'sub pmap_sid2pid {
	    my($s) = @_;
    	    eval q(((($s) + 1) << 1));
	}' unless defined(&pmap_sid2pid);
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_update {
	    my($pm) = @_;
    	    eval q(( &void)($pm));
	}' unless defined(&pmap_update);
	eval 'sub pmap_copy {
	    my($dpmap,$spmap,$da,$len,$sa) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_clear_modify {
	    my($pg) = @_;
    	    eval q( &pmap_changebit($pg, 0,  &PTE_PROT( &TLB_DIRTY)));
	}' unless defined(&pmap_clear_modify);
	eval 'sub pmap_clear_reference {
	    my($pg) = @_;
    	    eval q( &pmap_changebit($pg,  &PTE_PROT( &TLB_REFTRAP), 0));
	}' unless defined(&pmap_clear_reference);
	eval 'sub pmap_is_modified {
	    my($pg) = @_;
    	    eval q( &pmap_testbit($pg,  &PTE_PROT( &TLB_DIRTY)));
	}' unless defined(&pmap_is_modified);
	eval 'sub pmap_is_referenced {
	    my($pg) = @_;
    	    eval q( &pmap_testbit($pg,  &PTE_PROT( &TLB_REFTRAP)));
	}' unless defined(&pmap_is_referenced);
	eval 'sub pmap_unuse_final {
	    my($p) = @_;
    	    eval q();
	}' unless defined(&pmap_unuse_final);
	eval 'sub pmap_remove_holes {
	    my($vm) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pmap_remove_holes);
	eval 'sub pmap_prot {
	    my($pmap,$prot) = @_;
    	    eval q({ \'u_int\'  $hppa_prot[]; ( $hppa_prot[$prot] | ($pmap ==  &pmap_kernel()? 0:  &TLB_USER)); });
	}' unless defined(&pmap_prot);
	eval 'sub pmap_page_protect {
	    my($pg,$prot) = @_;
    	    eval q({  &if (($prot &  &PROT_WRITE) == 0) {  &if ($prot & ( &PROT_READ |  &PROT_EXEC))  &pmap_changebit($pg, 0,  &PTE_PROT( &TLB_WRITE));  &else  &pmap_page_remove($pg); } });
	}' unless defined(&pmap_page_protect);
	eval 'sub pmap_protect {
	    my($pmap,$sva,$eva,$prot) = @_;
    	    eval q({  &if (($prot &  &PROT_WRITE) == 0) {  &if ($prot & ( &PROT_READ |  &PROT_EXEC))  &pmap_write_protect($pmap, $sva, $eva, $prot);  &else  &pmap_remove($pmap, $sva, $eva); } });
	}' unless defined(&pmap_protect);
    }
    if(!defined(&_LOCORE)) {
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do {  &mtx_init(($pg)-> ($mdpage->{pvh_mtx}),  &IPL_VM); ($pg)-> ($mdpage->{pvh_list}) =  &NULL; ($pg)-> ($mdpage->{pvh_attrs}) = 0; }  &while (0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
