require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_EXTERNAL_BSD_DWC2_DWC2_H_)) {
    eval 'sub _EXTERNAL_BSD_DWC2_DWC2_H_ () {1;}' unless defined(&_EXTERNAL_BSD_DWC2_DWC2_H_);
    require 'sys/param.ph';
    require 'sys/kernel.ph';
    require 'sys/task.ph';
    require 'sys/timeout.ph';
    require 'lib/libkern/libkern.ph';
    if(0) {
	require './dev/usb/dwc2/opt_usb.ph';
    }
    eval 'sub STATIC_INLINE () { &static  &inline;}' unless defined(&STATIC_INLINE);
    eval 'sub STATIC () {1;}' unless defined(&STATIC);
    eval 'sub IRQ_NONE () {0;}' unless defined(&IRQ_NONE);
    eval 'sub IRQ_HANDLED () {1;}' unless defined(&IRQ_HANDLED);
    eval 'sub u8 () { &uint8_t;}' unless defined(&u8);
    eval 'sub u16 () { &uint16_t;}' unless defined(&u16);
    eval 'sub s16 () { &int16_t;}' unless defined(&s16);
    eval 'sub u32 () { &uint32_t;}' unless defined(&u32);
    eval 'sub u64 () { &uint64_t;}' unless defined(&u64);
    eval 'sub dma_addr_t () { &bus_addr_t;}' unless defined(&dma_addr_t);
    if(defined(&DWC2_DEBUG)) {
	eval 'sub WARN_ON {
	    my($x) = @_;
    	    eval q( &KASSERT(!($x)));
	}' unless defined(&WARN_ON);
	eval 'sub dev_info () {( &d, &fmt,...)  &do {  &printf("%s: "  &fmt,  &device_xname( &d),   &__VA_ARGS__); }  &while (0);}' unless defined(&dev_info);
	eval 'sub dev_warn () {( &d, &fmt,...)  &do {  &printf("%s: "  &fmt,  &device_xname( &d),   &__VA_ARGS__); }  &while (0);}' unless defined(&dev_warn);
	eval 'sub dev_err () {( &d, &fmt,...)  &do {  &printf("%s: "  &fmt,  &device_xname( &d),   &__VA_ARGS__); }  &while (0);}' unless defined(&dev_err);
	eval 'sub dev_dbg () {( &d, &fmt,...)  &do {  &if ( &dwc2debug >= 1) {  &printf("%s: "  &fmt,  &device_xname( &d),   &__VA_ARGS__); } }  &while (0);}' unless defined(&dev_dbg);
	eval 'sub dev_vdbg () {( &d, &fmt,...)  &do {  &if ( &dwc2debug >= 2) {  &printf("%s: "  &fmt,  &device_xname( &d),   &__VA_ARGS__); } }  &while (0);}' unless defined(&dev_vdbg);
    } else {
	eval 'sub WARN_ON {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&WARN_ON);
	eval 'sub dev_info () {(...)  &do { }  &while (0);}' unless defined(&dev_info);
	eval 'sub dev_warn () {(...)  &do { }  &while (0);}' unless defined(&dev_warn);
	eval 'sub dev_err () {(...)  &do { }  &while (0);}' unless defined(&dev_err);
	eval 'sub dev_dbg () {(...)  &do { }  &while (0);}' unless defined(&dev_dbg);
	eval 'sub dev_vdbg () {(...)  &do { }  &while (0);}' unless defined(&dev_vdbg);
    }
    eval 'sub jiffies () { &hardclock_ticks;}' unless defined(&jiffies);
    eval 'sub msecs_to_jiffies () { &mstohz;}' unless defined(&msecs_to_jiffies);
    eval 'sub gfp_t () {\'int\';}' unless defined(&gfp_t);
    eval 'sub GFP_KERNEL () { &M_WAITOK;}' unless defined(&GFP_KERNEL);
    eval 'sub GFP_ATOMIC () { &M_NOWAIT;}' unless defined(&GFP_ATOMIC);
    eval("sub OTG_STATE_RESERVED () { 0; }") unless defined(&OTG_STATE_RESERVED);
    eval("sub OTG_STATE_A_HOST () { 1; }") unless defined(&OTG_STATE_A_HOST);
    eval("sub OTG_STATE_A_PERIPHERAL () { 2; }") unless defined(&OTG_STATE_A_PERIPHERAL);
    eval("sub OTG_STATE_A_SUSPEND () { 3; }") unless defined(&OTG_STATE_A_SUSPEND);
    eval("sub OTG_STATE_B_HOST () { 4; }") unless defined(&OTG_STATE_B_HOST);
    eval("sub OTG_STATE_B_PERIPHERAL () { 5; }") unless defined(&OTG_STATE_B_PERIPHERAL);
    eval 'sub usleep_range {
        my($l, $u) = @_;
	    eval q( &do {  &DELAY($u); }  &while (0));
    }' unless defined(&usleep_range);
    eval 'sub spinlock_t () {\'struct mutex\';}' unless defined(&spinlock_t);
    eval 'sub spin_lock_init {
        my($lock) = @_;
	    eval q( &mtx_init($lock,  &IPL_SCHED));
    }' unless defined(&spin_lock_init);
    eval 'sub spin_lock {
        my($l) = @_;
	    eval q( &do {  &mtx_enter($l); }  &while (0));
    }' unless defined(&spin_lock);
    eval 'sub spin_unlock {
        my($l) = @_;
	    eval q( &do {  &mtx_leave($l); }  &while (0));
    }' unless defined(&spin_unlock);
    eval 'sub spin_lock_irqsave {
        my($l, $f) = @_;
	    eval q( &do {  &mtx_enter($l); ( &void)($f); }  &while (0));
    }' unless defined(&spin_lock_irqsave);
    eval 'sub spin_unlock_irqrestore {
        my($l, $f) = @_;
	    eval q( &do {  &mtx_leave($l); ( &void)($f); }  &while (0));
    }' unless defined(&spin_unlock_irqrestore);
    eval 'sub IRQ_RETVAL {
        my($r) = @_;
	    eval q(($r));
    }' unless defined(&IRQ_RETVAL);
    eval 'sub USB_ENDPOINT_XFER_CONTROL () { &UE_CONTROL;}' unless defined(&USB_ENDPOINT_XFER_CONTROL);
    eval 'sub USB_ENDPOINT_XFER_ISOC () { &UE_ISOCHRONOUS;}' unless defined(&USB_ENDPOINT_XFER_ISOC);
    eval 'sub USB_ENDPOINT_XFER_BULK () { &UE_BULK;}' unless defined(&USB_ENDPOINT_XFER_BULK);
    eval 'sub USB_ENDPOINT_XFER_INT () { &UE_INTERRUPT;}' unless defined(&USB_ENDPOINT_XFER_INT);
    eval 'sub USB_DIR_IN () { &UE_DIR_IN;}' unless defined(&USB_DIR_IN);
    eval 'sub USB_DIR_OUT () { &UE_DIR_OUT;}' unless defined(&USB_DIR_OUT);
    eval 'sub USB_PORT_FEAT_CONNECTION () { &UHF_PORT_CONNECTION;}' unless defined(&USB_PORT_FEAT_CONNECTION);
    eval 'sub USB_PORT_FEAT_ENABLE () { &UHF_PORT_ENABLE;}' unless defined(&USB_PORT_FEAT_ENABLE);
    eval 'sub USB_PORT_FEAT_SUSPEND () { &UHF_PORT_SUSPEND;}' unless defined(&USB_PORT_FEAT_SUSPEND);
    eval 'sub USB_PORT_FEAT_OVER_CURRENT () { &UHF_PORT_OVER_CURRENT;}' unless defined(&USB_PORT_FEAT_OVER_CURRENT);
    eval 'sub USB_PORT_FEAT_RESET () { &UHF_PORT_RESET;}' unless defined(&USB_PORT_FEAT_RESET);
    eval 'sub USB_PORT_FEAT_POWER () { &UHF_PORT_POWER;}' unless defined(&USB_PORT_FEAT_POWER);
    eval 'sub USB_PORT_FEAT_LOWSPEED () { &UHF_PORT_LOW_SPEED;}' unless defined(&USB_PORT_FEAT_LOWSPEED);
    eval 'sub USB_PORT_FEAT_C_CONNECTION () { &UHF_C_PORT_CONNECTION;}' unless defined(&USB_PORT_FEAT_C_CONNECTION);
    eval 'sub USB_PORT_FEAT_C_ENABLE () { &UHF_C_PORT_ENABLE;}' unless defined(&USB_PORT_FEAT_C_ENABLE);
    eval 'sub USB_PORT_FEAT_C_SUSPEND () { &UHF_C_PORT_SUSPEND;}' unless defined(&USB_PORT_FEAT_C_SUSPEND);
    eval 'sub USB_PORT_FEAT_C_OVER_CURRENT () { &UHF_C_PORT_OVER_CURRENT;}' unless defined(&USB_PORT_FEAT_C_OVER_CURRENT);
    eval 'sub USB_PORT_FEAT_C_RESET () { &UHF_C_PORT_RESET;}' unless defined(&USB_PORT_FEAT_C_RESET);
    eval 'sub USB_PORT_FEAT_TEST () { &UHF_PORT_TEST;}' unless defined(&USB_PORT_FEAT_TEST);
    eval 'sub USB_PORT_FEAT_INDICATOR () { &UHF_PORT_INDICATOR;}' unless defined(&USB_PORT_FEAT_INDICATOR);
    eval 'sub USB_PORT_FEAT_C_PORT_L1 () { &UHF_C_PORT_L1;}' unless defined(&USB_PORT_FEAT_C_PORT_L1);
    eval 'sub C_HUB_LOCAL_POWER () { &UHF_C_HUB_LOCAL_POWER;}' unless defined(&C_HUB_LOCAL_POWER);
    eval 'sub C_HUB_OVER_CURRENT () { &UHF_C_HUB_OVER_CURRENT;}' unless defined(&C_HUB_OVER_CURRENT);
    eval 'sub USB_REQ_GET_STATUS () { &UR_GET_STATUS;}' unless defined(&USB_REQ_GET_STATUS);
    eval 'sub USB_REQ_CLEAR_FEATURE () { &UR_CLEAR_FEATURE;}' unless defined(&USB_REQ_CLEAR_FEATURE);
    eval 'sub USB_REQ_SET_FEATURE () { &UR_SET_FEATURE;}' unless defined(&USB_REQ_SET_FEATURE);
    eval 'sub USB_REQ_GET_DESCRIPTOR () { &UR_GET_DESCRIPTOR;}' unless defined(&USB_REQ_GET_DESCRIPTOR);
    eval 'sub ClearHubFeature () {(( &UT_WRITE_CLASS_DEVICE << 8) |  &USB_REQ_CLEAR_FEATURE);}' unless defined(&ClearHubFeature);
    eval 'sub ClearPortFeature () {(( &UT_WRITE_CLASS_OTHER << 8) |  &USB_REQ_CLEAR_FEATURE);}' unless defined(&ClearPortFeature);
    eval 'sub GetHubDescriptor () {(( &UT_READ_CLASS_DEVICE << 8) |  &USB_REQ_GET_DESCRIPTOR);}' unless defined(&GetHubDescriptor);
    eval 'sub GetHubStatus () {(( &UT_READ_CLASS_DEVICE << 8) |  &USB_REQ_GET_STATUS);}' unless defined(&GetHubStatus);
    eval 'sub GetPortStatus () {(( &UT_READ_CLASS_OTHER << 8) |  &USB_REQ_GET_STATUS);}' unless defined(&GetPortStatus);
    eval 'sub SetHubFeature () {(( &UT_WRITE_CLASS_DEVICE << 8) |  &USB_REQ_SET_FEATURE);}' unless defined(&SetHubFeature);
    eval 'sub SetPortFeature () {(( &UT_WRITE_CLASS_OTHER << 8) |  &USB_REQ_SET_FEATURE);}' unless defined(&SetPortFeature);
    eval 'sub USB_PORT_STAT_CONNECTION () { &UPS_CURRENT_CONNECT_STATUS;}' unless defined(&USB_PORT_STAT_CONNECTION);
    eval 'sub USB_PORT_STAT_ENABLE () { &UPS_PORT_ENABLED;}' unless defined(&USB_PORT_STAT_ENABLE);
    eval 'sub USB_PORT_STAT_SUSPEND () { &UPS_SUSPEND;}' unless defined(&USB_PORT_STAT_SUSPEND);
    eval 'sub USB_PORT_STAT_OVERCURRENT () { &UPS_OVERCURRENT_INDICATOR;}' unless defined(&USB_PORT_STAT_OVERCURRENT);
    eval 'sub USB_PORT_STAT_RESET () { &UPS_RESET;}' unless defined(&USB_PORT_STAT_RESET);
    eval 'sub USB_PORT_STAT_L1 () { &UPS_PORT_L1;}' unless defined(&USB_PORT_STAT_L1);
    eval 'sub USB_PORT_STAT_POWER () { &UPS_PORT_POWER;}' unless defined(&USB_PORT_STAT_POWER);
    eval 'sub USB_PORT_STAT_LOW_SPEED () { &UPS_LOW_SPEED;}' unless defined(&USB_PORT_STAT_LOW_SPEED);
    eval 'sub USB_PORT_STAT_HIGH_SPEED () { &UPS_HIGH_SPEED;}' unless defined(&USB_PORT_STAT_HIGH_SPEED);
    eval 'sub USB_PORT_STAT_TEST () { &UPS_PORT_TEST;}' unless defined(&USB_PORT_STAT_TEST);
    eval 'sub USB_PORT_STAT_INDICATOR () { &UPS_PORT_INDICATOR;}' unless defined(&USB_PORT_STAT_INDICATOR);
    eval 'sub USB_PORT_STAT_C_CONNECTION () { &UPS_C_CONNECT_STATUS;}' unless defined(&USB_PORT_STAT_C_CONNECTION);
    eval 'sub USB_PORT_STAT_C_ENABLE () { &UPS_C_PORT_ENABLED;}' unless defined(&USB_PORT_STAT_C_ENABLE);
    eval 'sub USB_PORT_STAT_C_SUSPEND () { &UPS_C_SUSPEND;}' unless defined(&USB_PORT_STAT_C_SUSPEND);
    eval 'sub USB_PORT_STAT_C_OVERCURRENT () { &UPS_C_OVERCURRENT_INDICATOR;}' unless defined(&USB_PORT_STAT_C_OVERCURRENT);
    eval 'sub USB_PORT_STAT_C_RESET () { &UPS_C_PORT_RESET;}' unless defined(&USB_PORT_STAT_C_RESET);
    eval 'sub USB_PORT_STAT_C_L1 () { &UPS_C_PORT_L1;}' unless defined(&USB_PORT_STAT_C_L1);
    eval 'sub EREMOTEIO () { &EIO;}' unless defined(&EREMOTEIO);
    eval 'sub ECOMM () { &EIO;}' unless defined(&ECOMM);
    eval 'sub NS_TO_US {
        my($ns) = @_;
	    eval q((($ns + 500) / 1000));
    }' unless defined(&NS_TO_US);
}
1;
