require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_DB_MACHDEP_H_)) {
    eval 'sub _MACHINE_DB_MACHDEP_H_ () {1;}' unless defined(&_MACHINE_DB_MACHDEP_H_);
    require 'sys/param.ph';
    require 'uvm/uvm_extern.ph';
    require 'machine/trap.ph';
    require 'machine/psl.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &pc));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q(-> &pc = ($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub BKPT_INST () {0x3;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(1);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub FIXUP_PC_AFTER_BREAK {
        my($regs) = @_;
	    eval q((($regs)-> &pc -=  &BKPT_SIZE));
    }' unless defined(&FIXUP_PC_AFTER_BREAK);
    eval 'sub db_clear_single_step {
        my($regs) = @_;
	    eval q((($regs)-> &psl &= ~ &PSL_T));
    }' unless defined(&db_clear_single_step);
    eval 'sub db_set_single_step {
        my($regs) = @_;
	    eval q((($regs)-> &psl |=  &PSL_T));
    }' unless defined(&db_set_single_step);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_BPTFLT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_TRCTRAP));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub I_CALL () {0xfb;}' unless defined(&I_CALL);
    eval 'sub I_RET () {0x4;}' unless defined(&I_RET);
    eval 'sub I_IRET () {0x2;}' unless defined(&I_IRET);
    eval 'sub inst_trap_return {
        my($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_IRET));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        my($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_RET));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        my($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_CALL));
    }' unless defined(&inst_call);
}
1;
