<?php
/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

$autoloader = __DIR__ . '/../vendor/autoload.php';
if (!file_exists($autoloader)) {
    $autoloader = __DIR__ . '/../../../autoload.php';
}
include $autoloader;

$config = new \Doctrine\DBAL\Configuration();
$connectionParams = array(
    'dbname' => 'test',
    'user' => 'root',
    'password' => 'password',
    'host' => 'testfabric',
    'host' => 'localhost',
//    'unix_socket' => '/tmp/mysql.sock',
    'driver' => 'pdo_mysql',
    'server_charset' => 'utf8',
    'charset' => 'utf8',
    'sharding' => array(
        'shardTable' => 'test.fabrictest'
    )
);

$conn = \Doctrine\DBAL\DriverManager::getConnection($connectionParams, $config);
$sm = new \MySQLFabric\MySQLFabricShardManager($conn);

$schema = new \Doctrine\DBAL\Schema\Schema();
$test = $schema->createTable('fabrictest');
$test->addColumn('id', 'integer');
$test->setPrimaryKey(array('id'));

echo "Creating global table:\n";
$sync = new Doctrine\DBAL\Schema\Synchronizer\SingleDatabaseSynchronizer($conn);
$sm->selectGlobal();
var_dump(mysqlnd_ms_dump_servers($conn->getWrappedConnection()));
var_dump($sync->createSchema($schema));
echo "Server used: ".mysqlnd_ms_get_last_used_connection($conn->getWrappedConnection())['scheme']."\n\n";

echo "Inserting with ID 10:\n";
$sm->selectShard(10);
var_dump($conn->executeupdate('INSERT INTO fabrictest VALUES (10)'));
echo "Server used: ".mysqlnd_ms_get_last_used_connection($conn->getWrappedConnection())['scheme']."\n\n";

echo "Trying to read id 10 from 30010 (this should fail):\n";
$sm->selectShard(30010);
var_dump($conn->fetchAll('SELECT * FROM fabrictest'));
echo "Server used: ".mysqlnd_ms_get_last_used_connection($conn->getWrappedConnection())['scheme']."\n\n";

echo "Trying to read id 10 from shard 10:\n";
$sm->selectShard(10);
var_dump($conn->fetchAll('SELECT * FROM fabrictest'));
echo "Server used: ".mysqlnd_ms_get_last_used_connection($conn->getWrappedConnection())['scheme']."\n\n";


echo "Dropping table globally:\n";
$sm->selectGlobal();
var_dump($conn->executeUpdate('DROP TABLE fabrictest'));
echo "Server used: ".mysqlnd_ms_get_last_used_connection($conn->getWrappedConnection())['scheme']."\n\n";

