Ext.namespace('Zarafa.plugins.sugarcrm');

/**
 * @class Zarafa.plugins.sugarcrm.ABOUT
 * @extends String
 *
 * The copyright string holding the copyright notice for the Zarafa sugarcrm Plugin.
 */
Zarafa.plugins.sugarcrm.ABOUT = ""
	+ "<p>Copyright (C) 2005 - 2015  Zarafa B.V. &lt;info@zarafa.com&gt; and its licensors</p>"

	+ "<p>This program is free software: you can redistribute it and/or modify "
	+ "it under the terms of the GNU Affero General Public License as "
	+ "published by the Free Software Foundation, either version 3 of the "
	+ "License, or (at your option) any later version.</p>"

	+ "<p>This program is distributed in the hope that it will be useful, "
	+ "but WITHOUT ANY WARRANTY; without even the implied warranty of "
	+ "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
	+ "GNU Affero General Public License for more details.</p>"

	+ "<p>You should have received a copy of the GNU Affero General Public License "
	+ "along with this program.  If not, see <a href=\"http://www.gnu.org/licenses/\" target=\"_blank\">http://www.gnu.org/licenses/</a>.</p>";
Ext.namespace('Zarafa.plugins.sugarcrm');

/**
 * @class Zarafa.plugins.sugarcrm.SugarCRMPlugin
 * @extends Zarafa.core.Plugin
 *
 * SugarCRM integration plugin.
 * Allows to archive selected record to SugarCRM.
 */
Zarafa.plugins.sugarcrm.SugarCRMPlugin = Ext.extend(Zarafa.core.Plugin, {

	/**
	 * Called after constructor.
	 * Registers insertion point in contexts context menus.
	 * @protected
	 */
	initPlugin : function()
	{
		Zarafa.plugins.sugarcrm.SugarCRMPlugin.superclass.initPlugin.apply(this, arguments);

		this.registerInsertionPoint('context.mail.contextmenu.options', this.putAcrhiveMenuIconInContextMenu, this)
	},

	/**
	 * Creates configured context menu item.
	 *
	 * @return {Zarafa.core.ui.menu.ConditionalItem} menuItem MenuItem instance
	 */
	putAcrhiveMenuIconInContextMenu : function() {
		var plugin = this;
		var menuItem = {
			xtype       		: 'zarafa.conditionalitem',
			text        		: _('Archive to SugarCRM'),
			iconCls     		: 'icon_sugarcrm_archive',
			singleSelectOnly 	: true,
			handler     		: this.showArchiveToSugarCRMDialog,
			scope 				: this
		};
		return menuItem;
	},

	/**
	 * Send request to server after the user clicked on menu item.
	 * Opens the new window with returned url from server - in case of
	 * success.
	 *
	 */
	showArchiveToSugarCRMDialog : function(conditionalItem) {
		//In current version we take only the last selected record
		var selectedRecords = conditionalItem.getRecords();
		var lastRecord = selectedRecords[0];
		container.getRequest().singleRequest('sugarcrmmodule', 'archive', {
			entryid : lastRecord.get('entryid'),
			parent_entryid : lastRecord.get('parent_entryid'),
			store_entryid : lastRecord.get('store_entryid'),
			profile : 'sugarcrm'
		}, new Zarafa.plugins.sugarcrm.data.SugarCRMResponseHandler());
	}


});

Zarafa.onReady(function() {
	container.registerPlugin(new Zarafa.core.PluginMetaData({
		name : 'sugarcrm',
		displayName : _('SugarCRM Plugin'),
		about : Zarafa.plugins.sugarcrm.ABOUT,
		pluginConstructor : Zarafa.plugins.sugarcrm.SugarCRMPlugin
	}));
});
Ext.namespace('Zarafa.plugins.sugarcrm.data');

/**
 * @class Zarafa.plugins.sugarcrm.data.SugarCRMResponseHandler
 * @extends Zarafa.core.data.AbstractResponseHandler
 *
 * SugarCRM specific response handler.
 */
Zarafa.plugins.sugarcrm.data.SugarCRMResponseHandler = Ext.extend(Zarafa.core.data.AbstractResponseHandler, {

	/**
	 * Opens the window with the url returned from server or show error msg box in case of error.
	 * @param {Object} response Object contained the response data.
	 */
	doItem : function(response) {
		var server_url = response.serverurl;
		if(!Ext.isEmpty(server_url)) {
			window.open(server_url, "", "width=720,height=520,resizable=yes,scrollbars=yes");
		} else {
			Ext.MessageBox.show({
				title   : _('Warning'),
				msg     : response.message,
				icon    : Ext.MessageBox.WARNING,
				buttons : Ext.MessageBox.OK
			});
		}
	}
});

Ext.reg('sugarcrm.responsehandler', Zarafa.plugins.sugarcrm.data.SugarCRMResponseHandler);