/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.constructorfield;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.codegenerator.constructorfield.ConstructorFieldChangeProcessor;
import org.python.pydev.refactoring.codegenerator.constructorfield.ConstructorFieldRequestProcessor;
import org.python.pydev.refactoring.core.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.RefactoringInfo;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.model.constructorfield.ClassFieldTreeProvider;
import org.python.pydev.refactoring.ui.pages.ConstructorFieldPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorFieldRefactoring
extends AbstractPythonRefactoring {
    private ConstructorFieldRequestProcessor requestProcessor;
    private IChangeProcessor changeProcessor;

    public ConstructorFieldRefactoring(RefactoringInfo req) {
        super(req);
        try {
            this.initWizard();
        }
        catch (Throwable throwable) {
            this.status.addInfo(Messages.infoFixCode);
        }
    }

    private void initWizard() throws Throwable {
        ClassFieldTreeProvider provider = new ClassFieldTreeProvider(this.info.getScopeClass());
        this.requestProcessor = new ConstructorFieldRequestProcessor(this.info.getNewLineDelim());
        this.changeProcessor = new ConstructorFieldChangeProcessor(this.getName(), this.info, this.requestProcessor);
        this.pages.add(new ConstructorFieldPage(this.getName(), provider, this.requestProcessor));
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ArrayList<IChangeProcessor> processors = new ArrayList<IChangeProcessor>();
        processors.add(this.changeProcessor);
        return processors;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IClassDefAdapter rootClass = this.info.getScopeClass();
        if (rootClass != null && rootClass.getAttributes().size() > 0) {
            return this.status;
        }
        this.status.addFatalError(Messages.constructorFieldUnavailable);
        return this.status;
    }

    public String getName() {
        return Messages.constructorFieldLabel;
    }
}

