/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.connections.socket.ConnectionDescriptor;
import com.sun.star.lib.connections.socket.SocketConnection;
import com.sun.star.registry.XRegistryKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public final class socketConnector
implements XConnector {
    public static final String __serviceName = "com.sun.star.connection.socketConnector";
    private boolean connected = false;

    public static XSingleServiceFactory __getServiceFactory(String string, XMultiServiceFactory xMultiServiceFactory, XRegistryKey xRegistryKey) {
        return string.equals(socketConnector.class.getName()) ? FactoryHelper.getServiceFactory(socketConnector.class, __serviceName, xMultiServiceFactory, xRegistryKey) : null;
    }

    public synchronized XConnection connect(String string) throws NoConnectException, ConnectionSetupException {
        SocketConnection socketConnection;
        InetAddress[] inetAddressArray;
        ConnectionDescriptor connectionDescriptor;
        if (this.connected) {
            throw new ConnectionSetupException("alread connected");
        }
        try {
            connectionDescriptor = new ConnectionDescriptor(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConnectionSetupException(illegalArgumentException);
        }
        if (connectionDescriptor.getHost() == null) {
            throw new ConnectionSetupException("host parameter missing");
        }
        try {
            inetAddressArray = InetAddress.getAllByName(connectionDescriptor.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConnectionSetupException(unknownHostException);
        }
        Socket socket = null;
        for (int i = 0; i < inetAddressArray.length; ++i) {
            try {
                socket = new Socket(inetAddressArray[i], connectionDescriptor.getPort());
                break;
            }
            catch (IOException iOException) {
                if (i != inetAddressArray.length - 1) continue;
                throw new NoConnectException(iOException);
            }
        }
        try {
            if (connectionDescriptor.getTcpNoDelay() != null) {
                socket.setTcpNoDelay(connectionDescriptor.getTcpNoDelay());
            }
            socketConnection = new SocketConnection(string, socket);
        }
        catch (IOException iOException) {
            throw new NoConnectException(iOException);
        }
        this.connected = true;
        return socketConnection;
    }
}

