/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.helper;

import com.sun.star.comp.helper.ComponentContextEntry;
import com.sun.star.comp.helper.Disposer;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.DeploymentException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContext
implements XComponentContext,
XComponent {
    private static final boolean DEBUG = false;
    private static final String SMGR_NAME = "/singletons/com.sun.star.lang.theServiceManager";
    private static final String TDMGR_NAME = "/singletons/com.sun.star.reflection.theTypeDescriptionManager";
    private Map<String, Object> m_table;
    private XComponentContext m_xDelegate;
    private XMultiComponentFactory m_xSMgr;
    private boolean m_bDisposeSMgr;
    private ArrayList<XEventListener> m_eventListener = new ArrayList();

    public ComponentContext(Hashtable<String, Object> hashtable, XComponentContext xComponentContext) {
        this((Map<String, Object>)hashtable, xComponentContext);
    }

    public ComponentContext(Map<String, Object> map, XComponentContext xComponentContext) {
        this.m_table = map;
        this.m_xDelegate = xComponentContext;
        this.m_xSMgr = null;
        this.m_bDisposeSMgr = false;
        Object object = map.get(SMGR_NAME);
        if (object != null) {
            if (object instanceof ComponentContextEntry) {
                object = ((ComponentContextEntry)object).m_value;
            }
            this.m_xSMgr = UnoRuntime.queryInterface(XMultiComponentFactory.class, object);
        }
        if (this.m_xSMgr != null) {
            this.m_bDisposeSMgr = true;
        } else if (this.m_xDelegate != null) {
            this.m_xSMgr = this.m_xDelegate.getServiceManager();
        }
        XComponent xComponent = UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xDelegate);
        if (xComponent != null) {
            xComponent.addEventListener(new Disposer(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueByName(String string) {
        Object object = this.m_table.get(string);
        if (object != null) {
            if (object instanceof ComponentContextEntry) {
                ComponentContextEntry componentContextEntry = (ComponentContextEntry)object;
                if (componentContextEntry.m_lateInit != null) {
                    XInterface xInterface;
                    Object object2;
                    Object object3 = null;
                    try {
                        object2 = (String)componentContextEntry.m_lateInit;
                        if (object2 != null) {
                            if (this.m_xSMgr != null) {
                                object3 = this.m_xSMgr.createInstanceWithContext((String)object2, this);
                            }
                        } else {
                            xInterface = UnoRuntime.queryInterface(XSingleComponentFactory.class, componentContextEntry.m_lateInit);
                            if (xInterface != null) {
                                object3 = xInterface.createInstanceWithContext(this);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object3 != null) {
                        object2 = componentContextEntry;
                        synchronized (object2) {
                            if (componentContextEntry.m_lateInit != null) {
                                componentContextEntry.m_value = object3;
                                componentContextEntry.m_lateInit = null;
                            } else {
                                xInterface = UnoRuntime.queryInterface(XComponent.class, object3);
                                if (xInterface != null) {
                                    xInterface.dispose();
                                }
                            }
                        }
                    }
                }
                return componentContextEntry.m_value;
            }
            return object;
        }
        if (this.m_xDelegate != null) {
            return this.m_xDelegate.getValueByName(string);
        }
        return Any.VOID;
    }

    @Override
    public XMultiComponentFactory getServiceManager() {
        if (this.m_xSMgr == null) {
            throw new DeploymentException("null component context service manager");
        }
        return this.m_xSMgr;
    }

    @Override
    public void dispose() {
        XComponent xComponent;
        EventObject eventObject = new EventObject(this);
        for (XEventListener object2 : this.m_eventListener) {
            object2.disposing(eventObject);
        }
        this.m_eventListener.clear();
        Object object3 = null;
        for (Map.Entry<String, Object> entry : this.m_table.entrySet()) {
            XComponent xComponent2;
            String string = entry.getKey();
            if (string.equals(SMGR_NAME)) continue;
            Object object = entry.getValue();
            if (object instanceof ComponentContextEntry) {
                object = ((ComponentContextEntry)object).m_value;
            }
            if ((xComponent2 = UnoRuntime.queryInterface(XComponent.class, object)) == null) continue;
            if (string.equals(TDMGR_NAME)) {
                object3 = xComponent2;
                continue;
            }
            xComponent2.dispose();
        }
        this.m_table.clear();
        if (this.m_bDisposeSMgr && (xComponent = UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xSMgr)) != null) {
            xComponent.dispose();
        }
        this.m_xSMgr = null;
        if (object3 != null) {
            object3.dispose();
        }
    }

    @Override
    public void addEventListener(XEventListener xEventListener) {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (this.m_eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener already registred.");
        }
        this.m_eventListener.add(xEventListener);
    }

    @Override
    public void removeEventListener(XEventListener xEventListener) {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (!this.m_eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener is not registered.");
        }
        this.m_eventListener.remove(xEventListener);
    }
}

