/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XNumberFormats;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.BlindtextCreator;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.report.RecordTable;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.TextTableHandler;

public class DBColumn {
    public XCell xValCell;
    public XTextRange xValTextCell;
    public XTextCursor xValCellCursor;
    public XNumberFormats xValCellNumberFormats;
    public XCell xNameCell;
    public XTextRange xNameTextCell;
    public boolean bAlignLeft;
    public Object DefaultValue;
    public String CharFontName;
    public int FormatKey;
    public PropertyState PropertyState;
    public int ValColumn = 1;
    public int ValRow = 0;
    public FieldColumn CurDBField;
    private XTextTable xTextTable;
    private XTableColumns xTableColumns;
    private XCellRange xCellRange;
    public XNamed xTableName;
    private boolean bIsGroupColumn;
    TextDocument oTextDocument;
    RecordParser CurDBMetaData;
    RecordTable CurRecordTable;
    TextTableHandler oTextTableHandler;

    public DBColumn(TextTableHandler textTableHandler, RecordParser recordParser, int n) {
        this.CurRecordTable = new RecordTable(textTableHandler);
        this.initializeRecordTableMembers(this.CurRecordTable, textTableHandler, recordParser, n, false);
    }

    public DBColumn(RecordTable recordTable, TextTableHandler textTableHandler, RecordParser recordParser, int n, boolean bl) {
        this.initializeRecordTableMembers(recordTable, textTableHandler, recordParser, n, bl);
    }

    public DBColumn(RecordTable recordTable, TextTableHandler textTableHandler, RecordParser recordParser, int n) {
        this.initializeRecordTableMembers(recordTable, textTableHandler, recordParser, n, false);
    }

    private void initializeRecordTableMembers(RecordTable recordTable, TextTableHandler textTableHandler, RecordParser recordParser, int n, boolean bl) {
        this.oTextTableHandler = textTableHandler;
        this.CurDBMetaData = recordParser;
        this.CurRecordTable = recordTable;
        this.bIsGroupColumn = false;
        this.CurDBField = this.CurDBMetaData.RecordFieldColumns != null ? this.CurDBMetaData.getFieldColumnByFieldName(this.CurDBMetaData.RecordFieldColumns[n].getFieldName()) : this.CurDBMetaData.getFieldColumnByFieldName(this.CurDBMetaData.getRecordFieldName(n));
        if (bl) {
            this.assignCells(n, true);
        } else {
            for (int i = 0; i < this.CurRecordTable.xTableColumns.getCount(); ++i) {
                this.assignCells(i, false);
            }
        }
    }

    private boolean assignCells(int n, boolean bl) {
        try {
            XCell xCell = this.CurRecordTable.xCellRange.getCellByPosition(n, 0);
            XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xCell);
            String string = "Column";
            XTextCursor xTextCursor = TextDocument.createTextCursor(xCell);
            if (this.isNameCell(xTextCursor, this.CurDBField.getFieldName(), string) || bl) {
                this.xNameCell = xCell;
                this.xNameTextCell = xTextRange;
                this.xValCell = this.CurRecordTable.xCellRange.getCellByPosition(n, 1);
                this.xValTextCell = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.xValCell);
                this.xValCellCursor = TextDocument.createTextCursor(this.xValCell);
                this.ValColumn = n;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return false;
    }

    public DBColumn(TextTableHandler textTableHandler, RecordParser recordParser, String string, int n, String string2, DBColumn dBColumn) {
        this.oTextTableHandler = textTableHandler;
        this.CurDBMetaData = recordParser;
        this.CurDBField = this.CurDBMetaData.getFieldColumnByDisplayName(string);
        this.bIsGroupColumn = true;
        this.getTableColumns(string2);
        this.xNameCell = dBColumn.xNameCell;
        this.xNameTextCell = dBColumn.xNameTextCell;
        this.xValCell = dBColumn.xValCell;
        this.xValTextCell = dBColumn.xValTextCell;
        this.xValCellCursor = TextDocument.createTextCursor(this.xValCell);
        this.ValColumn = dBColumn.ValColumn;
        this.ValRow = dBColumn.ValRow;
        this.initializeNumberFormat();
    }

    public DBColumn(TextTableHandler textTableHandler, RecordParser recordParser, String string, int n, String string2) throws Exception {
        this.oTextTableHandler = textTableHandler;
        this.CurDBMetaData = recordParser;
        this.CurDBField = this.CurDBMetaData.getFieldColumnByFieldName(string);
        this.bIsGroupColumn = true;
        this.getTableColumns(string2);
        XTableRows xTableRows = null;
        try {
            xTableRows = this.xTextTable.getRows();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        for (int i = 0; i < this.xTableColumns.getCount(); ++i) {
            for (int j = 0; j < xTableRows.getCount(); ++j) {
                XCell xCell = this.xCellRange.getCellByPosition(i, j);
                XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xCell);
                String string3 = string2.substring(4);
                XTextCursor xTextCursor = TextDocument.createTextCursor(xCell);
                if (this.isNameCell(xTextCursor, this.CurDBField.getFieldName(), string3)) {
                    this.xNameCell = xCell;
                    this.xNameTextCell = xTextRange;
                    continue;
                }
                this.xValCell = xCell;
                this.xValTextCell = xTextRange;
                this.xValCellCursor = xTextCursor;
                this.ValColumn = i;
                this.ValRow = j;
                this.checkforLeftAlignment();
            }
        }
    }

    private void getTableColumns(String string) {
        try {
            XNameAccess xNameAccess = this.oTextTableHandler.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string)) {
                Object object = xNameAccess.getByName(string);
                this.xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)object);
                this.xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object);
                this.xTableName = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)object);
                this.xTableColumns = this.xTextTable.getColumns();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initializeNumberFormat() {
        if (this.CurDBField.isBoolean()) {
            NumberFormatter numberFormatter = this.oTextTableHandler.getNumberFormatter();
            int n = numberFormatter.setBooleanReportDisplayNumberFormat();
            numberFormatter.setNumberFormat((XInterface)this.xValCell, n, numberFormatter);
        } else {
            this.oTextTableHandler.getNumberFormatter().setNumberFormat((XInterface)this.xValCell, this.CurDBField.getDBFormatKey(), this.CurDBMetaData.getNumberFormatter());
        }
        this.setCellFont();
    }

    public void insertColumnData(TextFieldHandler textFieldHandler, boolean bl) {
        this.insertUserFieldToTableCell(textFieldHandler);
        this.replaceValueCellofTable(bl);
    }

    public void insertUserFieldToTableCell(TextFieldHandler textFieldHandler) {
        XTextCursor xTextCursor = TextDocument.createTextCursor(this.xNameCell);
        xTextCursor.gotoStart(false);
        xTextCursor.gotoEnd(true);
        xTextCursor.setString(PropertyNames.EMPTY_STRING);
        textFieldHandler.insertUserField(xTextCursor, this.CurDBField.getFieldName(), this.CurDBField.getFieldTitle());
    }

    public void insertUserFieldToTableCell(TextFieldHandler textFieldHandler, XCell xCell) {
        XTextCursor xTextCursor = TextDocument.createTextCursor(xCell);
        xTextCursor.gotoStart(false);
        xTextCursor.gotoEnd(true);
        xTextCursor.setString(PropertyNames.EMPTY_STRING);
        textFieldHandler.insertUserField(xTextCursor, this.CurDBField.getFieldName(), this.CurDBField.getFieldTitle());
    }

    public void formatValueCell() {
        this.initializeNumberFormat();
        if (this.checkforLeftAlignment()) {
            this.bAlignLeft = true;
        }
    }

    private boolean checkforLeftAlignment() {
        this.bAlignLeft = this.CurDBField.isNumberFormat() && this.ValColumn == this.xTableColumns.getCount() - 1;
        return this.bAlignLeft;
    }

    public void modifyCellContent(XCellRange xCellRange, Object object) {
        try {
            this.xValCell = xCellRange.getCellByPosition(this.ValColumn, this.ValRow);
            this.xValTextCell = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.xValCell);
            this.modifyCellContent(object);
            if (this.bAlignLeft) {
                this.xValCellCursor = TextDocument.createTextCursor(this.xValCell);
                Helper.setUnoPropertyValue(this.xValCellCursor, "ParaAdjust", 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void modifyCellContent(Object object) {
        double d = 0.0;
        try {
            if (this.xValCell != null) {
                if (AnyConverter.isString((Object)object)) {
                    String string = AnyConverter.toString((Object)object);
                    this.xValTextCell.setString(string);
                } else {
                    if (AnyConverter.isBoolean((Object)object)) {
                        d = AnyConverter.toInt((Object)object);
                    }
                    if (AnyConverter.isByte((Object)object)) {
                        d = AnyConverter.toByte((Object)object);
                    } else if (AnyConverter.isDouble((Object)object)) {
                        d = AnyConverter.toDouble((Object)object);
                    } else if (AnyConverter.isFloat((Object)object)) {
                        d = AnyConverter.toFloat((Object)object);
                    } else if (AnyConverter.isInt((Object)object)) {
                        d = AnyConverter.toInt((Object)object);
                    } else if (AnyConverter.isLong((Object)object)) {
                        d = AnyConverter.toLong((Object)object);
                    } else if (AnyConverter.isShort((Object)object)) {
                        d = AnyConverter.toShort((Object)object);
                    }
                    this.xValCell.setValue(d);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
    }

    public void replaceValueCellofTable(boolean bl) {
        try {
            int n;
            Object object = !this.bIsGroupColumn && !this.CurDBField.isNumberFormat() ? BlindtextCreator.adjustBlindTextlength(this.CurDBField.getFieldTitle(), this.CurDBField.getFieldWidth(), bl, this.bIsGroupColumn, this.CurDBMetaData.getRecordFieldNames()) : this.CurDBField.getDefaultValue();
            this.modifyCellContent(object);
            if (this.bAlignLeft) {
                Helper.setUnoPropertyValue(this.xValCellCursor, "ParaAdjust", 0);
            }
            if ((n = this.CurDBField.getFieldType()) == -7 || n == 16) {
                this.CharFontName = "StarSymbol";
                Helper.setUnoPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
                if (!this.bIsGroupColumn) {
                    Helper.setUnoPropertyValue(this.xValCellCursor, "ParaAdjust", 3);
                }
            } else if (this.PropertyState == com.sun.star.beans.PropertyState.DEFAULT_VALUE) {
                XPropertyState xPropertyState = (XPropertyState)UnoRuntime.queryInterface(XPropertyState.class, (Object)this.xValCellCursor);
                xPropertyState.setPropertyToDefault("CharFontName");
            } else if (this.PropertyState == com.sun.star.beans.PropertyState.DIRECT_VALUE) {
                Helper.setUnoPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
            }
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(System.err);
        }
    }

    public void setCellFont() {
        try {
            int n = this.CurDBField.getFieldType();
            if (n == -7 || n == 16) {
                this.CharFontName = "StarSymbol";
                this.PropertyState = com.sun.star.beans.PropertyState.DIRECT_VALUE;
                this.xValCellCursor.gotoStart(false);
                this.xValCellCursor.gotoEnd(true);
                Helper.setUnoPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
            } else {
                XPropertyState xPropertyState = (XPropertyState)UnoRuntime.queryInterface(XPropertyState.class, (Object)this.xValCellCursor);
                this.PropertyState = xPropertyState.getPropertyState("CharFontName");
                this.CharFontName = AnyConverter.toString((Object)Helper.getUnoPropertyValue(this.xValCellCursor, "CharFontName"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private boolean isNameCell(XTextCursor xTextCursor, String string, String string2) {
        try {
            xTextCursor.gotoStart(false);
            XTextRange xTextRange = xTextCursor.getEnd();
            Object object = Helper.getUnoPropertyValue(xTextRange, "TextField");
            if (AnyConverter.isVoid((Object)object)) {
                return false;
            }
            XDependentTextField xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)object);
            XPropertySet xPropertySet = xDependentTextField.getTextFieldMaster();
            String string3 = (String)xPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME);
            boolean bl = false;
            if (string3.startsWith(string2) || string3.equals(string)) {
                bl = true;
            } else {
                String string4 = string + "_renamed_";
                if (string3.startsWith(string4)) {
                    bl = true;
                }
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return true;
        }
    }
}

