/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.XPropertySet;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import java.util.ArrayList;

public class TypeInspector {
    private String[] sDataTypeNames;
    private int[] nDataTypeInfos;
    private int[] nPrecisionInfos;
    private int[] nNullableInfos;
    private int[] nSearchables;
    private boolean[] bisAutoIncrementableInfos;
    private int[] nMinScaleInfos;
    private int[] nMaxScaleInfos;
    private final int[] nNumericFallBackList = new int[]{4, 6, 7, 8, 2, 3};
    static final int INVALID = 999999;
    XResultSet xResultSet;

    public TypeInspector(XResultSet xResultSet) {
        try {
            this.xResultSet = xResultSet;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
            ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)this.xResultSet);
            while (this.xResultSet.next()) {
                arrayList.add(xRow.getString(1));
                arrayList2.add(Integer.valueOf(xRow.getShort(2)));
                arrayList5.add(xRow.getInt(3));
                arrayList3.add(Integer.valueOf(xRow.getShort(7)));
                arrayList8.add(Integer.valueOf(xRow.getShort(9)));
                arrayList4.add(xRow.getBoolean(12));
                arrayList6.add(Integer.valueOf(xRow.getShort(14)));
                arrayList7.add(Integer.valueOf(xRow.getShort(15)));
            }
            this.sDataTypeNames = new String[arrayList.size()];
            arrayList.toArray(this.sDataTypeNames);
            this.nDataTypeInfos = JavaTools.IntegerTointList(arrayList2);
            this.nNullableInfos = JavaTools.IntegerTointList(arrayList3);
            this.nSearchables = JavaTools.IntegerTointList(arrayList8);
            this.bisAutoIncrementableInfos = JavaTools.BooleanTobooleanList(arrayList4);
            this.nPrecisionInfos = JavaTools.IntegerTointList(arrayList5);
            this.nMinScaleInfos = JavaTools.IntegerTointList(arrayList6);
            this.nMaxScaleInfos = JavaTools.IntegerTointList(arrayList7);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
        }
    }

    public int getScale(XPropertySet xPropertySet) {
        try {
            int n = this.getDataTypeIndex(xPropertySet, false);
            int n2 = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Scale"));
            if (n == -1) {
                return n2;
            }
            if (n2 > this.nMaxScaleInfos[n]) {
                return this.nMaxScaleInfos[n];
            }
            if (n2 < this.nMinScaleInfos[n]) {
                return this.nMinScaleInfos[n];
            }
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return 0;
        }
    }

    public int getNullability(XPropertySet xPropertySet, int n) {
        int n2 = this.getDataTypeIndex(xPropertySet, false);
        if (n2 == -1) {
            return 0;
        }
        if (n == 1) {
            return this.nNullableInfos[n2];
        }
        return n;
    }

    public int getNullability(XPropertySet xPropertySet) {
        try {
            int n = this.getDataTypeIndex(xPropertySet, false);
            if (n == -1) {
                return 0;
            }
            int n2 = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("IsNullable"));
            if (n2 == 1) {
                return this.nNullableInfos[n];
            }
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return 0;
        }
    }

    public boolean isColumnOrderable(XPropertySet xPropertySet) {
        int n = this.getDataTypeIndex(xPropertySet, false);
        if (n > -1) {
            return this.nSearchables[n] != 0;
        }
        return false;
    }

    public int isNullable(XPropertySet xPropertySet) {
        int n = this.getDataTypeIndex(xPropertySet, false);
        if (n > -1) {
            return this.nNullableInfos[n];
        }
        return 0;
    }

    private int getDataTypeIndex(XPropertySet xPropertySet, boolean bl) {
        try {
            int n = -1;
            int n2 = -1;
            int n3 = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Type"));
            String string = AnyConverter.toString((Object)xPropertySet.getPropertyValue("TypeName"));
            if (bl) {
                n = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Precision"));
                n2 = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Scale"));
            }
            boolean bl2 = false;
            int n4 = 0;
            while (!bl2) {
                int n5 = JavaTools.FieldInIntTable(this.nDataTypeInfos, n3, n4);
                n4 = n5 + 1;
                bl2 = n5 < 0;
                if (bl2 || !string.equals(this.sDataTypeNames[n5])) continue;
                if (bl) {
                    if (n > this.nPrecisionInfos[n5] || n2 < this.nMinScaleInfos[n5] || n2 > this.nMinScaleInfos[n5]) continue;
                    return n5;
                }
                return n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return -1;
    }

    public boolean supportsDataType(int n) {
        return JavaTools.FieldInIntTable(this.nDataTypeInfos, n) > -1;
    }

    public int getLastConversionFallbackDataType() {
        if (this.supportsDataType(12)) {
            return 12;
        }
        return -1;
    }

    public String getDefaultTypeName(int n, Integer n2) {
        String string = PropertyNames.EMPTY_STRING;
        for (int i = 0; i < this.nDataTypeInfos.length; ++i) {
            if (this.nDataTypeInfos[i] != n) continue;
            if (n2 == null || this.nPrecisionInfos[i] >= n2) {
                string = this.sDataTypeNames[i];
                break;
            }
            if (string.length() != 0) continue;
            string = this.sDataTypeNames[i];
        }
        return string;
    }

    public int getDataType(String string) {
        int n = JavaTools.FieldInList(this.sDataTypeNames, string);
        if (n > -1) {
            return this.nDataTypeInfos[n];
        }
        return this.getLastConversionFallbackDataType();
    }

    public int convertDataType(int n) {
        int n2 = n;
        if (!this.supportsDataType(n)) {
            switch (n) {
                case -7: {
                    n2 = this.convertDataType(16);
                    break;
                }
                case 16: {
                    n2 = this.convertDataType(-7);
                    break;
                }
                case -6: {
                    n2 = this.convertDataType(5);
                    break;
                }
                case 5: {
                    n2 = this.convertDataType(4);
                    break;
                }
                case 4: {
                    n2 = this.convertDataType(6);
                    break;
                }
                case 6: {
                    n2 = this.convertDataType(7);
                    break;
                }
                case 91: 
                case 92: {
                    n2 = this.convertDataType(93);
                    break;
                }
                case -5: 
                case 7: 
                case 93: {
                    n2 = this.convertDataType(8);
                    break;
                }
                case 8: {
                    n2 = this.convertDataType(2);
                    break;
                }
                case 2: {
                    n2 = this.convertDataType(3);
                    break;
                }
                case 3: {
                    if (this.supportsDataType(8)) {
                        n2 = this.convertDataType(8);
                        break;
                    }
                    if (this.supportsDataType(2)) {
                        n2 = 2;
                        break;
                    }
                    n2 = this.getLastConversionFallbackDataType();
                    break;
                }
                case 12: {
                    n2 = this.getLastConversionFallbackDataType();
                    break;
                }
                default: {
                    n2 = this.getLastConversionFallbackDataType();
                }
            }
        }
        return n2;
    }

    public int getAutoIncrementIndex(XPropertySet xPropertySet) {
        try {
            boolean bl = false;
            int n = 0;
            int n2 = (Integer)xPropertySet.getPropertyValue("Type");
            while (!bl) {
                int n3 = JavaTools.FieldInIntTable(this.nDataTypeInfos, n2, n);
                n = n3 + 1;
                bl = n3 == -1;
                if (bl || !this.bisAutoIncrementableInfos[n3]) continue;
                return this.nDataTypeInfos[n3];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return 999999;
    }

    public boolean isAutoIncrementable(XPropertySet xPropertySet) {
        return this.getAutoIncrementIndex(xPropertySet) != 999999;
    }

    public TypeInfo findAutomaticPrimaryKeyType() {
        int n;
        for (int i = 0; i < this.nNumericFallBackList.length; ++i) {
            n = this.nNumericFallBackList[i];
            boolean bl = false;
            int n2 = 0;
            while (!bl) {
                int n3 = JavaTools.FieldInIntTable(this.nDataTypeInfos, n, n2);
                boolean bl2 = bl = n3 < 0;
                if (!bl) {
                    if (this.bisAutoIncrementableInfos[n3]) {
                        return new TypeInfo(n, this.sDataTypeNames[n3], true);
                    }
                    n2 = n3 + 1;
                }
                n2 = n3 + 1;
            }
        }
        n = this.convertDataType(4);
        return new TypeInfo(n, this.getDefaultTypeName(n, null), false);
    }

    public class TypeInfo {
        public int nDataType;
        public String sDataTypeName;
        public boolean bisAutoIncrementable;

        public TypeInfo(int n, String string, boolean bl) {
            this.nDataType = n;
            this.sDataTypeName = string;
            this.bisAutoIncrementable = bl;
        }
    }
}

