/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.application.XDatabaseDocumentUI;
import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.NamedValueCollection;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.ui.WizardDialog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DatabaseObjectWizard
extends WizardDialog {
    protected final PropertyValue[] m_wizardContext;
    protected final XDatabaseDocumentUI m_docUI;
    protected final XFrame m_frame;

    protected DatabaseObjectWizard(XMultiServiceFactory xMultiServiceFactory, int n, PropertyValue[] propertyValueArray) {
        super(xMultiServiceFactory, n);
        this.m_wizardContext = propertyValueArray;
        NamedValueCollection namedValueCollection = new NamedValueCollection(this.m_wizardContext);
        this.m_docUI = namedValueCollection.queryOrDefault("DocumentUI", null, XDatabaseDocumentUI.class);
        if (this.m_docUI != null) {
            XController xController = (XController)UnoRuntime.queryInterface(XController.class, (Object)this.m_docUI);
            this.m_frame = xController.getFrame();
        } else {
            XFrame xFrame = namedValueCollection.queryOrDefault("ParentFrame", null, XFrame.class);
            this.m_frame = xFrame != null ? xFrame : Desktop.getActiveFrame(this.xMSF);
        }
    }

    protected final void loadSubComponent(int n, String string, boolean bl) {
        try {
            if (this.m_docUI != null) {
                this.m_docUI.loadComponent(n, string, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, noSuchElementException);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    protected static void executeWizardFromCommandLine(String[] stringArray, String string) {
        String[] stringArray2 = new String[]{null, null, null};
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (n >= 0) {
                stringArray2[n] = stringArray[i];
                n = -1;
                continue;
            }
            if (stringArray[i].equals("--pipe-name")) {
                n = 0;
                continue;
            }
            if (stringArray[i].equals("--database-location")) {
                n = 1;
                continue;
            }
            if (stringArray[i].equals("--data-source-name")) {
                n = 2;
                continue;
            }
            bl = true;
        }
        if (stringArray2[0] == null) {
            bl = true;
        }
        if (stringArray2[2] == null && stringArray2[1] == null) {
            bl = true;
        }
        if (bl) {
            System.err.println("supported arguments: ");
            System.err.println("  --pipe-name <name>           : specifies the name of the pipe to connect to the running OOo instance");
            System.err.println("  --database-location <url>    : specifies the URL of the database document to work with");
            System.err.println("  --data-source-name <name>    : specifies the name of the data source to work with");
            return;
        }
        String string2 = "uno:pipe,name=" + stringArray2[0] + ";urp;StarOffice.ServiceManager";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect(string2);
            if (xMultiServiceFactory != null) {
                PropertyValue[] propertyValueArray = new PropertyValue[]{stringArray2[1] != null ? Properties.createProperty("DatabaseLocation", stringArray2[1]) : Properties.createProperty("DataSourceName", stringArray2[2])};
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(XMultiServiceFactory.class, PropertyValue[].class);
                Method method = clazz.getMethod("start", new Class[0]);
                Object obj = constructor.newInstance(xMultiServiceFactory, propertyValueArray);
                method.invoke(obj, new Object[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

