/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class CheckinResourcesCommand
implements ISVNCommand {
    protected IResource[] resources;
    protected String message;
    protected boolean keepLocks;
    protected int depth;
    protected SVNWorkspaceRoot root;

    public CheckinResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, int depth, String message, boolean keepLocks) {
        this.resources = resources;
        this.message = message;
        this.depth = depth;
        this.root = root;
        this.keepLocks = keepLocks;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        final ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        ArrayList<IContainer> parentsList = new ArrayList<IContainer>();
        int i = 0;
        while (i < this.resources.length) {
            IResource currentResource = this.resources[i];
            IContainer parent = currentResource.getParent();
            ISVNLocalResource svnParentResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)parent);
            while (parent.getType() != 8 && parent.getType() != 4 && !svnParentResource.hasRemote()) {
                if (!this.inCommitList((IResource)parent)) {
                    parentsList.add(parent);
                }
                parent = parent.getParent();
                svnParentResource = svnParentResource.getParent();
            }
            ++i;
        }
        int parents = parentsList.size();
        if (parents > 0) {
            this.depth = 0;
        }
        final File[] resourceFiles = new File[parents + this.resources.length];
        int i2 = 0;
        while (i2 < parents) {
            resourceFiles[i2] = ((IResource)parentsList.get(i2)).getLocation().toFile();
            ++i2;
        }
        i2 = 0;
        int j = parents;
        while (i2 < this.resources.length) {
            resourceFiles[j] = this.resources[i2].getLocation().toFile();
            ++i2;
            ++j;
        }
        SVNProviderPlugin.run(new ISVNRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor pm) throws SVNException {
                try {
                    try {
                        pm.beginTask(null, resourceFiles.length);
                        OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(pm));
                        if (svnClient.canCommitAcrossWC()) {
                            svnClient.commitAcrossWC(resourceFiles, CheckinResourcesCommand.this.message, CheckinResourcesCommand.this.depth == 2, CheckinResourcesCommand.this.keepLocks, true);
                        } else {
                            svnClient.commit(resourceFiles, CheckinResourcesCommand.this.message, CheckinResourcesCommand.this.depth == 2, CheckinResourcesCommand.this.keepLocks);
                        }
                    }
                    catch (SVNClientException e) {
                        throw SVNException.wrapException((Exception)((Object)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    OperationManager.getInstance().endOperation();
                    pm.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    OperationManager.getInstance().endOperation();
                }
                pm.done();
            }
        }, Policy.monitorFor(monitor));
    }

    private boolean inCommitList(IResource resource) {
        int i = 0;
        while (i < this.resources.length) {
            if (this.resources[i].equals((Object)resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

