/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;

public class ResourceEditionNode
implements IStructureComparator,
ITypedElement,
IStreamContentAccessor,
IEncodedStreamContentAccessor {
    private ISVNRemoteResource resource;
    private ResourceEditionNode[] children;
    private SVNLocalCompareInput.SVNLocalResourceNode localResource = null;
    private String charset = null;

    public ResourceEditionNode(ISVNRemoteResource resourceEdition) {
        this.resource = resourceEdition;
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.resource;
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public Object[] getChildren() {
        block5: {
            if (this.children == null) {
                this.children = new ResourceEditionNode[0];
                if (this.resource != null) {
                    try {
                        SVNUIPlugin.runWithProgress(null, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                try {
                                    ISVNRemoteResource[] members = ResourceEditionNode.this.resource.members(monitor);
                                    ResourceEditionNode.this.children = new ResourceEditionNode[members.length];
                                    int i = 0;
                                    while (i < members.length) {
                                        ((ResourceEditionNode)ResourceEditionNode.this).children[i] = new ResourceEditionNode(members[i]);
                                        SVNLocalCompareInput.SVNLocalResourceNode localNode = ResourceEditionNode.this.matchLocalResource(members[i]);
                                        if (localNode != null) {
                                            ResourceEditionNode.this.children[i].setLocalResource(localNode);
                                            try {
                                                ResourceEditionNode.this.children[i].setCharset(localNode.getCharset());
                                            }
                                            catch (CoreException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (!(t instanceof TeamException)) break block5;
                        SVNUIPlugin.log(((TeamException)t).getStatus());
                    }
                }
            }
        }
        return this.children;
    }

    public InputStream getContents() throws CoreException {
        block4: {
            if (this.resource == null || this.resource.isContainer()) {
                return null;
            }
            try {
                final InputStream[] holder = new InputStream[1];
                SVNUIPlugin.runWithProgress(null, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            holder[0] = ResourceEditionNode.this.resource.getStorage(monitor).getContents();
                        }
                        catch (CoreException e1) {
                            SVNUIPlugin.log(e1);
                        }
                    }
                });
                return holder[0];
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof TeamException)) break block4;
                throw new CoreException(((TeamException)t).getStatus());
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.resource);
    }

    public String getName() {
        return this.resource == null ? "" : this.resource.getName();
    }

    public String getType() {
        if (this.resource == null) {
            return "???";
        }
        if (this.resource.isContainer()) {
            return "FOLDER";
        }
        String name = this.resource.getName();
        return (name = name.substring(name.lastIndexOf(46) + 1)).length() == 0 ? "???" : name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getCharset() throws CoreException {
        return this.charset;
    }

    public void setCharset(String charset) throws CoreException {
        this.charset = charset;
    }

    public void setLocalResource(SVNLocalCompareInput.SVNLocalResourceNode localResource) {
        this.localResource = localResource;
    }

    private SVNLocalCompareInput.SVNLocalResourceNode matchLocalResource(ISVNRemoteResource remoteNode) {
        if (this.localResource == null) {
            return null;
        }
        Object[] lrn = this.localResource.getChildren();
        String remotePath = remoteNode.getRepositoryRelativePath();
        int idx = remotePath.indexOf("/", 1);
        if (idx > 0) {
            remotePath = remotePath.substring(idx);
        }
        int i = 0;
        while (i < lrn.length) {
            String localPath = ((SVNLocalCompareInput.SVNLocalResourceNode)((Object)lrn[i])).getResource().getFullPath().toString();
            if ((localPath = localPath.substring(localPath.indexOf("/", 1))).equals(remotePath)) {
                return (SVNLocalCompareInput.SVNLocalResourceNode)((Object)lrn[i]);
            }
            ++i;
        }
        return null;
    }
}

