/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import org.apache.batik.Version;
import org.apache.batik.apps.svgbrowser.Resources;

public class AboutDialog
extends JWindow {
    public static final String ICON_BATIK_SPLASH = "AboutDialog.icon.batik.splash";
    public static final String ICON_APACHE_LOGO = "AboutDialog.icon.apache.logo";
    public static final String LABEL_APACHE_BATIK_PROJECT = "AboutDialog.label.apache.batik.project";
    public static final String LABEL_CONTRIBUTORS = "AboutDialog.label.contributors";

    public AboutDialog() {
        this.buildGUI();
    }

    public AboutDialog(Frame frame) {
        super(frame);
        this.buildGUI();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ((Component)AboutDialog.this).setVisible(false);
                    AboutDialog.this.dispose();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ((Component)AboutDialog.this).setVisible(false);
                AboutDialog.this.dispose();
            }
        });
    }

    public void setLocationRelativeTo(Frame frame) {
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Point point2 = new Point(point.x, point.y);
        Rectangle rectangle = this.getBounds();
        int n = point2.x + (dimension.width - rectangle.width) / 2;
        int n2 = point2.y + (dimension.height - rectangle.height) / 2;
        Dimension dimension2 = this.getToolkit().getScreenSize();
        if (n2 + rectangle.height > dimension2.height) {
            n2 = dimension2.height - rectangle.height;
            int n3 = n = point2.x < dimension2.width >> 1 ? point2.x + dimension.width : point2.x - rectangle.width;
        }
        if (n + rectangle.width > dimension2.width) {
            n = dimension2.width - rectangle.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        ((Component)this).setLocation(n, n2);
    }

    protected void buildGUI() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBackground(Color.white);
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(Resources.getString(ICON_APACHE_LOGO));
        JLabel jLabel = new JLabel(Resources.getString(LABEL_APACHE_BATIK_PROJECT), new ImageIcon(uRL), 2);
        jPanel.add("North", jLabel);
        uRL = classLoader.getResource(Resources.getString(ICON_BATIK_SPLASH));
        jPanel.add("Center", new JLabel(new ImageIcon(uRL)));
        String string = Version.getVersion();
        jPanel.add("South", new JLabel(string, 4));
        ((Component)this).setBackground(Color.white);
        this.getContentPane().setBackground(Color.white);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)jPanel, "Center");
        JTextArea jTextArea = new JTextArea(Resources.getString(LABEL_CONTRIBUTORS)){
            {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setEnabled(false);
                this.setRows(11);
            }
        };
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel2.add((Component)jTextArea, "South");
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.black), BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)), BorderFactory.createEmptyBorder(10, 10, 10, 10))));
        this.getContentPane().add(jPanel2);
        this.pack();
    }
}

