/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.Day;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.ResultSetRow;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.reader.ProjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimaveraDatabaseReader
implements ProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    private String m_schema = "";
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;
    private UserFieldCounters m_udfCounters = new UserFieldCounters();
    private boolean m_matchPrimaveraWBS = true;
    private Map<FieldType, String> m_resourceFields = PrimaveraReader.getDefaultResourceFieldMap();
    private Map<FieldType, String> m_wbsFields = PrimaveraReader.getDefaultWbsFieldMap();
    private Map<FieldType, String> m_taskFields = PrimaveraReader.getDefaultTaskFieldMap();
    private Map<FieldType, String> m_assignmentFields = PrimaveraReader.getDefaultAssignmentFieldMap();
    private Map<FieldType, String> m_aliases = PrimaveraReader.getDefaultAliases();

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            List<Row> list = this.getRows("select proj_id, proj_short_name from " + this.m_schema + "project where delete_date is null");
            for (Row row : list) {
                Integer n = row.getInteger("proj_id");
                String string = row.getString("proj_short_name");
                hashMap.put(n, string);
            }
            return hashMap;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new PrimaveraReader(this.m_udfCounters, this.m_resourceFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_aliases, this.m_matchPrimaveraWBS);
            ProjectFile projectFile = this.m_reader.getProject();
            projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            projectFile.updateStructure();
            ProjectFile projectFile2 = projectFile;
            return projectFile2;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
        finally {
            if (this.m_allocatedConnection && this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
                this.m_connection = null;
            }
        }
    }

    public List<ProjectFile> readAll() throws MPXJException {
        LinkedList<ProjectFile> linkedList = new LinkedList<ProjectFile>();
        Map<Integer, String> map = this.listProjects();
        for (Integer n : map.keySet()) {
            this.setProjectID(n);
            linkedList.add(this.read());
        }
        return linkedList;
    }

    private void processProjectProperties() throws SQLException {
        List<Row> list = this.getRows("select * from " + this.m_schema + "project where proj_id=?", this.m_projectID);
        this.m_reader.processProjectProperties(list);
        list = this.getRows("select * from " + this.m_schema + "prefer where prefer.delete_date is null");
        if (!list.isEmpty()) {
            Row row = list.get(0);
            ProjectProperties projectProperties = this.m_reader.getProject().getProjectProperties();
            projectProperties.setCreationDate(row.getDate("create_date"));
            projectProperties.setLastSaved(row.getDate("update_date"));
            projectProperties.setMinutesPerDay(row.getDouble("day_hr_cnt") * 60.0);
            projectProperties.setMinutesPerWeek(row.getDouble("week_hr_cnt") * 60.0);
            projectProperties.setWeekStartDay(Day.getInstance(row.getInt("week_start_day_num")));
            this.processDefaultCurrency(row.getInteger("curr_id"));
        }
    }

    private void processDefaultCurrency(Integer n) throws SQLException {
        List<Row> list = this.getRows("select * from " + this.m_schema + "currtype where curr_id=?", n);
        if (!list.isEmpty()) {
            Row row = list.get(0);
            this.m_reader.processDefaultCurrency(row);
        }
    }

    private void processResources() throws SQLException {
        List<Row> list = this.getRows("select * from " + this.m_schema + "rsrc where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_seq_num", this.m_projectID);
        this.m_reader.processResources(list);
    }

    private void processTasks() throws SQLException {
        List<Row> list = this.getRows("select * from " + this.m_schema + "projwbs where proj_id=? and delete_date is null order by parent_wbs_id,seq_num", this.m_projectID);
        List<Row> list2 = this.getRows("select * from " + this.m_schema + "task where proj_id=? and delete_date is null", this.m_projectID);
        List<Row> list3 = this.getRows("select * from " + this.m_schema + "projcost where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processTasks(list, list2, list3);
    }

    private void processPredecessors() throws SQLException {
        List<Row> list = this.getRows("select * from " + this.m_schema + "taskpred where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processPredecessors(list);
    }

    private void processCalendars() throws SQLException {
        List<Row> list = this.getRows("select * from " + this.m_schema + "calendar where (proj_id is null or proj_id=?) and delete_date is null", this.m_projectID);
        this.m_reader.processCalendars(list);
    }

    private void processAssignments() throws SQLException {
        List<Row> list = this.getRows("select * from " + this.m_schema + "taskrsrc where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processAssignments(list);
    }

    public void setProjectID(int n) {
        this.m_projectID = n;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String string) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> linkedList = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(string);
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                linkedList.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String string, Integer n) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> linkedList = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(string);
            this.m_ps.setInt(1, NumberHelper.getInt(n));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                linkedList.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    private void releaseConnection() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_rs = null;
        }
        if (this.m_ps != null) {
            try {
                this.m_ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_ps = null;
        }
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
        int n = resultSetMetaData.getColumnCount() + 1;
        for (int i = 1; i < n; ++i) {
            String string = resultSetMetaData.getColumnName(i).toLowerCase();
            Integer n2 = resultSetMetaData.getColumnType(i);
            this.m_meta.put(string, n2);
        }
    }

    public void setSchema(String string) {
        if (string == null) {
            string = "";
        } else if (!string.isEmpty() && !string.endsWith(".")) {
            string = string + '.';
        }
        this.m_schema = string;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public void setFieldNameForUdfType(UserFieldDataType userFieldDataType, String string) {
        this.m_udfCounters.setFieldNameForType(userFieldDataType, string);
    }

    public Map<FieldType, String> getResourceFieldMap() {
        return this.m_resourceFields;
    }

    public Map<FieldType, String> getWbsFieldMap() {
        return this.m_wbsFields;
    }

    public Map<FieldType, String> getTaskFieldMap() {
        return this.m_taskFields;
    }

    public Map<FieldType, String> getAssignmentFields() {
        return this.m_assignmentFields;
    }

    public Map<FieldType, String> getAliases() {
        return this.m_aliases;
    }

    public boolean getMatchPrimaveraWBS() {
        return this.m_matchPrimaveraWBS;
    }

    public void setMatchPrimaveraWBS(boolean bl) {
        this.m_matchPrimaveraWBS = bl;
    }
}

