/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TestOperator implements MpxjEnum
{
    IS_ANY_VALUE(0){

        public boolean evaluate(Object object, Object object2) {
            return true;
        }
    }
    ,
    IS_WITHIN(1){

        public boolean evaluate(Object object, Object object2) {
            return this.evaluateWithin(object, object2);
        }
    }
    ,
    IS_GREATER_THAN(2){

        public boolean evaluate(Object object, Object object2) {
            return this.evaluateCompareTo(object, object2) > 0;
        }
    }
    ,
    IS_LESS_THAN(3){

        public boolean evaluate(Object object, Object object2) {
            return this.evaluateCompareTo(object, object2) < 0;
        }
    }
    ,
    IS_GREATER_THAN_OR_EQUAL_TO(4){

        public boolean evaluate(Object object, Object object2) {
            return this.evaluateCompareTo(object, object2) >= 0;
        }
    }
    ,
    IS_LESS_THAN_OR_EQUAL_TO(5){

        public boolean evaluate(Object object, Object object2) {
            return this.evaluateCompareTo(object, object2) <= 0;
        }
    }
    ,
    EQUALS(6){

        public boolean evaluate(Object object, Object object2) {
            boolean bl = object == null ? this.getSingleOperand(object2) == null : object.equals(this.getSingleOperand(object2));
            return bl;
        }
    }
    ,
    DOES_NOT_EQUAL(7){

        public boolean evaluate(Object object, Object object2) {
            boolean bl = object == null ? this.getSingleOperand(object2) != null : !object.equals(this.getSingleOperand(object2));
            return bl;
        }
    }
    ,
    CONTAINS(8){

        public boolean evaluate(Object object, Object object2) {
            return this.evaluateContains(object, object2);
        }
    }
    ,
    IS_NOT_WITHIN(9){

        public boolean evaluate(Object object, Object object2) {
            return !this.evaluateWithin(object, object2);
        }
    }
    ,
    DOES_NOT_CONTAIN(10){

        public boolean evaluate(Object object, Object object2) {
            return !this.evaluateContains(object, object2);
        }
    }
    ,
    CONTAINS_EXACTLY(11){

        public boolean evaluate(Object object, Object object2) {
            return this.evaluateContainsExactly(object, object2);
        }
    }
    ,
    AND(12){

        public boolean evaluate(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OR(13){

        public boolean evaluate(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }
    };

    private static final TestOperator[] TYPE_VALUES;
    private int m_value;

    private TestOperator(int n2) {
        this.m_value = n2;
    }

    public static TestOperator getInstance(int n) {
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = IS_ANY_VALUE.getValue();
        }
        return TYPE_VALUES[n];
    }

    public static TestOperator getInstance(Number number) {
        int n = number == null ? -1 : NumberHelper.getInt(number);
        return TestOperator.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public abstract boolean evaluate(Object var1, Object var2);

    protected Object getSingleOperand(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            object = objectArray[0];
        }
        return object;
    }

    protected boolean evaluateWithin(Object object, Object object2) {
        boolean bl = false;
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            if (object != null) {
                Comparable comparable = (Comparable)object;
                if (objectArray[0] != null && objectArray[1] != null) {
                    bl = comparable.compareTo(objectArray[0]) >= 0 && comparable.compareTo(objectArray[1]) <= 0 || comparable.compareTo(objectArray[0]) <= 0 && comparable.compareTo(objectArray[1]) >= 0;
                }
            } else {
                bl = objectArray[0] == null || objectArray[1] == null;
            }
        }
        return bl;
    }

    protected int evaluateCompareTo(Object object, Object object2) {
        object2 = this.getSingleOperand(object2);
        int n = object == null || object2 == null ? (object == object2 ? 0 : (object == null ? 1 : -1)) : ((Comparable)object).compareTo(object2);
        return n;
    }

    protected boolean evaluateContains(Object object, Object object2) {
        boolean bl = false;
        object2 = this.getSingleOperand(object2);
        if (object instanceof String && object2 instanceof String) {
            bl = ((String)object).toUpperCase().indexOf(((String)object2).toUpperCase()) != -1;
        }
        return bl;
    }

    protected boolean evaluateContainsExactly(Object object, Object object2) {
        boolean bl = false;
        object2 = this.getSingleOperand(object2);
        if (object instanceof String && object2 instanceof String) {
            bl = ((String)object).indexOf((String)object2) != -1;
        }
        return bl;
    }

    static {
        TYPE_VALUES = (TestOperator[])EnumHelper.createTypeArray(TestOperator.class);
    }
}

