/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.StringTokenizer;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.SetupQueryRunner;
import org.postgresql.core.Utils;
import org.postgresql.core.v2.ProtocolConnectionImpl;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.util.GT;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.UnixCrypt;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;

    @Override
    public ProtocolConnection openConnectionImpl(String host, int port, String user, String database, Properties info, Logger logger) throws SQLException {
        boolean requireSSL;
        boolean trySSL = requireSSL = info.getProperty("ssl") != null;
        boolean requireTCPKeepAlive = Boolean.valueOf(info.getProperty("tcpKeepAlive"));
        if (logger.logDebug()) {
            logger.debug("Trying to establish a protocol version 2 connection to " + host + ":" + port);
        }
        PGStream newStream = null;
        try {
            newStream = new PGStream(host, port);
            if (trySSL) {
                newStream = this.enableSSL(newStream, requireSSL, info, logger);
            }
            String socketTimeoutProperty = info.getProperty("socketTimeout", "0");
            try {
                int socketTimeout = Integer.parseInt(socketTimeoutProperty);
                if (socketTimeout > 0) {
                    newStream.getSocket().setSoTimeout(socketTimeout * 1000);
                }
            }
            catch (NumberFormatException nfe) {
                logger.info("Couldn't parse socketTimeout value:" + socketTimeoutProperty);
            }
            newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
            this.sendStartupPacket(newStream, user, database, logger);
            this.doAuthentication(newStream, user, info.getProperty("password"), logger);
            ProtocolConnectionImpl protoConnection = new ProtocolConnectionImpl(newStream, user, database, logger);
            this.readStartupMessages(newStream, protoConnection, logger);
            this.runInitialQueries(protoConnection, info, logger);
            return protoConnection;
        }
        catch (ConnectException cex) {
            throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
        }
        catch (IOException ioe) {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
        catch (SQLException se) {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw se;
        }
    }

    private PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info, Logger logger) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" FE=> SSLRequest");
        }
        pgStream.SendInteger4(8);
        pgStream.SendInteger2(1234);
        pgStream.SendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.ReceiveChar();
        switch (beresp) {
            case 69: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLError");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getHost(), pgStream.getPort());
            }
            case 78: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLRefused");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLOk");
                }
                MakeSSL.convert(pgStream, info, logger);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pgStream, String user, String database, Logger logger) throws IOException {
        if (logger.logDebug()) {
            logger.debug(" FE=> StartupPacket(user=" + user + ",database=" + database + ")");
        }
        pgStream.SendInteger4(296);
        pgStream.SendInteger2(2);
        pgStream.SendInteger2(0);
        pgStream.Send(database.getBytes("UTF-8"), 64);
        pgStream.Send(user.getBytes("UTF-8"), 32);
        pgStream.Send(new byte[64]);
        pgStream.Send(new byte[64]);
        pgStream.Send(new byte[64]);
        pgStream.flush();
    }

    private void doAuthentication(PGStream pgStream, String user, String password, Logger logger) throws IOException, SQLException {
        block10: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 69: {
                    String errorMsg = pgStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + errorMsg + ")");
                    }
                    throw new PSQLException(GT.tr("Connection rejected: {0}.", errorMsg), PSQLState.CONNECTION_REJECTED);
                }
                case 82: {
                    int areq = pgStream.ReceiveInteger4();
                    switch (areq) {
                        case 4: {
                            byte[] salt = pgStream.Receive(2);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqCrypt(salt='" + new String(salt, "US-ASCII") + "')");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedResult = UnixCrypt.crypt(salt, password.getBytes("UTF-8"));
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(crypt='" + new String(encodedResult, "US-ASCII") + "')");
                            }
                            pgStream.SendInteger4(4 + encodedResult.length + 1);
                            pgStream.Send(encodedResult);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 5: {
                            byte[] md5Salt = pgStream.Receive(4);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqMD5(salt=" + Utils.toHexString(md5Salt) + ")");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] digest = MD5Digest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(md5digest=" + new String(digest, "US-ASCII") + ")");
                            }
                            pgStream.SendInteger4(4 + digest.length + 1);
                            pgStream.Send(digest);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 3: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqPassword");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(password=<not shown>)");
                            }
                            byte[] encodedPassword = password.getBytes("UTF-8");
                            pgStream.SendInteger4(4 + encodedPassword.length + 1);
                            pgStream.Send(encodedPassword);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 0: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                    }
                    if (logger.logDebug()) {
                        logger.debug(" <=BE AuthenticationReq (unsupported type " + areq + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(areq)), PSQLState.CONNECTION_REJECTED);
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void readStartupMessages(PGStream pgStream, ProtocolConnectionImpl protoConnection, Logger logger) throws IOException, SQLException {
        block6: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ReadyForQuery");
                    }
                    return;
                }
                case 75: {
                    int pid = pgStream.ReceiveInteger4();
                    int ckey = pgStream.ReceiveInteger4();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE BackendKeyData(pid=" + pid + ",ckey=" + ckey + ")");
                    }
                    protoConnection.setBackendKeyData(pid, ckey);
                    continue block6;
                }
                case 69: {
                    String errorMsg = pgStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorResponse(" + errorMsg + ")");
                    }
                    throw new PSQLException(GT.tr("Backend start-up failed: {0}.", errorMsg), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                case 78: {
                    String warnMsg = pgStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE NoticeResponse(" + warnMsg + ")");
                    }
                    protoConnection.addWarning(new SQLWarning(warnMsg));
                    continue block6;
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void runInitialQueries(ProtocolConnectionImpl protoConnection, Properties info, Logger logger) throws SQLException, IOException {
        byte[][] results = SetupQueryRunner.run(protoConnection, "set datestyle = 'ISO'; select version(), case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end", true);
        String rawDbVersion = protoConnection.getEncoding().decode(results[0]);
        StringTokenizer versionParts = new StringTokenizer(rawDbVersion);
        versionParts.nextToken();
        String dbVersion = versionParts.nextToken();
        protoConnection.setServerVersion(dbVersion);
        if (dbVersion.compareTo("7.3") >= 0) {
            if (logger.logDebug()) {
                logger.debug("Switching to UTF8 client_encoding");
            }
            String sql = "begin; set autocommit = on; set client_encoding = 'UTF8'; ";
            if (dbVersion.compareTo("9.0") >= 0) {
                sql = sql + "SET extra_float_digits=3; ";
            } else if (dbVersion.compareTo("7.4") >= 0) {
                sql = sql + "SET extra_float_digits=2; ";
            }
            sql = sql + "commit";
            SetupQueryRunner.run(protoConnection, sql, false);
            protoConnection.setEncoding(Encoding.getDatabaseEncoding("UTF8"));
        } else {
            String dbEncoding;
            String charSet = info.getProperty("charSet");
            String string = dbEncoding = results[1] == null ? null : protoConnection.getEncoding().decode(results[1]);
            if (logger.logDebug()) {
                logger.debug("Specified charset:  " + charSet);
                logger.debug("Database encoding: " + dbEncoding);
            }
            if (charSet != null) {
                protoConnection.setEncoding(Encoding.getJVMEncoding(charSet));
            } else if (dbEncoding != null) {
                protoConnection.setEncoding(Encoding.getDatabaseEncoding(dbEncoding));
            } else {
                protoConnection.setEncoding(Encoding.defaultEncoding());
            }
        }
        if (logger.logDebug()) {
            logger.debug("Connection encoding (using JVM's nomenclature): " + protoConnection.getEncoding());
        }
        if (dbVersion.compareTo("8.1") >= 0) {
            results = SetupQueryRunner.run(protoConnection, "select current_setting('standard_conforming_strings')", true);
            String value = protoConnection.getEncoding().decode(results[0]);
            protoConnection.setStandardConformingStrings(value.equalsIgnoreCase("on"));
        } else {
            protoConnection.setStandardConformingStrings(false);
        }
        String appName = info.getProperty("ApplicationName");
        if (appName != null && dbVersion.compareTo("9.0") >= 0) {
            StringBuffer sb = new StringBuffer("SET application_name = '");
            Utils.appendEscapedLiteral(sb, appName, protoConnection.getStandardConformingStrings());
            sb.append("'");
            SetupQueryRunner.run(protoConnection, sb.toString(), false);
        }
    }
}

