/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class HttpsURL
extends HttpURL {
    public static final char[] DEFAULT_SCHEME = new char[]{'h', 't', 't', 'p', 's'};
    public static final char[] _default_scheme = DEFAULT_SCHEME;
    public static final int DEFAULT_PORT = 443;
    public static final int _default_port = 443;
    static final long serialVersionUID = 887844277028676648L;

    protected HttpsURL() {
    }

    public HttpsURL(char[] cArray, String string) throws URIException, NullPointerException {
        this.protocolCharset = string;
        this.parseUriReference(new String(cArray), true);
        this.checkValid();
    }

    public HttpsURL(char[] cArray) throws URIException, NullPointerException {
        this.parseUriReference(new String(cArray), true);
        this.checkValid();
    }

    public HttpsURL(String string, String string2) throws URIException {
        this.protocolCharset = string2;
        this.parseUriReference(string, false);
        this.checkValid();
    }

    public HttpsURL(String string) throws URIException {
        this.parseUriReference(string, false);
        this.checkValid();
    }

    public HttpsURL(String string, int n, String string2) throws URIException {
        this(null, string, n, string2, null, null);
    }

    public HttpsURL(String string, int n, String string2, String string3) throws URIException {
        this(null, string, n, string2, string3, null);
    }

    public HttpsURL(String string, String string2, String string3) throws URIException {
        this(string, string2, string3, -1, null, null, null);
    }

    public HttpsURL(String string, String string2, String string3, int n) throws URIException {
        this(string, string2, string3, n, null, null, null);
    }

    public HttpsURL(String string, String string2, String string3, int n, String string4) throws URIException {
        this(string, string2, string3, n, string4, null, null);
    }

    public HttpsURL(String string, String string2, String string3, int n, String string4, String string5) throws URIException {
        this(string, string2, string3, n, string4, string5, null);
    }

    public HttpsURL(String string, String string2, String string3, String string4) throws URIException {
        this(null, string, -1, string2, string3, string4);
    }

    public HttpsURL(String string, String string2, String string3, String string4, String string5) throws URIException {
        this(string, string2, -1, string3, string4, string5);
    }

    public HttpsURL(String string, String string2, int n, String string3) throws URIException {
        this(string, string2, n, string3, null, null);
    }

    public HttpsURL(String string, String string2, int n, String string3, String string4) throws URIException {
        this(string, string2, n, string3, string4, null);
    }

    public HttpsURL(String string, String string2, int n, String string3, String string4, String string5) throws URIException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null || string2 != null || n != -1) {
            this._scheme = DEFAULT_SCHEME;
            stringBuffer.append(_default_scheme);
            stringBuffer.append("://");
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append('@');
            }
            if (string2 != null) {
                stringBuffer.append(URIUtil.encode(string2, URI.allowed_host));
                if (n != -1 || n != 443) {
                    stringBuffer.append(':');
                    stringBuffer.append(n);
                }
            }
        }
        if (string3 != null) {
            if (scheme != null && !string3.startsWith("/")) {
                throw new URIException(1, "abs_path requested");
            }
            stringBuffer.append(URIUtil.encode(string3, URI.allowed_abs_path));
        }
        if (string4 != null) {
            stringBuffer.append('?');
            stringBuffer.append(URIUtil.encode(string4, URI.allowed_query));
        }
        if (string5 != null) {
            stringBuffer.append('#');
            stringBuffer.append(URIUtil.encode(string5, URI.allowed_fragment));
        }
        this.parseUriReference(stringBuffer.toString(), true);
        this.checkValid();
    }

    public HttpsURL(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URIException {
        this(HttpURL.toUserinfo(string, string2), string3, n, string4, string5, string6);
    }

    public HttpsURL(HttpsURL httpsURL, String string) throws URIException {
        this(httpsURL, new HttpsURL(string));
    }

    public HttpsURL(HttpsURL httpsURL, HttpsURL httpsURL2) throws URIException {
        super((HttpURL)httpsURL, httpsURL2);
        this.checkValid();
    }

    public char[] getRawScheme() {
        return this._scheme == null ? null : DEFAULT_SCHEME;
    }

    public String getScheme() {
        return this._scheme == null ? null : new String(DEFAULT_SCHEME);
    }

    public int getPort() {
        return this._port == -1 ? 443 : this._port;
    }

    protected void checkValid() throws URIException {
        if (!this.equals(this._scheme, DEFAULT_SCHEME) && this._scheme != null) {
            throw new URIException(1, "wrong class use");
        }
    }
}

