/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.ScriptEditor;
import com.sun.star.script.framework.provider.SwingInvocation;
import com.sun.star.script.framework.provider.beanshell.PlainSourceView;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceModel;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceView;
import com.sun.star.script.provider.XScriptContext;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ScriptEditorForBeanShell
implements ScriptEditor,
ActionListener {
    private JFrame frame;
    private String filename;
    private ScriptSourceModel model;
    private ScriptSourceView view;
    private XScriptContext context;
    private URL scriptURL = null;
    private ClassLoader cl = null;
    private static ScriptEditorForBeanShell theScriptEditorForBeanShell;
    private static Map<URL, ScriptEditorForBeanShell> BEING_EDITED;
    private static String BSHTEMPLATE;

    public static synchronized ScriptEditorForBeanShell getEditor() {
        if (theScriptEditorForBeanShell == null) {
            theScriptEditorForBeanShell = new ScriptEditorForBeanShell();
        }
        return theScriptEditorForBeanShell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptEditorForBeanShell getEditor(URL uRL) {
        Map<URL, ScriptEditorForBeanShell> map = BEING_EDITED;
        synchronized (map) {
            return BEING_EDITED.get(uRL);
        }
    }

    public boolean isModified() {
        return this.view.isModified();
    }

    public String getText() {
        return this.view.getText();
    }

    public String getTemplate() {
        return BSHTEMPLATE;
    }

    public String getExtension() {
        return "bsh";
    }

    public void indicateErrorLine(int n) {
        this.model.indicateErrorLine(n);
    }

    public Object execute() throws Exception {
        this.frame.toFront();
        return this.model.execute(this.context, this.cl);
    }

    public void edit(final XScriptContext xScriptContext, ScriptMetaData scriptMetaData) {
        if (scriptMetaData != null) {
            try {
                ClassLoader classLoader = null;
                try {
                    classLoader = ClassLoaderFactory.getURLClassLoader(scriptMetaData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final ClassLoader classLoader2 = classLoader;
                String string = scriptMetaData.getParcelLocation();
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                string = string + scriptMetaData.getLanguageName();
                final URL uRL = scriptMetaData.getSourceURL();
                SwingInvocation.invoke(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ScriptEditorForBeanShell scriptEditorForBeanShell;
                        Map map = BEING_EDITED;
                        synchronized (map) {
                            scriptEditorForBeanShell = (ScriptEditorForBeanShell)BEING_EDITED.get(uRL);
                            if (scriptEditorForBeanShell == null) {
                                scriptEditorForBeanShell = new ScriptEditorForBeanShell(xScriptContext, classLoader2, uRL);
                                BEING_EDITED.put(uRL, scriptEditorForBeanShell);
                            }
                        }
                        scriptEditorForBeanShell.frame.toFront();
                    }
                });
            }
            catch (IOException iOException) {
                this.showErrorMessage("Error loading file: " + iOException.getMessage());
            }
        }
    }

    private ScriptEditorForBeanShell() {
    }

    private ScriptEditorForBeanShell(XScriptContext xScriptContext, ClassLoader classLoader, URL uRL) {
        this.context = xScriptContext;
        this.scriptURL = uRL;
        this.model = new ScriptSourceModel(uRL);
        this.filename = uRL.getFile();
        this.cl = classLoader;
        try {
            Class<?> clazz = Class.forName("org.openoffice.netbeans.editor.NetBeansSourceView");
            Class[] classArray = new Class[]{ScriptSourceModel.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            if (constructor != null) {
                Object[] objectArray = new Object[]{this.model};
                this.view = (ScriptSourceView)constructor.newInstance(objectArray);
            } else {
                this.view = new PlainSourceView(this.model);
            }
        }
        catch (Error error) {
            this.view = new PlainSourceView(this.model);
        }
        catch (Exception exception) {
            this.view = new PlainSourceView(this.model);
        }
        this.model.setView(this.view);
        this.initUI();
        this.frame.setVisible(true);
    }

    private void showErrorMessage(String string) {
        JOptionPane.showMessageDialog(this.frame, string, "Error", 0);
    }

    private void initUI() {
        this.frame = new JFrame("BeanShell Debug Window: " + this.filename);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ScriptEditorForBeanShell.this.doClose();
            }
        });
        String[] stringArray = new String[]{"Run", "Clear", "Save", "Close"};
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        for (String string : stringArray) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            if (!string.equals("Save") || this.filename != null) continue;
            jButton.setEnabled(false);
        }
        this.frame.getContentPane().add((Component)((JComponent)((Object)this.view)), "Center");
        this.frame.getContentPane().add((Component)jPanel, "South");
        this.frame.pack();
        this.frame.setSize(590, 480);
        this.frame.setLocation(300, 200);
    }

    private void doClose() {
        if (this.view.isModified()) {
            boolean bl;
            int n = JOptionPane.showConfirmDialog(this.frame, "The script has been modified. Do you want to save the changes?");
            if (n == 2) {
                return;
            }
            if (n == 0 && !(bl = this.saveTextArea())) {
                return;
            }
        }
        this.frame.dispose();
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveTextArea() {
        boolean bl = true;
        if (!this.view.isModified()) {
            return true;
        }
        OutputStream outputStream = null;
        try {
            String string = this.view.getText();
            outputStream = this.scriptURL.openConnection().getOutputStream();
            if (outputStream != null) {
                outputStream.write(string.getBytes());
            } else {
                this.showErrorMessage("Error saving script: Could not open stream for file");
                bl = false;
            }
            this.view.setModified(false);
        }
        catch (IOException iOException) {
            this.showErrorMessage("Error saving script: " + iOException.getMessage());
            bl = false;
        }
        catch (Exception exception) {
            this.showErrorMessage("Error saving script: " + exception.getMessage());
            bl = false;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        Map<URL, ScriptEditorForBeanShell> map = BEING_EDITED;
        synchronized (map) {
            BEING_EDITED.remove(this.scriptURL);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Run")) {
            try {
                this.execute();
            }
            catch (Exception exception) {
                this.showErrorMessage(exception.getMessage());
            }
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.doClose();
        } else if (actionEvent.getActionCommand().equals("Save")) {
            this.saveTextArea();
        } else if (actionEvent.getActionCommand().equals("Clear")) {
            this.view.clear();
        }
    }

    static {
        BEING_EDITED = new HashMap<URL, ScriptEditorForBeanShell>();
        try {
            int n;
            URL uRL = ScriptEditorForBeanShell.class.getResource("template.bsh");
            InputStream inputStream = uRL.openStream();
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                stringBuilder.append(new String(byArray, 0, n));
            }
            inputStream.close();
            BSHTEMPLATE = stringBuilder.toString();
        }
        catch (IOException iOException) {
            BSHTEMPLATE = "// BeanShell script";
        }
        catch (Exception exception) {
            BSHTEMPLATE = "// BeanShell script";
        }
    }
}

