/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObjectVar0;
import org.jruby.RubyObjectVar1;
import org.jruby.RubyObjectVar2;
import org.jruby.RubyObjectVar3;
import org.jruby.RubyObjectVar4;
import org.jruby.RubyObjectVar5;
import org.jruby.RubyObjectVar6;
import org.jruby.RubyObjectVar7;
import org.jruby.RubyObjectVar8;
import org.jruby.RubyObjectVar9;
import org.jruby.RubyString;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.JIT;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.InvokeSite;
import org.jruby.ir.targets.SuperInvokeSite;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MathLinker;
import org.jruby.runtime.invokedynamic.VariableSite;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Bootstrap {
    public static final String BOOTSTRAP_BARE_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    public static final String BOOTSTRAP_LONG_STRING_INT_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE, String.class, Integer.TYPE);
    public static final String BOOTSTRAP_DOUBLE_STRING_INT_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Double.TYPE, String.class, Integer.TYPE);
    public static final Class[] REIFIED_OBJECT_CLASSES = new Class[]{RubyObjectVar0.class, RubyObjectVar1.class, RubyObjectVar2.class, RubyObjectVar3.class, RubyObjectVar4.class, RubyObjectVar5.class, RubyObjectVar6.class, RubyObjectVar7.class, RubyObjectVar8.class, RubyObjectVar9.class};
    private static final Logger LOG = LoggerFactory.getLogger("Bootstrap");
    static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Signature STRING_SIGNATURE = Signature.from(RubyString.class, Helpers.arrayOf(ThreadContext.class), "context");
    private static final Signature NEW_STRING_SHARED_SIGNATURE = Signature.from(RubyString.class, Helpers.arrayOf(ThreadContext.class, ByteList.class), "context", "byteList");
    private static final SmartHandle NEW_STRING_SHARED_HANDLE = SmartBinder.from(NEW_STRING_SHARED_SIGNATURE).invokeStaticQuiet(MethodHandles.lookup(), Bootstrap.class, "newStringShared");

    public static CallSite string(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName, int cr) {
        EncodingDB.Entry entry = EncodingDB.getEncodings().get(encodingName.getBytes());
        if (entry == null) {
            entry = EncodingDB.getAliases().get(encodingName.getBytes());
        }
        if (entry == null) {
            throw new RuntimeException("could not find encoding: " + encodingName);
        }
        Encoding encoding2 = entry.getEncoding();
        ByteList byteList = new ByteList(value2.getBytes(RubyEncoding.ISO), encoding2);
        MutableCallSite site = new MutableCallSite(type2);
        Binder binder = Binder.from(RubyString.class, ThreadContext.class, new Class[0]).insert(0, Helpers.arrayOf(MutableCallSite.class, ByteList.class, Integer.TYPE), new Object[]{site, byteList, cr});
        if (name2.equals("frozen")) {
            site.setTarget(binder.invokeStaticQuiet(lookup, Bootstrap.class, "frozenString"));
        } else {
            site.setTarget(binder.invokeStaticQuiet(lookup, Bootstrap.class, "string"));
        }
        return site;
    }

    public static CallSite bytelist(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName) {
        EncodingDB.Entry entry = EncodingDB.getEncodings().get(encodingName.getBytes());
        if (entry == null) {
            entry = EncodingDB.getAliases().get(encodingName.getBytes());
        }
        if (entry == null) {
            throw new RuntimeException("could not find encoding: " + encodingName);
        }
        Encoding encoding2 = entry.getEncoding();
        ByteList byteList = new ByteList(value2.getBytes(RubyEncoding.ISO), encoding2);
        return new ConstantCallSite(MethodHandles.constant(ByteList.class, byteList));
    }

    public static CallSite array(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from(type2).collect(1, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "array");
        ConstantCallSite site = new ConstantCallSite(handle);
        return site;
    }

    public static CallSite hash(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from(lookup, type2).collect(1, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "hash");
        ConstantCallSite site = new ConstantCallSite(handle);
        return site;
    }

    public static CallSite kwargsHash(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from(lookup, type2).collect(2, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "kwargsHash");
        ConstantCallSite site = new ConstantCallSite(handle);
        return site;
    }

    public static CallSite ivar(MethodHandles.Lookup lookup, String name2, MethodType type2) throws Throwable {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = names2[1];
        VariableSite site = new VariableSite(type2, varName, "noname", 0);
        MethodHandle handle = lookup.findStatic(Bootstrap.class, operation, type2.insertParameterTypes(0, VariableSite.class));
        handle = handle.bindTo(site);
        site.setTarget(handle.asType(site.type()));
        return site;
    }

    public static CallSite searchConst(MethodHandles.Lookup lookup, String name2, MethodType type2, int noPrivateConsts) {
        MutableCallSite site = new MutableCallSite(type2);
        String[] bits = name2.split(":");
        String constName = bits[1];
        MethodHandle handle = Binder.from(lookup, type2).append(site, constName.intern()).append(noPrivateConsts != 0).invokeStaticQuiet(LOOKUP, Bootstrap.class, bits[0]);
        site.setTarget(handle);
        return site;
    }

    public static Handle string() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "string", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE));
    }

    public static Handle bytelist() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "bytelist", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class));
    }

    public static Handle array() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "array", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class));
    }

    public static Handle hash() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "hash", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class));
    }

    public static Handle kwargsHash() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "kwargsHash", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class));
    }

    public static Handle invokeSuper() {
        return SuperInvokeSite.BOOTSTRAP;
    }

    public static Handle ivar() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "ivar", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class));
    }

    public static Handle searchConst() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "searchConst", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE));
    }

    public static RubyString string(MutableCallSite site, ByteList value2, int cr, ThreadContext context) throws Throwable {
        MethodHandle handle = SmartBinder.from(STRING_SIGNATURE).invoke(NEW_STRING_SHARED_HANDLE.apply("byteList", (Object)value2)).handle();
        site.setTarget(handle);
        return RubyString.newStringShared(context.runtime, value2, cr);
    }

    public static RubyString frozenString(MutableCallSite site, ByteList value2, int cr, ThreadContext context) throws Throwable {
        RubyString frozen = context.runtime.freezeAndDedupString(RubyString.newStringShared(context.runtime, value2, cr));
        MethodHandle handle = Binder.from(RubyString.class, ThreadContext.class, new Class[0]).dropAll().constant(frozen);
        site.setTarget(handle);
        return frozen;
    }

    @JIT
    private static RubyString newStringShared(ThreadContext context, ByteList byteList) {
        return RubyString.newStringShared(context.runtime, byteList);
    }

    public static IRubyObject array(ThreadContext context, IRubyObject[] elts) {
        return RubyArray.newArrayNoCopy(context.runtime, elts);
    }

    public static Handle contextValue() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "contextValue", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class));
    }

    public static Handle contextValueString() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "contextValueString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class));
    }

    public static CallSite contextValue(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(Binder.from(type2).append(site).invokeStaticQuiet(lookup, Bootstrap.class, name2));
        return site;
    }

    public static CallSite contextValueString(MethodHandles.Lookup lookup, String name2, MethodType type2, String str) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(Binder.from(type2).append(site, str).invokeStaticQuiet(lookup, Bootstrap.class, name2));
        return site;
    }

    public static IRubyObject nil(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)((RubyNil)context.nil).constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.nil);
        }
        site.setTarget(constant);
        return context.nil;
    }

    public static IRubyObject True(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.runtime.getTrue().constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.runtime.getTrue());
        }
        site.setTarget(constant);
        return context.runtime.getTrue();
    }

    public static IRubyObject False(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.runtime.getFalse().constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.runtime.getFalse());
        }
        site.setTarget(constant);
        return context.runtime.getFalse();
    }

    public static Ruby runtime(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.runtime.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(Ruby.class, context.runtime);
        }
        site.setTarget(constant);
        return context.runtime;
    }

    public static RubyEncoding encoding(ThreadContext context, MutableCallSite site, String name2) {
        RubyEncoding rubyEncoding = IRRuntimeHelpers.retrieveEncoding(context, name2);
        MethodHandle constant = (MethodHandle)rubyEncoding.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(RubyEncoding.class, rubyEncoding);
        }
        site.setTarget(constant);
        return rubyEncoding;
    }

    public static IRubyObject hash(ThreadContext context, IRubyObject[] pairs) {
        Ruby runtime = context.runtime;
        RubyHash hash2 = RubyHash.newHash(runtime);
        int i2 = 0;
        while (i2 < pairs.length) {
            hash2.fastASetCheckString(runtime, pairs[i2++], pairs[i2++]);
        }
        return hash2;
    }

    public static IRubyObject kwargsHash(ThreadContext context, RubyHash hash2, IRubyObject[] pairs) {
        return IRRuntimeHelpers.dupKwargsHashAndPopulateFromArray(context, hash2, pairs);
    }

    static MethodHandle buildIndyHandle(InvokeSite site, DynamicMethod method, RubyModule implClass) {
        MethodHandle mh = null;
        Signature siteToDyncall = site.signature.insertArgs(3, Helpers.arrayOf("class", "name"), Helpers.arrayOf(RubyModule.class, String.class));
        if (method instanceof HandleMethod) {
            boolean blockGiven;
            HandleMethod handleMethod = (HandleMethod)method;
            boolean bl = blockGiven = site.signature.lastArgType() == Block.class;
            if (site.arity >= 0 && site.arity <= 3) {
                mh = handleMethod.getHandle(site.arity);
                if (mh != null) {
                    if (!blockGiven) {
                        mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                    }
                    mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                } else {
                    mh = handleMethod.getHandle(4);
                    if (site.arity == 0) {
                        mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                        mh = !blockGiven ? MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK) : MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, IRubyObject.NULL_ARRAY);
                    } else {
                        if (!blockGiven) {
                            mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                        }
                        mh = SmartBinder.from(MethodHandles.lookup(), siteToDyncall).permute("context", "self", "class", "name", "block", "arg.*").collect("args", "arg.*").permute("context", "self", "class", "name", "args", "block").invoke(mh).handle();
                    }
                }
            } else {
                mh = handleMethod.getHandle(4);
                if (!blockGiven) {
                    mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                }
                mh = SmartBinder.from(MethodHandles.lookup(), siteToDyncall).permute("context", "self", "class", "name", "args", "block").invoke(mh).handle();
            }
            mh = MethodHandles.insertArguments(mh, 3, implClass, site.name());
        }
        return mh;
    }

    static MethodHandle buildGenericHandle(InvokeSite site, DynamicMethod method, RubyClass dispatchClass) {
        SmartBinder binder = SmartBinder.from(site.signature).permute("context", "self", "arg.*", "block").insert(2, new String[]{"rubyClass", "name"}, new Class[]{RubyModule.class, String.class}, dispatchClass, site.name()).insert(0, "method", DynamicMethod.class, (Object)method);
        if (site.arity > 3) {
            binder = binder.collect("args", "arg.*");
        }
        return binder.invokeVirtualQuiet(LOOKUP, "call").handle();
    }

    static MethodHandle buildJittedHandle(InvokeSite site, DynamicMethod method, boolean blockGiven) {
        DynamicMethod actualMethod;
        MethodHandle mh = null;
        CompiledIRMethod compiledIRMethod = null;
        if (method instanceof CompiledIRMethod) {
            compiledIRMethod = (CompiledIRMethod)method;
        } else if (method instanceof MixedModeIRMethod && (actualMethod = ((MixedModeIRMethod)method).getActualMethod()) instanceof CompiledIRMethod) {
            compiledIRMethod = (CompiledIRMethod)actualMethod;
        }
        if (compiledIRMethod != null) {
            MethodHandle specific;
            SmartBinder binder = SmartBinder.from(site.signature).permute("context", "self", "arg.*", "block");
            if (site.arity == -1) {
                mh = (MethodHandle)compiledIRMethod.getHandle();
            } else if (site.arity == 0) {
                specific = compiledIRMethod.getHandleFor(site.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.insert(2, "args", IRubyObject.NULL_ARRAY);
                }
            } else {
                specific = compiledIRMethod.getHandleFor(site.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.collect("args", "arg.*");
                }
            }
            if (!blockGiven) {
                binder = binder.append("block", Block.class, (Object)Block.NULL_BLOCK);
            }
            binder = binder.insert(1, "scope", StaticScope.class, (Object)compiledIRMethod.getStaticScope()).append("class", RubyModule.class, (Object)compiledIRMethod.getImplementationClass()).append("frameName", String.class, (Object)site.name());
            mh = binder.invoke(mh).handle();
        }
        return mh;
    }

    static MethodHandle buildNativeHandle(InvokeSite site, DynamicMethod method, boolean blockGiven) {
        MethodHandle mh = null;
        SmartBinder binder = null;
        if (method.getNativeCall() != null) {
            int nativeArgCount = Bootstrap.getNativeArgCount(method, method.getNativeCall());
            DynamicMethod.NativeCall nc = method.getNativeCall();
            if (!nc.isJava()) {
                if (nativeArgCount >= 0) {
                    if (nativeArgCount == site.arity) {
                        binder = SmartBinder.from(MethodHandles.lookup(), site.signature);
                    }
                } else {
                    binder = site.arity == -1 ? SmartBinder.from(MethodHandles.lookup(), site.signature) : (site.arity == 0 ? SmartBinder.from(MethodHandles.lookup(), site.signature).insert(2, "args", IRubyObject.NULL_ARRAY) : SmartBinder.from(MethodHandles.lookup(), site.signature).collect("args", "arg.*"));
                }
                if (binder != null) {
                    if (!nc.hasContext()) {
                        binder = binder.drop("context");
                    }
                    if (nc.hasBlock() && !blockGiven) {
                        binder = binder.append("block", Block.NULL_BLOCK);
                    } else if (!nc.hasBlock() && blockGiven) {
                        binder = binder.drop("block");
                    }
                    mh = nc.isStatic() ? binder.permute("context", "self", "arg.*", "block").cast(nc.getNativeReturn(), nc.getNativeSignature()).invokeStaticQuiet(LOOKUP, nc.getNativeTarget(), nc.getNativeName()).handle() : binder.permute("self", "context", "arg.*", "block").castArg("self", nc.getNativeTarget()).castVirtual(nc.getNativeReturn(), nc.getNativeTarget(), nc.getNativeSignature()).invokeVirtualQuiet(LOOKUP, nc.getNativeName()).handle();
                }
            }
        }
        return mh;
    }

    public static int getNativeArgCount(DynamicMethod method, DynamicMethod.NativeCall nativeCall) {
        return Bootstrap.getArgCount(nativeCall.getNativeSignature(), nativeCall.isStatic());
    }

    private static int getArgCount(Class[] args2, boolean isStatic) {
        int length2 = args2.length;
        boolean hasContext = false;
        if (isStatic) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            assert (args2.length >= 1);
            --length2;
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[1] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[0] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        }
        return length2;
    }

    public static IRubyObject ivarGet(VariableSite site, IRubyObject self2) throws Throwable {
        MethodHandle getValue2;
        RubyClass realClass = self2.getMetaClass().getRealClass();
        VariableAccessor accessor = realClass.getVariableAccessorForRead(site.name());
        MethodHandle nullToNil = Bootstrap.findStatic(Helpers.class, "nullToNil", MethodType.methodType(IRubyObject.class, IRubyObject.class, IRubyObject.class));
        nullToNil = MethodHandles.insertArguments(nullToNil, 1, self2.getRuntime().getNil());
        nullToNil = MethodHandles.explicitCastArguments(nullToNil, MethodType.methodType(IRubyObject.class, Object.class));
        boolean direct = false;
        if (accessor instanceof FieldVariableAccessor) {
            direct = true;
            int offset2 = ((FieldVariableAccessor)accessor).getOffset();
            Class cls = REIFIED_OBJECT_CLASSES[offset2];
            getValue2 = MethodHandles.lookup().findGetter(cls, "var" + offset2, Object.class);
            getValue2 = MethodHandles.explicitCastArguments(getValue2, MethodType.methodType(Object.class, IRubyObject.class));
        } else {
            getValue2 = Bootstrap.findStatic(VariableAccessor.class, "getVariable", MethodType.methodType(Object.class, RubyBasicObject.class, Integer.TYPE));
            getValue2 = MethodHandles.explicitCastArguments(getValue2, MethodType.methodType(Object.class, IRubyObject.class, Integer.TYPE));
            getValue2 = MethodHandles.insertArguments(getValue2, 1, accessor.getIndex());
        }
        getValue2 = MethodHandles.filterReturnValue(getValue2, nullToNil);
        MethodHandle fallback = null;
        if (site.chainCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(site.name() + "\tqet on type " + self2.getMetaClass().id + " failed (polymorphic)" + Bootstrap.extractSourceInfo(site), new Object[0]);
            }
            fallback = Bootstrap.findStatic(Bootstrap.class, "ivarGetFail", MethodType.methodType(IRubyObject.class, VariableSite.class, IRubyObject.class));
            fallback = fallback.bindTo(site);
            site.setTarget(fallback);
            return (IRubyObject)fallback.invokeWithArguments(self2);
        }
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            if (direct) {
                LOG.info(site.name() + "\tget field on type " + self2.getMetaClass().id + " added to PIC" + Bootstrap.extractSourceInfo(site), new Object[0]);
            } else {
                LOG.info(site.name() + "\tget on type " + self2.getMetaClass().id + " added to PIC" + Bootstrap.extractSourceInfo(site), new Object[0]);
            }
        }
        fallback = site.getTarget();
        site.incrementChainCount();
        MethodHandle test2 = Bootstrap.findStatic(Bootstrap.class, "testRealClass", MethodType.methodType(Boolean.TYPE, Integer.TYPE, IRubyObject.class));
        test2 = MethodHandles.insertArguments(test2, 0, accessor.getClassId());
        getValue2 = MethodHandles.guardWithTest(test2, getValue2, fallback);
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(site.name() + "\tget on class " + self2.getMetaClass().id + " bound directly" + Bootstrap.extractSourceInfo(site), new Object[0]);
        }
        site.setTarget(getValue2);
        return getValue2.invokeExact(self2);
    }

    public static IRubyObject ivarGetFail(VariableSite site, IRubyObject self2) throws Throwable {
        return site.getVariable(self2);
    }

    public static void ivarSet(VariableSite site, IRubyObject self2, IRubyObject value2) throws Throwable {
        MethodHandle setValue2;
        RubyClass realClass = self2.getMetaClass().getRealClass();
        VariableAccessor accessor = realClass.getVariableAccessorForWrite(site.name());
        boolean direct = false;
        if (accessor instanceof FieldVariableAccessor) {
            direct = true;
            int offset2 = ((FieldVariableAccessor)accessor).getOffset();
            Class cls = REIFIED_OBJECT_CLASSES[offset2];
            setValue2 = Bootstrap.findStatic(cls, "setVariableChecked", MethodType.methodType(Void.TYPE, cls, Object.class));
            setValue2 = MethodHandles.explicitCastArguments(setValue2, MethodType.methodType(Void.TYPE, IRubyObject.class, IRubyObject.class));
        } else {
            setValue2 = Bootstrap.findStatic(accessor.getClass(), "setVariableChecked", MethodType.methodType(Void.TYPE, RubyBasicObject.class, RubyClass.class, Integer.TYPE, Object.class));
            setValue2 = MethodHandles.explicitCastArguments(setValue2, MethodType.methodType(Void.TYPE, IRubyObject.class, RubyClass.class, Integer.TYPE, IRubyObject.class));
            setValue2 = MethodHandles.insertArguments(setValue2, 1, realClass, accessor.getIndex());
        }
        MethodHandle fallback = null;
        if (site.chainCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(site.name() + "\tset on type " + self2.getMetaClass().id + " failed (polymorphic)" + Bootstrap.extractSourceInfo(site), new Object[0]);
            }
            fallback = Bootstrap.findStatic(Bootstrap.class, "ivarSetFail", MethodType.methodType(Void.TYPE, VariableSite.class, IRubyObject.class, IRubyObject.class));
            fallback = fallback.bindTo(site);
            site.setTarget(fallback);
            fallback.invokeExact(self2, value2);
        } else {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                if (direct) {
                    LOG.info(site.name() + "\tset field on type " + self2.getMetaClass().id + " added to PIC" + Bootstrap.extractSourceInfo(site), new Object[0]);
                } else {
                    LOG.info(site.name() + "\tset on type " + self2.getMetaClass().id + " added to PIC" + Bootstrap.extractSourceInfo(site), new Object[0]);
                }
            }
            fallback = site.getTarget();
            site.incrementChainCount();
        }
        MethodHandle test2 = Bootstrap.findStatic(Bootstrap.class, "testRealClass", MethodType.methodType(Boolean.TYPE, Integer.TYPE, IRubyObject.class));
        test2 = MethodHandles.insertArguments(test2, 0, accessor.getClassId());
        test2 = MethodHandles.dropArguments(test2, 1, new Class[]{IRubyObject.class});
        setValue2 = MethodHandles.guardWithTest(test2, setValue2, fallback);
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(site.name() + "\tset on class " + self2.getMetaClass().id + " bound directly" + Bootstrap.extractSourceInfo(site), new Object[0]);
        }
        site.setTarget(setValue2);
        setValue2.invokeExact(self2, value2);
    }

    public static void ivarSetFail(VariableSite site, IRubyObject self2, IRubyObject value2) throws Throwable {
        site.setVariable(self2, value2);
    }

    private static MethodHandle findStatic(Class target, String name2, MethodType type2) {
        return Bootstrap.findStatic(MethodHandles.lookup(), target, name2, type2);
    }

    private static MethodHandle findStatic(MethodHandles.Lookup lookup, Class target, String name2, MethodType type2) {
        try {
            return lookup.findStatic(target, name2, type2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean testRealClass(int id2, IRubyObject self2) {
        return id2 == ((RubyBasicObject)self2).getMetaClass().getRealClass().id;
    }

    public static boolean testType(RubyClass original, IRubyObject self2) {
        return ((RubyBasicObject)self2).getMetaClass() == original;
    }

    public static IRubyObject searchConst(ThreadContext context, StaticScope staticScope, MutableCallSite site, String constName, boolean noPrivateConsts) throws Throwable {
        Ruby runtime = context.getRuntime();
        RubyClass object = runtime.getObject();
        IRubyObject constant = staticScope == null ? object.getConstant(constName) : staticScope.getConstantInner(constName);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        }
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(constName));
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(constName).getData();
        MethodHandle target = Binder.from(site.type()).drop(0, 2).constant(constant);
        MethodHandle fallback = Binder.from(site.type()).append(site, constName).append(noPrivateConsts).invokeStatic(LOOKUP, Bootstrap.class, "searchConst");
        site.setTarget(switchPoint.guardWithTest(target, fallback));
        return constant;
    }

    public static IRubyObject inheritanceSearchConst(ThreadContext context, IRubyObject cmVal, MutableCallSite site, String constName, boolean noPrivateConsts) throws Throwable {
        IRubyObject constant;
        Ruby runtime = context.runtime;
        if (!(cmVal instanceof RubyModule)) {
            throw runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    public static IRubyObject lexicalSearchConst(ThreadContext context, StaticScope scope, MutableCallSite site, String constName, boolean noPrivateConsts) throws Throwable {
        Ruby runtime = context.runtime;
        IRubyObject constant = scope.getConstantInner(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(constName).getData();
        MethodHandle target = Binder.from(site.type()).drop(0, 2).constant(constant);
        MethodHandle fallback = Binder.from(site.type()).append(site, constName).append(noPrivateConsts).invokeStatic(LOOKUP, Bootstrap.class, "lexicalSearchConst");
        site.setTarget(switchPoint.guardWithTest(target, fallback));
        return constant;
    }

    public static IRubyObject instVarNullToNil(IRubyObject value2, IRubyObject nil, String name2) {
        if (value2 == null) {
            Ruby runtime = nil.getRuntime();
            if (runtime.isVerbose()) {
                nil.getRuntime().getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + name2 + " not initialized");
            }
            return nil;
        }
        return value2;
    }

    public static boolean testArg0ModuleMatch(IRubyObject arg0, int id2) {
        System.out.println("testing " + arg0 + " for match (id = " + ((RubyModule)arg0).id + "): " + (arg0 instanceof RubyModule && ((RubyModule)arg0).id == id2));
        return arg0 instanceof RubyModule && ((RubyModule)arg0).id == id2;
    }

    private static String extractSourceInfo(VariableSite site) {
        return " (" + site.file() + ":" + site.line() + ")";
    }

    public static Handle getFixnumOperatorHandle() {
        return Bootstrap.getBootstrapHandle("fixnumOperatorBootstrap", MathLinker.class, BOOTSTRAP_LONG_STRING_INT_SIG);
    }

    public static Handle getFloatOperatorHandle() {
        return Bootstrap.getBootstrapHandle("floatOperatorBootstrap", MathLinker.class, BOOTSTRAP_DOUBLE_STRING_INT_SIG);
    }

    public static Handle checkpointHandle() {
        return Bootstrap.getBootstrapHandle("checkpointBootstrap", BOOTSTRAP_BARE_SIG);
    }

    public static Handle getBootstrapHandle(String name2, String sig) {
        return Bootstrap.getBootstrapHandle(name2, Bootstrap.class, sig);
    }

    public static Handle getBootstrapHandle(String name2, Class type2, String sig) {
        return new Handle(6, CodegenUtils.p(type2), name2, sig);
    }

    public static CallSite checkpointBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2) throws Throwable {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle handle = lookup.findStatic(Bootstrap.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static void checkpointFallback(MutableCallSite site, ThreadContext context) throws Throwable {
        Ruby runtime = context.runtime;
        Invalidator invalidator = runtime.getCheckpointInvalidator();
        MethodHandle target = Binder.from(Void.TYPE, ThreadContext.class, new Class[0]).nop();
        MethodHandle fallback = MethodHandles.lookup().findStatic(Bootstrap.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
    }
}

