/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvocationLinker;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvokeDynamicMethodFactory
extends InvocationMethodFactory {
    private static final Logger LOG = LoggerFactory.getLogger("InvokeDynamicMethodFactory");
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final com.headius.invokebinder.Signature VARIABLE_ARITY_SIGNATURE = com.headius.invokebinder.Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class).appendArg("class", RubyModule.class).appendArg("name", String.class).appendArg("args", IRubyObject[].class).appendArg("block", Block.class);
    public static final com.headius.invokebinder.Signature[] SPECIFIC_ARITY_SIGNATURES;
    private static final SmartBinder[] SPREAD_BINDERS;

    public InvokeDynamicMethodFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public DynamicMethod getAnnotatedMethod(final RubyModule implementationClass, final List<JavaMethodDescriptor> descs) {
        JavaMethodDescriptor desc1 = descs.get(0);
        if (desc1.anno.frame()) {
            return super.getAnnotatedMethod(implementationClass, descs);
        }
        if (!Modifier.isPublic(desc1.getDeclaringClass().getModifiers())) {
            LOG.warn("warning: binding non-public class {}; reflected handles won't work", desc1.declaringClassName);
        }
        int min2 = Integer.MAX_VALUE;
        int max2 = 0;
        boolean notImplemented = false;
        for (JavaMethodDescriptor desc : descs) {
            int specificArity = -1;
            if (desc.optional == 0 && !desc.rest) {
                if (desc.required == 0) {
                    if (desc.actualRequired <= 3) {
                        specificArity = desc.actualRequired;
                    }
                } else if (desc.required >= 0 && desc.required <= 3) {
                    specificArity = desc.required;
                }
            }
            if (specificArity != -1) {
                if (specificArity < min2) {
                    min2 = specificArity;
                }
                if (specificArity > max2) {
                    max2 = specificArity;
                }
            } else {
                if (desc.required < min2) {
                    min2 = desc.required;
                }
                if (desc.rest) {
                    max2 = Integer.MAX_VALUE;
                }
                if (desc.required + desc.optional > max2) {
                    max2 = desc.required + desc.optional;
                }
            }
            notImplemented = notImplemented || desc.anno.notImplemented();
        }
        InvocationMethodFactory.DescriptorInfo info = new InvocationMethodFactory.DescriptorInfo(descs);
        Callable<MethodHandle[]> targetsGenerator = new Callable<MethodHandle[]>(){

            @Override
            public MethodHandle[] call() throws Exception {
                return InvokeDynamicMethodFactory.this.buildAnnotatedMethodHandles(implementationClass.getRuntime(), descs, implementationClass);
            }
        };
        return new HandleMethod(implementationClass, desc1.anno.visibility(), CallConfiguration.getCallConfig(info.isFrame(), info.isScope()), targetsGenerator, min2 == max2 ? Signature.from(min2, 0, 0, 0, 0, Signature.Rest.NONE, false) : Signature.OPTIONAL, true, notImplemented, info.getParameterDesc());
    }

    private MethodHandle[] buildAnnotatedMethodHandles(Ruby runtime, List<JavaMethodDescriptor> descs, RubyModule implementationClass) {
        MethodHandle[] targets = new MethodHandle[5];
        int min2 = Integer.MAX_VALUE;
        int max2 = 0;
        JavaMethodDescriptor desc1 = descs.get(0);
        String rubyName = desc1.anno.name() != null && desc1.anno.name().length > 0 ? desc1.anno.name()[0] : desc1.name;
        for (JavaMethodDescriptor desc : descs) {
            int specificArity = -1;
            if (desc.optional == 0 && !desc.rest) {
                if (desc.required == 0) {
                    if (desc.actualRequired <= 3) {
                        specificArity = desc.actualRequired;
                    }
                } else if (desc.required >= 0 && desc.required <= 3) {
                    specificArity = desc.required;
                }
            }
            if (specificArity != -1) {
                if (specificArity < min2) {
                    min2 = specificArity;
                }
                if (specificArity > max2) {
                    max2 = specificArity;
                }
            } else {
                if (desc.required < min2) {
                    min2 = desc.required;
                }
                if (desc.rest) {
                    max2 = Integer.MAX_VALUE;
                }
                if (desc.required + desc.optional > max2) {
                    max2 = desc.required + desc.optional;
                }
            }
            String javaMethodName = desc.name;
            com.headius.invokebinder.Signature baseSignature = specificArity >= 0 ? SPECIFIC_ARITY_SIGNATURES[specificArity] : VARIABLE_ARITY_SIGNATURE;
            SmartBinder targetBinder = SmartBinder.from(baseSignature);
            targetBinder = targetBinder.exclude("class", "name");
            MethodHandle returnFilter = null;
            boolean castReturn = false;
            if (desc.returnClass != IRubyObject.class) {
                if (desc.returnClass == Void.TYPE) {
                    returnFilter = MethodHandles.constant(IRubyObject.class, runtime.getNil());
                } else {
                    castReturn = true;
                }
            }
            if (desc.isStatic) {
                if (desc.hasContext) {
                    if (!desc.hasBlock) {
                        targetBinder = targetBinder.exclude("block");
                    }
                } else {
                    targetBinder = desc.hasBlock ? targetBinder.exclude("context") : targetBinder.exclude("context", "block");
                }
                if (returnFilter != null) {
                    targetBinder = targetBinder.filterReturn(returnFilter);
                } else if (castReturn) {
                    targetBinder = targetBinder.castReturn(desc.returnClass);
                }
            } else {
                targetBinder = desc.hasContext ? (desc.hasBlock ? targetBinder.permute("self", "context", "arg*", "block") : targetBinder.permute("self", "context", "arg*")) : (desc.hasBlock ? targetBinder.permute("self", "arg*", "block") : targetBinder.permute("self", "arg*"));
                if (returnFilter != null) {
                    targetBinder = targetBinder.filterReturn(returnFilter);
                } else if (castReturn) {
                    targetBinder = targetBinder.castReturn(desc.returnClass);
                }
                targetBinder = targetBinder.castArg("self", desc.getDeclaringClass());
            }
            SmartHandle target = desc.isStatic ? targetBinder.invokeStaticQuiet(LOOKUP, desc.getDeclaringClass(), javaMethodName) : targetBinder.invokeVirtualQuiet(LOOKUP, javaMethodName);
            CallConfiguration callConfig = CallConfiguration.getCallConfigByAnno(desc.anno);
            if (!callConfig.isNoop()) {
                target = SmartHandle.from(target.signature(), InvocationLinker.wrapWithFraming(baseSignature, callConfig, implementationClass, rubyName, target.handle(), null));
            }
            if (specificArity >= 0) {
                targets[specificArity] = target.handle();
                continue;
            }
            targets[4] = target.handle();
        }
        if (targets[4] == null) {
            MethodHandle[] varargsTargets = new MethodHandle[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                if (targets[i2] == null) continue;
                varargsTargets[i2] = i2 == 0 ? MethodHandles.dropArguments(targets[i2], 4, new Class[]{IRubyObject[].class}) : SmartBinder.from(VARIABLE_ARITY_SIGNATURE).permute("context", "self", "class", "name", "block", "args").spread("arg", i2).permute("context", "self", "class", "name", "arg*", "block").invoke(targets[i2]).handle();
            }
            SmartHandle HANDLE_GETTER = SmartBinder.from(com.headius.invokebinder.Signature.returning(MethodHandle.class).appendArg("targets", MethodHandle[].class).appendArg("arity", Integer.TYPE)).arrayGet();
            SmartHandle handleLookup = SmartBinder.from(com.headius.invokebinder.Signature.returning(MethodHandle.class).appendArg("args", IRubyObject[].class)).filterReturn(HANDLE_GETTER.bindTo(varargsTargets)).cast(Integer.TYPE, Object.class).invokeStaticQuiet(LOOKUP, Array.class, "getLength");
            SmartHandle variableCall = SmartBinder.from(VARIABLE_ARITY_SIGNATURE).fold("handle", handleLookup).invoker();
            targets[4] = variableCall.handle();
        }
        targets[4] = SmartBinder.from(VARIABLE_ARITY_SIGNATURE).foldVoid(SmartBinder.from(VARIABLE_ARITY_SIGNATURE.changeReturn(Integer.TYPE)).permute("context", "name", "args").append(Helpers.arrayOf("min", "max"), Helpers.arrayOf(Integer.TYPE, Integer.TYPE), min2, max2).invokeStaticQuiet(LOOKUP, Arity.class, "checkArgumentCount").handle()).invoke(targets[4]).handle();
        if (Options.DEBUG_FULLTRACE.load().booleanValue()) {
            for (int i3 = 0; i3 < targets.length; ++i3) {
                MethodHandle target = targets[i3];
                if (target == null) continue;
                MethodHandle traceCall = Binder.from(target.type().changeReturnType(Void.TYPE)).permute(0, 3, 2).insert(1, new Object[]{RubyEvent.C_CALL}).invokeVirtualQuiet(LOOKUP, "trace");
                MethodHandle traceReturn = Binder.from(target.type().changeReturnType(Void.TYPE)).permute(0, 3, 2).insert(1, new Object[]{RubyEvent.C_RETURN}).invokeVirtualQuiet(LOOKUP, "trace");
                targets[i3] = Binder.from(target.type()).foldVoid(traceCall).tryFinally(traceReturn).invoke(target);
            }
        }
        return targets;
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        return this.getAnnotatedMethod(implementationClass, Arrays.asList(desc));
    }

    static {
        com.headius.invokebinder.Signature[] specifics = new com.headius.invokebinder.Signature[4];
        com.headius.invokebinder.Signature specific = com.headius.invokebinder.Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class).appendArg("class", RubyModule.class).appendArg("name", String.class);
        specifics[0] = specific.appendArg("block", Block.class);
        for (int i2 = 0; i2 < 3; ++i2) {
            specific = specific.appendArg("arg" + i2, IRubyObject.class);
            specifics[i2 + 1] = specific.appendArg("block", Block.class);
        }
        SPECIFIC_ARITY_SIGNATURES = specifics;
        SPREAD_BINDERS = new SmartBinder[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            InvokeDynamicMethodFactory.SPREAD_BINDERS[i3] = SmartBinder.from(VARIABLE_ARITY_SIGNATURE).permute("context", "self", "block", "args").spread("arg", i3).permute("context", "self", "arg*", "block");
        }
    }
}

