/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.digest;

import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.digest.BubbleBabble;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Digest"})
public class RubyDigest {
    private static Provider provider = null;
    private static final Map<String, MessageDigest> CLONEABLE_DIGESTS = new HashMap<String, MessageDigest>();
    private static final byte[] digits;

    public static void createDigest(Ruby runtime) {
        provider = (Provider)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
        RubyModule mDigest = runtime.defineModule("Digest");
        mDigest.defineAnnotatedMethods(RubyDigest.class);
        RubyModule mDigestInstance = mDigest.defineModuleUnder("Instance");
        mDigestInstance.defineAnnotatedMethods(DigestInstance.class);
        RubyClass cDigestClass = mDigest.defineClassUnder("Class", runtime.getObject(), DigestClass.DIGEST_CLASS_ALLOCATOR);
        cDigestClass.defineAnnotatedMethods(DigestClass.class);
        cDigestClass.includeModule(mDigestInstance);
        RubyClass cDigestBase = mDigest.defineClassUnder("Base", cDigestClass, DigestBase.DIGEST_BASE_ALLOCATOR);
        cDigestBase.defineAnnotatedMethods(DigestBase.class);
    }

    private static MessageDigest createMessageDigest(Ruby runtime, String providerName) throws NoSuchAlgorithmException {
        MessageDigest cloneable = CLONEABLE_DIGESTS.get(providerName);
        if (cloneable != null) {
            try {
                return (MessageDigest)cloneable.clone();
            }
            catch (CloneNotSupportedException cnse) {
                // empty catch block
            }
        }
        if (provider != null) {
            try {
                return MessageDigest.getInstance(providerName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(providerName);
    }

    private static ByteList toHex(byte[] val) {
        ByteList byteList = new ByteList(val.length * 2);
        int j = val.length;
        for (int i2 = 0; i2 < j; ++i2) {
            int b2 = val[i2] & 0xFF;
            byteList.append(digits[b2 >> 4]);
            byteList.append(digits[b2 & 0xF]);
        }
        return byteList;
    }

    private static IRubyObject toHexString(Ruby runtime, byte[] val) {
        return RubyString.newStringNoCopy(runtime, new ByteList(ByteList.plain(RubyDigest.toHex(val)), USASCIIEncoding.INSTANCE));
    }

    @JRubyMethod(name={"hexencode"}, required=1, meta=true)
    public static IRubyObject s_hexencode(IRubyObject recv2, IRubyObject arg2) {
        return RubyDigest.toHexString(recv2.getRuntime(), arg2.convertToString().getBytes());
    }

    @JRubyMethod(name={"bubblebabble"}, required=1, meta=true)
    public static IRubyObject bubblebabble(IRubyObject recv2, IRubyObject arg2) {
        ByteList bytes2 = arg2.convertToString().getByteList();
        return RubyString.newString(recv2.getRuntime(), BubbleBabble.bubblebabble(bytes2.unsafeBytes(), bytes2.begin(), bytes2.length()));
    }

    public static void createDigestMD5(Ruby runtime) {
        runtime.getLoadService().require("digest");
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_MD5 = mDigest.defineClassUnder("MD5", cDigestBase, cDigestBase.getAllocator());
        cDigest_MD5.setInternalVariable("metadata", new Metadata("MD5", 64));
    }

    public static void createDigestRMD160(Ruby runtime) {
        runtime.getLoadService().require("digest");
        if (provider == null) {
            throw runtime.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_RMD160 = mDigest.defineClassUnder("RMD160", cDigestBase, cDigestBase.getAllocator());
        cDigest_RMD160.setInternalVariable("metadata", new Metadata("RIPEMD160", 64));
    }

    public static void createDigestSHA1(Ruby runtime) {
        runtime.getLoadService().require("digest");
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_SHA1 = mDigest.defineClassUnder("SHA1", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA1.setInternalVariable("metadata", new Metadata("SHA1", 64));
    }

    public static void createDigestSHA2(Ruby runtime) {
        runtime.getLoadService().require("digest");
        try {
            RubyDigest.createMessageDigest(runtime, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newLoadError("SHA2 not supported");
        }
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_SHA2_256 = mDigest.defineClassUnder("SHA256", cDigestBase, cDigestBase.getAllocator());
        Metadata sha256Metadata = new Metadata("SHA-256", 64);
        cDigest_SHA2_256.setInternalVariable("metadata", sha256Metadata);
        RubyClass cDigest_SHA2_384 = mDigest.defineClassUnder("SHA384", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_384.setInternalVariable("metadata", new Metadata("SHA-384", 128));
        RubyClass cDigest_SHA2_512 = mDigest.defineClassUnder("SHA512", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_512.setInternalVariable("metadata", new Metadata("SHA-512", 128));
    }

    static {
        for (String name2 : new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}) {
            try {
                MessageDigest digest2 = MessageDigest.getInstance(name2);
                digest2.clone();
                CLONEABLE_DIGESTS.put(name2, digest2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    }

    @JRubyClass(name={"Digest::Base"})
    public static class DigestBase
    extends RubyObject {
        protected static final ObjectAllocator DIGEST_BASE_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new DigestBase(runtime, klass);
            }
        };
        private MessageDigest algo;
        private int blockLength = 0;

        public DigestBase(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
            if (type2 == runtime.getModule("Digest").getClass("Base")) {
                throw runtime.newNotImplementedError("Digest::Base is an abstract class");
            }
            Metadata metadata = this.getMetadata(type2);
            if (metadata == null) {
                throw runtime.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(metadata);
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
        }

        private Metadata getMetadata(RubyModule type2) {
            for (RubyModule current2 = type2; current2 != null; current2 = current2.getSuperClass()) {
                Metadata metadata = (Metadata)current2.getInternalVariable("metadata");
                if (metadata == null) continue;
                return metadata;
            }
            return null;
        }

        @Override
        @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
        public IRubyObject initialize_copy(IRubyObject obj) {
            if (this == obj) {
                return this;
            }
            ((RubyObject)obj).checkFrozen();
            String name2 = ((DigestBase)obj).algo.getAlgorithm();
            try {
                this.algo = (MessageDigest)((DigestBase)obj).algo.clone();
            }
            catch (CloneNotSupportedException e) {
                throw this.getRuntime().newTypeError("Could not initialize copy of digest (" + name2 + ")");
            }
            return this;
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public IRubyObject update(IRubyObject obj) {
            ByteList bytes2 = obj.convertToString().getByteList();
            this.algo.update(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
            return this;
        }

        @JRubyMethod
        public IRubyObject finish() {
            RubyString digest2 = RubyString.newStringNoCopy(this.getRuntime(), this.algo.digest());
            this.algo.reset();
            return digest2;
        }

        @JRubyMethod
        public IRubyObject digest_length() {
            return RubyFixnum.newFixnum(this.getRuntime(), this.algo.getDigestLength());
        }

        @JRubyMethod
        public IRubyObject block_length() {
            if (this.blockLength == 0) {
                throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.blockLength);
        }

        @JRubyMethod
        public IRubyObject reset() {
            this.algo.reset();
            return this;
        }

        @JRubyMethod
        public IRubyObject bubblebabble(ThreadContext context) {
            byte[] digest2 = this.algo.digest();
            return RubyString.newString(context.runtime, BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        private void setAlgorithm(Metadata metadata) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(this.getRuntime(), metadata.getName());
            this.blockLength = metadata.getBlockLength();
        }
    }

    @JRubyClass(name={"Digest::Class"})
    public static class DigestClass
    extends RubyObject {
        protected static final ObjectAllocator DIGEST_CLASS_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new DigestClass(runtime, klass);
            }
        };

        public DigestClass(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
        }

        @JRubyMethod(name={"digest"}, required=1, rest=true, meta=true)
        public static IRubyObject s_digest(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            Ruby runtime = recv2.getRuntime();
            if (args2.length < 1) {
                throw runtime.newArgumentError("no data given");
            }
            RubyString str = args2[0].convertToString();
            IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
            System.arraycopy(args2, 1, newArgs, 0, args2.length - 1);
            IRubyObject obj = ((RubyClass)recv2).newInstance(context, newArgs, Block.NULL_BLOCK);
            return obj.callMethod(context, "digest", str);
        }

        @JRubyMethod(name={"hexdigest"}, required=1, optional=1, meta=true)
        public static IRubyObject s_hexdigest(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            Ruby runtime = recv2.getRuntime();
            byte[] digest2 = recv2.callMethod(context, "digest", args2, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyDigest.toHexString(runtime, digest2);
        }
    }

    @JRubyModule(name={"Digest::Instance"})
    public static class DigestInstance {
        private static IRubyObject throwUnimplError(IRubyObject self2, String name2) {
            throw self2.getRuntime().newRuntimeError(String.format("%s does not implement %s()", self2.getMetaClass().getRealClass().getName(), name2));
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public static IRubyObject update(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return DigestInstance.throwUnimplError(self2, "update");
        }

        @JRubyMethod
        public static IRubyObject finish(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(self2, "finish");
        }

        @JRubyMethod
        public static IRubyObject reset(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(self2, "reset");
        }

        @JRubyMethod
        public static IRubyObject digest_length(ThreadContext context, IRubyObject self2) {
            return DigestInstance.digest(context, self2, null).convertToString().bytesize();
        }

        @JRubyMethod
        public static IRubyObject block_length(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(self2, "block_length");
        }

        @JRubyMethod(name={"=="}, required=1)
        public static IRubyObject op_equal(ThreadContext context, IRubyObject self2, IRubyObject oth) {
            RubyString str2;
            RubyString str1;
            if (oth.isNil()) {
                return context.runtime.getFalse();
            }
            RubyModule instance = (RubyModule)context.runtime.getModule("Digest").getConstantAt("Instance");
            if (oth.getMetaClass().getRealClass().hasModuleInHierarchy(instance)) {
                str1 = DigestInstance.digest(context, self2, null).convertToString();
                str2 = DigestInstance.digest(context, oth, null).convertToString();
            } else {
                str1 = DigestInstance.to_s(context, self2).convertToString();
                str2 = oth.convertToString();
            }
            boolean ret = str1.bytesize().eql(str2.bytesize()) && str1.eql(str2);
            return ret ? context.runtime.getTrue() : context.runtime.getFalse();
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            return RubyString.newStringNoCopy(self2.getRuntime(), ByteList.plain("#<" + self2.getMetaClass().getRealClass().getName() + ": " + DigestInstance.hexdigest(context, self2, null) + ">"));
        }

        @JRubyMethod(name={"new"})
        public static IRubyObject newObject(ThreadContext context, IRubyObject self2) {
            return self2.rbClone().callMethod(context, "reset");
        }

        @JRubyMethod(optional=1)
        public static IRubyObject digest(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            IRubyObject value2 = null;
            if (args2 != null && args2.length > 0) {
                self2.callMethod(context, "reset");
                self2.callMethod(context, "update", args2[0]);
                value2 = self2.callMethod(context, "finish");
                self2.callMethod(context, "reset");
            } else {
                IRubyObject clone = self2.rbClone();
                value2 = clone.callMethod(context, "finish");
                clone.callMethod(context, "reset");
            }
            return value2;
        }

        @JRubyMethod(name={"digest!"})
        public static IRubyObject digest_bang(ThreadContext context, IRubyObject self2) {
            IRubyObject value2 = self2.callMethod(context, "finish");
            self2.callMethod(context, "reset");
            return value2;
        }

        @JRubyMethod(optional=1)
        public static IRubyObject hexdigest(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            return RubyDigest.toHexString(context.runtime, DigestInstance.digest(context, self2, args2).convertToString().getBytes());
        }

        @JRubyMethod(name={"hexdigest!"})
        public static IRubyObject hexdigest_bang(ThreadContext context, IRubyObject self2) {
            return RubyDigest.toHexString(context.runtime, DigestInstance.digest_bang(context, self2).convertToString().getBytes());
        }

        @JRubyMethod(name={"bubblebabble"}, required=1, optional=1, meta=true)
        public static IRubyObject bubblebabble(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            byte[] digest2 = recv2.callMethod(context, "digest", args2, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyString.newString(recv2.getRuntime(), BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            return self2.callMethod(context, "hexdigest");
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject length(ThreadContext context, IRubyObject self2) {
            return self2.callMethod(context, "digest_length");
        }
    }

    @JRubyClass(name={"Digest::SHA512"}, parent="Digest::Base")
    public static class SHA512 {
    }

    @JRubyClass(name={"Digest::SHA384"}, parent="Digest::Base")
    public static class SHA384 {
    }

    @JRubyClass(name={"Digest::SHA256"}, parent="Digest::Base")
    public static class SHA256 {
    }

    @JRubyClass(name={"Digest::SHA1"}, parent="Digest::Base")
    public static class SHA1 {
    }

    @JRubyClass(name={"Digest::RMD160"}, parent="Digest::Base")
    public static class RMD160 {
    }

    @JRubyClass(name={"Digest::MD5"}, parent="Digest::Base")
    public static class MD5 {
    }

    private static class Metadata {
        private final String name;
        private final int blockLength;

        Metadata(String name2, int blockLength) {
            this.name = name2;
            this.blockLength = blockLength;
        }

        String getName() {
            return this.name;
        }

        int getBlockLength() {
            return this.blockLength;
        }
    }
}

