/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;

public class IsolatedScriptingContainer
extends ScriptingContainer {
    private static final String JRUBY_HOME = "/META-INF/jruby.home";

    public IsolatedScriptingContainer() {
        this(LocalContextScope.SINGLETON);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public IsolatedScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT);
    }

    public IsolatedScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        super(scope, behavior, lazy);
        this.setLoadPaths(Arrays.asList("uri:classloader:"));
        this.setEnvironment(null);
    }

    @Override
    public void setEnvironment(Map environment) {
        if (!(environment != null && environment.containsKey("GEM_PATH") && environment.containsKey("GEM_HOME") && environment.containsKey("JARS_HOME"))) {
            HashMap<String, String> env;
            HashMap<String, String> hashMap = env = environment == null ? new HashMap<String, String>() : new HashMap(environment);
            if (!env.containsKey("GEM_PATH")) {
                env.put("GEM_PATH", "uri:classloader://");
            }
            if (!env.containsKey("GEM_HOME")) {
                env.put("GEM_HOME", "uri:classloader://");
            }
            if (!env.containsKey("JARS_HOME")) {
                env.put("JARS_HOME", "uri:classloader://jars");
            }
            super.setEnvironment(env);
        } else {
            super.setEnvironment(environment);
        }
    }
}

