/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.methods;

import com.oracle.truffle.api.source.SourceSection;
import org.jruby.ast.Node;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.methods.Arity;

public class SharedMethodInfo {
    private final SourceSection sourceSection;
    private final LexicalScope lexicalScope;
    private final Arity arity;
    private final String name;
    private final boolean isBlock;
    private final Node parseTree;
    private final boolean alwaysSplit;

    public SharedMethodInfo(SourceSection sourceSection, LexicalScope lexicalScope, Arity arity, String name, boolean isBlock, Node parseTree, boolean alwaysSplit) {
        assert (sourceSection != null);
        assert (name != null);
        this.sourceSection = sourceSection;
        this.lexicalScope = lexicalScope;
        this.arity = arity;
        this.name = name;
        this.isBlock = isBlock;
        this.parseTree = parseTree;
        this.alwaysSplit = alwaysSplit;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public Arity getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public Node getParseTree() {
        return this.parseTree;
    }

    public boolean shouldAlwaysSplit() {
        return this.alwaysSplit;
    }

    public SharedMethodInfo withName(String newName) {
        return new SharedMethodInfo(this.sourceSection, this.lexicalScope, this.arity, newName, this.isBlock, this.parseTree, this.alwaysSplit);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isBlock) {
            builder.append("block in ");
        }
        builder.append(this.name);
        builder.append(":");
        builder.append(this.sourceSection.getShortDescription());
        return builder.toString();
    }
}

