/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.methods;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;

public class Arity {
    public static final Arity NO_ARGUMENTS = new Arity(0, 0, false, false, false, 0);
    public static final Arity ONE_REQUIRED = new Arity(1, 0, false, false, false, 0);
    public static final Arity AT_LEAST_ONE = new Arity(1, 0, true, false, false, 0);
    private final int required;
    private final int optional;
    private final boolean allowsMore;
    private final int definedKeywords;
    private final boolean hasKeywords;
    private final boolean hasKeyRest;
    private final List<String> keywordArguments;

    public Arity(int required, int optional, boolean allowsMore, boolean hasKeywords, boolean hasKeyRest, int definedKeywords) {
        this.required = required;
        this.optional = optional;
        this.allowsMore = allowsMore;
        this.definedKeywords = definedKeywords;
        this.hasKeywords = hasKeywords;
        this.hasKeyRest = hasKeyRest;
        this.keywordArguments = null;
    }

    public Arity(int required, int optional, boolean allowsMore, boolean hasKeywords, boolean hasKeyRest, int definedKeywords, ArgsNode argsNode) {
        this.required = required;
        this.optional = optional;
        this.allowsMore = allowsMore;
        this.definedKeywords = definedKeywords;
        this.hasKeywords = hasKeywords;
        this.hasKeyRest = hasKeyRest;
        if (argsNode.hasKwargs()) {
            this.keywordArguments = new ArrayList<String>();
            if (argsNode.getKeywords() != null) {
                for (Node node : argsNode.getKeywords().children()) {
                    KeywordArgNode kwarg = (KeywordArgNode)node;
                    AssignableNode assignableNode = kwarg.getAssignable();
                    if (assignableNode instanceof LocalAsgnNode) {
                        this.keywordArguments.add(((LocalAsgnNode)assignableNode).getName());
                        continue;
                    }
                    if (assignableNode instanceof DAsgnNode) {
                        this.keywordArguments.add(((DAsgnNode)assignableNode).getName());
                        continue;
                    }
                    throw new UnsupportedOperationException("unsupported keyword arg " + node);
                }
            }
        } else {
            this.keywordArguments = null;
        }
    }

    public int getRequired() {
        return this.required;
    }

    public int getOptional() {
        return this.optional;
    }

    public boolean allowsMore() {
        return this.allowsMore;
    }

    public boolean hasKeywords() {
        return this.hasKeywords;
    }

    public int getCountKeywords() {
        return this.definedKeywords;
    }

    public boolean hasKeyRest() {
        return this.hasKeyRest;
    }

    public int getArityNumber() {
        int count = this.required;
        if (this.hasKeywords) {
            ++count;
        }
        if (this.optional > 0 || this.allowsMore) {
            count = -count - 1;
        }
        return count;
    }

    public List<String> getKeywordArguments() {
        return this.keywordArguments;
    }

    public String toString() {
        return "Arity{required=" + this.required + ", optional=" + this.optional + ", allowsMore=" + this.allowsMore + ", definedKeywords=" + this.definedKeywords + ", hasKeywords=" + this.hasKeywords + ", hasKeyRest=" + this.hasKeyRest + '}';
    }
}

