/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class DebugOperations {
    public static String inspect(RubyContext context, Object object) {
        CompilerAsserts.neverPartOfCompilation();
        Object inspected = DebugOperations.send(context, object, "inspect", null, new Object[0]);
        if (inspected == null) {
            return String.format("%s@%x", object.getClass().getSimpleName(), object.hashCode());
        }
        return inspected.toString();
    }

    public static Object send(RubyContext context, Object object, String methodName, RubyBasicObject block, Object ... arguments) {
        CompilerAsserts.neverPartOfCompilation();
        assert (block == null || RubyGuards.isRubyProc(block));
        InternalMethod method = ModuleOperations.lookupMethod(context.getCoreLibrary().getMetaClass(object), methodName);
        if (method == null || method.isUndefined()) {
            return null;
        }
        return method.getCallTarget().call(RubyArguments.pack(method, method.getDeclarationFrame(), object, block, arguments));
    }

    public static void panic(RubyContext context, Node currentNode, String message) {
        CompilerDirectives.transferToInterpreter();
        System.err.println("=========================== JRuby+Truffle Debug Report ========================");
        if (message != null) {
            System.err.println();
            System.err.println("Stopped because: " + message);
        }
        System.err.println();
        System.err.println("    =========================== Ruby Bracktrace ===========================    ");
        System.err.println();
        try {
            for (String line : Backtrace.PANIC_FORMATTER.format(context, null, RubyCallStack.getBacktrace(currentNode))) {
                System.err.println(line);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.err.println();
        System.err.println("    ========================== AST Backtrace ==========================    ");
        System.err.println();
        System.err.println();
        System.err.println("    =========================== Java Backtrace ============================    ");
        System.err.println();
        new Exception().printStackTrace();
        System.err.println();
        System.err.println("===============================================================================");
        System.exit(1);
    }

    public static void printBacktrace(RubyContext context, Node currentNode) {
        for (String line : Backtrace.DISPLAY_FORMATTER.format(context, null, RubyCallStack.getBacktrace(currentNode))) {
            System.err.println(line);
        }
    }

    public static void printASTBacktrace(Node currentNode) {
        if (currentNode != null) {
            DebugOperations.printMethodASTBacktrace(currentNode);
        }
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){

            @Override
            public Object visitFrame(FrameInstance frameInstance) {
                DebugOperations.printMethodASTBacktrace(frameInstance.getCallNode());
                return null;
            }
        });
    }

    private static void printMethodASTBacktrace(Node currentNode) {
        ArrayList<Node> activeNodes = new ArrayList<Node>();
        activeNodes.addAll(NodeUtil.findAllParents(currentNode, Node.class));
        activeNodes.add(currentNode);
        DebugOperations.printASTForBacktrace(currentNode.getRootNode(), activeNodes, 0);
    }

    private static Object executeInNewNode(final RubyNode node) {
        new Node(){
            @Node.Child
            RubyNode child;
            {
                this.child = node;
            }
        }.adoptChildren();
        return node.execute(null);
    }

    public static boolean verySlowIsFrozen(RubyContext context, Object object) {
        return (Boolean)DebugOperations.executeInNewNode(IsFrozenNodeGen.create(context, null, new LiteralNode(context, null, object)));
    }

    private static void printASTForBacktrace(Node node, List<Node> activeNodes, int indentation) {
        for (int n = 0; n < indentation; ++n) {
            System.err.print("  ");
        }
        if (activeNodes.contains(node)) {
            System.err.print("-> ");
        } else {
            System.err.print("   ");
        }
        System.err.println(node);
        for (Node child : node.getChildren()) {
            if (child == null) continue;
            DebugOperations.printASTForBacktrace(child, activeNodes, indentation + 1);
        }
    }
}

