/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.constants.platform.WaitFlags;
import jnr.posix.Passwd;
import jnr.posix.Times;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.defined.DefinedWrapperNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.nodes.objects.ClassNodeGen;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ThrowException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.signal.ProcSignalHandler;
import org.jruby.truffle.runtime.signal.SignalOperations;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.util.io.PosixShim;
import sun.misc.Signal;

public abstract class VMPrimitiveNodes {

    @RubiniusPrimitive(name="vm_set_class", needsSelf=false)
    public static abstract class VMSetClassPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMSetClassPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject setClass(RubyBasicObject object, RubyClass newClass) {
            CompilerDirectives.bailout("We're not sure how vm_set_class (Rubinius::Unsafe.set_class) will interact with compilation");
            object.unsafeChangeLogicalClass(newClass);
            return object;
        }
    }

    @RubiniusPrimitive(name="vm_wait_pid", needsSelf=false)
    public static abstract class VMWaitPidPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMWaitPidPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object waitPID(final int input_pid, boolean no_hang) {
            int options = 0;
            final int[] statusReference = new int[]{0};
            if (no_hang) {
                options |= WaitFlags.WNOHANG.intValue();
            }
            final int finalOptions = options;
            int pid = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return VMWaitPidPrimitiveNode.this.posix().waitpid(input_pid, statusReference, finalOptions);
                }
            });
            int errno = this.posix().errno();
            if (pid == -1) {
                if (errno == Errno.ECHILD.intValue()) {
                    return false;
                }
                if (errno == Errno.EINTR.intValue()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }
            if (no_hang && pid == 0) {
                return this.nil();
            }
            Object output = this.nil();
            Object termsig = this.nil();
            Object stopsig = this.nil();
            int status = statusReference[0];
            if (PosixShim.WAIT_MACROS.WIFEXITED((long)status)) {
                output = PosixShim.WAIT_MACROS.WEXITSTATUS((long)status);
            } else if (PosixShim.WAIT_MACROS.WIFSIGNALED((long)status)) {
                termsig = PosixShim.WAIT_MACROS.WTERMSIG((long)status);
            } else if (PosixShim.WAIT_MACROS.WIFSTOPPED((long)status)) {
                stopsig = PosixShim.WAIT_MACROS.WSTOPSIG((long)status);
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), output, termsig, stopsig, pid);
        }
    }

    @RubiniusPrimitive(name="vm_get_config_section", needsSelf=false)
    public static abstract class VMGetConfigSectionPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMGetConfigSectionPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(section)"})
        public RubyBasicObject getSection(RubyBasicObject section) {
            ArrayList<RubyBasicObject> sectionKeyValues = new ArrayList<RubyBasicObject>();
            for (String key : this.getContext().getRubiniusConfiguration().getSection(section.toString())) {
                Object value = this.getContext().getRubiniusConfiguration().get(key);
                String stringValue = RubyGuards.isRubyBignum(value) ? BignumNodes.getBigIntegerValue((RubyBasicObject)value).toString() : value.toString();
                sectionKeyValues.add(ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), this.createString(key), this.createString(stringValue)));
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), sectionKeyValues.toArray());
        }
    }

    @RubiniusPrimitive(name="vm_get_config_item", needsSelf=false)
    public static abstract class VMGetConfigItemPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMGetConfigItemPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(key)"})
        public Object get(RubyBasicObject key) {
            Object value = this.getContext().getRubiniusConfiguration().get(key.toString());
            if (value == null) {
                return this.nil();
            }
            return value;
        }
    }

    @RubiniusPrimitive(name="vm_watch_signal", needsSelf=false)
    public static abstract class VMWatchSignalPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMWatchSignalPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(signalName)", "isRubyString(action)"})
        public boolean watchSignal(RubyBasicObject signalName, RubyBasicObject action) {
            if (!action.toString().equals("DEFAULT")) {
                throw new UnsupportedOperationException();
            }
            Signal signal = new Signal(signalName.toString());
            SignalOperations.watchDefaultForSignal(signal);
            return true;
        }

        @Specialization(guards={"isRubyString(signalName)", "isNil(nil)"})
        public boolean watchSignal(RubyBasicObject signalName, Object nil) {
            Signal signal = new Signal(signalName.toString());
            SignalOperations.watchSignal(signal, SignalOperations.IGNORE_HANDLER);
            return true;
        }

        @Specialization(guards={"isRubyString(signalName)", "isRubyProc(proc)"})
        public boolean watchSignalProc(RubyBasicObject signalName, RubyBasicObject proc) {
            Signal signal = new Signal(signalName.toString());
            SignalOperations.watchSignal(signal, new ProcSignalHandler(this.getContext(), proc));
            return true;
        }
    }

    @RubiniusPrimitive(name="vm_times", needsSelf=false)
    public static abstract class TimesNode
    extends RubiniusPrimitiveNode {
        public TimesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject times() {
            Times tms = this.posix().times();
            double utime = 0.0;
            double stime = 0.0;
            double cutime = 0.0;
            double cstime = 0.0;
            if (tms == null) {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                if (bean.isCurrentThreadCpuTimeSupported()) {
                    cutime = utime = (double)bean.getCurrentThreadUserTime();
                    cstime = stime = (double)(bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime());
                }
            } else {
                utime = tms.utime();
                stime = tms.stime();
                cutime = tms.cutime();
                cstime = tms.cstime();
            }
            long hz = this.posix().sysconf(Sysconf._SC_CLK_TCK);
            if (hz == -1L) {
                hz = 60L;
            }
            double tutime = 0.0;
            double tstime = 0.0;
            return this.createArray(new double[]{utime /= (double)hz, stime /= (double)hz, cutime /= (double)hz, cstime /= (double)hz, 0.0, 0.0}, 6);
        }
    }

    @RubiniusPrimitive(name="vm_time", needsSelf=false)
    public static abstract class TimeNode
    extends RubiniusPrimitiveNode {
        public TimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long time() {
            return System.currentTimeMillis() / 1000L;
        }
    }

    @RubiniusPrimitive(name="vm_throw", needsSelf=false)
    public static abstract class ThrowNode
    extends RubiniusPrimitiveNode {
        public ThrowNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object doThrow(Object tag, Object value) {
            throw new ThrowException(tag, value);
        }
    }

    @RubiniusPrimitive(name="vm_singleton_class_object", needsSelf=false)
    public static abstract class VMObjectSingletonClassObjectPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMObjectSingletonClassObjectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object vmSingletonClassObject(Object object) {
            return object instanceof RubyClass && ((RubyClass)object).isSingleton();
        }
    }

    @RubiniusPrimitive(name="vm_set_module_name", needsSelf=false)
    public static abstract class VMSetModuleNamePrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMSetModuleNamePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object vmSetModuleName(Object object) {
            throw new UnsupportedOperationException("vm_set_module_name");
        }
    }

    @RubiniusPrimitive(name="vm_raise_exception", needsSelf=false)
    public static abstract class VMRaiseExceptionPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMRaiseExceptionPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject vmRaiseException(RubyException exception) {
            throw new RaiseException(exception);
        }
    }

    @RubiniusPrimitive(name="vm_object_singleton_class", needsSelf=false)
    public static abstract class VMObjectSingletonClassPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private KernelNodes.SingletonClassMethodNode singletonClassNode;

        public VMObjectSingletonClassPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = KernelNodesFactory.SingletonClassMethodNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        @Specialization
        public Object vmObjectClass(VirtualFrame frame, Object object) {
            return this.singletonClassNode.singletonClass(frame, object);
        }
    }

    @RubiniusPrimitive(name="vm_object_respond_to", needsSelf=false)
    public static abstract class VMObjectRespondToPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;

        public VMObjectRespondToPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.respondToNode = KernelNodesFactory.RespondToNodeFactory.create(context, sourceSection, null, null, null);
        }

        @Specialization
        public boolean vmObjectRespondTo(VirtualFrame frame, Object object, Object name, boolean includePrivate) {
            return this.respondToNode.executeDoesRespondTo(frame, object, name, includePrivate);
        }
    }

    @RubiniusPrimitive(name="vm_object_kind_of", needsSelf=false)
    public static abstract class VMObjectKindOfPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private KernelNodes.IsANode isANode;

        public VMObjectKindOfPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization
        public boolean vmObjectKindOf(VirtualFrame frame, Object object, RubyModule rubyClass) {
            return this.isANode.executeIsA(frame, object, rubyClass);
        }
    }

    @RubiniusPrimitive(name="vm_object_equal", needsSelf=false)
    public static abstract class VMObjectEqualPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        BasicObjectNodes.ReferenceEqualNode referenceEqualNode;

        public VMObjectEqualPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.referenceEqualNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
        }

        @Specialization
        public boolean vmObjectEqual(VirtualFrame frame, Object a, Object b) {
            return this.referenceEqualNode.executeReferenceEqual(frame, a, b);
        }
    }

    @RubiniusPrimitive(name="vm_object_class", needsSelf=false)
    public static abstract class VMObjectClassPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ClassNode classNode;

        public VMObjectClassPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyClass vmObjectClass(VirtualFrame frame, Object object) {
            return this.classNode.executeGetClass(frame, object);
        }
    }

    @RubiniusPrimitive(name="vm_get_user_home", needsSelf=false)
    public static abstract class VMGetUserHomePrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMGetUserHomePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(username)"})
        public RubyBasicObject vmGetUserHome(RubyBasicObject username) {
            CompilerDirectives.transferToInterpreter();
            Passwd passwd = this.getContext().getPosix().getpwnam(username.toString());
            if (passwd == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("user " + username.toString() + " does not exist", this));
            }
            return this.createString(passwd.getHome());
        }
    }

    @RubiniusPrimitive(name="vm_get_module_name", needsSelf=false)
    public static abstract class VMGetModuleNamePrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMGetModuleNamePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject vmGetModuleName(RubyModule module) {
            return this.createString(module.getName());
        }
    }

    @RubiniusPrimitive(name="vm_gc_start", needsSelf=false)
    public static abstract class VMGCStartPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMGCStartPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyBasicObject vmGCStart() {
            RubyThread runningThread = this.getContext().getThreadManager().leaveGlobalLock();
            try {
                System.gc();
            }
            finally {
                this.getContext().getThreadManager().enterGlobalLock(runningThread);
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="vm_catch", needsSelf=false)
    public static abstract class CatchNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private YieldDispatchHeadNode dispatchNode;
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;
        @Node.Child
        private WriteInstanceVariableNode clearExceptionVariableNode;

        public CatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = new YieldDispatchHeadNode(context);
        }

        private boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object doCatch(VirtualFrame frame, Object tag, RubyBasicObject block) {
            CompilerDirectives.transferToInterpreter();
            try {
                return this.dispatchNode.dispatch(frame, block, tag);
            }
            catch (ThrowException e) {
                if (this.areSame(frame, e.getTag(), tag)) {
                    if (this.clearExceptionVariableNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        RubyContext context = this.getContext();
                        SourceSection sourceSection = this.getSourceSection();
                        this.clearExceptionVariableNode = this.insert(new WriteInstanceVariableNode(this.getContext(), this.getSourceSection(), "$!", new LiteralNode(this.getContext(), this.getSourceSection(), this.getContext().getThreadManager().getCurrentThread().getThreadLocals()), new DefinedWrapperNode(context, sourceSection, new LiteralNode(context, sourceSection, context.getCoreLibrary().getNilObject()), "nil"), true));
                    }
                    this.clearExceptionVariableNode.execute(frame);
                    return e.getValue();
                }
                throw e;
            }
        }
    }
}

