/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public abstract class EncodingPrimitiveNodes {

    @RubiniusPrimitive(name="encoding_get_object_encoding", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingNode
    extends RubiniusPrimitiveNode {
        public EncodingGetObjectEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public RubyBasicObject encodingGetObjectEncodingString(RubyBasicObject string) {
            return EncodingNodes.getEncoding(StringNodes.getByteList(string).getEncoding());
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public RubyBasicObject encodingGetObjectEncodingSymbol(RubyBasicObject symbol) {
            return EncodingNodes.getEncoding(SymbolNodes.getByteList(symbol).getEncoding());
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public RubyBasicObject encodingGetObjectEncoding(RubyBasicObject encoding) {
            return encoding;
        }

        @Specialization(guards={"!isRubyString(object)", "!isRubySymbol(object)", "!isRubyEncoding(object)"})
        public RubyBasicObject encodingGetObjectEncodingNil(RubyBasicObject object) {
            return this.nil();
        }
    }
}

