/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.DefineOrGetModuleNode;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;

public class DefineOrGetClassNode
extends DefineOrGetModuleNode {
    @Node.Child
    private RubyNode superClass;
    @Node.Child
    private CallDispatchHeadNode inheritedNode;

    public DefineOrGetClassNode(RubyContext context, SourceSection sourceSection, String name, RubyNode lexicalParent, RubyNode superClass) {
        super(context, sourceSection, name, lexicalParent);
        this.superClass = superClass;
    }

    private void callInherited(VirtualFrame frame, RubyClass superClass, RubyClass subClass) {
        if (this.inheritedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.inheritedNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
        }
        this.inheritedNode.call(frame, superClass, "inherited", null, subClass);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyClass definingClass;
        CompilerDirectives.transferToInterpreter();
        RubyContext context = this.getContext();
        RubyModule lexicalParent = this.getLexicalParentModule(frame);
        RubyConstant constant = this.lookupForExistingModule(lexicalParent);
        RubyClass superClassObject = this.getRubySuperClass(frame, context);
        if (constant == null) {
            definingClass = new RubyClass(context, lexicalParent, superClassObject, this.name, superClassObject.getAllocator());
            this.callInherited(frame, superClassObject, definingClass);
        } else if (constant.getValue() instanceof RubyClass) {
            definingClass = (RubyClass)constant.getValue();
            this.checkSuperClassCompatibility(context, superClassObject, definingClass);
        } else {
            throw new RaiseException(context.getCoreLibrary().typeErrorIsNotA(constant.getValue().toString(), "class", this));
        }
        return definingClass;
    }

    private RubyClass getRubySuperClass(VirtualFrame frame, RubyContext context) {
        Object superClassObj = this.superClass.execute(frame);
        if (superClassObj instanceof RubyClass) {
            if (((RubyClass)superClassObj).isSingleton()) {
                throw new RaiseException(context.getCoreLibrary().typeError("can't make subclass of virtual class", this));
            }
            return (RubyClass)superClassObj;
        }
        throw new RaiseException(context.getCoreLibrary().typeError("superclass must be a Class", this));
    }

    private boolean isBlankOrRootClass(RubyClass rubyClass) {
        return rubyClass == this.getContext().getCoreLibrary().getBasicObjectClass() || rubyClass == this.getContext().getCoreLibrary().getObjectClass();
    }

    private void checkSuperClassCompatibility(RubyContext context, RubyClass superClassObject, RubyClass definingClass) {
        if (!this.isBlankOrRootClass(superClassObject) && !this.isBlankOrRootClass(definingClass) && definingClass.getSuperClass() != superClassObject) {
            throw new RaiseException(context.getCoreLibrary().typeError("superclass mismatch for class " + definingClass.getName(), this));
        }
    }
}

