/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.locals;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.locals.ReadDeclarationVariableNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.WriteNode;

public class WriteDeclarationVariableNode
extends RubyNode
implements WriteNode {
    @Node.Child
    private RubyNode valueNode;
    @Node.Child
    private WriteFrameSlotNode writeFrameSlotNode;
    private final int frameDepth;

    public WriteDeclarationVariableNode(RubyContext context, SourceSection sourceSection, RubyNode valueNode, int frameDepth, FrameSlot frameSlot) {
        super(context, sourceSection);
        this.valueNode = valueNode;
        this.writeFrameSlotNode = WriteFrameSlotNodeGen.create(frameSlot);
        this.frameDepth = frameDepth;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame(frame, this.frameDepth);
        return this.writeFrameSlotNode.executeWrite(declarationFrame, this.valueNode.execute(frame));
    }

    @Override
    public RubyNode makeReadNode() {
        return new ReadDeclarationVariableNode(this.getContext(), this.getSourceSection(), this.frameDepth, this.writeFrameSlotNode.getFrameSlot());
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.createString("assignment");
    }
}

