/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import org.jruby.ext.digest.BubbleBabble;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.ByteList;

@CoreClass(name="Truffle::Digest")
public abstract class DigestNodes {
    private static final HiddenKey DIGEST_IDENTIFIER = new HiddenKey("digest");
    private static final Property DIGEST_PROPERTY;
    private static final DynamicObjectFactory DIGEST_FACTORY;

    private static RubyBasicObject createDigest(RubyContext context, Algorithm algorithm) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm.getName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return new RubyBasicObject(context.getCoreLibrary().getObjectClass(), DIGEST_FACTORY.newInstance(digest));
    }

    public static MessageDigest getDigest(RubyBasicObject digest) {
        assert (digest.getDynamicObject().getShape().hasProperty(DIGEST_IDENTIFIER));
        return (MessageDigest)DIGEST_PROPERTY.get(digest.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        DIGEST_PROPERTY = Property.create(DIGEST_IDENTIFIER, allocator.locationForType(MessageDigest.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
        DIGEST_FACTORY = RubyBasicObject.EMPTY_SHAPE.addProperty(DIGEST_PROPERTY).createFactory();
    }

    @CoreMethod(names={"bubblebabble"}, isModuleFunction=true, required=1)
    public static abstract class BubbleBabbleNode
    extends CoreMethodArrayArgumentsNode {
        public BubbleBabbleNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public RubyBasicObject bubblebabble(RubyBasicObject message) {
            ByteList byteList = StringNodes.getByteList(message);
            return this.createString(BubbleBabble.bubblebabble((byte[])byteList.unsafeBytes(), (int)byteList.begin(), (int)byteList.length()));
        }
    }

    @CoreMethod(names={"digest_length"}, isModuleFunction=true, required=1)
    public static abstract class DigestLengthNode
    extends CoreMethodArrayArgumentsNode {
        public DigestLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int digestLength(RubyBasicObject digestObject) {
            return DigestNodes.getDigest(digestObject).getDigestLength();
        }
    }

    @CoreMethod(names={"digest"}, isModuleFunction=true, required=1)
    public static abstract class DigestNode
    extends CoreMethodArrayArgumentsNode {
        public DigestNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject digest(RubyBasicObject digestObject) {
            MessageDigest clonedDigest;
            MessageDigest digest = DigestNodes.getDigest(digestObject);
            try {
                clonedDigest = (MessageDigest)digest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            return this.createString(clonedDigest.digest());
        }
    }

    @CoreMethod(names={"reset"}, isModuleFunction=true, required=1)
    public static abstract class ResetNode
    extends CoreMethodArrayArgumentsNode {
        public ResetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject reset(RubyBasicObject digestObject) {
            DigestNodes.getDigest(digestObject).reset();
            return digestObject;
        }
    }

    @CoreMethod(names={"update"}, isModuleFunction=true, required=2)
    public static abstract class UpdateNode
    extends CoreMethodArrayArgumentsNode {
        public UpdateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public RubyBasicObject update(RubyBasicObject digestObject, RubyBasicObject message) {
            ByteList bytes = StringNodes.getByteList(message);
            DigestNodes.getDigest(digestObject).update(bytes.getUnsafeBytes(), bytes.begin(), bytes.length());
            return digestObject;
        }
    }

    @CoreMethod(names={"sha512"}, isModuleFunction=true)
    public static abstract class SHA512Node
    extends CoreMethodArrayArgumentsNode {
        public SHA512Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject sha512() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA512);
        }
    }

    @CoreMethod(names={"sha384"}, isModuleFunction=true)
    public static abstract class SHA384Node
    extends CoreMethodArrayArgumentsNode {
        public SHA384Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject sha384() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA384);
        }
    }

    @CoreMethod(names={"sha256"}, isModuleFunction=true)
    public static abstract class SHA256Node
    extends CoreMethodArrayArgumentsNode {
        public SHA256Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject sha256() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA256);
        }
    }

    @CoreMethod(names={"sha1"}, isModuleFunction=true)
    public static abstract class SHA1Node
    extends CoreMethodArrayArgumentsNode {
        public SHA1Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject sha1() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA1);
        }
    }

    @CoreMethod(names={"md5"}, isModuleFunction=true)
    public static abstract class MD5Node
    extends CoreMethodArrayArgumentsNode {
        public MD5Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject md5() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.MD5);
        }
    }

    private static enum Algorithm {
        MD5("MD5"),
        SHA1("SHA1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String name;

        private Algorithm(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

