/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.EnumSet;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.cast.IntegerCastNode;
import org.jruby.truffle.nodes.cast.IntegerCastNodeGen;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.constants.GetConstantNode;
import org.jruby.truffle.nodes.constants.GetConstantNodeGen;
import org.jruby.truffle.nodes.constants.LookupConstantNodeGen;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.ext.BigDecimalNodesFactory;
import org.jruby.truffle.nodes.internal.UnreachableCodeBranch;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.object.BasicObjectType;

@CoreClass(name="Truffle::BigDecimal")
public abstract class BigDecimalNodes {
    public static final BigDecimalType BIG_DECIMAL_TYPE = new BigDecimalType();
    public static final Property VALUE_PROPERTY;
    public static final Property TYPE_PROPERTY;
    private static final HiddenKey VALUE_IDENTIFIER;
    private static final HiddenKey TYPE_IDENTIFIER;
    private static final DynamicObjectFactory BIG_DECIMAL_FACTORY;

    public static BigDecimal getBigDecimalValue(long v) {
        return BigDecimal.valueOf(v);
    }

    public static BigDecimal getBigDecimalValue(double v) {
        return BigDecimal.valueOf(v);
    }

    public static BigDecimal getBignumBigDecimalValue(RubyBasicObject v) {
        return new BigDecimal(BignumNodes.getBigIntegerValue(v));
    }

    public static BigDecimal getBigDecimalValue(RubyBasicObject bigdecimal) {
        assert (RubyGuards.isRubyBigDecimal(bigdecimal));
        assert (bigdecimal.getDynamicObject().getShape().hasProperty(VALUE_IDENTIFIER));
        return (BigDecimal)VALUE_PROPERTY.get(bigdecimal.getDynamicObject(), true);
    }

    public static Type getBigDecimalType(RubyBasicObject bigdecimal) {
        assert (RubyGuards.isRubyBigDecimal(bigdecimal));
        assert (bigdecimal.getDynamicObject().getShape().hasProperty(TYPE_IDENTIFIER));
        return (Type)((Object)TYPE_PROPERTY.get(bigdecimal.getDynamicObject(), true));
    }

    public static RoundingMode toRoundingMode(int constValue) {
        switch (constValue) {
            case 1: {
                return RoundingMode.UP;
            }
            case 2: {
                return RoundingMode.DOWN;
            }
            case 3: {
                return RoundingMode.HALF_UP;
            }
            case 4: {
                return RoundingMode.HALF_DOWN;
            }
            case 5: {
                return RoundingMode.CEILING;
            }
            case 6: {
                return RoundingMode.FLOOR;
            }
            case 7: {
                return RoundingMode.HALF_EVEN;
            }
        }
        throw new UnreachableCodeBranch();
    }

    private static int nearestBiggerMultipleOf4(int value) {
        return (value / 4 + 1) * 4;
    }

    public static int defaultDivisionPrecision(int precisionA, int precisionB, int limit) {
        int combination = BigDecimalNodes.nearestBiggerMultipleOf4(precisionA + precisionB) * 4;
        return limit > 0 && limit < combination ? limit : combination;
    }

    public static int defaultDivisionPrecision(BigDecimal a, BigDecimal b, int limit) {
        return BigDecimalNodes.defaultDivisionPrecision(a.precision(), b.precision(), limit);
    }

    static {
        VALUE_IDENTIFIER = new HiddenKey("value");
        TYPE_IDENTIFIER = new HiddenKey("type");
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        VALUE_PROPERTY = Property.create(VALUE_IDENTIFIER, allocator.locationForType(BigDecimal.class, EnumSet.of(LocationModifier.NonNull)), 0);
        TYPE_PROPERTY = Property.create(TYPE_IDENTIFIER, allocator.locationForType(Type.class, EnumSet.of(LocationModifier.NonNull)), 0);
        BIG_DECIMAL_FACTORY = RubyBasicObject.LAYOUT.createShape(BIG_DECIMAL_TYPE).addProperty(TYPE_PROPERTY).addProperty(VALUE_PROPERTY).createFactory();
    }

    @NodeChildren(value={@NodeChild(value="value", type=RubyNode.class), @NodeChild(value="cast", type=BigDecimalCastNode.class, executeWith={"value"})})
    public static abstract class BigDecimalCoerceNode
    extends RubyNode {
        @Node.Child
        private CreateBigDecimalNode createBigDecimal;

        public BigDecimalCoerceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public static BigDecimalCoerceNode create(RubyContext context, SourceSection sourceSection, RubyNode value) {
            return BigDecimalNodesFactory.BigDecimalCoerceNodeGen.create(context, sourceSection, value, BigDecimalNodesFactory.BigDecimalCastNodeGen.create(context, sourceSection, null));
        }

        private void setupCreateBigDecimal() {
            if (this.createBigDecimal == null) {
                CompilerDirectives.transferToInterpreter();
                this.createBigDecimal = this.insert(BigDecimalNodesFactory.CreateBigDecimalNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
        }

        protected RubyBasicObject createBigDecimal(VirtualFrame frame, Object value) {
            this.setupCreateBigDecimal();
            return this.createBigDecimal.executeCreate(frame, value);
        }

        public abstract RubyBasicObject executeBigDecimal(VirtualFrame var1, Object var2);

        @Specialization
        public Object doBigDecimal(VirtualFrame frame, Object value, BigDecimal cast) {
            return this.createBigDecimal(frame, cast);
        }

        @Specialization(guards={"isRubyBigDecimal(value)", "isNil(cast)"})
        public Object doBigDecimal(RubyBasicObject value, RubyBasicObject cast) {
            return value;
        }
    }

    @ImportStatic(value={BigDecimalCoreMethodNode.class})
    @NodeChild(value="value", type=RubyNode.class)
    public static abstract class BigDecimalCastNode
    extends RubyNode {
        public BigDecimalCastNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract BigDecimal executeBigDecimal(VirtualFrame var1, Object var2);

        public abstract Object executeObject(VirtualFrame var1, Object var2);

        @Specialization
        public BigDecimal doInt(long value) {
            return BigDecimal.valueOf(value);
        }

        @Specialization
        public BigDecimal doDouble(double value) {
            return BigDecimal.valueOf(value);
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public BigDecimal doBignum(RubyBasicObject value) {
            return new BigDecimal(BignumNodes.getBigIntegerValue(value));
        }

        @Specialization(guards={"isNormalRubyBigDecimal(value)"})
        public BigDecimal doBigDecimal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value);
        }

        @Fallback
        public Object doBigDecimalFallback(Object value) {
            return this.nil();
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object toINormal(RubyBasicObject value) {
            return this.fixnumOrBignum.fixnumOrBignum(BigDecimalNodes.getBigDecimalValue(value).toBigInteger());
        }

        @Specialization(guards={"!isNormal(value)"})
        public int toISpecial(RubyBasicObject value) {
            Type type = BigDecimalNodes.getBigDecimalType(value);
            switch (type) {
                case NEGATIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError(type.getRepresentation(), this));
                }
                case POSITIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError(type.getRepresentation(), this));
                }
                case NAN: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError(type.getRepresentation(), this));
                }
                case NEGATIVE_ZERO: {
                    return 0;
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"unscaled"}, visibility=Visibility.PRIVATE)
    public static abstract class UnscaledNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public UnscaledNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object unscaled(RubyBasicObject value) {
            return this.createString(BigDecimalNodes.getBigDecimalValue(value).abs().stripTrailingZeros().unscaledValue().toString());
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object unscaledSpecial(RubyBasicObject value) {
            String type = BigDecimalNodes.getBigDecimalType(value).getRepresentation();
            return this.createString(type.startsWith("-") ? type.substring(1) : type);
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public double toFNormal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).doubleValue();
        }

        @Specialization(guards={"!isNormal(value)"})
        public double toFSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_INFINITY: {
                    return Double.NEGATIVE_INFINITY;
                }
                case POSITIVE_INFINITY: {
                    return Double.POSITIVE_INFINITY;
                }
                case NEGATIVE_ZERO: {
                    return 0.0;
                }
                case NAN: {
                    return Double.NaN;
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"precs"})
    public static abstract class PrecsNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public PrecsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object precsNormal(RubyBasicObject value) {
            BigDecimal bigDecimalValue = BigDecimalNodes.getBigDecimalValue(value).abs();
            return this.createArray(new int[]{bigDecimalValue.stripTrailingZeros().unscaledValue().toString().length(), BigDecimalNodes.nearestBiggerMultipleOf4(bigDecimalValue.unscaledValue().toString().length())}, 2);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object precsSpecial(RubyBasicObject value) {
            return this.createArray(new int[]{1, 1}, 2);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public InfiniteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public Object infiniteNormal(RubyBasicObject value) {
            return this.nil();
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object infiniteSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case POSITIVE_INFINITY: {
                    return 1;
                }
                case NEGATIVE_INFINITY: {
                    return -1;
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"finite?"})
    public static abstract class FiniteNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public FiniteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public boolean finiteNormal(RubyBasicObject value) {
            return true;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean finiteSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case POSITIVE_INFINITY: 
                case NEGATIVE_INFINITY: 
                case NAN: {
                    return false;
                }
            }
            return true;
        }
    }

    @CoreMethod(names={"round"}, optional=2)
    public static abstract class RoundNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public RoundNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal round(RubyBasicObject value, int digit, RoundingMode roundingMode) {
            BigDecimal valueBigDecimal = BigDecimalNodes.getBigDecimalValue(value);
            if (digit <= valueBigDecimal.scale()) {
                return valueBigDecimal.movePointRight(digit).setScale(0, roundingMode).movePointLeft(digit);
            }
            return valueBigDecimal;
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, RubyBasicObject value, NotProvided digit, NotProvided roundingMode) {
            return this.createBigDecimal(frame, this.round(value, 0, this.getRoundMode(frame)));
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, RubyBasicObject value, int digit, NotProvided roundingMode) {
            return this.createBigDecimal(frame, this.round(value, digit, this.getRoundMode(frame)));
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, RubyBasicObject value, int digit, int roundingMode) {
            return this.createBigDecimal(frame, this.round(value, digit, BigDecimalNodes.toRoundingMode(roundingMode)));
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object roundSpecial(VirtualFrame frame, RubyBasicObject value, Object unusedPrecision, Object unusedRoundingMode) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Computation results to '-Infinity'", this));
                }
                case POSITIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Computation results to 'Infinity'", this));
                }
                case NEGATIVE_ZERO: {
                    return value;
                }
                case NAN: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"abs"})
    public static abstract class AbsNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal abs(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).abs();
        }

        @Specialization(guards={"isNormal(value)"})
        public Object abs(VirtualFrame frame, RubyBasicObject value) {
            return this.createBigDecimal(frame, this.abs(value));
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object absSpecial(VirtualFrame frame, RubyBasicObject value) {
            Type type = BigDecimalNodes.getBigDecimalType(value);
            switch (type) {
                case NEGATIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, BigDecimal.ZERO);
                }
                case POSITIVE_INFINITY: 
                case NAN: {
                    return this.createBigDecimal(frame, (Object)type);
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"exponent"})
    public static abstract class ExponentNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public ExponentNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public long exponent(RubyBasicObject value) {
            BigDecimal val = BigDecimalNodes.getBigDecimalValue(value).abs().stripTrailingZeros();
            return val.precision() - val.scale();
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int exponentZero(RubyBasicObject value) {
            return 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public int exponentSpecial(RubyBasicObject value) {
            return 0;
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NanNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public NanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public boolean nanNormal(RubyBasicObject value) {
            return false;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean nanSpecial(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalType(value) == Type.NAN;
        }
    }

    @CoreMethod(names={"sign"})
    public static abstract class SignNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        private final ConditionProfile positive = ConditionProfile.createBinaryProfile();
        @Node.Child
        private GetIntegerConstantNode sign;

        public SignNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sign = BigDecimalNodesFactory.GetIntegerConstantNodeGen.create(context, sourceSection, new LiteralNode(context, sourceSection, this.getBigDecimalClass()));
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int signNormalZero(VirtualFrame frame, RubyBasicObject value) {
            return this.sign.executeGetIntegerConstant(frame, "SIGN_POSITIVE_ZERO");
        }

        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public int signNormal(VirtualFrame frame, RubyBasicObject value) {
            if (this.positive.profile(BigDecimalNodes.getBigDecimalValue(value).signum() > 0)) {
                return this.sign.executeGetIntegerConstant(frame, "SIGN_POSITIVE_FINITE");
            }
            return this.sign.executeGetIntegerConstant(frame, "SIGN_NEGATIVE_FINITE");
        }

        @Specialization(guards={"!isNormal(value)"})
        public int signSpecial(VirtualFrame frame, RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_INFINITY: {
                    return this.sign.executeGetIntegerConstant(frame, "SIGN_NEGATIVE_INFINITE");
                }
                case POSITIVE_INFINITY: {
                    return this.sign.executeGetIntegerConstant(frame, "SIGN_POSITIVE_INFINITE");
                }
                case NEGATIVE_ZERO: {
                    return this.sign.executeGetIntegerConstant(frame, "SIGN_NEGATIVE_ZERO");
                }
                case NAN: {
                    return this.sign.executeGetIntegerConstant(frame, "SIGN_NaN");
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @NodeChildren(value={@NodeChild(value="name", type=RubyNode.class), @NodeChild(value="module", type=RubyNode.class), @NodeChild(value="getConst", type=GetConstantNode.class, executeWith={"module", "name"}), @NodeChild(value="coerce", type=ToIntNode.class, executeWith={"getConst"}), @NodeChild(value="cast", type=IntegerCastNode.class, executeWith={"coerce"})})
    public static abstract class GetIntegerConstantNode
    extends RubyNode {
        public GetIntegerConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public static GetIntegerConstantNode create(RubyContext context, SourceSection sourceSection) {
            return GetIntegerConstantNode.create(context, sourceSection, null);
        }

        public static GetIntegerConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode module) {
            return BigDecimalNodesFactory.GetIntegerConstantNodeGen.create(context, sourceSection, null, module, GetConstantNodeGen.create(context, sourceSection, null, null, LookupConstantNodeGen.create(context, sourceSection, LexicalScope.NONE, null, null)), ToIntNodeGen.create(context, sourceSection, null), IntegerCastNodeGen.create(context, sourceSection, null));
        }

        public abstract IntegerCastNode getCast();

        public abstract int executeGetIntegerConstant(VirtualFrame var1, String var2, RubyModule var3);

        public abstract int executeGetIntegerConstant(VirtualFrame var1, String var2);

        @Specialization
        public int doInteger(String name, RubyModule module, Object constValue, Object coercedConstValue, int castedValue) {
            return castedValue;
        }
    }

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public ZeroNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)"})
        public boolean zeroNormal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).compareTo(BigDecimal.ZERO) == 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean zeroSpecial(RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case NEGATIVE_ZERO: {
                    return true;
                }
            }
            return false;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private int compareBigDecimal(RubyBasicObject a, BigDecimal b) {
            return BigDecimalNodes.getBigDecimalValue(a).compareTo(b);
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(RubyBasicObject a, long b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(RubyBasicObject a, double b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public int compare(RubyBasicObject a, RubyBasicObject b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public int compareNormal(RubyBasicObject a, RubyBasicObject b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(VirtualFrame frame, RubyBasicObject a, long b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(VirtualFrame frame, RubyBasicObject a, double b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object compareSpecialBignum(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimalNodes.getBignumBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isNan(a)"})
        public Object compareSpecialNan(RubyBasicObject a, RubyBasicObject b) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)", "isNormal(a) || !isNan(a)"})
        public Object compareSpecial(RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.nil();
            }
            if (aType == bType) {
                return 0;
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return 1;
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return -1;
            }
            BigDecimal aCompare = aType == Type.NEGATIVE_ZERO ? BigDecimal.ZERO : BigDecimalNodes.getBigDecimalValue(a);
            BigDecimal bCompare = bType == Type.NEGATIVE_ZERO ? BigDecimal.ZERO : BigDecimalNodes.getBigDecimalValue(b);
            return aCompare.compareTo(bCompare);
        }

        @Specialization(guards={"isNil(b)"})
        public Object compareNil(RubyBasicObject a, RubyBasicObject b) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyBigDecimal(b)", "!isNil(b)"})
        public Object compareCoerced(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :<=>, b", "b", b);
        }
    }

    @CoreMethod(names={"sqrt"}, required=1)
    @NodeChildren(value={@NodeChild(value="self", type=RubyNode.class), @NodeChild(value="precision", type=RubyNode.class)})
    public static abstract class SqrtNode
    extends BigDecimalCoreMethodNode {
        private final ConditionProfile positiveValueProfile = ConditionProfile.createBinaryProfile();

        public SqrtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeSqrt(VirtualFrame var1, RubyBasicObject var2, int var3);

        @CompilerDirectives.TruffleBoundary
        private BigDecimal sqrt(BigDecimal value, MathContext mathContext) {
            return RubyBigDecimal.bigSqrt((BigDecimal)value, (MathContext)mathContext);
        }

        @Specialization(guards={"precision < 0"})
        public Object sqrtNegativePrecision(VirtualFrame frame, RubyBasicObject a, int precision) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("precision must be positive", this));
        }

        @Specialization(guards={"precision == 0"})
        public Object sqrtZeroPrecision(VirtualFrame frame, RubyBasicObject a, int precision) {
            return this.executeSqrt(frame, a, 1);
        }

        @Specialization(guards={"isNormal(a)", "precision > 0"})
        public Object sqrt(VirtualFrame frame, RubyBasicObject a, int precision) {
            BigDecimal valueBigDecimal = BigDecimalNodes.getBigDecimalValue(a);
            if (this.positiveValueProfile.profile(valueBigDecimal.signum() >= 0)) {
                return this.createBigDecimal(frame, this.sqrt(valueBigDecimal, new MathContext(precision, this.getRoundMode(frame))));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("(VpSqrt) SQRT(negative value)", this));
        }

        @Specialization(guards={"!isNormal(a)", "precision > 0"})
        public Object sqrtSpecial(VirtualFrame frame, RubyBasicObject a, int precision) {
            switch (BigDecimalNodes.getBigDecimalType(a)) {
                case NAN: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("(VpSqrt) SQRT(NaN value)", this));
                }
                case POSITIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("(VpSqrt) SQRT(negative value)", this));
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, this.sqrt(BigDecimal.ZERO, new MathContext(precision, this.getRoundMode(frame))));
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"**", "power"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(value="self", type=RubyNode.class), @NodeChild(value="exponent", type=RubyNode.class), @NodeChild(value="precision", type=RubyNode.class)})
    public static abstract class PowerNode
    extends BigDecimalCoreMethodNode {
        private final ConditionProfile positiveExponentProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile zeroExponentProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile zeroProfile = ConditionProfile.createBinaryProfile();

        public PowerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal power(BigDecimal value, int exponent, MathContext mathContext) {
            return value.pow(exponent, mathContext);
        }

        @Specialization(guards={"isNormal(a)"})
        public Object power(VirtualFrame frame, RubyBasicObject a, int exponent, NotProvided precision) {
            return this.power(frame, a, exponent, this.getLimit(frame));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object power(VirtualFrame frame, RubyBasicObject a, int exponent, int precision) {
            BigDecimal aBigDecimal = BigDecimalNodes.getBigDecimalValue(a);
            boolean positiveExponent = this.positiveExponentProfile.profile(exponent >= 0);
            if (this.zeroProfile.profile(aBigDecimal.compareTo(BigDecimal.ZERO) == 0)) {
                if (positiveExponent) {
                    if (this.zeroExponentProfile.profile(exponent == 0)) {
                        return this.createBigDecimal(frame, BigDecimal.ONE);
                    }
                    return this.createBigDecimal(frame, BigDecimal.ZERO);
                }
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            int newPrecision = positiveExponent ? precision : (-exponent + 4) * (this.getDigits(aBigDecimal) + 4);
            return this.createBigDecimal(frame, this.power(BigDecimalNodes.getBigDecimalValue(a), exponent, new MathContext(newPrecision, this.getRoundMode(frame))));
        }

        @CompilerDirectives.TruffleBoundary
        private int getDigits(BigDecimal value) {
            return value.abs().unscaledValue().toString().length();
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object power(VirtualFrame frame, RubyBasicObject a, int exponent, Object unusedPrecision) {
            switch (BigDecimalNodes.getBigDecimalType(a)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case POSITIVE_INFINITY: {
                    return this.createBigDecimal(frame, exponent >= 0 ? Type.POSITIVE_INFINITY : BigDecimal.ZERO);
                }
                case NEGATIVE_INFINITY: {
                    return this.createBigDecimal(frame, Integer.signum(exponent) == 1 ? (exponent % 2 == 0 ? Type.POSITIVE_INFINITY : Type.NEGATIVE_INFINITY) : BigDecimal.ZERO);
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, Integer.signum(exponent) == 1 ? BigDecimal.ZERO : Type.NAN);
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"modulo", "%"}, required=1)
    public static abstract class ModuloNode
    extends OpNode {
        public ModuloNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        public static BigDecimal moduloBigDecimal(BigDecimal a, BigDecimal b) {
            BigDecimal modulo = a.remainder(b);
            if (modulo.signum() * b.signum() < 0) {
                return modulo.add(b);
            }
            return modulo;
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(b)"})
        public Object modulo(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.createBigDecimal(frame, ModuloNode.moduloBigDecimal(BigDecimalNodes.getBigDecimalValue(a), BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object moduloZero(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object moduloSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (bType == Type.NEGATIVE_ZERO || bType == Type.NORMAL && ModuloNode.isNormalZero(b)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            if (aType == Type.NEGATIVE_ZERO || aType == Type.NORMAL && ModuloNode.isNormalZero(a)) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            if (aType == Type.POSITIVE_INFINITY || aType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (bType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, a);
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"remainder"}, required=1)
    public static abstract class RemainderNode
    extends OpNode {
        public RemainderNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        public static BigDecimal remainderBigDecimal(BigDecimal a, BigDecimal b) {
            return a.remainder(b);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(b)"})
        public Object remainder(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.createBigDecimal(frame, RemainderNode.remainderBigDecimal(BigDecimalNodes.getBigDecimalValue(a), BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object remainderZero(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.createBigDecimal(frame, (Object)Type.NAN);
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object remainderSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NEGATIVE_ZERO && bType == Type.NORMAL) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            return this.createBigDecimal(frame, (Object)Type.NAN);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends OpNode {
        @Node.Child
        private CallDispatchHeadNode signCall;
        @Node.Child
        private IntegerCastNode signIntegerCast;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal[] divmodBigDecimal(BigDecimal a, BigDecimal b) {
            BigDecimal[] result = a.divideAndRemainder(b);
            if (result[1].signum() * b.signum() < 0) {
                result[0] = result[0].subtract(BigDecimal.ONE);
                result[1] = result[1].add(b);
            }
            return result;
        }

        private void setupSignCall() {
            if (this.signCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.signCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        private void setupLimitIntegerCast() {
            if (this.signIntegerCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.signIntegerCast = this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(a)", "!isNormalZero(b)"})
        public Object divmod(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            BigDecimal[] result = this.divmodBigDecimal(BigDecimalNodes.getBigDecimalValue(a), BigDecimalNodes.getBigDecimalValue(b));
            return this.createArray(this.createBigDecimal(frame, result[0]), this.createBigDecimal(frame, result[1]));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(a)", "!isNormalZero(b)"})
        public Object divmodZeroDividend(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.createArray(this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, BigDecimal.ZERO));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object divmodZeroDivisor(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object divmodSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.createArray(this.createBigDecimal(frame, (Object)Type.NAN), this.createBigDecimal(frame, (Object)Type.NAN));
            }
            if (bType == Type.NEGATIVE_ZERO || bType == Type.NORMAL && DivModNode.isNormalZero(b)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            if (aType == Type.NEGATIVE_ZERO || aType == Type.NORMAL && DivModNode.isNormalZero(a)) {
                return this.createArray(this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, BigDecimal.ZERO));
            }
            if (aType == Type.POSITIVE_INFINITY || aType == Type.NEGATIVE_INFINITY) {
                this.setupSignCall();
                this.setupLimitIntegerCast();
                int signA = aType == Type.POSITIVE_INFINITY ? 1 : -1;
                int signB = Integer.signum(this.signIntegerCast.executeInteger(frame, this.signCall.call(frame, b, "sign", null, new Object[0])));
                int sign = signA * signB;
                Type type = (new Type[]{Type.NEGATIVE_INFINITY, Type.NAN, Type.POSITIVE_INFINITY})[sign + 1];
                return this.createArray(this.createBigDecimal(frame, (Object)type), this.createBigDecimal(frame, (Object)Type.NAN));
            }
            if (bType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createArray(this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, a));
            }
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"div"}, required=1, optional=1)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class DivNode
    extends AbstractDivNode {
        private final ConditionProfile zeroPrecisionProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile bZeroProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CallDispatchHeadNode floorCall;

        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        private void setupFloorCall() {
            if (this.floorCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.floorCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, NotProvided precision) {
            this.setupFloorCall();
            if (this.bZeroProfile.profile(DivNode.isNormalZero(b))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            Object result = this.div(frame, a, b, 0);
            return this.floorCall.call(frame, result, "floor", null, new Object[0]);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            int newPrecision = this.zeroPrecisionProfile.profile(precision == 0) ? BigDecimalNodes.defaultDivisionPrecision(BigDecimalNodes.getBigDecimalValue(a), BigDecimalNodes.getBigDecimalValue(b), this.getLimit(frame)) : precision;
            return super.div(frame, a, b, newPrecision);
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, NotProvided precision) {
            if (BigDecimalNodes.getBigDecimalType(b) == Type.NEGATIVE_ZERO) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            if (BigDecimalNodes.getBigDecimalType(b) == Type.NAN) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
            }
            return this.divNormalSpecial(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.divNormalSpecial(frame, a, b, precision);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, NotProvided precision) {
            if (DivNode.isNormalZero(b)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            if (BigDecimalNodes.getBigDecimalType(a) == Type.NAN) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
            }
            if (BigDecimalNodes.getBigDecimalType(a) == Type.POSITIVE_INFINITY || BigDecimalNodes.getBigDecimalType(a) == Type.NEGATIVE_INFINITY) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Computation results to 'Infinity'", this));
            }
            return this.divSpecialNormal(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.divSpecialNormal(frame, a, b, precision);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, NotProvided precision) {
            if (BigDecimalNodes.getBigDecimalType(b) == Type.NEGATIVE_ZERO) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            if (BigDecimalNodes.getBigDecimalType(a) == Type.NAN || BigDecimalNodes.getBigDecimalType(b) == Type.NAN) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
            }
            return this.divSpecialSpecial(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.divSpecialSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"/", "quo"}, required=1)
    public static abstract class DivOpNode
    extends AbstractDivNode {
        public DivOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            int precision = BigDecimalNodes.defaultDivisionPrecision(BigDecimalNodes.getBigDecimalValue(a), BigDecimalNodes.getBigDecimalValue(b), this.getLimit(frame));
            return this.div(frame, a, b, precision);
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.divNormalSpecial(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.divSpecialNormal(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.divSpecialSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractDivNode
    extends OpNode {
        private final ConditionProfile normalZero = ConditionProfile.createBinaryProfile();

        public AbstractDivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        private Object divBigDecimalWithProfile(RubyBasicObject a, RubyBasicObject b, MathContext mathContext) {
            BigDecimal aBigDecimal = BigDecimalNodes.getBigDecimalValue(a);
            BigDecimal bBigDecimal = BigDecimalNodes.getBigDecimalValue(b);
            if (this.normalZero.profile(bBigDecimal.signum() == 0)) {
                switch (aBigDecimal.signum()) {
                    case 1: {
                        return Type.POSITIVE_INFINITY;
                    }
                    case 0: {
                        return Type.NAN;
                    }
                    case -1: {
                        return Type.NEGATIVE_INFINITY;
                    }
                }
                throw new UnreachableCodeBranch();
            }
            return this.divBigDecimal(aBigDecimal, bBigDecimal, mathContext);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal divBigDecimal(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return a.divide(b, mathContext);
        }

        protected Object div(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.createBigDecimal(frame, this.divBigDecimalWithProfile(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object divNormalSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            switch (BigDecimalNodes.getBigDecimalType(b)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case NEGATIVE_ZERO: {
                    switch (BigDecimalNodes.getBigDecimalValue(a).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(a).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                        case -1: 
                        case 0: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                    }
                }
            }
            throw new UnreachableCodeBranch();
        }

        protected Object divSpecialNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            switch (BigDecimalNodes.getBigDecimalType(a)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case NEGATIVE_ZERO: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                    }
                }
            }
            throw new UnreachableCodeBranch();
        }

        protected Object divSpecialSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.NEGATIVE_ZERO && bType == Type.NEGATIVE_ZERO) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.NEGATIVE_ZERO) {
                if (bType == Type.POSITIVE_INFINITY) {
                    return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                }
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            if (bType == Type.NEGATIVE_ZERO) {
                if (aType == Type.POSITIVE_INFINITY) {
                    return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                }
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            return this.createBigDecimal(frame, (Object)Type.NAN);
        }
    }

    @CoreMethod(names={"mult"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class MultNode
    extends AbstractMultNode {
        public MultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object mult(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.mult(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multNormalSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.multNormalSpecial(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object multSpecialNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.multSpecialNormal(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.multSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MultOpNode
    extends AbstractMultNode {
        public MultOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object mult(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.mult(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multNormalSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.multSpecialNormal(frame, b, a, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object multSpecialNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.multSpecialNormal(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.multSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractMultNode
    extends OpNode {
        private final ConditionProfile zeroNormal = ConditionProfile.createBinaryProfile();

        public AbstractMultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        private Object multBigDecimalWithProfile(RubyBasicObject a, RubyBasicObject b, MathContext mathContext) {
            BigDecimal bBigDecimal = BigDecimalNodes.getBigDecimalValue(b);
            if (this.zeroNormal.profile(AbstractMultNode.isNormalZero(a) && bBigDecimal.signum() == -1)) {
                return Type.NEGATIVE_ZERO;
            }
            return this.multBigDecimal(BigDecimalNodes.getBigDecimalValue(a), bBigDecimal, mathContext);
        }

        @CompilerDirectives.TruffleBoundary
        private Object multBigDecimal(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return a.multiply(b, mathContext);
        }

        protected Object mult(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.createBigDecimal(frame, this.multBigDecimalWithProfile(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object multNormalSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.multSpecialNormal(frame, b, a, precision);
        }

        protected Object multSpecialNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            switch (BigDecimalNodes.getBigDecimalType(a)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case NEGATIVE_ZERO: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (BigDecimalNodes.getBigDecimalValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                    }
                }
            }
            throw new UnreachableCodeBranch();
        }

        protected Object multSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.NEGATIVE_ZERO && bType == Type.NEGATIVE_ZERO) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            if (aType == Type.NEGATIVE_ZERO || bType == Type.NEGATIVE_ZERO) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY) {
                return bType == Type.POSITIVE_INFINITY ? a : this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY) {
                return bType == Type.POSITIVE_INFINITY ? a : this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public Object negNormal(VirtualFrame frame, RubyBasicObject value) {
            return this.createBigDecimal(frame, BigDecimalNodes.getBigDecimalValue(value).negate());
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public Object negNormalZero(VirtualFrame frame, RubyBasicObject value) {
            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object negSpecial(VirtualFrame frame, RubyBasicObject value) {
            switch (BigDecimalNodes.getBigDecimalType(value)) {
                case POSITIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                }
                case NEGATIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, BigDecimal.ZERO);
                }
                case NAN: {
                    return value;
                }
            }
            throw new UnreachableCodeBranch();
        }
    }

    @CoreMethod(names={"sub"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class SubNode
    extends AbstractSubNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object subNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.subNormal(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object subSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.subSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubOpNode
    extends AbstractSubNode {
        public SubOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object subNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.subNormal(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object subSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.subSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractSubNode
    extends OpNode {
        public AbstractSubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal subBigDecimal(RubyBasicObject a, RubyBasicObject b, MathContext mathContext) {
            return BigDecimalNodes.getBigDecimalValue(a).subtract(BigDecimalNodes.getBigDecimalValue(b), mathContext);
        }

        protected Object subNormal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.createBigDecimal(frame, this.subBigDecimal(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object subSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.POSITIVE_INFINITY && bType == Type.POSITIVE_INFINITY || aType == Type.NEGATIVE_INFINITY && bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
            }
            if (AbstractSubNode.isNormal(a)) {
                return a;
            }
            return this.createBigDecimal(frame, BigDecimalNodes.getBigDecimalValue(b).negate());
        }
    }

    @CoreMethod(names={"add"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class AddNode
    extends AbstractAddNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        protected Object add(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.add(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        protected Object addSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return super.addSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddOpNode
    extends AbstractAddNode {
        public AddOpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object add(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.add(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object addSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            return this.addSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractAddNode
    extends OpNode {
        public AbstractAddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal addBigDecimal(RubyBasicObject a, RubyBasicObject b, MathContext mathContext) {
            return BigDecimalNodes.getBigDecimalValue(a).add(BigDecimalNodes.getBigDecimalValue(b), mathContext);
        }

        protected Object add(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            return this.createBigDecimal(frame, this.addBigDecimal(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object addSpecial(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b, int precision) {
            Type aType = BigDecimalNodes.getBigDecimalType(a);
            Type bType = BigDecimalNodes.getBigDecimalType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.POSITIVE_INFINITY && bType == Type.NEGATIVE_INFINITY || aType == Type.NEGATIVE_INFINITY && bType == Type.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
            }
            if (AbstractAddNode.isNormal(a)) {
                return a;
            }
            return b;
        }
    }

    @NodeChildren(value={@NodeChild(value="a", type=RubyNode.class), @NodeChild(value="b", type=RubyNode.class)})
    public static abstract class OpNode
    extends BigDecimalCoreMethodNode {
        public OpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"b"})
        protected RubyNode castB(RubyNode b) {
            return BigDecimalNodesFactory.BigDecimalCoerceNodeGen.create(this.getContext(), this.getSourceSection(), b);
        }
    }

    @CoreMethod(names={"initialize"}, required=1, optional=1)
    public static abstract class InitializeNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object initialize(VirtualFrame frame, RubyBasicObject self, Object value, NotProvided digits) {
            return this.createBigDecimal(frame, value, self);
        }

        @Specialization
        public Object initialize(VirtualFrame frame, RubyBasicObject self, Object value, int digits) {
            return this.createBigDecimal(frame, value, self, digits);
        }
    }

    @ImportStatic(value={Type.class})
    @NodeChildren(value={@NodeChild(value="value", type=RubyNode.class), @NodeChild(value="self", type=RubyNode.class), @NodeChild(value="digits", type=RubyNode.class)})
    public static abstract class CreateBigDecimalNode
    extends BigDecimalCoreMethodNode {
        private static final Pattern NUMBER_PATTERN;
        private static final Pattern ZERO_PATTERN;
        @Node.Child
        private BigDecimalCastNode bigDecimalCast;
        @Node.Child
        private CallDispatchHeadNode modeCall;
        @Node.Child
        private GetIntegerConstantNode getIntegerConstant;
        @Node.Child
        private BooleanCastNode booleanCast;

        public CreateBigDecimalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.bigDecimalCast = BigDecimalNodesFactory.BigDecimalCastNodeGen.create(context, sourceSection, null);
        }

        private void setBigDecimalValue(RubyBasicObject bigdecimal, BigDecimal value) {
            assert (RubyGuards.isRubyBigDecimal(bigdecimal));
            assert (bigdecimal.getDynamicObject().getShape().hasProperty(VALUE_IDENTIFIER));
            VALUE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), value, null);
            TYPE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), (Object)Type.NORMAL, null);
        }

        private void setBigDecimalValue(RubyBasicObject bigdecimal, Type type) {
            assert (RubyGuards.isRubyBigDecimal(bigdecimal));
            assert (bigdecimal.getDynamicObject().getShape().hasProperty(TYPE_IDENTIFIER));
            VALUE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), BigDecimal.ZERO, null);
            TYPE_PROPERTY.setSafe(bigdecimal.getDynamicObject(), (Object)type, null);
        }

        public abstract RubyBasicObject executeCreate(VirtualFrame var1, Object var2, RubyBasicObject var3, int var4);

        public final RubyBasicObject executeCreate(VirtualFrame frame, Object value) {
            return this.executeCreate(frame, value, this.getBigDecimalClass().allocate(this));
        }

        public final RubyBasicObject executeCreate(VirtualFrame frame, Object value, RubyBasicObject alreadyAllocatedSelf) {
            return this.executeCreate(frame, value, alreadyAllocatedSelf, 0);
        }

        @Specialization
        public RubyBasicObject create(VirtualFrame frame, long value, RubyBasicObject self, int digits) {
            this.setBigDecimalValue(self, this.bigDecimalCast.executeBigDecimal(frame, value).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization
        public RubyBasicObject create(VirtualFrame frame, double value, RubyBasicObject self, int digits) {
            this.setBigDecimalValue(self, this.bigDecimalCast.executeBigDecimal(frame, value).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"value == NEGATIVE_INFINITY || value == POSITIVE_INFINITY"})
        public RubyBasicObject createInfinity(VirtualFrame frame, Type value, RubyBasicObject self, int digits) {
            return this.createWithMode(frame, value, self, "EXCEPTION_INFINITY", "Computation results to 'Infinity'");
        }

        @Specialization(guards={"value == NAN"})
        public RubyBasicObject createNaN(VirtualFrame frame, Type value, RubyBasicObject self, int digits) {
            return this.createWithMode(frame, value, self, "EXCEPTION_NaN", "Computation results to 'NaN'(Not a Number)");
        }

        @Specialization(guards={"value == NEGATIVE_ZERO"})
        public RubyBasicObject createNegativeZero(VirtualFrame frame, Type value, RubyBasicObject self, int digits) {
            this.setBigDecimalValue(self, value);
            return self;
        }

        @Specialization
        public RubyBasicObject create(VirtualFrame frame, BigDecimal value, RubyBasicObject self, int digits) {
            this.setBigDecimalValue(self, value.round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public RubyBasicObject createBignum(VirtualFrame frame, RubyBasicObject value, RubyBasicObject self, int digits) {
            this.setBigDecimalValue(self, BigDecimalNodes.getBignumBigDecimalValue(value).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"isRubyBigDecimal(value)"})
        public RubyBasicObject createBigDecimal(VirtualFrame frame, RubyBasicObject value, RubyBasicObject self, int digits) {
            this.setBigDecimalValue(self, BigDecimalNodes.getBigDecimalValue(value).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"isRubyString(value)"})
        public RubyBasicObject createString(VirtualFrame frame, RubyBasicObject value, RubyBasicObject self, int digits) {
            return this.executeCreate(frame, this.getValueFromString(value.toString(), digits), self, digits);
        }

        private RubyBasicObject createWithMode(VirtualFrame frame, Type value, RubyBasicObject self, String constantName, String errorMessage) {
            this.setupModeCall();
            this.setupGetIntegerConstant();
            this.setupBooleanCast();
            int exceptionConstant = this.getIntegerConstant.executeGetIntegerConstant(frame, constantName);
            boolean raise = this.booleanCast.executeBoolean(frame, this.modeCall.call(frame, this.getBigDecimalClass(), "boolean_mode", null, exceptionConstant));
            if (raise) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError(errorMessage, this));
            }
            this.setBigDecimalValue(self, value);
            return self;
        }

        private void setupBooleanCast() {
            if (this.booleanCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.booleanCast = this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        private void setupGetIntegerConstant() {
            if (this.getIntegerConstant == null) {
                CompilerDirectives.transferToInterpreter();
                this.getIntegerConstant = this.insert(BigDecimalNodesFactory.GetIntegerConstantNodeGen.create(this.getContext(), this.getSourceSection(), new LiteralNode(this.getContext(), this.getSourceSection(), this.getBigDecimalClass())));
            }
        }

        private void setupModeCall() {
            if (this.modeCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.modeCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object getValueFromString(String string, int digits) {
            String strValue;
            switch (strValue = string.trim()) {
                case "NaN": {
                    return Type.NAN;
                }
                case "Infinity": 
                case "+Infinity": {
                    return Type.POSITIVE_INFINITY;
                }
                case "-Infinity": {
                    return Type.NEGATIVE_INFINITY;
                }
                case "-0": {
                    return Type.NEGATIVE_ZERO;
                }
            }
            strValue = strValue.replaceFirst("[dD]", "E");
            strValue = strValue.replaceAll("_", "");
            Matcher matcher = NUMBER_PATTERN.matcher(strValue);
            strValue = matcher.replaceFirst("$1");
            MatchResult result = matcher.toMatchResult();
            try {
                BigDecimal value = new BigDecimal(strValue, new MathContext(digits));
                if (value.compareTo(BigDecimal.ZERO) == 0 && strValue.startsWith("-")) {
                    return Type.NEGATIVE_ZERO;
                }
                return value;
            }
            catch (NumberFormatException e) {
                if (ZERO_PATTERN.matcher(strValue).matches()) {
                    return BigDecimal.ZERO;
                }
                BigInteger exponent = new BigInteger(result.group(3));
                if (exponent.signum() == 1) {
                    return Type.POSITIVE_INFINITY;
                }
                if (exponent.signum() == -1) {
                    return BigDecimal.ZERO;
                }
                throw e;
            }
        }

        static {
            String exponent = "([eE][+-]?)?(\\d*)";
            NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?(\\d*)).*");
            ZERO_PATTERN = Pattern.compile("^[+-]?0*\\.?0*([eE][+-]?)?(\\d*)");
        }
    }

    @NodeChild(value="arguments", type=RubyNode[].class)
    public static abstract class BigDecimalCoreMethodArrayArgumentsNode
    extends BigDecimalCoreMethodNode {
        public BigDecimalCoreMethodArrayArgumentsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }
    }

    public static abstract class BigDecimalCoreMethodNode
    extends CoreMethodNode {
        @Node.Child
        private CreateBigDecimalNode createBigDecimal;
        @Node.Child
        private CallDispatchHeadNode limitCall;
        @Node.Child
        private IntegerCastNode limitIntegerCast;
        @Node.Child
        private CallDispatchHeadNode roundModeCall;
        @Node.Child
        private IntegerCastNode roundModeIntegerCast;

        public BigDecimalCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public static boolean isNormal(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalType(value) == Type.NORMAL;
        }

        public static boolean isNormalRubyBigDecimal(RubyBasicObject value) {
            return RubyGuards.isRubyBigDecimal(value) && BigDecimalNodes.getBigDecimalType(value) == Type.NORMAL;
        }

        public static boolean isSpecialRubyBigDecimal(RubyBasicObject value) {
            return RubyGuards.isRubyBigDecimal(value) && BigDecimalNodes.getBigDecimalType(value) != Type.NORMAL;
        }

        public static boolean isNormalZero(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalValue(value).compareTo(BigDecimal.ZERO) == 0;
        }

        public static boolean isNan(RubyBasicObject value) {
            return BigDecimalNodes.getBigDecimalType(value) == Type.NAN;
        }

        private void setupCreateBigDecimal() {
            if (this.createBigDecimal == null) {
                CompilerDirectives.transferToInterpreter();
                this.createBigDecimal = this.insert(BigDecimalNodesFactory.CreateBigDecimalNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
        }

        protected RubyBasicObject createBigDecimal(VirtualFrame frame, Object value) {
            this.setupCreateBigDecimal();
            return this.createBigDecimal.executeCreate(frame, value);
        }

        protected RubyBasicObject createBigDecimal(VirtualFrame frame, Object value, RubyBasicObject self) {
            this.setupCreateBigDecimal();
            return this.createBigDecimal.executeCreate(frame, value, self);
        }

        protected RubyBasicObject createBigDecimal(VirtualFrame frame, Object value, RubyBasicObject self, int digits) {
            this.setupCreateBigDecimal();
            return this.createBigDecimal.executeCreate(frame, value, self, digits);
        }

        private void setupLimitCall() {
            if (this.limitCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.limitCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        private void setupLimitIntegerCast() {
            if (this.limitIntegerCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.limitIntegerCast = this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        protected int getLimit(VirtualFrame frame) {
            this.setupLimitCall();
            this.setupLimitIntegerCast();
            return this.limitIntegerCast.executeInteger(frame, this.limitCall.call(frame, this.getBigDecimalClass(), "limit", null, new Object[0]));
        }

        private void setupRoundModeCall() {
            if (this.roundModeCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.roundModeCall = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        private void setupRoundModeIntegerCast() {
            if (this.roundModeIntegerCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.roundModeIntegerCast = this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        protected RoundingMode getRoundMode(VirtualFrame frame) {
            this.setupRoundModeCall();
            this.setupRoundModeIntegerCast();
            return BigDecimalNodes.toRoundingMode(this.roundModeIntegerCast.executeInteger(frame, this.roundModeCall.call(frame, this.getBigDecimalClass(), "mode", null, 256)));
        }

        protected RubyClass getBigDecimalClass() {
            return this.getContext().getCoreLibrary().getBigDecimalClass();
        }
    }

    public static class RubyBigDecimalAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBasicObject(rubyClass, BIG_DECIMAL_FACTORY.newInstance(new Object[]{Type.NORMAL, BigDecimal.ZERO}));
        }
    }

    public static class BigDecimalType
    extends BasicObjectType {
        private BigDecimalType() {
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type NEGATIVE_INFINITY = new Type("-Infinity");
        public static final /* enum */ Type POSITIVE_INFINITY = new Type("Infinity");
        public static final /* enum */ Type NAN = new Type("NaN");
        public static final /* enum */ Type NEGATIVE_ZERO = new Type("-0");
        public static final /* enum */ Type NORMAL = new Type(null);
        private final String representation;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            assert (this.representation != null);
            return this.representation;
        }

        static {
            $VALUES = new Type[]{NEGATIVE_INFINITY, POSITIVE_INFINITY, NAN, NEGATIVE_ZERO, NORMAL};
        }
    }
}

