/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.cli.Options;

public class CachedBoxedMethodMissingDispatchNode
extends CachedDispatchNode {
    private static final boolean DISPATCH_METHODMISSING_ALWAYS_CLONED = (Boolean)Options.TRUFFLE_DISPATCH_METHODMISSING_ALWAYS_CLONED.load();
    private static final boolean DISPATCH_METHODMISSING_ALWAYS_INLINED = (Boolean)Options.TRUFFLE_DISPATCH_METHODMISSING_ALWAYS_INLINED.load();
    private final RubyClass expectedClass;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public CachedBoxedMethodMissingDispatchNode(RubyContext context, Object cachedName, DispatchNode next, RubyClass expectedClass, InternalMethod method, boolean indirect, DispatchAction dispatchAction) {
        super(context, cachedName, next, indirect, dispatchAction);
        this.expectedClass = expectedClass;
        this.unmodifiedAssumption = expectedClass.getUnmodifiedAssumption();
        this.method = method;
        if (indirect) {
            this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
        } else {
            this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
            if (this.callNode.isCallTargetCloningAllowed() && (DISPATCH_METHODMISSING_ALWAYS_CLONED || method.getSharedMethodInfo().shouldAlwaysSplit())) {
                this.insert(this.callNode);
                this.callNode.cloneCallTarget();
            }
            if (this.callNode.isInlinable() && DISPATCH_METHODMISSING_ALWAYS_INLINED) {
                this.insert(this.callNode);
                this.callNode.forceInlining();
            }
        }
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver instanceof RubyBasicObject && ((RubyBasicObject)receiver).getMetaClass() == this.expectedClass;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, (RubyBasicObject)blockObject, argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                Object[] argumentsObjectsArray = (Object[])argumentsObjects;
                Object[] modifiedArgumentsObjects = new Object[1 + argumentsObjectsArray.length];
                modifiedArgumentsObjects[0] = this.getCachedNameAsSymbol();
                ArrayUtils.arraycopy(argumentsObjectsArray, 0, modifiedArgumentsObjects, 1, argumentsObjectsArray.length);
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.method.getCallTarget(), RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyBasicObject)blockObject, modifiedArgumentsObjects));
                }
                return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyBasicObject)blockObject, modifiedArgumentsObjects));
            }
            case RESPOND_TO_METHOD: {
                return false;
            }
        }
        throw new UnsupportedOperationException();
    }
}

