/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

@GeneratedBy(value=HashNodes.class)
public final class HashNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ConstructNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), GetOrUndefinedNodeFactory.getInstance(), SetIndexNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompareByIdentityNodeFactory.getInstance(), IsCompareByIdentityNodeFactory.getInstance(), DefaultProcNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), EachNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), MapNodeFactory.getInstance(), MergeNodeFactory.getInstance(), SetDefaultNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), RehashNodeFactory.getInstance(), DefaultValueNodeFactory.getInstance(), SetDefaultValueNodeFactory.getInstance(), SetDefaultProcNodeFactory.getInstance());
    }

    @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
    public static final class SetDefaultProcNodeFactory
    extends NodeFactoryBase<HashNodes.SetDefaultProcNode> {
        private static SetDefaultProcNodeFactory setDefaultProcNodeFactoryInstance;

        private SetDefaultProcNodeFactory() {
            super(HashNodes.SetDefaultProcNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public HashNodes.SetDefaultProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SetDefaultProcNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultProcNode> getInstance() {
            if (setDefaultProcNodeFactoryInstance == null) {
                setDefaultProcNodeFactoryInstance = new SetDefaultProcNodeFactory();
            }
            return setDefaultProcNodeFactoryInstance;
        }

        public static HashNodes.SetDefaultProcNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultProc) {
            return new SetDefaultProcNodeGen(context, sourceSection, self, defaultProc);
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        public static final class SetDefaultProcNodeGen
        extends HashNodes.SetDefaultProcNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode defaultProc_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetDefaultProcNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultProc) {
                super(context, sourceSection);
                this.self_ = self;
                this.defaultProc_ = defaultProc;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="setDefaultProc(RubyBasicObject, Object)", value=HashNodes.SetDefaultProcNode.class)
            private static final class SetDefaultProc1Node_
            extends BaseNode_ {
                SetDefaultProc1Node_(SetDefaultProcNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    if (selfValue instanceof RubyBasicObject) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        if (this.root.isNil(defaultProcValue)) {
                            return this.root.setDefaultProc(selfValue_, defaultProcValue);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new SetDefaultProc1Node_(root);
                }
            }

            @GeneratedBy(methodName="setDefaultProc(RubyBasicObject, RubyBasicObject)", value=HashNodes.SetDefaultProcNode.class)
            private static final class SetDefaultProc0Node_
            extends BaseNode_ {
                SetDefaultProc0Node_(SetDefaultProcNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    if (selfValue instanceof RubyBasicObject && defaultProcValue instanceof RubyBasicObject) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        RubyBasicObject defaultProcValue_ = (RubyBasicObject)defaultProcValue;
                        if (RubyGuards.isRubyProc(defaultProcValue_)) {
                            return this.root.setDefaultProc(selfValue_, defaultProcValue_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new SetDefaultProc0Node_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetDefaultProcNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue, Object defaultProcValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue, defaultProcValue));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    return this.getNext().executeRubyBasicObject_(frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetDefaultProcNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SetDefaultProcNodeGen root;

                BaseNode_(SetDefaultProcNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.defaultProc_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object defaultProcValue) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, selfValue, defaultProcValue);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object defaultProcValue_ = this.root.defaultProc_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, selfValue_, defaultProcValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object defaultProcValue) {
                    if (selfValue instanceof RubyBasicObject) {
                        RubyBasicObject defaultProcValue_;
                        if (defaultProcValue instanceof RubyBasicObject && RubyGuards.isRubyProc(defaultProcValue_ = (RubyBasicObject)defaultProcValue)) {
                            return SetDefaultProc0Node_.create(this.root);
                        }
                        if (this.root.isNil(defaultProcValue)) {
                            return SetDefaultProc1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
    public static final class SetDefaultValueNodeFactory
    extends NodeFactoryBase<HashNodes.SetDefaultValueNode> {
        private static SetDefaultValueNodeFactory setDefaultValueNodeFactoryInstance;

        private SetDefaultValueNodeFactory() {
            super(HashNodes.SetDefaultValueNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public HashNodes.SetDefaultValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SetDefaultValueNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultValueNode> getInstance() {
            if (setDefaultValueNodeFactoryInstance == null) {
                setDefaultValueNodeFactoryInstance = new SetDefaultValueNodeFactory();
            }
            return setDefaultValueNodeFactoryInstance;
        }

        public static HashNodes.SetDefaultValueNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultValue) {
            return new SetDefaultValueNodeGen(context, sourceSection, self, defaultValue);
        }

        @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
        public static final class SetDefaultValueNodeGen
        extends HashNodes.SetDefaultValueNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode defaultValue_;

            private SetDefaultValueNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultValue) {
                super(context, sourceSection);
                this.self_ = self;
                this.defaultValue_ = defaultValue;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject selfValue_;
                try {
                    selfValue_ = this.self_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object defaultValueValue = this.defaultValue_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), defaultValueValue);
                }
                Object defaultValueValue_ = this.defaultValue_.execute(frameValue);
                return this.setDefaultValue(selfValue_, defaultValueValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object selfValue, Object defaultValueValue) {
                return new UnsupportedSpecializationException(this, new Node[]{this.self_, this.defaultValue_}, selfValue, defaultValueValue);
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultValueNode.class)
    public static final class DefaultValueNodeFactory
    extends NodeFactoryBase<HashNodes.DefaultValueNode> {
        private static DefaultValueNodeFactory defaultValueNodeFactoryInstance;

        private DefaultValueNodeFactory() {
            super(HashNodes.DefaultValueNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        @Override
        public HashNodes.DefaultValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return DefaultValueNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DefaultValueNode> getInstance() {
            if (defaultValueNodeFactoryInstance == null) {
                defaultValueNodeFactoryInstance = new DefaultValueNodeFactory();
            }
            return defaultValueNodeFactoryInstance;
        }

        public static HashNodes.DefaultValueNode create(RubyContext context, SourceSection sourceSection, RubyNode self) {
            return new DefaultValueNodeGen(context, sourceSection, self);
        }

        @GeneratedBy(value=HashNodes.DefaultValueNode.class)
        public static final class DefaultValueNodeGen
        extends HashNodes.DefaultValueNode {
            @Node.Child
            private RubyNode self_;

            private DefaultValueNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection);
                this.self_ = self;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject selfValue_;
                try {
                    selfValue_ = this.self_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.defaultValue(selfValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object selfValue) {
                return new UnsupportedSpecializationException(this, new Node[]{this.self_}, selfValue);
            }
        }
    }

    @GeneratedBy(value=HashNodes.RehashNode.class)
    public static final class RehashNodeFactory
    extends NodeFactoryBase<HashNodes.RehashNode> {
        private static RehashNodeFactory rehashNodeFactoryInstance;

        private RehashNodeFactory() {
            super(HashNodes.RehashNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.RehashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RehashNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.RehashNode> getInstance() {
            if (rehashNodeFactoryInstance == null) {
                rehashNodeFactoryInstance = new RehashNodeFactory();
            }
            return rehashNodeFactoryInstance;
        }

        public static HashNodes.RehashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RehashNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        public static final class RehashNodeGen
        extends HashNodes.RehashNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private RehashNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="rehashBuckets(RubyBasicObject)", value=HashNodes.RehashNode.class)
            private static final class RehashBucketsNode_
            extends BaseNode_ {
                RehashBucketsNode_(RehashNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isBucketHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.rehashBuckets(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new RehashBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="rehashPackedArray(VirtualFrame, RubyBasicObject)", value=HashNodes.RehashNode.class)
            private static final class RehashPackedArrayNode_
            extends BaseNode_ {
                RehashPackedArrayNode_(RehashNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isPackedHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.rehashPackedArray(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new RehashPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="rehashNull(RubyBasicObject)", value=HashNodes.RehashNode.class)
            private static final class RehashNullNode_
            extends BaseNode_ {
                RehashNullNode_(RehashNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.rehashNull(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new RehashNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.RehashNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RehashNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.RehashNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RehashNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.RehashNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RehashNodeGen root;

                BaseNode_(RehashNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return RehashNullNode_.create(this.root);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_)) {
                            return RehashPackedArrayNode_.create(this.root);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            return RehashBucketsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<HashNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(HashNodes.SizeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static HashNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends HashNodes.SizeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="sizePackedArray(RubyBasicObject)", value=HashNodes.SizeNode.class)
            private static final class SizePackedArrayNode_
            extends BaseNode_ {
                SizePackedArrayNode_(SizeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (!HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.sizePackedArray(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.sizePackedArray(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new SizePackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="sizeNull(RubyBasicObject)", value=HashNodes.SizeNode.class)
            private static final class SizeNullNode_
            extends BaseNode_ {
                SizeNullNode_(SizeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.sizeNull(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.sizeNull(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new SizeNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SizeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SizeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SizeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SizeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SizeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SizeNodeGen root;

                BaseNode_(SizeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return SizeNullNode_.create(this.root);
                        }
                        return SizePackedArrayNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    extends NodeFactoryBase<HashNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
            super(HashNodes.ShiftNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.ShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ShiftNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        public static HashNodes.ShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        public static final class ShiftNodeGen
        extends HashNodes.ShiftNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="shiftBuckets(RubyBasicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftBucketsNode_
            extends BaseNode_ {
                ShiftBucketsNode_(ShiftNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !HashGuards.isEmptyHash(arguments0Value_ = (RubyBasicObject)arguments0Value) && HashGuards.isBucketHash(arguments0Value_)) {
                        return this.root.shiftBuckets(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftPackedArray(RubyBasicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftPackedArrayNode_
            extends BaseNode_ {
                ShiftPackedArrayNode_(ShiftNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !HashGuards.isEmptyHash(arguments0Value_ = (RubyBasicObject)arguments0Value) && HashGuards.isPackedHash(arguments0Value_)) {
                        return this.root.shiftPackedArray(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftEmptyDefaultProc(RubyBasicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftEmptyDefaultProcNode_
            extends BaseNode_ {
                ShiftEmptyDefaultProcNode_(ShiftNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isEmptyHash(arguments0Value_ = (RubyBasicObject)arguments0Value) && !HashGuards.hasDefaultValue(arguments0Value_) && HashGuards.hasDefaultBlock(arguments0Value_)) {
                        return this.root.shiftEmptyDefaultProc(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftEmptyDefaultProcNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftEmpyDefaultValue(RubyBasicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftEmpyDefaultValueNode_
            extends BaseNode_ {
                ShiftEmpyDefaultValueNode_(ShiftNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isEmptyHash(arguments0Value_ = (RubyBasicObject)arguments0Value) && HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                        return this.root.shiftEmpyDefaultValue(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftEmpyDefaultValueNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftEmpty(RubyBasicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftEmptyNode_
            extends BaseNode_ {
                ShiftEmptyNode_(ShiftNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isEmptyHash(arguments0Value_ = (RubyBasicObject)arguments0Value) && !HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                        return this.root.shiftEmpty(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftEmptyNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ShiftNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ShiftNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ShiftNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ShiftNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ShiftNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ShiftNodeGen root;

                BaseNode_(ShiftNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (HashGuards.isEmptyHash(arguments0Value_) && !HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                            return ShiftEmptyNode_.create(this.root);
                        }
                        if (HashGuards.isEmptyHash(arguments0Value_) && HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                            return ShiftEmpyDefaultValueNode_.create(this.root);
                        }
                        if (HashGuards.isEmptyHash(arguments0Value_) && !HashGuards.hasDefaultValue(arguments0Value_) && HashGuards.hasDefaultBlock(arguments0Value_)) {
                            return ShiftEmptyDefaultProcNode_.create(this.root);
                        }
                        if (!HashGuards.isEmptyHash(arguments0Value_) && HashGuards.isPackedHash(arguments0Value_)) {
                            return ShiftPackedArrayNode_.create(this.root);
                        }
                        if (!HashGuards.isEmptyHash(arguments0Value_) && HashGuards.isBucketHash(arguments0Value_)) {
                            return ShiftBucketsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultNode.class)
    public static final class SetDefaultNodeFactory
    extends NodeFactoryBase<HashNodes.SetDefaultNode> {
        private static SetDefaultNodeFactory setDefaultNodeFactoryInstance;

        private SetDefaultNodeFactory() {
            super(HashNodes.SetDefaultNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.SetDefaultNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetDefaultNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultNode> getInstance() {
            if (setDefaultNodeFactoryInstance == null) {
                setDefaultNodeFactoryInstance = new SetDefaultNodeFactory();
            }
            return setDefaultNodeFactoryInstance;
        }

        public static HashNodes.SetDefaultNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetDefaultNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.SetDefaultNode.class)
        public static final class SetDefaultNodeGen
        extends HashNodes.SetDefaultNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private SetDefaultNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.setDefault(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=HashNodes.MergeNode.class)
    public static final class MergeNodeFactory
    extends NodeFactoryBase<HashNodes.MergeNode> {
        private static MergeNodeFactory mergeNodeFactoryInstance;

        private MergeNodeFactory() {
            super(HashNodes.MergeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.MergeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MergeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.MergeNode> getInstance() {
            if (mergeNodeFactoryInstance == null) {
                mergeNodeFactoryInstance = new MergeNodeFactory();
            }
            return mergeNodeFactoryInstance;
        }

        public static HashNodes.MergeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MergeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        public static final class MergeNodeGen
        extends HashNodes.MergeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private MergeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="merge(VirtualFrame, RubyBasicObject, Object, Object)", value=HashNodes.MergeNode.class)
            private static final class Merge1Node_
            extends BaseNode_ {
                Merge1Node_(MergeNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            return this.root.merge(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new Merge1Node_(root);
                }
            }

            @GeneratedBy(methodName="merge(VirtualFrame, RubyBasicObject, RubyBasicObject, RubyBasicObject)", value=HashNodes.MergeNode.class)
            private static final class Merge0Node_
            extends BaseNode_ {
                Merge0Node_(MergeNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.merge(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new Merge0Node_(root);
                }
            }

            @GeneratedBy(methodName="mergeBucketsPacked(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeBucketsPackedNode_
            extends BaseNode_ {
                MergeBucketsPackedNode_(MergeNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergeBucketsPacked(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeBucketsPackedNode_(root);
                }
            }

            @GeneratedBy(methodName="mergePackedBuckets(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergePackedBucketsNode_
            extends BaseNode_ {
                MergePackedBucketsNode_(MergeNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergePackedBuckets(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergePackedBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeBucketsBuckets(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeBucketsBucketsNode_
            extends BaseNode_ {
                MergeBucketsBucketsNode_(MergeNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergeBucketsBuckets(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeBucketsBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="mergePackedPacked(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergePackedPackedNode_
            extends BaseNode_ {
                MergePackedPackedNode_(MergeNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                            return this.root.mergePackedPacked(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergePackedPackedNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeBucketsEmpty(RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeBucketsEmptyNode_
            extends BaseNode_ {
                MergeBucketsEmptyNode_(MergeNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergeBucketsEmpty(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeBucketsEmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeEmptyBuckets(RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeEmptyBucketsNode_
            extends BaseNode_ {
                MergeEmptyBucketsNode_(MergeNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                            return this.root.mergeEmptyBuckets(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeEmptyBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="mergePackedEmpty(RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergePackedEmptyNode_
            extends BaseNode_ {
                MergePackedEmptyNode_(MergeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergePackedEmpty(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergePackedEmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeEmptyPacked(RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeEmptyPackedNode_
            extends BaseNode_ {
                MergeEmptyPackedNode_(MergeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                            return this.root.mergeEmptyPacked(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeEmptyPackedNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeEmptyEmpty(RubyBasicObject, RubyBasicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeEmptyEmptyNode_
            extends BaseNode_ {
                MergeEmptyEmptyNode_(MergeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                            return this.root.mergeEmptyEmpty(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeEmptyEmptyNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MergeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MergeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MergeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MergeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MergeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MergeNodeGen root;

                BaseNode_(MergeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (arguments2Value instanceof NotProvided) {
                                if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                                    return MergeEmptyEmptyNode_.create(this.root);
                                }
                                if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                                    return MergeEmptyPackedNode_.create(this.root);
                                }
                                if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergePackedEmptyNode_.create(this.root);
                                }
                                if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                                    return MergeEmptyBucketsNode_.create(this.root);
                                }
                                if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergeBucketsEmptyNode_.create(this.root);
                                }
                                if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                                    return MergePackedPackedNode_.create(this.root);
                                }
                                if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergeBucketsBucketsNode_.create(this.root);
                                }
                                if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergePackedBucketsNode_.create(this.root);
                                }
                                if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergeBucketsPackedNode_.create(this.root);
                                }
                            }
                            if (arguments2Value instanceof RubyBasicObject) {
                                RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                                if (RubyGuards.isRubyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                                    return Merge0Node_.create(this.root);
                                }
                            }
                        }
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            return Merge1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.MapNode.class)
    public static final class MapNodeFactory
    extends NodeFactoryBase<HashNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
            super(HashNodes.MapNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.MapNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        public static HashNodes.MapNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MapNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        public static final class MapNodeGen
        extends HashNodes.MapNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MapNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="mapBuckets(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=HashNodes.MapNode.class)
            private static final class MapBucketsNode_
            extends BaseNode_ {
                MapBucketsNode_(MapNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapBuckets(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="mapPackedArray(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=HashNodes.MapNode.class)
            private static final class MapPackedArrayNode_
            extends BaseNode_ {
                MapPackedArrayNode_(MapNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapPackedArray(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="mapNull(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=HashNodes.MapNode.class)
            private static final class MapNullNode_
            extends BaseNode_ {
                MapNullNode_(MapNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.mapNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MapNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MapNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MapNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MapNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MapNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MapNodeGen root;

                BaseNode_(MapNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapNullNode_.create(this.root);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapPackedArrayNode_.create(this.root);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return MapBucketsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<HashNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(HashNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static HashNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeCopyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends HashNodes.InitializeCopyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeCopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="replaceBuckets(VirtualFrame, RubyBasicObject, Object)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplaceBuckets1Node_
            extends BaseNode_ {
                ReplaceBuckets1Node_(InitializeCopyNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            return this.root.replaceBuckets(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new ReplaceBuckets1Node_(root);
                }
            }

            @GeneratedBy(methodName="replaceBuckets(RubyBasicObject, RubyBasicObject)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplaceBuckets0Node_
            extends BaseNode_ {
                ReplaceBuckets0Node_(InitializeCopyNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                            return this.root.replaceBuckets(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new ReplaceBuckets0Node_(root);
                }
            }

            @GeneratedBy(methodName="replacePackedArray(RubyBasicObject, RubyBasicObject)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplacePackedArrayNode_
            extends BaseNode_ {
                ReplacePackedArrayNode_(InitializeCopyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                            return this.root.replacePackedArray(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new ReplacePackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="replaceNull(RubyBasicObject, RubyBasicObject)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplaceNullNode_
            extends BaseNode_ {
                ReplaceNullNode_(InitializeCopyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                            return this.root.replaceNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new ReplaceNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeCopyNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeCopyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeCopyNodeGen root;

                BaseNode_(InitializeCopyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                                return ReplaceNullNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                                return ReplacePackedArrayNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                                return ReplaceBuckets0Node_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            return ReplaceBuckets1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<HashNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(HashNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static HashNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends HashNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(RubyBasicObject, Object, RubyBasicObject)", value=HashNodes.InitializeNode.class)
            private static final class Initialize3Node_
            extends BaseNode_ {
                Initialize3Node_(InitializeNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments2Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize3Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(RubyBasicObject, Object, NotProvided)", value=HashNodes.InitializeNode.class)
            private static final class Initialize2Node_
            extends BaseNode_ {
                Initialize2Node_(InitializeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize2Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(RubyBasicObject, NotProvided, RubyBasicObject)", value=HashNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(RubyBasicObject, NotProvided, NotProvided)", value=HashNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments2Value_;
                        if (arguments1Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided) {
                                return Initialize0Node_.create(this.root);
                            }
                            if (arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                                return Initialize1Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof NotProvided && RubyGuards.wasProvided(arguments1Value)) {
                            return Initialize2Node_.create(this.root);
                        }
                        if (arguments2Value instanceof RubyBasicObject) {
                            arguments2Value_ = (RubyBasicObject)arguments2Value;
                            if (RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                                return Initialize3Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<HashNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(HashNodes.EmptyNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        public static HashNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EmptyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends HashNodes.EmptyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private EmptyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="emptyPackedArray(RubyBasicObject)", value=HashNodes.EmptyNode.class)
            private static final class EmptyPackedArrayNode_
            extends BaseNode_ {
                EmptyPackedArrayNode_(EmptyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (!HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.emptyPackedArray(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.emptyPackedArray(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new EmptyPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="emptyNull(RubyBasicObject)", value=HashNodes.EmptyNode.class)
            private static final class EmptyNullNode_
            extends BaseNode_ {
                EmptyNullNode_(EmptyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.emptyNull(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.emptyNull(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new EmptyNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EmptyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EmptyNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EmptyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EmptyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EmptyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EmptyNodeGen root;

                BaseNode_(EmptyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return EmptyNullNode_.create(this.root);
                        }
                        return EmptyPackedArrayNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<HashNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(HashNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        public static HashNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        public static final class EachNodeGen
        extends HashNodes.EachNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="each(VirtualFrame, RubyBasicObject, NotProvided)", value=HashNodes.EachNode.class)
            private static final class EachNode_
            extends BaseNode_ {
                EachNode_(EachNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachNode_(root);
                }
            }

            @GeneratedBy(methodName="eachBuckets(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=HashNodes.EachNode.class)
            private static final class EachBucketsNode_
            extends BaseNode_ {
                EachBucketsNode_(EachNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachBuckets(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="eachPackedArray(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=HashNodes.EachNode.class)
            private static final class EachPackedArrayNode_
            extends BaseNode_ {
                EachPackedArrayNode_(EachNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachPackedArray(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="eachNull(RubyBasicObject, RubyBasicObject)", value=HashNodes.EachNode.class)
            private static final class EachNullNode_
            extends BaseNode_ {
                EachNullNode_(EachNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EachNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EachNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EachNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EachNodeGen root;

                BaseNode_(EachNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachNullNode_.create(this.root);
                            }
                            if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachPackedArrayNode_.create(this.root);
                            }
                            if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachBucketsNode_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided) {
                            return EachNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<HashNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(HashNodes.DeleteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        public static HashNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DeleteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        public static final class DeleteNodeGen
        extends HashNodes.DeleteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="delete(VirtualFrame, RubyBasicObject, Object, Object)", value=HashNodes.DeleteNode.class)
            private static final class DeleteNode_
            extends BaseNode_ {
                DeleteNode_(DeleteNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isBucketHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.delete(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteNode_(root);
                }
            }

            @GeneratedBy(methodName="deletePackedArray(VirtualFrame, RubyBasicObject, Object, Object)", value=HashNodes.DeleteNode.class)
            private static final class DeletePackedArrayNode_
            extends BaseNode_ {
                DeletePackedArrayNode_(DeleteNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isPackedHash(arguments0Value_ = (RubyBasicObject)arguments0Value) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                        return this.root.deletePackedArray(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeletePackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteNull(VirtualFrame, RubyBasicObject, Object, Object)", value=HashNodes.DeleteNode.class)
            private static final class DeleteNullNode_
            extends BaseNode_ {
                DeleteNullNode_(DeleteNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.deleteNull(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DeleteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DeleteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DeleteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DeleteNodeGen root;

                BaseNode_(DeleteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return DeleteNullNode_.create(this.root);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                            return DeletePackedArrayNode_.create(this.root);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            return DeleteNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultProcNode.class)
    public static final class DefaultProcNodeFactory
    extends NodeFactoryBase<HashNodes.DefaultProcNode> {
        private static DefaultProcNodeFactory defaultProcNodeFactoryInstance;

        private DefaultProcNodeFactory() {
            super(HashNodes.DefaultProcNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.DefaultProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefaultProcNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DefaultProcNode> getInstance() {
            if (defaultProcNodeFactoryInstance == null) {
                defaultProcNodeFactoryInstance = new DefaultProcNodeFactory();
            }
            return defaultProcNodeFactoryInstance;
        }

        public static HashNodes.DefaultProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DefaultProcNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.DefaultProcNode.class)
        public static final class DefaultProcNodeGen
        extends HashNodes.DefaultProcNode {
            @Node.Child
            private RubyNode arguments0_;

            private DefaultProcNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.defaultProc(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
    public static final class IsCompareByIdentityNodeFactory
    extends NodeFactoryBase<HashNodes.IsCompareByIdentityNode> {
        private static IsCompareByIdentityNodeFactory isCompareByIdentityNodeFactoryInstance;

        private IsCompareByIdentityNodeFactory() {
            super(HashNodes.IsCompareByIdentityNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.IsCompareByIdentityNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsCompareByIdentityNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.IsCompareByIdentityNode> getInstance() {
            if (isCompareByIdentityNodeFactoryInstance == null) {
                isCompareByIdentityNodeFactoryInstance = new IsCompareByIdentityNodeFactory();
            }
            return isCompareByIdentityNodeFactoryInstance;
        }

        public static HashNodes.IsCompareByIdentityNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsCompareByIdentityNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
        public static final class IsCompareByIdentityNodeGen
        extends HashNodes.IsCompareByIdentityNode {
            @Node.Child
            private RubyNode arguments0_;

            private IsCompareByIdentityNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.compareByIdentity(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
    public static final class CompareByIdentityNodeFactory
    extends NodeFactoryBase<HashNodes.CompareByIdentityNode> {
        private static CompareByIdentityNodeFactory compareByIdentityNodeFactoryInstance;

        private CompareByIdentityNodeFactory() {
            super(HashNodes.CompareByIdentityNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.CompareByIdentityNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareByIdentityNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.CompareByIdentityNode> getInstance() {
            if (compareByIdentityNodeFactoryInstance == null) {
                compareByIdentityNodeFactoryInstance = new CompareByIdentityNodeFactory();
            }
            return compareByIdentityNodeFactoryInstance;
        }

        public static HashNodes.CompareByIdentityNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareByIdentityNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
        public static final class CompareByIdentityNodeGen
        extends HashNodes.CompareByIdentityNode {
            @Node.Child
            private RubyNode arguments0_;

            private CompareByIdentityNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.compareByIdentity(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=HashNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<HashNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(HashNodes.ClearNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static HashNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ClearNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends HashNodes.ClearNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ClearNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="empty(RubyBasicObject)", value=HashNodes.ClearNode.class)
            private static final class EmptyNode_
            extends BaseNode_ {
                EmptyNode_(ClearNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.empty(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new EmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="emptyNull(RubyBasicObject)", value=HashNodes.ClearNode.class)
            private static final class EmptyNullNode_
            extends BaseNode_ {
                EmptyNullNode_(ClearNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.emptyNull(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new EmptyNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ClearNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ClearNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ClearNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ClearNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ClearNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ClearNodeGen root;

                BaseNode_(ClearNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return EmptyNullNode_.create(this.root);
                        }
                        return EmptyNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetIndexNode.class)
    public static final class SetIndexNodeFactory
    extends NodeFactoryBase<HashNodes.SetIndexNode> {
        private static SetIndexNodeFactory setIndexNodeFactoryInstance;

        private SetIndexNodeFactory() {
            super(HashNodes.SetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.SetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetIndexNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetIndexNode> getInstance() {
            if (setIndexNodeFactoryInstance == null) {
                setIndexNodeFactoryInstance = new SetIndexNodeFactory();
            }
            return setIndexNodeFactoryInstance;
        }

        public static HashNodes.SetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetIndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        public static final class SetIndexNodeGen
        extends HashNodes.SetIndexNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;

            private SetIndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                return this.setNull(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
    public static final class GetOrUndefinedNodeFactory
    extends NodeFactoryBase<HashNodes.GetOrUndefinedNode> {
        private static GetOrUndefinedNodeFactory getOrUndefinedNodeFactoryInstance;

        private GetOrUndefinedNodeFactory() {
            super(HashNodes.GetOrUndefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.GetOrUndefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetOrUndefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.GetOrUndefinedNode> getInstance() {
            if (getOrUndefinedNodeFactoryInstance == null) {
                getOrUndefinedNodeFactoryInstance = new GetOrUndefinedNodeFactory();
            }
            return getOrUndefinedNodeFactoryInstance;
        }

        public static HashNodes.GetOrUndefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetOrUndefinedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
        public static final class GetOrUndefinedNodeGen
        extends HashNodes.GetOrUndefinedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private GetOrUndefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.getOrUndefined(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<HashNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(HashNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        public static HashNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetIndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        public static final class GetIndexNodeGen
        extends HashNodes.GetIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetIndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeGet(VirtualFrame frameValue, RubyBasicObject arguments0Value, Object arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="getBuckets(VirtualFrame, RubyBasicObject, Object)", value=HashNodes.GetIndexNode.class)
            private static final class GetBucketsNode_
            extends BaseNode_ {
                GetBucketsNode_(GetIndexNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, RubyBasicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isBucketHash(arguments0Value)) {
                        return this.root.getBuckets(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isBucketHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.getBuckets(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="getPackedArray(VirtualFrame, RubyBasicObject, Object)", value=HashNodes.GetIndexNode.class)
            private static final class GetPackedArrayNode_
            extends BaseNode_ {
                GetPackedArrayNode_(GetIndexNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, RubyBasicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isPackedHash(arguments0Value)) {
                        return this.root.getPackedArray(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isPackedHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.getPackedArray(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="getNull(VirtualFrame, RubyBasicObject, Object)", value=HashNodes.GetIndexNode.class)
            private static final class GetNullNode_
            extends BaseNode_ {
                GetNullNode_(GetIndexNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, RubyBasicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isNullHash(arguments0Value)) {
                        return this.root.getNull(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && HashGuards.isNullHash(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.getNull(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.GetIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetIndexNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.GetIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.GetIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GetIndexNodeGen root;

                BaseNode_(GetIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, RubyBasicObject arguments0Value, Object arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return GetNullNode_.create(this.root);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_)) {
                            return GetPackedArrayNode_.create(this.root);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            return GetBucketsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.ConstructNode.class)
    public static final class ConstructNodeFactory
    extends NodeFactoryBase<HashNodes.ConstructNode> {
        private static ConstructNodeFactory constructNodeFactoryInstance;

        private ConstructNodeFactory() {
            super(HashNodes.ConstructNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public HashNodes.ConstructNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstructNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ConstructNode> getInstance() {
            if (constructNodeFactoryInstance == null) {
                constructNodeFactoryInstance = new ConstructNodeFactory();
            }
            return constructNodeFactoryInstance;
        }

        public static HashNodes.ConstructNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ConstructNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        public static final class ConstructNodeGen
        extends HashNodes.ConstructNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private ConstructNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="constructFallback(VirtualFrame, RubyClass, Object[])", value=HashNodes.ConstructNode.class)
            private static final class ConstructFallbackNode_
            extends BaseNode_ {
                ConstructFallbackNode_(ConstructNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyClass && arguments1Value instanceof Object[]) {
                        RubyClass arguments0Value_ = (RubyClass)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        return this.root.constructFallback(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root) {
                    return new ConstructFallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="construct(VirtualFrame, RubyClass, Object[])", value=HashNodes.ConstructNode.class)
            private static final class ConstructNode_
            extends BaseNode_ {
                ConstructNode_(ConstructNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyClass && arguments1Value instanceof Object[]) {
                        RubyClass arguments0Value_ = (RubyClass)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (HashNodes.ConstructNode.isSmallArrayOfPairs(arguments1Value_)) {
                            return this.root.construct(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root) {
                    return new ConstructNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ConstructNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ConstructNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ConstructNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ConstructNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ConstructNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ConstructNodeGen root;

                BaseNode_(ConstructNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyClass && arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (HashNodes.ConstructNode.isSmallArrayOfPairs(arguments1Value_)) {
                            return ConstructNode_.create(this.root);
                        }
                        return ConstructFallbackNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }
}

