/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;

public class StringGuards {
    public static boolean isSingleByteOptimizable(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)StringNodes.getByteList(string).getEncoding());
    }

    public static boolean isAsciiCompatible(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringNodes.getByteList(string).getEncoding().isAsciiCompatible();
    }

    public static boolean isSingleByteOptimizableOrAsciiOnly(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringGuards.isSingleByteOptimizable(string);
    }

    public static boolean isSingleByte(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringNodes.getByteList(string).getEncoding().isSingleByte();
    }

    public static boolean isValidOr7BitEncoding(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringNodes.isCodeRangeValid(string) || CodeRangeSupport.isCodeRangeAsciiOnly((CodeRangeable)StringNodes.getCodeRangeable(string));
    }

    public static boolean isFixedWidthEncoding(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringNodes.getByteList(string).getEncoding().isFixedWidth();
    }

    public static boolean isValidUtf8(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringNodes.isCodeRangeValid(string) && StringNodes.getByteList(string).getEncoding() instanceof UTF8Encoding;
    }
}

