/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.RangeNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyRange;

@GeneratedBy(value=RangeNodes.class)
public final class RangeNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(CollectNodeFactory.getInstance(), EachNodeFactory.getInstance(), ExcludeEndNodeFactory.getInstance(), BeginNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), EndNodeFactory.getInstance(), StepNodeFactory.getInstance(), ToANodeFactory.getInstance());
    }

    @GeneratedBy(value=RangeNodes.InternalSetExcludeEndNode.class)
    public static final class InternalSetExcludeEndNodeGen
    extends RangeNodes.InternalSetExcludeEndNode {
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private RubyNode excludeEnd_;

        private InternalSetExcludeEndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode excludeEnd) {
            super(context, sourceSection);
            this.self_ = self;
            this.excludeEnd_ = this.castToBoolean(excludeEnd);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            boolean excludeEndValue_;
            RubyRange.ObjectRange selfValue_;
            try {
                selfValue_ = InternalSetExcludeEndNodeGen.expectObjectRange(this.self_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                Object excludeEndValue = this.excludeEnd_.execute(frameValue);
                throw this.unsupported(ex.getResult(), excludeEndValue);
            }
            try {
                excludeEndValue_ = this.excludeEnd_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                throw this.unsupported(selfValue_, ex.getResult());
            }
            return this.setExcludeEnd(selfValue_, excludeEndValue_);
        }

        protected UnsupportedSpecializationException unsupported(Object selfValue, Object excludeEndValue) {
            return new UnsupportedSpecializationException(this, new Node[]{this.self_, this.excludeEnd_}, selfValue, excludeEndValue);
        }

        private static RubyRange.ObjectRange expectObjectRange(Object value) throws UnexpectedResultException {
            if (value instanceof RubyRange.ObjectRange) {
                return (RubyRange.ObjectRange)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RangeNodes.InternalSetExcludeEndNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode excludeEnd) {
            return new InternalSetExcludeEndNodeGen(context, sourceSection, self, excludeEnd);
        }
    }

    @GeneratedBy(value=RangeNodes.InternalSetEndNode.class)
    public static final class InternalSetEndNodeGen
    extends RangeNodes.InternalSetEndNode {
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private RubyNode end_;

        private InternalSetEndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode end) {
            super(context, sourceSection);
            this.self_ = self;
            this.end_ = end;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyRange.ObjectRange selfValue_;
            try {
                selfValue_ = InternalSetEndNodeGen.expectObjectRange(this.self_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.end_.execute(frameValue);
                throw this.unsupported(ex.getResult(), endValue);
            }
            Object endValue_ = this.end_.execute(frameValue);
            return this.setEnd(selfValue_, endValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected UnsupportedSpecializationException unsupported(Object selfValue, Object endValue) {
            return new UnsupportedSpecializationException(this, new Node[]{this.self_, this.end_}, selfValue, endValue);
        }

        private static RubyRange.ObjectRange expectObjectRange(Object value) throws UnexpectedResultException {
            if (value instanceof RubyRange.ObjectRange) {
                return (RubyRange.ObjectRange)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RangeNodes.InternalSetEndNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode end) {
            return new InternalSetEndNodeGen(context, sourceSection, self, end);
        }
    }

    @GeneratedBy(value=RangeNodes.InternalSetBeginNode.class)
    public static final class InternalSetBeginNodeGen
    extends RangeNodes.InternalSetBeginNode {
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private RubyNode begin_;

        private InternalSetBeginNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode begin) {
            super(context, sourceSection);
            this.self_ = self;
            this.begin_ = begin;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyRange.ObjectRange selfValue_;
            try {
                selfValue_ = InternalSetBeginNodeGen.expectObjectRange(this.self_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                Object beginValue = this.begin_.execute(frameValue);
                throw this.unsupported(ex.getResult(), beginValue);
            }
            Object beginValue_ = this.begin_.execute(frameValue);
            return this.setBegin(selfValue_, beginValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected UnsupportedSpecializationException unsupported(Object selfValue, Object beginValue) {
            return new UnsupportedSpecializationException(this, new Node[]{this.self_, this.begin_}, selfValue, beginValue);
        }

        private static RubyRange.ObjectRange expectObjectRange(Object value) throws UnexpectedResultException {
            if (value instanceof RubyRange.ObjectRange) {
                return (RubyRange.ObjectRange)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static RangeNodes.InternalSetBeginNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode begin) {
            return new InternalSetBeginNodeGen(context, sourceSection, self, begin);
        }
    }

    @GeneratedBy(value=RangeNodes.ToANode.class)
    public static final class ToANodeFactory
    extends NodeFactoryBase<RangeNodes.ToANode> {
        private static ToANodeFactory toANodeFactoryInstance;

        private ToANodeFactory() {
            super(RangeNodes.ToANode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.ToANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToANodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.ToANode> getInstance() {
            if (toANodeFactoryInstance == null) {
                toANodeFactoryInstance = new ToANodeFactory();
            }
            return toANodeFactoryInstance;
        }

        public static RangeNodes.ToANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToANodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        public static final class ToANodeGen
        extends RangeNodes.ToANode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToANodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="toA(VirtualFrame, ObjectRange)", value=RangeNodes.ToANode.class)
            private static final class ToA1Node_
            extends BaseNode_ {
                ToA1Node_(ToANodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        return this.root.toA(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new ToA1Node_(root);
                }
            }

            @GeneratedBy(methodName="toA(IntegerFixnumRange)", value=RangeNodes.ToANode.class)
            private static final class ToA0Node_
            extends BaseNode_ {
                ToA0Node_(ToANodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        return this.root.toA(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new ToA0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ToANode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToANodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ToANode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToANodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ToANode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToANodeGen root;

                BaseNode_(ToANodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange) {
                        return ToA0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        return ToA1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.StepNode.class)
    public static final class StepNodeFactory
    extends NodeFactoryBase<RangeNodes.StepNode> {
        private static StepNodeFactory stepNodeFactoryInstance;

        private StepNodeFactory() {
            super(RangeNodes.StepNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.StepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StepNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.StepNode> getInstance() {
            if (stepNodeFactoryInstance == null) {
                stepNodeFactoryInstance = new StepNodeFactory();
            }
            return stepNodeFactoryInstance;
        }

        public static RangeNodes.StepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new StepNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        public static final class StepNodeGen
        extends RangeNodes.StepNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private StepNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="step(VirtualFrame, ObjectRange, Object, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class Step11Node_
            extends BaseNode_ {
                Step11Node_(StepNodeGen root) {
                    super(root, 14);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments2Value instanceof NotProvided) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step11Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, ObjectRange, NotProvided, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class Step10Node_
            extends BaseNode_ {
                Step10Node_(StepNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments1Value instanceof NotProvided && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step10Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, ObjectRange, NotProvided, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class Step9Node_
            extends BaseNode_ {
                Step9Node_(StepNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step9Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, ObjectRange, Object, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class Step8Node_
            extends BaseNode_ {
                Step8Node_(StepNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step8Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, LongFixnumRange, Object, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class Step7Node_
            extends BaseNode_ {
                Step7Node_(StepNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments2Value instanceof NotProvided) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step7Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, LongFixnumRange, NotProvided, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class Step6Node_
            extends BaseNode_ {
                Step6Node_(StepNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments1Value instanceof NotProvided && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step6Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, LongFixnumRange, NotProvided, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class Step5Node_
            extends BaseNode_ {
                Step5Node_(StepNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step5Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, IntegerFixnumRange, Object, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class Step4Node_
            extends BaseNode_ {
                Step4Node_(StepNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange && arguments2Value instanceof NotProvided) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step4Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, IntegerFixnumRange, NotProvided, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class Step3Node_
            extends BaseNode_ {
                Step3Node_(StepNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange && arguments1Value instanceof NotProvided && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step3Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, IntegerFixnumRange, NotProvided, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class Step2Node_
            extends BaseNode_ {
                Step2Node_(StepNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step2Node_(root);
                }
            }

            @GeneratedBy(methodName="stepFallback(VirtualFrame, LongFixnumRange, Object, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class StepFallback1Node_
            extends BaseNode_ {
                StepFallback1Node_(StepNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepFallback(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepFallback1Node_(root);
                }
            }

            @GeneratedBy(methodName="stepFallback(VirtualFrame, IntegerFixnumRange, Object, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class StepFallback0Node_
            extends BaseNode_ {
                StepFallback0Node_(StepNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepFallback(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepFallback0Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, LongFixnumRange, int, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class Step1Node_
            extends BaseNode_ {
                Step1Node_(StepNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments2Value_;
                    int arguments1Value_;
                    RubyRange.LongFixnumRange arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeLongFixnumRange(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                        return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments1Value instanceof Integer && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step1Node_(root);
                }
            }

            @GeneratedBy(methodName="step(VirtualFrame, IntegerFixnumRange, int, RubyBasicObject)", value=RangeNodes.StepNode.class)
            private static final class Step0Node_
            extends BaseNode_ {
                Step0Node_(StepNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments2Value_;
                    int arguments1Value_;
                    RubyRange.IntegerFixnumRange arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeIntegerFixnumRange(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                        return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange && arguments1Value instanceof Integer && arguments2Value instanceof RubyBasicObject) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new Step0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.StepNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(StepNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.StepNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(StepNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.StepNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final StepNodeGen root;

                BaseNode_(StepNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments2Value_;
                    if (arguments2Value instanceof RubyBasicObject) {
                        arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (arguments1Value instanceof Integer) {
                            int arguments1Value_ = (Integer)arguments1Value;
                            if (arguments0Value instanceof RubyRange.IntegerFixnumRange && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                                return Step0Node_.create(this.root);
                            }
                            if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                                return Step1Node_.create(this.root);
                            }
                        }
                        if (arguments0Value instanceof RubyRange.IntegerFixnumRange && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return StepFallback0Node_.create(this.root);
                        }
                        if (arguments0Value instanceof RubyRange.LongFixnumRange && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return StepFallback1Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange) {
                        if (arguments1Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided) {
                                return Step2Node_.create(this.root);
                            }
                            if (arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                                return Step3Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof NotProvided && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return Step4Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof RubyRange.LongFixnumRange) {
                        if (arguments1Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided) {
                                return Step5Node_.create(this.root);
                            }
                            if (arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                                return Step6Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof NotProvided && RubyGuards.wasProvided(arguments1Value)) {
                            return Step7Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        if (arguments2Value instanceof RubyBasicObject) {
                            arguments2Value_ = (RubyBasicObject)arguments2Value;
                            if (RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                                return Step8Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided) {
                                return Step9Node_.create(this.root);
                            }
                            if (arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                                return Step10Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof NotProvided && RubyGuards.wasProvided(arguments1Value)) {
                            return Step11Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EndNode.class)
    public static final class EndNodeFactory
    extends NodeFactoryBase<RangeNodes.EndNode> {
        private static EndNodeFactory endNodeFactoryInstance;

        private EndNodeFactory() {
            super(RangeNodes.EndNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.EndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EndNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.EndNode> getInstance() {
            if (endNodeFactoryInstance == null) {
                endNodeFactoryInstance = new EndNodeFactory();
            }
            return endNodeFactoryInstance;
        }

        public static RangeNodes.EndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EndNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        public static final class EndNodeGen
        extends RangeNodes.EndNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private EndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="last(ObjectRange)", value=RangeNodes.EndNode.class)
            private static final class Last2Node_
            extends BaseNode_ {
                Last2Node_(EndNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        return this.root.last(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new Last2Node_(root);
                }
            }

            @GeneratedBy(methodName="last(LongFixnumRange)", value=RangeNodes.EndNode.class)
            private static final class Last1Node_
            extends BaseNode_ {
                Last1Node_(EndNodeGen root) {
                    super(root, 2);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyRange.LongFixnumRange arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeLongFixnumRange(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EndNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.last(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        return this.root.last(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new Last1Node_(root);
                }
            }

            @GeneratedBy(methodName="last(IntegerFixnumRange)", value=RangeNodes.EndNode.class)
            private static final class Last0Node_
            extends BaseNode_ {
                Last0Node_(EndNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyRange.IntegerFixnumRange arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeIntegerFixnumRange(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EndNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.last(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        return this.root.last(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new Last0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EndNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EndNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EndNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EndNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EndNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EndNodeGen root;

                BaseNode_(EndNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return EndNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return EndNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange) {
                        return Last0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyRange.LongFixnumRange) {
                        return Last1Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        return Last2Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<RangeNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(RangeNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static RangeNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends RangeNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static RubyRange.ObjectRange expectObjectRange(Object value) throws UnexpectedResultException {
                if (value instanceof RubyRange.ObjectRange) {
                    return (RubyRange.ObjectRange)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="initialize(ObjectRange, Object, Object, boolean)", value=RangeNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean arguments3Value_;
                    RubyRange.ObjectRange arguments0Value_;
                    try {
                        arguments0Value_ = InitializeNodeGen.expectObjectRange(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        return this.getNext().executeObjectRange_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeObjectRange_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                public RubyRange.ObjectRange executeObjectRange_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments3Value instanceof Boolean) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        boolean arguments3Value_ = (Boolean)arguments3Value;
                        return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                    }
                    return this.getNext().executeObjectRange_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(ObjectRange, Object, Object, NotProvided)", value=RangeNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyRange.ObjectRange executeObjectRange_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments3Value instanceof NotProvided) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                    }
                    return this.getNext().executeObjectRange_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public RubyRange.ObjectRange executeObjectRange_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().executeObjectRange_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyRange.ObjectRange executeObjectRange_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return (RubyRange.ObjectRange)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.executeObjectRange_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract RubyRange.ObjectRange executeObjectRange_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.executeArguments3_(frameValue);
                    return this.executeObjectRange_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        if (arguments3Value instanceof NotProvided) {
                            return Initialize0Node_.create(this.root);
                        }
                        if (arguments3Value instanceof Boolean) {
                            return Initialize1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments3_(Frame frameValue) {
                    Object object;
                    Class arguments3Type_ = this.root.arguments3Type_;
                    if (arguments3Type_ == Boolean.TYPE) {
                        return this.root.arguments3_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments3Type_ != null) return this.root.arguments3_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments3_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments3Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments3Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments3Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.BeginNode.class)
    public static final class BeginNodeFactory
    extends NodeFactoryBase<RangeNodes.BeginNode> {
        private static BeginNodeFactory beginNodeFactoryInstance;

        private BeginNodeFactory() {
            super(RangeNodes.BeginNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.BeginNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BeginNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.BeginNode> getInstance() {
            if (beginNodeFactoryInstance == null) {
                beginNodeFactoryInstance = new BeginNodeFactory();
            }
            return beginNodeFactoryInstance;
        }

        public static RangeNodes.BeginNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BeginNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        public static final class BeginNodeGen
        extends RangeNodes.BeginNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private BeginNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="each(ObjectRange)", value=RangeNodes.BeginNode.class)
            private static final class Each2Node_
            extends BaseNode_ {
                Each2Node_(BeginNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        return this.root.each(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new Each2Node_(root);
                }
            }

            @GeneratedBy(methodName="each(LongFixnumRange)", value=RangeNodes.BeginNode.class)
            private static final class Each1Node_
            extends BaseNode_ {
                Each1Node_(BeginNodeGen root) {
                    super(root, 2);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyRange.LongFixnumRange arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeLongFixnumRange(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return BeginNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.each(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        return this.root.each(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new Each1Node_(root);
                }
            }

            @GeneratedBy(methodName="each(IntegerFixnumRange)", value=RangeNodes.BeginNode.class)
            private static final class Each0Node_
            extends BaseNode_ {
                Each0Node_(BeginNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyRange.IntegerFixnumRange arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeIntegerFixnumRange(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return BeginNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.each(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        return this.root.each(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new Each0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.BeginNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BeginNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.BeginNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BeginNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.BeginNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BeginNodeGen root;

                BaseNode_(BeginNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BeginNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BeginNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange) {
                        return Each0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyRange.LongFixnumRange) {
                        return Each1Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyRange.ObjectRange) {
                        return Each2Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
    public static final class ExcludeEndNodeFactory
    extends NodeFactoryBase<RangeNodes.ExcludeEndNode> {
        private static ExcludeEndNodeFactory excludeEndNodeFactoryInstance;

        private ExcludeEndNodeFactory() {
            super(RangeNodes.ExcludeEndNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.ExcludeEndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExcludeEndNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.ExcludeEndNode> getInstance() {
            if (excludeEndNodeFactoryInstance == null) {
                excludeEndNodeFactoryInstance = new ExcludeEndNodeFactory();
            }
            return excludeEndNodeFactoryInstance;
        }

        public static RangeNodes.ExcludeEndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExcludeEndNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        public static final class ExcludeEndNodeGen
        extends RangeNodes.ExcludeEndNode {
            @Node.Child
            private RubyNode arguments0_;

            private ExcludeEndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyRange arguments0Value_;
                try {
                    arguments0Value_ = ExcludeEndNodeGen.expectRubyRange(this.arguments0_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.excludeEnd(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }

            private static RubyRange expectRubyRange(Object value) throws UnexpectedResultException {
                if (value instanceof RubyRange) {
                    return (RubyRange)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<RangeNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(RangeNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        public static RangeNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        public static final class EachNodeGen
        extends RangeNodes.EachNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="each(VirtualFrame, ObjectRange, RubyBasicObject)", value=RangeNodes.EachNode.class)
            private static final class Each4Node_
            extends BaseNode_ {
                Each4Node_(EachNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments1Value instanceof RubyBasicObject) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new Each4Node_(root);
                }
            }

            @GeneratedBy(methodName="each(VirtualFrame, ObjectRange, NotProvided)", value=RangeNodes.EachNode.class)
            private static final class Each3Node_
            extends BaseNode_ {
                Each3Node_(EachNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments1Value instanceof NotProvided) {
                        RubyRange.ObjectRange arguments0Value_ = (RubyRange.ObjectRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new Each3Node_(root);
                }
            }

            @GeneratedBy(methodName="each(VirtualFrame, LongFixnumRange, NotProvided)", value=RangeNodes.EachNode.class)
            private static final class Each2Node_
            extends BaseNode_ {
                Each2Node_(EachNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments1Value instanceof NotProvided) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new Each2Node_(root);
                }
            }

            @GeneratedBy(methodName="each(VirtualFrame, LongFixnumRange, RubyBasicObject)", value=RangeNodes.EachNode.class)
            private static final class Each1Node_
            extends BaseNode_ {
                Each1Node_(EachNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyRange.LongFixnumRange && arguments1Value instanceof RubyBasicObject) {
                        RubyRange.LongFixnumRange arguments0Value_ = (RubyRange.LongFixnumRange)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new Each1Node_(root);
                }
            }

            @GeneratedBy(methodName="each(VirtualFrame, IntegerFixnumRange, RubyBasicObject)", value=RangeNodes.EachNode.class)
            private static final class Each0Node_
            extends BaseNode_ {
                Each0Node_(EachNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyRange.IntegerFixnumRange && arguments1Value instanceof RubyBasicObject) {
                        RubyRange.IntegerFixnumRange arguments0Value_ = (RubyRange.IntegerFixnumRange)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new Each0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EachNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EachNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EachNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EachNodeGen root;

                BaseNode_(EachNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments1Value instanceof RubyBasicObject) {
                        arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (arguments0Value instanceof RubyRange.IntegerFixnumRange && RubyGuards.isRubyProc(arguments1Value_)) {
                            return Each0Node_.create(this.root);
                        }
                        if (arguments0Value instanceof RubyRange.LongFixnumRange && RubyGuards.isRubyProc(arguments1Value_)) {
                            return Each1Node_.create(this.root);
                        }
                    }
                    if (arguments1Value instanceof NotProvided) {
                        if (arguments0Value instanceof RubyRange.LongFixnumRange) {
                            return Each2Node_.create(this.root);
                        }
                        if (arguments0Value instanceof RubyRange.ObjectRange) {
                            return Each3Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof RubyRange.ObjectRange && arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                        return Each4Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.CollectNode.class)
    public static final class CollectNodeFactory
    extends NodeFactoryBase<RangeNodes.CollectNode> {
        private static CollectNodeFactory collectNodeFactoryInstance;

        private CollectNodeFactory() {
            super(RangeNodes.CollectNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RangeNodes.CollectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CollectNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.CollectNode> getInstance() {
            if (collectNodeFactoryInstance == null) {
                collectNodeFactoryInstance = new CollectNodeFactory();
            }
            return collectNodeFactoryInstance;
        }

        public static RangeNodes.CollectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CollectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        public static final class CollectNodeGen
        extends RangeNodes.CollectNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private CollectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value_;
                RubyRange.IntegerFixnumRange arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyProc(arguments1Value_)) {
                    return this.collect(frameValue, arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }
}

