/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=BignumNodes.class)
public final class BignumNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(NegNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), MulNodeFactory.getInstance(), DivNodeFactory.getInstance(), ModNodeFactory.getInstance(), LessNodeFactory.getInstance(), LessEqualNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), GreaterEqualNodeFactory.getInstance(), GreaterNodeFactory.getInstance(), BitAndNodeFactory.getInstance(), BitOrNodeFactory.getInstance(), BitXOrNodeFactory.getInstance(), LeftShiftNodeFactory.getInstance(), RightShiftNodeFactory.getInstance(), AbsNodeFactory.getInstance(), BitLengthNodeFactory.getInstance(), CoerceNodeFactory.getInstance(), DivModNodeFactory.getInstance(), EvenNodeFactory.getInstance(), HashNodeFactory.getInstance(), OddNodeFactory.getInstance(), SizeNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance());
    }

    @GeneratedBy(value=BignumNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<BignumNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(BignumNodes.ToSNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static BignumNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends BignumNodes.ToSNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToSNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="toS(RubyBasicObject, int)", value=BignumNodes.ToSNode.class)
            private static final class ToS1Node_
            extends BaseNode_ {
                ToS1Node_(ToSNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.toS(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.toS(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new ToS1Node_(root);
                }
            }

            @GeneratedBy(methodName="toS(RubyBasicObject, NotProvided)", value=BignumNodes.ToSNode.class)
            private static final class ToS0Node_
            extends BaseNode_ {
                ToS0Node_(ToSNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.toS(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new ToS0Node_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.ToSNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToSNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.ToSNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToSNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.ToSNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToSNodeGen root;

                BaseNode_(ToSNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            return ToS0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer) {
                            return ToS1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<BignumNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(BignumNodes.ToFNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        public static BignumNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToFNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.ToFNode.class)
        public static final class ToFNodeGen
        extends BignumNodes.ToFNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToFNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDouble(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDouble(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toF(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<BignumNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(BignumNodes.SizeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static BignumNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends BignumNodes.SizeNode {
            @Node.Child
            private RubyNode arguments0_;

            private SizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.size(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.OddNode.class)
    public static final class OddNodeFactory
    extends NodeFactoryBase<BignumNodes.OddNode> {
        private static OddNodeFactory oddNodeFactoryInstance;

        private OddNodeFactory() {
            super(BignumNodes.OddNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.OddNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OddNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.OddNode> getInstance() {
            if (oddNodeFactoryInstance == null) {
                oddNodeFactoryInstance = new OddNodeFactory();
            }
            return oddNodeFactoryInstance;
        }

        public static BignumNodes.OddNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new OddNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.OddNode.class)
        public static final class OddNodeGen
        extends BignumNodes.OddNode {
            @Node.Child
            private RubyNode arguments0_;

            private OddNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.odd(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<BignumNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(BignumNodes.HashNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        public static BignumNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HashNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.HashNode.class)
        public static final class HashNodeGen
        extends BignumNodes.HashNode {
            @Node.Child
            private RubyNode arguments0_;

            private HashNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.hash(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.EvenNode.class)
    public static final class EvenNodeFactory
    extends NodeFactoryBase<BignumNodes.EvenNode> {
        private static EvenNodeFactory evenNodeFactoryInstance;

        private EvenNodeFactory() {
            super(BignumNodes.EvenNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.EvenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EvenNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.EvenNode> getInstance() {
            if (evenNodeFactoryInstance == null) {
                evenNodeFactoryInstance = new EvenNodeFactory();
            }
            return evenNodeFactoryInstance;
        }

        public static BignumNodes.EvenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EvenNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.EvenNode.class)
        public static final class EvenNodeGen
        extends BignumNodes.EvenNode {
            @Node.Child
            private RubyNode arguments0_;

            private EvenNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.even(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.DivModNode.class)
    public static final class DivModNodeFactory
    extends NodeFactoryBase<BignumNodes.DivModNode> {
        private static DivModNodeFactory divModNodeFactoryInstance;

        private DivModNodeFactory() {
            super(BignumNodes.DivModNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.DivModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivModNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.DivModNode> getInstance() {
            if (divModNodeFactoryInstance == null) {
                divModNodeFactoryInstance = new DivModNodeFactory();
            }
            return divModNodeFactoryInstance;
        }

        public static BignumNodes.DivModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DivModNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.DivModNode.class)
        public static final class DivModNodeGen
        extends BignumNodes.DivModNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private DivModNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="divMod(RubyBasicObject, RubyBasicObject)", value=BignumNodes.DivModNode.class)
            private static final class DivMod1Node_
            extends BaseNode_ {
                DivMod1Node_(DivModNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.divMod(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new DivMod1Node_(root);
                }
            }

            @GeneratedBy(methodName="divMod(RubyBasicObject, long)", value=BignumNodes.DivModNode.class)
            private static final class DivMod0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                DivMod0Node_(DivModNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((DivMod0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.divMod(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.divMod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root, Object arguments1Value) {
                    return new DivMod0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.DivModNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DivModNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.DivModNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DivModNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.DivModNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DivModNodeGen root;

                BaseNode_(DivModNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return DivMod0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return DivMod1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.CoerceNode.class)
    public static final class CoerceNodeFactory
    extends NodeFactoryBase<BignumNodes.CoerceNode> {
        private static CoerceNodeFactory coerceNodeFactoryInstance;

        private CoerceNodeFactory() {
            super(BignumNodes.CoerceNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.CoerceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CoerceNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.CoerceNode> getInstance() {
            if (coerceNodeFactoryInstance == null) {
                coerceNodeFactoryInstance = new CoerceNodeFactory();
            }
            return coerceNodeFactoryInstance;
        }

        public static BignumNodes.CoerceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CoerceNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.CoerceNode.class)
        public static final class CoerceNodeGen
        extends BignumNodes.CoerceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CoerceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="coerce(RubyBasicObject, RubyBasicObject)", value=BignumNodes.CoerceNode.class)
            private static final class Coerce2Node_
            extends BaseNode_ {
                Coerce2Node_(CoerceNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.coerce(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CoerceNodeGen root) {
                    return new Coerce2Node_(root);
                }
            }

            @GeneratedBy(methodName="coerce(RubyBasicObject, long)", value=BignumNodes.CoerceNode.class)
            private static final class Coerce1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Coerce1Node_(CoerceNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Coerce1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.coerce(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.coerce(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CoerceNodeGen root, Object arguments1Value) {
                    return new Coerce1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="coerce(RubyBasicObject, int)", value=BignumNodes.CoerceNode.class)
            private static final class Coerce0Node_
            extends BaseNode_ {
                Coerce0Node_(CoerceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.coerce(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.coerce(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CoerceNodeGen root) {
                    return new Coerce0Node_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.CoerceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CoerceNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CoerceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.CoerceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CoerceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CoerceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.CoerceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CoerceNodeGen root;

                BaseNode_(CoerceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (arguments1Value instanceof Integer) {
                            return Coerce0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Coerce1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Coerce2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.BitLengthNode.class)
    public static final class BitLengthNodeFactory
    extends NodeFactoryBase<BignumNodes.BitLengthNode> {
        private static BitLengthNodeFactory bitLengthNodeFactoryInstance;

        private BitLengthNodeFactory() {
            super(BignumNodes.BitLengthNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.BitLengthNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitLengthNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.BitLengthNode> getInstance() {
            if (bitLengthNodeFactoryInstance == null) {
                bitLengthNodeFactoryInstance = new BitLengthNodeFactory();
            }
            return bitLengthNodeFactoryInstance;
        }

        public static BignumNodes.BitLengthNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitLengthNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.BitLengthNode.class)
        public static final class BitLengthNodeGen
        extends BignumNodes.BitLengthNode {
            @Node.Child
            private RubyNode arguments0_;

            private BitLengthNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.bitLength(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.AbsNode.class)
    public static final class AbsNodeFactory
    extends NodeFactoryBase<BignumNodes.AbsNode> {
        private static AbsNodeFactory absNodeFactoryInstance;

        private AbsNodeFactory() {
            super(BignumNodes.AbsNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.AbsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.AbsNode> getInstance() {
            if (absNodeFactoryInstance == null) {
                absNodeFactoryInstance = new AbsNodeFactory();
            }
            return absNodeFactoryInstance;
        }

        public static BignumNodes.AbsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AbsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.AbsNode.class)
        public static final class AbsNodeGen
        extends BignumNodes.AbsNode {
            @Node.Child
            private RubyNode arguments0_;

            private AbsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.abs(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.RightShiftNode.class)
    public static final class RightShiftNodeFactory
    extends NodeFactoryBase<BignumNodes.RightShiftNode> {
        private static RightShiftNodeFactory rightShiftNodeFactoryInstance;

        private RightShiftNodeFactory() {
            super(BignumNodes.RightShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.RightShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RightShiftNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.RightShiftNode> getInstance() {
            if (rightShiftNodeFactoryInstance == null) {
                rightShiftNodeFactoryInstance = new RightShiftNodeFactory();
            }
            return rightShiftNodeFactoryInstance;
        }

        public static BignumNodes.RightShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RightShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.RightShiftNode.class)
        public static final class RightShiftNodeGen
        extends BignumNodes.RightShiftNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private RightShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.leftShift(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.LeftShiftNode.class)
    public static final class LeftShiftNodeFactory
    extends NodeFactoryBase<BignumNodes.LeftShiftNode> {
        private static LeftShiftNodeFactory leftShiftNodeFactoryInstance;

        private LeftShiftNodeFactory() {
            super(BignumNodes.LeftShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.LeftShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LeftShiftNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.LeftShiftNode> getInstance() {
            if (leftShiftNodeFactoryInstance == null) {
                leftShiftNodeFactoryInstance = new LeftShiftNodeFactory();
            }
            return leftShiftNodeFactoryInstance;
        }

        public static BignumNodes.LeftShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LeftShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.LeftShiftNode.class)
        public static final class LeftShiftNodeGen
        extends BignumNodes.LeftShiftNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private LeftShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.leftShift(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=BignumNodes.BitXOrNode.class)
    public static final class BitXOrNodeFactory
    extends NodeFactoryBase<BignumNodes.BitXOrNode> {
        private static BitXOrNodeFactory bitXOrNodeFactoryInstance;

        private BitXOrNodeFactory() {
            super(BignumNodes.BitXOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.BitXOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitXOrNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.BitXOrNode> getInstance() {
            if (bitXOrNodeFactoryInstance == null) {
                bitXOrNodeFactoryInstance = new BitXOrNodeFactory();
            }
            return bitXOrNodeFactoryInstance;
        }

        public static BignumNodes.BitXOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitXOrNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.BitXOrNode.class)
        public static final class BitXOrNodeGen
        extends BignumNodes.BitXOrNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BitXOrNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="bitXOr(RubyBasicObject, RubyBasicObject)", value=BignumNodes.BitXOrNode.class)
            private static final class BitXOr1Node_
            extends BaseNode_ {
                BitXOr1Node_(BitXOrNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.bitXOr(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root) {
                    return new BitXOr1Node_(root);
                }
            }

            @GeneratedBy(methodName="bitXOr(RubyBasicObject, long)", value=BignumNodes.BitXOrNode.class)
            private static final class BitXOr0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                BitXOr0Node_(BitXOrNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((BitXOr0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.bitXOr(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.bitXOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root, Object arguments1Value) {
                    return new BitXOr0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.BitXOrNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BitXOrNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.BitXOrNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BitXOrNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.BitXOrNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BitXOrNodeGen root;

                BaseNode_(BitXOrNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return BitXOr0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return BitXOr1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.BitOrNode.class)
    public static final class BitOrNodeFactory
    extends NodeFactoryBase<BignumNodes.BitOrNode> {
        private static BitOrNodeFactory bitOrNodeFactoryInstance;

        private BitOrNodeFactory() {
            super(BignumNodes.BitOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.BitOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitOrNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.BitOrNode> getInstance() {
            if (bitOrNodeFactoryInstance == null) {
                bitOrNodeFactoryInstance = new BitOrNodeFactory();
            }
            return bitOrNodeFactoryInstance;
        }

        public static BignumNodes.BitOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitOrNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.BitOrNode.class)
        public static final class BitOrNodeGen
        extends BignumNodes.BitOrNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BitOrNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="bitOr(RubyBasicObject, RubyBasicObject)", value=BignumNodes.BitOrNode.class)
            private static final class BitOr1Node_
            extends BaseNode_ {
                BitOr1Node_(BitOrNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.bitOr(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root) {
                    return new BitOr1Node_(root);
                }
            }

            @GeneratedBy(methodName="bitOr(RubyBasicObject, long)", value=BignumNodes.BitOrNode.class)
            private static final class BitOr0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                BitOr0Node_(BitOrNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((BitOr0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.bitOr(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.bitOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root, Object arguments1Value) {
                    return new BitOr0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.BitOrNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BitOrNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.BitOrNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BitOrNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.BitOrNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BitOrNodeGen root;

                BaseNode_(BitOrNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return BitOr0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return BitOr1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.BitAndNode.class)
    public static final class BitAndNodeFactory
    extends NodeFactoryBase<BignumNodes.BitAndNode> {
        private static BitAndNodeFactory bitAndNodeFactoryInstance;

        private BitAndNodeFactory() {
            super(BignumNodes.BitAndNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.BitAndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitAndNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.BitAndNode> getInstance() {
            if (bitAndNodeFactoryInstance == null) {
                bitAndNodeFactoryInstance = new BitAndNodeFactory();
            }
            return bitAndNodeFactoryInstance;
        }

        public static BignumNodes.BitAndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitAndNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.BitAndNode.class)
        public static final class BitAndNodeGen
        extends BignumNodes.BitAndNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BitAndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="bitAnd(RubyBasicObject, RubyBasicObject)", value=BignumNodes.BitAndNode.class)
            private static final class BitAnd1Node_
            extends BaseNode_ {
                BitAnd1Node_(BitAndNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.bitAnd(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root) {
                    return new BitAnd1Node_(root);
                }
            }

            @GeneratedBy(methodName="bitAnd(RubyBasicObject, long)", value=BignumNodes.BitAndNode.class)
            private static final class BitAnd0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                BitAnd0Node_(BitAndNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((BitAnd0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.bitAnd(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.bitAnd(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root, Object arguments1Value) {
                    return new BitAnd0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.BitAndNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BitAndNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.BitAndNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BitAndNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.BitAndNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BitAndNodeGen root;

                BaseNode_(BitAndNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return BitAnd0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return BitAnd1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.GreaterNode.class)
    public static final class GreaterNodeFactory
    extends NodeFactoryBase<BignumNodes.GreaterNode> {
        private static GreaterNodeFactory greaterNodeFactoryInstance;

        private GreaterNodeFactory() {
            super(BignumNodes.GreaterNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.GreaterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.GreaterNode> getInstance() {
            if (greaterNodeFactoryInstance == null) {
                greaterNodeFactoryInstance = new GreaterNodeFactory();
            }
            return greaterNodeFactoryInstance;
        }

        public static BignumNodes.GreaterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GreaterNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        public static final class GreaterNodeGen
        extends BignumNodes.GreaterNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GreaterNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="greaterCoerced(VirtualFrame, RubyBasicObject, Object)", value=BignumNodes.GreaterNode.class)
            private static final class GreaterCoercedNode_
            extends BaseNode_ {
                GreaterCoercedNode_(GreaterNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.greaterCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new GreaterCoercedNode_(root);
                }
            }

            @GeneratedBy(methodName="greater(RubyBasicObject, RubyBasicObject)", value=BignumNodes.GreaterNode.class)
            private static final class Greater2Node_
            extends BaseNode_ {
                Greater2Node_(GreaterNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.greater(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new Greater2Node_(root);
                }
            }

            @GeneratedBy(methodName="greater(RubyBasicObject, double)", value=BignumNodes.GreaterNode.class)
            private static final class Greater1Node_
            extends BaseNode_ {
                Greater1Node_(GreaterNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.greater(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new Greater1Node_(root);
                }
            }

            @GeneratedBy(methodName="greater(RubyBasicObject, long)", value=BignumNodes.GreaterNode.class)
            private static final class Greater0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Greater0Node_(GreaterNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Greater0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.greater(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root, Object arguments1Value) {
                    return new Greater0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.GreaterNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GreaterNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.GreaterNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GreaterNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.GreaterNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GreaterNodeGen root;

                BaseNode_(GreaterNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return GreaterNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Greater0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Greater1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Greater2Node_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return GreaterCoercedNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
    public static final class GreaterEqualNodeFactory
    extends NodeFactoryBase<BignumNodes.GreaterEqualNode> {
        private static GreaterEqualNodeFactory greaterEqualNodeFactoryInstance;

        private GreaterEqualNodeFactory() {
            super(BignumNodes.GreaterEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.GreaterEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.GreaterEqualNode> getInstance() {
            if (greaterEqualNodeFactoryInstance == null) {
                greaterEqualNodeFactoryInstance = new GreaterEqualNodeFactory();
            }
            return greaterEqualNodeFactoryInstance;
        }

        public static BignumNodes.GreaterEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GreaterEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        public static final class GreaterEqualNodeGen
        extends BignumNodes.GreaterEqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GreaterEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="greaterEqualCoerced(VirtualFrame, RubyBasicObject, Object)", value=BignumNodes.GreaterEqualNode.class)
            private static final class GreaterEqualCoercedNode_
            extends BaseNode_ {
                GreaterEqualCoercedNode_(GreaterEqualNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.greaterEqualCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new GreaterEqualCoercedNode_(root);
                }
            }

            @GeneratedBy(methodName="greaterEqual(RubyBasicObject, RubyBasicObject)", value=BignumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual2Node_
            extends BaseNode_ {
                GreaterEqual2Node_(GreaterEqualNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new GreaterEqual2Node_(root);
                }
            }

            @GeneratedBy(methodName="greaterEqual(RubyBasicObject, double)", value=BignumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual1Node_
            extends BaseNode_ {
                GreaterEqual1Node_(GreaterEqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new GreaterEqual1Node_(root);
                }
            }

            @GeneratedBy(methodName="greaterEqual(RubyBasicObject, long)", value=BignumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                GreaterEqual0Node_(GreaterEqualNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GreaterEqual0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root, Object arguments1Value) {
                    return new GreaterEqual0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GreaterEqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GreaterEqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GreaterEqualNodeGen root;

                BaseNode_(GreaterEqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return GreaterEqualNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return GreaterEqual0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return GreaterEqual1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return GreaterEqual2Node_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return GreaterEqualCoercedNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<BignumNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(BignumNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static BignumNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends BignumNodes.CompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="compare(RubyBasicObject, RubyBasicObject)", value=BignumNodes.CompareNode.class)
            private static final class Compare2Node_
            extends BaseNode_ {
                Compare2Node_(CompareNodeGen root) {
                    super(root, 3);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare2Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(RubyBasicObject, double)", value=BignumNodes.CompareNode.class)
            private static final class Compare1Node_
            extends BaseNode_ {
                Compare1Node_(CompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.compare(arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare1Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(RubyBasicObject, long)", value=BignumNodes.CompareNode.class)
            private static final class Compare0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Compare0Node_(CompareNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Compare0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.compare(arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root, Object arguments1Value) {
                    return new Compare0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.CompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompareNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.CompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.CompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CompareNodeGen root;

                BaseNode_(CompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Compare0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Compare1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Compare2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<BignumNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(BignumNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        public static BignumNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        public static final class EqualNodeGen
        extends BignumNodes.EqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private EqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="equal(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BignumNodes.EqualNode.class)
            private static final class Equal4Node_
            extends BaseNode_ {
                Equal4Node_(EqualNodeGen root) {
                    super(root, 5);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.equal(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.equal(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal4Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(RubyBasicObject, RubyBasicObject)", value=BignumNodes.EqualNode.class)
            private static final class Equal3Node_
            extends BaseNode_ {
                Equal3Node_(EqualNodeGen root) {
                    super(root, 4);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.equal(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal3Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(RubyBasicObject, double)", value=BignumNodes.EqualNode.class)
            private static final class Equal2Node_
            extends BaseNode_ {
                Equal2Node_(EqualNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal2Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(RubyBasicObject, long)", value=BignumNodes.EqualNode.class)
            private static final class Equal1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Equal1Node_(EqualNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Equal1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root, Object arguments1Value) {
                    return new Equal1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="equal(RubyBasicObject, int)", value=BignumNodes.EqualNode.class)
            private static final class Equal0Node_
            extends BaseNode_ {
                Equal0Node_(EqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal0Node_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.EqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.EqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.EqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EqualNodeGen root;

                BaseNode_(EqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        if (arguments1Value instanceof Integer) {
                            return Equal0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Equal1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Equal2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments1Value_)) {
                                return Equal3Node_.create(this.root);
                            }
                            return Equal4Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.LessEqualNode.class)
    public static final class LessEqualNodeFactory
    extends NodeFactoryBase<BignumNodes.LessEqualNode> {
        private static LessEqualNodeFactory lessEqualNodeFactoryInstance;

        private LessEqualNodeFactory() {
            super(BignumNodes.LessEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.LessEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.LessEqualNode> getInstance() {
            if (lessEqualNodeFactoryInstance == null) {
                lessEqualNodeFactoryInstance = new LessEqualNodeFactory();
            }
            return lessEqualNodeFactoryInstance;
        }

        public static BignumNodes.LessEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LessEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        public static final class LessEqualNodeGen
        extends BignumNodes.LessEqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LessEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="lessEqualCoerced(VirtualFrame, RubyBasicObject, Object)", value=BignumNodes.LessEqualNode.class)
            private static final class LessEqualCoercedNode_
            extends BaseNode_ {
                LessEqualCoercedNode_(LessEqualNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.lessEqualCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new LessEqualCoercedNode_(root);
                }
            }

            @GeneratedBy(methodName="lessEqual(RubyBasicObject, RubyBasicObject)", value=BignumNodes.LessEqualNode.class)
            private static final class LessEqual2Node_
            extends BaseNode_ {
                LessEqual2Node_(LessEqualNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.lessEqual(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new LessEqual2Node_(root);
                }
            }

            @GeneratedBy(methodName="lessEqual(RubyBasicObject, double)", value=BignumNodes.LessEqualNode.class)
            private static final class LessEqual1Node_
            extends BaseNode_ {
                LessEqual1Node_(LessEqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.lessEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new LessEqual1Node_(root);
                }
            }

            @GeneratedBy(methodName="lessEqual(RubyBasicObject, long)", value=BignumNodes.LessEqualNode.class)
            private static final class LessEqual0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                LessEqual0Node_(LessEqualNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((LessEqual0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.lessEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root, Object arguments1Value) {
                    return new LessEqual0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.LessEqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LessEqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.LessEqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LessEqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.LessEqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LessEqualNodeGen root;

                BaseNode_(LessEqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LessEqualNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return LessEqual0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return LessEqual1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return LessEqual2Node_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return LessEqualCoercedNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.LessNode.class)
    public static final class LessNodeFactory
    extends NodeFactoryBase<BignumNodes.LessNode> {
        private static LessNodeFactory lessNodeFactoryInstance;

        private LessNodeFactory() {
            super(BignumNodes.LessNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.LessNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.LessNode> getInstance() {
            if (lessNodeFactoryInstance == null) {
                lessNodeFactoryInstance = new LessNodeFactory();
            }
            return lessNodeFactoryInstance;
        }

        public static BignumNodes.LessNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LessNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        public static final class LessNodeGen
        extends BignumNodes.LessNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LessNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="lessCoerced(VirtualFrame, RubyBasicObject, Object)", value=BignumNodes.LessNode.class)
            private static final class LessCoercedNode_
            extends BaseNode_ {
                LessCoercedNode_(LessNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.lessCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new LessCoercedNode_(root);
                }
            }

            @GeneratedBy(methodName="less(RubyBasicObject, RubyBasicObject)", value=BignumNodes.LessNode.class)
            private static final class Less2Node_
            extends BaseNode_ {
                Less2Node_(LessNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.less(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new Less2Node_(root);
                }
            }

            @GeneratedBy(methodName="less(RubyBasicObject, double)", value=BignumNodes.LessNode.class)
            private static final class Less1Node_
            extends BaseNode_ {
                Less1Node_(LessNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.less(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new Less1Node_(root);
                }
            }

            @GeneratedBy(methodName="less(RubyBasicObject, long)", value=BignumNodes.LessNode.class)
            private static final class Less0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Less0Node_(LessNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Less0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.less(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root, Object arguments1Value) {
                    return new Less0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.LessNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LessNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.LessNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LessNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.LessNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LessNodeGen root;

                BaseNode_(LessNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LessNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Less0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Less1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Less2Node_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return LessCoercedNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.ModNode.class)
    public static final class ModNodeFactory
    extends NodeFactoryBase<BignumNodes.ModNode> {
        private static ModNodeFactory modNodeFactoryInstance;

        private ModNodeFactory() {
            super(BignumNodes.ModNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.ModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.ModNode> getInstance() {
            if (modNodeFactoryInstance == null) {
                modNodeFactoryInstance = new ModNodeFactory();
            }
            return modNodeFactoryInstance;
        }

        public static BignumNodes.ModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ModNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.ModNode.class)
        public static final class ModNodeGen
        extends BignumNodes.ModNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ModNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="mod(VirtualFrame, RubyBasicObject, Object)", value=BignumNodes.ModNode.class)
            private static final class Mod2Node_
            extends BaseNode_ {
                Mod2Node_(ModNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!(RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isRubyBignum(arguments1Value))) {
                            return this.root.mod(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root) {
                    return new Mod2Node_(root);
                }
            }

            @GeneratedBy(methodName="mod(RubyBasicObject, RubyBasicObject)", value=BignumNodes.ModNode.class)
            private static final class Mod1Node_
            extends BaseNode_ {
                Mod1Node_(ModNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.mod(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root) {
                    return new Mod1Node_(root);
                }
            }

            @GeneratedBy(methodName="mod(RubyBasicObject, long)", value=BignumNodes.ModNode.class)
            private static final class Mod0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Mod0Node_(ModNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Mod0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.mod(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.mod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root, Object arguments1Value) {
                    return new Mod0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.ModNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ModNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.ModNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ModNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.ModNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ModNodeGen root;

                BaseNode_(ModNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Mod0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Mod1Node_.create(this.root);
                        }
                        if (!(RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isRubyBignum(arguments1Value))) {
                            return Mod2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.DivNode.class)
    public static final class DivNodeFactory
    extends NodeFactoryBase<BignumNodes.DivNode> {
        private static DivNodeFactory divNodeFactoryInstance;

        private DivNodeFactory() {
            super(BignumNodes.DivNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.DivNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.DivNode> getInstance() {
            if (divNodeFactoryInstance == null) {
                divNodeFactoryInstance = new DivNodeFactory();
            }
            return divNodeFactoryInstance;
        }

        public static BignumNodes.DivNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DivNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        public static final class DivNodeGen
        extends BignumNodes.DivNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private DivNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="div(RubyBasicObject, RubyBasicObject)", value=BignumNodes.DivNode.class)
            private static final class Div2Node_
            extends BaseNode_ {
                Div2Node_(DivNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.div(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new Div2Node_(root);
                }
            }

            @GeneratedBy(methodName="div(RubyBasicObject, double)", value=BignumNodes.DivNode.class)
            private static final class Div1Node_
            extends BaseNode_ {
                Div1Node_(DivNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return DivNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return DivNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.div(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.div(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new Div1Node_(root);
                }
            }

            @GeneratedBy(methodName="div(RubyBasicObject, long)", value=BignumNodes.DivNode.class)
            private static final class Div0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Div0Node_(DivNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Div0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.div(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.div(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root, Object arguments1Value) {
                    return new Div0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.DivNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DivNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.DivNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DivNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.DivNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DivNodeGen root;

                BaseNode_(DivNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return DivNodeGen.expectDouble(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Div0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Div1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Div2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<BignumNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(BignumNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        public static BignumNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MulNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        public static final class MulNodeGen
        extends BignumNodes.MulNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private MulNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="mul(RubyBasicObject, RubyBasicObject)", value=BignumNodes.MulNode.class)
            private static final class Mul2Node_
            extends BaseNode_ {
                Mul2Node_(MulNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.mul(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Mul2Node_(root);
                }
            }

            @GeneratedBy(methodName="mul(RubyBasicObject, double)", value=BignumNodes.MulNode.class)
            private static final class Mul1Node_
            extends BaseNode_ {
                Mul1Node_(MulNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return MulNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.mul(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.mul(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Mul1Node_(root);
                }
            }

            @GeneratedBy(methodName="mul(RubyBasicObject, long)", value=BignumNodes.MulNode.class)
            private static final class Mul0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Mul0Node_(MulNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Mul0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.mul(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.mul(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments1Value) {
                    return new Mul0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.MulNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MulNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.MulNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MulNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.MulNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MulNodeGen root;

                BaseNode_(MulNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return MulNodeGen.expectDouble(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Mul0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Mul1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Mul2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.SubNode.class)
    public static final class SubNodeFactory
    extends NodeFactoryBase<BignumNodes.SubNode> {
        private static SubNodeFactory subNodeFactoryInstance;

        private SubNodeFactory() {
            super(BignumNodes.SubNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.SubNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.SubNode> getInstance() {
            if (subNodeFactoryInstance == null) {
                subNodeFactoryInstance = new SubNodeFactory();
            }
            return subNodeFactoryInstance;
        }

        public static BignumNodes.SubNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SubNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        public static final class SubNodeGen
        extends BignumNodes.SubNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SubNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="sub(RubyBasicObject, RubyBasicObject)", value=BignumNodes.SubNode.class)
            private static final class Sub2Node_
            extends BaseNode_ {
                Sub2Node_(SubNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.sub(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new Sub2Node_(root);
                }
            }

            @GeneratedBy(methodName="sub(RubyBasicObject, double)", value=BignumNodes.SubNode.class)
            private static final class Sub1Node_
            extends BaseNode_ {
                Sub1Node_(SubNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return SubNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return SubNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.sub(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.sub(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new Sub1Node_(root);
                }
            }

            @GeneratedBy(methodName="sub(RubyBasicObject, long)", value=BignumNodes.SubNode.class)
            private static final class Sub0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Sub0Node_(SubNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Sub0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.sub(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.sub(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root, Object arguments1Value) {
                    return new Sub0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.SubNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SubNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.SubNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SubNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.SubNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SubNodeGen root;

                BaseNode_(SubNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return SubNodeGen.expectDouble(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Sub0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Sub1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Sub2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<BignumNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(BignumNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AddNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        public static BignumNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AddNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        public static final class AddNodeGen
        extends BignumNodes.AddNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private AddNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="add(RubyBasicObject, RubyBasicObject)", value=BignumNodes.AddNode.class)
            private static final class Add2Node_
            extends BaseNode_ {
                Add2Node_(AddNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.add(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new Add2Node_(root);
                }
            }

            @GeneratedBy(methodName="add(RubyBasicObject, double)", value=BignumNodes.AddNode.class)
            private static final class Add1Node_
            extends BaseNode_ {
                Add1Node_(AddNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return AddNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return AddNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.add(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new Add1Node_(root);
                }
            }

            @GeneratedBy(methodName="add(RubyBasicObject, long)", value=BignumNodes.AddNode.class)
            private static final class Add0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Add0Node_(AddNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Add0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.add(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root, Object arguments1Value) {
                    return new Add0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BignumNodes.AddNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AddNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.AddNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AddNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BignumNodes.AddNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AddNodeGen root;

                BaseNode_(AddNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return AddNodeGen.expectDouble(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Add0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Add1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Add2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BignumNodes.NegNode.class)
    public static final class NegNodeFactory
    extends NodeFactoryBase<BignumNodes.NegNode> {
        private static NegNodeFactory negNodeFactoryInstance;

        private NegNodeFactory() {
            super(BignumNodes.NegNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BignumNodes.NegNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NegNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BignumNodes.NegNode> getInstance() {
            if (negNodeFactoryInstance == null) {
                negNodeFactoryInstance = new NegNodeFactory();
            }
            return negNodeFactoryInstance;
        }

        public static BignumNodes.NegNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NegNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BignumNodes.NegNode.class)
        public static final class NegNodeGen
        extends BignumNodes.NegNode {
            @Node.Child
            private RubyNode arguments0_;

            private NegNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.neg(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }
}

