/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=BasicObjectNodes.class)
public final class BasicObjectNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(NotNodeFactory.getInstance(), NotEqualNodeFactory.getInstance(), ReferenceEqualNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InstanceEvalNodeFactory.getInstance(), InstanceExecNodeFactory.getInstance(), MethodMissingNodeFactory.getInstance(), SendNodeFactory.getInstance());
    }

    @GeneratedBy(value=BasicObjectNodes.SendNode.class)
    public static final class SendNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.SendNode> {
        private static SendNodeFactory sendNodeFactoryInstance;

        private SendNodeFactory() {
            super(BasicObjectNodes.SendNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.SendNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SendNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.SendNode> getInstance() {
            if (sendNodeFactoryInstance == null) {
                sendNodeFactoryInstance = new SendNodeFactory();
            }
            return sendNodeFactoryInstance;
        }

        public static BasicObjectNodes.SendNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SendNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.SendNode.class)
        public static final class SendNodeGen
        extends BasicObjectNodes.SendNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private SendNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="send(VirtualFrame, Object, Object[], RubyBasicObject)", value=BasicObjectNodes.SendNode.class)
            private static final class Send1Node_
            extends BaseNode_ {
                Send1Node_(SendNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof RubyBasicObject) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.send(frameValue, arguments0Value, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new Send1Node_(root);
                }
            }

            @GeneratedBy(methodName="send(VirtualFrame, Object, Object[], NotProvided)", value=BasicObjectNodes.SendNode.class)
            private static final class Send0Node_
            extends BaseNode_ {
                Send0Node_(SendNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.send(frameValue, arguments0Value, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new Send0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.SendNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SendNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.SendNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SendNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.SendNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SendNodeGen root;

                BaseNode_(SendNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[]) {
                        RubyBasicObject arguments2Value_;
                        if (arguments2Value instanceof NotProvided) {
                            return Send0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                            return Send1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
    public static final class MethodMissingNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.MethodMissingNode> {
        private static MethodMissingNodeFactory methodMissingNodeFactoryInstance;

        private MethodMissingNodeFactory() {
            super(BasicObjectNodes.MethodMissingNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.MethodMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodMissingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.MethodMissingNode> getInstance() {
            if (methodMissingNodeFactoryInstance == null) {
                methodMissingNodeFactoryInstance = new MethodMissingNodeFactory();
            }
            return methodMissingNodeFactoryInstance;
        }

        public static BasicObjectNodes.MethodMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MethodMissingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
        public static final class MethodMissingNodeGen
        extends BasicObjectNodes.MethodMissingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private MethodMissingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="methodMissing(Object, Object[], RubyBasicObject)", value=BasicObjectNodes.MethodMissingNode.class)
            private static final class MethodMissing1Node_
            extends BaseNode_ {
                MethodMissing1Node_(MethodMissingNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof RubyBasicObject) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.methodMissing(arguments0Value, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new MethodMissing1Node_(root);
                }
            }

            @GeneratedBy(methodName="methodMissing(Object, Object[], NotProvided)", value=BasicObjectNodes.MethodMissingNode.class)
            private static final class MethodMissing0Node_
            extends BaseNode_ {
                MethodMissing0Node_(MethodMissingNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.methodMissing(arguments0Value, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new MethodMissing0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MethodMissingNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MethodMissingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MethodMissingNodeGen root;

                BaseNode_(MethodMissingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[]) {
                        RubyBasicObject arguments2Value_;
                        if (arguments2Value instanceof NotProvided) {
                            return MethodMissing0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                            return MethodMissing1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
    public static final class InstanceExecNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InstanceExecNode> {
        private static InstanceExecNodeFactory instanceExecNodeFactoryInstance;

        private InstanceExecNodeFactory() {
            super(BasicObjectNodes.InstanceExecNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.InstanceExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceExecNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.InstanceExecNode> getInstance() {
            if (instanceExecNodeFactoryInstance == null) {
                instanceExecNodeFactoryInstance = new InstanceExecNodeFactory();
            }
            return instanceExecNodeFactoryInstance;
        }

        public static BasicObjectNodes.InstanceExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceExecNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
        public static final class InstanceExecNodeGen
        extends BasicObjectNodes.InstanceExecNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceExecNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="instanceExec(Object, Object[], NotProvided)", value=BasicObjectNodes.InstanceExecNode.class)
            private static final class InstanceExec1Node_
            extends BaseNode_ {
                InstanceExec1Node_(InstanceExecNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.instanceExec(arguments0Value, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new InstanceExec1Node_(root);
                }
            }

            @GeneratedBy(methodName="instanceExec(VirtualFrame, Object, Object[], RubyBasicObject)", value=BasicObjectNodes.InstanceExecNode.class)
            private static final class InstanceExec0Node_
            extends BaseNode_ {
                InstanceExec0Node_(InstanceExecNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof RubyBasicObject) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.instanceExec(frameValue, arguments0Value, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new InstanceExec0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceExecNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceExecNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InstanceExecNodeGen root;

                BaseNode_(InstanceExecNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[]) {
                        RubyBasicObject arguments2Value_;
                        if (arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                            return InstanceExec0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof NotProvided) {
                            return InstanceExec1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
    public static final class InstanceEvalNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InstanceEvalNode> {
        private static InstanceEvalNodeFactory instanceEvalNodeFactoryInstance;

        private InstanceEvalNodeFactory() {
            super(BasicObjectNodes.InstanceEvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.InstanceEvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceEvalNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.InstanceEvalNode> getInstance() {
            if (instanceEvalNodeFactoryInstance == null) {
                instanceEvalNodeFactoryInstance = new InstanceEvalNodeFactory();
            }
            return instanceEvalNodeFactoryInstance;
        }

        public static BasicObjectNodes.InstanceEvalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceEvalNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
        public static final class InstanceEvalNodeGen
        extends BasicObjectNodes.InstanceEvalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceEvalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="instanceEval(VirtualFrame, Object, NotProvided, RubyBasicObject)", value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class InstanceEval1Node_
            extends BaseNode_ {
                InstanceEval1Node_(InstanceEvalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof NotProvided && arguments2Value instanceof RubyBasicObject) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.instanceEval(frameValue, arguments0Value, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root) {
                    return new InstanceEval1Node_(root);
                }
            }

            @GeneratedBy(methodName="instanceEval(Object, RubyBasicObject, NotProvided)", value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class InstanceEval0Node_
            extends BaseNode_ {
                InstanceEval0Node_(InstanceEvalNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.instanceEval(arguments0Value, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root) {
                    return new InstanceEval0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceEvalNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceEvalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InstanceEvalNodeGen root;

                BaseNode_(InstanceEvalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments2Value_;
                    RubyBasicObject arguments1Value_;
                    if (arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided && RubyGuards.isRubyString(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                        return InstanceEval0Node_.create(this.root);
                    }
                    if (arguments1Value instanceof NotProvided && arguments2Value instanceof RubyBasicObject && RubyGuards.isRubyProc(arguments2Value_ = (RubyBasicObject)arguments2Value)) {
                        return InstanceEval1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(BasicObjectNodes.InitializeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static BasicObjectNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends BasicObjectNodes.InitializeNode {
            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.initialize();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException(this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
    public static final class ReferenceEqualNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.ReferenceEqualNode> {
        private static ReferenceEqualNodeFactory referenceEqualNodeFactoryInstance;

        private ReferenceEqualNodeFactory() {
            super(BasicObjectNodes.ReferenceEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public BasicObjectNodes.ReferenceEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ReferenceEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.ReferenceEqualNode> getInstance() {
            if (referenceEqualNodeFactoryInstance == null) {
                referenceEqualNodeFactoryInstance = new ReferenceEqualNodeFactory();
            }
            return referenceEqualNodeFactoryInstance;
        }

        public static BasicObjectNodes.ReferenceEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
            return new ReferenceEqualNodeGen(context, sourceSection, left, right);
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        public static final class ReferenceEqualNodeGen
        extends BasicObjectNodes.ReferenceEqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode left_;
            @Node.Child
            private RubyNode right_;
            @CompilerDirectives.CompilationFinal
            private Class<?> leftType_;
            @CompilerDirectives.CompilationFinal
            private Class<?> rightType_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReferenceEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
                super(context, sourceSection);
                this.left_ = left;
                this.right_ = right;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public RubyNode getLeft() {
                return this.left_;
            }

            @Override
            public RubyNode getRight() {
                return this.right_;
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                return this.specialization_.executeBoolean1(frameValue, leftValue, rightValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean0(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="equal(RubyBasicObject, Object)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal7Node_
            extends BaseNode_ {
                Equal7Node_(ReferenceEqualNodeGen root) {
                    super(root, 8);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    RubyBasicObject leftValue_;
                    try {
                        leftValue_ = this.root.left_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object rightValue = this.executeRight_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), rightValue);
                    }
                    Object rightValue_ = this.executeRight_(frameValue);
                    if (this.root.isNotRubyBasicObject(rightValue_)) {
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (leftValue instanceof RubyBasicObject) {
                        RubyBasicObject leftValue_ = (RubyBasicObject)leftValue;
                        if (this.root.isNotRubyBasicObject(rightValue)) {
                            return this.root.equal(leftValue_, rightValue);
                        }
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal7Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(Object, RubyBasicObject)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal6Node_
            extends BaseNode_ {
                Equal6Node_(ReferenceEqualNodeGen root) {
                    super(root, 7);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    RubyBasicObject rightValue_;
                    Object leftValue_ = this.executeLeft_(frameValue);
                    try {
                        rightValue_ = this.root.right_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, leftValue_, ex.getResult());
                    }
                    if (this.root.isNotRubyBasicObject(leftValue_)) {
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (rightValue instanceof RubyBasicObject) {
                        RubyBasicObject rightValue_ = (RubyBasicObject)rightValue;
                        if (this.root.isNotRubyBasicObject(leftValue)) {
                            return this.root.equal(leftValue, rightValue_);
                        }
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal6Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(Object, Object)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal5Node_
            extends BaseNode_ {
                Equal5Node_(ReferenceEqualNodeGen root) {
                    super(root, 6);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object leftValue_ = this.executeLeft_(frameValue);
                    Object rightValue_ = this.executeRight_(frameValue);
                    if (this.root.isNotRubyBasicObject(leftValue_) && this.root.isNotRubyBasicObject(rightValue_) && this.root.notSameClass(leftValue_, rightValue_)) {
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (this.root.isNotRubyBasicObject(leftValue) && this.root.isNotRubyBasicObject(rightValue) && this.root.notSameClass(leftValue, rightValue)) {
                        return this.root.equal(leftValue, rightValue);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal5Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(RubyBasicObject, RubyBasicObject)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal4Node_
            extends BaseNode_ {
                Equal4Node_(ReferenceEqualNodeGen root) {
                    super(root, 5);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    RubyBasicObject rightValue_;
                    RubyBasicObject leftValue_;
                    try {
                        leftValue_ = this.root.left_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object rightValue = this.executeRight_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), rightValue);
                    }
                    try {
                        rightValue_ = this.root.right_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, leftValue_, ex.getResult());
                    }
                    return this.root.equal(leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (leftValue instanceof RubyBasicObject && rightValue instanceof RubyBasicObject) {
                        RubyBasicObject leftValue_ = (RubyBasicObject)leftValue;
                        RubyBasicObject rightValue_ = (RubyBasicObject)rightValue;
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal4Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(double, double)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal3Node_
            extends BaseNode_ {
                Equal3Node_(ReferenceEqualNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    double rightValue_;
                    double leftValue_;
                    try {
                        leftValue_ = this.root.left_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object rightValue = this.executeRight_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), rightValue);
                    }
                    try {
                        rightValue_ = this.root.right_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, leftValue_, ex.getResult());
                    }
                    return this.root.equal(leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (leftValue instanceof Double && rightValue instanceof Double) {
                        double leftValue_ = (Double)leftValue;
                        double rightValue_ = (Double)rightValue;
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal3Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(long, long)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal2Node_
            extends BaseNode_ {
                private final Class<?> leftImplicitType;
                private final Class<?> rightImplicitType;

                Equal2Node_(ReferenceEqualNodeGen root, Object leftValue, Object rightValue) {
                    super(root, 3);
                    this.leftImplicitType = RubyTypesGen.getImplicitLongClass(leftValue);
                    this.rightImplicitType = RubyTypesGen.getImplicitLongClass(rightValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.leftImplicitType == ((Equal2Node_)other).leftImplicitType && this.rightImplicitType == ((Equal2Node_)other).rightImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    long rightValue_;
                    long leftValue_;
                    block9: {
                        block8: {
                            try {
                                if (this.leftImplicitType == Long.TYPE) {
                                    leftValue_ = this.root.left_.executeLong(frameValue);
                                    break block8;
                                }
                                if (this.leftImplicitType == Integer.TYPE) {
                                    leftValue_ = RubyTypes.int2long(this.root.left_.executeInteger(frameValue));
                                    break block8;
                                }
                                Object leftValue__ = this.executeLeft_(frameValue);
                                throw new UnexpectedResultException(leftValue__);
                            }
                            catch (UnexpectedResultException ex) {
                                Object rightValue = this.executeRight_(frameValue);
                                return this.getNext().executeBoolean1(frameValue, ex.getResult(), rightValue);
                            }
                        }
                        try {
                            if (this.rightImplicitType == Long.TYPE) {
                                rightValue_ = this.root.right_.executeLong(frameValue);
                                break block9;
                            }
                            if (this.rightImplicitType == Integer.TYPE) {
                                rightValue_ = RubyTypes.int2long(this.root.right_.executeInteger(frameValue));
                                break block9;
                            }
                            Object rightValue__ = this.executeRight_(frameValue);
                            throw new UnexpectedResultException(rightValue__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeBoolean1(frameValue, leftValue_, ex.getResult());
                        }
                    }
                    return this.root.equal(leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (RubyTypesGen.isImplicitLong(leftValue, this.leftImplicitType) && RubyTypesGen.isImplicitLong(rightValue, this.rightImplicitType)) {
                        long leftValue_ = RubyTypesGen.asImplicitLong(leftValue, this.leftImplicitType);
                        long rightValue_ = RubyTypesGen.asImplicitLong(rightValue, this.rightImplicitType);
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root, Object leftValue, Object rightValue) {
                    return new Equal2Node_(root, leftValue, rightValue);
                }
            }

            @GeneratedBy(methodName="equal(int, int)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal1Node_
            extends BaseNode_ {
                Equal1Node_(ReferenceEqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    int rightValue_;
                    int leftValue_;
                    try {
                        leftValue_ = this.root.left_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object rightValue = this.executeRight_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), rightValue);
                    }
                    try {
                        rightValue_ = this.root.right_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, leftValue_, ex.getResult());
                    }
                    return this.root.equal(leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        int leftValue_ = (Integer)leftValue;
                        int rightValue_ = (Integer)rightValue;
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal1Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(boolean, boolean)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal0Node_
            extends BaseNode_ {
                Equal0Node_(ReferenceEqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    boolean rightValue_;
                    boolean leftValue_;
                    try {
                        leftValue_ = this.root.left_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object rightValue = this.executeRight_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), rightValue);
                    }
                    try {
                        rightValue_ = this.root.right_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, leftValue_, ex.getResult());
                    }
                    return this.root.equal(leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
                        boolean leftValue_ = (Boolean)leftValue;
                        boolean rightValue_ = (Boolean)rightValue;
                        return this.root.equal(leftValue_, rightValue_);
                    }
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReferenceEqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object leftValue, Object rightValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, leftValue, rightValue));
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object leftValue_ = this.executeLeft_(frameValue);
                    Object rightValue_ = this.executeRight_(frameValue);
                    return this.getNext().executeBoolean1(frameValue, leftValue_, rightValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    return this.getNext().executeBoolean1(frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReferenceEqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                    return (Boolean)this.uninitialized((Frame)frameValue, leftValue, rightValue);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ReferenceEqualNodeGen root;

                BaseNode_(ReferenceEqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.left_, this.root.right_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object leftValue, Object rightValue) {
                    return this.executeBoolean1((VirtualFrame)frameValue, leftValue, rightValue);
                }

                public abstract boolean executeBoolean1(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object leftValue_ = this.executeLeft_(frameValue);
                    Object rightValue_ = this.executeRight_(frameValue);
                    return this.executeBoolean1(frameValue, leftValue_, rightValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean0(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object leftValue, Object rightValue) {
                    if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
                        return Equal0Node_.create(this.root);
                    }
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return Equal1Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(leftValue) && RubyTypesGen.isImplicitLong(rightValue)) {
                        return Equal2Node_.create(this.root, leftValue, rightValue);
                    }
                    if (leftValue instanceof Double && rightValue instanceof Double) {
                        return Equal3Node_.create(this.root);
                    }
                    if (leftValue instanceof RubyBasicObject && rightValue instanceof RubyBasicObject) {
                        return Equal4Node_.create(this.root);
                    }
                    if (this.root.isNotRubyBasicObject(leftValue) && this.root.isNotRubyBasicObject(rightValue) && this.root.notSameClass(leftValue, rightValue)) {
                        return Equal5Node_.create(this.root);
                    }
                    if (rightValue instanceof RubyBasicObject && this.root.isNotRubyBasicObject(leftValue)) {
                        return Equal6Node_.create(this.root);
                    }
                    if (leftValue instanceof RubyBasicObject && this.root.isNotRubyBasicObject(rightValue)) {
                        return Equal7Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeLeft_(Frame frameValue) {
                    Object object;
                    Class leftType_ = this.root.leftType_;
                    if (leftType_ == Boolean.TYPE) {
                        return this.root.left_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (leftType_ == Double.TYPE) {
                        return this.root.left_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (leftType_ == Integer.TYPE) {
                        return this.root.left_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (leftType_ == Long.TYPE) {
                        return this.root.left_.executeLong((VirtualFrame)frameValue);
                    }
                    if (leftType_ != null) return this.root.left_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.left_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.leftType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.leftType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.leftType_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeRight_(Frame frameValue) {
                    Object object;
                    Class rightType_ = this.root.rightType_;
                    if (rightType_ == Boolean.TYPE) {
                        return this.root.right_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (rightType_ == Double.TYPE) {
                        return this.root.right_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (rightType_ == Integer.TYPE) {
                        return this.root.right_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (rightType_ == Long.TYPE) {
                        return this.root.right_.executeLong((VirtualFrame)frameValue);
                    }
                    if (rightType_ != null) return this.root.right_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.right_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.rightType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.rightType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.rightType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.NotEqualNode.class)
    public static final class NotEqualNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.NotEqualNode> {
        private static NotEqualNodeFactory notEqualNodeFactoryInstance;

        private NotEqualNodeFactory() {
            super(BasicObjectNodes.NotEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.NotEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NotEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.NotEqualNode> getInstance() {
            if (notEqualNodeFactoryInstance == null) {
                notEqualNodeFactoryInstance = new NotEqualNodeFactory();
            }
            return notEqualNodeFactoryInstance;
        }

        public static BasicObjectNodes.NotEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NotEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.NotEqualNode.class)
        public static final class NotEqualNodeGen
        extends BasicObjectNodes.NotEqualNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private NotEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.equal(frameValue, arguments0Value_, arguments1Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.NotNode.class)
    public static final class NotNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.NotNode> {
        private static NotNodeFactory notNodeFactoryInstance;

        private NotNodeFactory() {
            super(BasicObjectNodes.NotNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        @Override
        public BasicObjectNodes.NotNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return NotNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.NotNode> getInstance() {
            if (notNodeFactoryInstance == null) {
                notNodeFactoryInstance = new NotNodeFactory();
            }
            return notNodeFactoryInstance;
        }

        public static BasicObjectNodes.NotNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new NotNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=BasicObjectNodes.NotNode.class)
        public static final class NotNodeGen
        extends BasicObjectNodes.NotNode {
            @Node.Child
            private RubyNode operand_;

            private NotNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.not(operandValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }
}

