/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class WhenSplatNode
extends RubyNode {
    @Node.Child
    private RubyNode readCaseExpression;
    @Node.Child
    private RubyNode splat;
    @Node.Child
    private CallDispatchHeadNode dispatchCaseEqual;

    public WhenSplatNode(RubyContext context, SourceSection sourceSection, RubyNode readCaseExpression, RubyNode splat) {
        super(context, sourceSection);
        this.readCaseExpression = readCaseExpression;
        this.splat = splat;
        this.dispatchCaseEqual = DispatchHeadNodeFactory.createMethodCall(context);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        RubyBasicObject array;
        CompilerDirectives.transferToInterpreter();
        Object caseExpression = this.readCaseExpression.execute(frame);
        try {
            array = this.splat.executeRubyBasicObject(frame);
        }
        catch (UnexpectedResultException e) {
            throw new UnsupportedOperationException();
        }
        if (!RubyGuards.isRubyArray(array)) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }
        for (Object value : ArrayNodes.slowToArray(array)) {
            if (!this.dispatchCaseEqual.callBoolean(frame, caseExpression, "===", null, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }
}

