WebInspector.EventSourceMessagesView=function(request)
{WebInspector.VBox.call(this);this.registerRequiredCSS("network/eventSourceMessagesView.css");this.element.classList.add("event-source-messages-view");this._request=request;var columns=[{id:"id",title:WebInspector.UIString("Id"),sortable:true,weight:8},{id:"type",title:WebInspector.UIString("Type"),sortable:true,weight:8},{id:"data",title:WebInspector.UIString("Data"),sortable:false,weight:88},{id:"time",title:WebInspector.UIString("Time"),sortable:true,weight:8}];this._dataGrid=new WebInspector.SortableDataGrid(columns);this._dataGrid.setStickToBottom(true);this._dataGrid.markColumnAsSortedBy("time",WebInspector.DataGrid.Order.Ascending);this._sortItems();this._dataGrid.addEventListener(WebInspector.DataGrid.Events.SortingChanged,this._sortItems,this);this._dataGrid.setName("EventSourceMessagesView");this._dataGrid.show(this.element);}
WebInspector.EventSourceMessagesView.prototype={wasShown:function()
{this._dataGrid.rootNode().removeChildren();var messages=this._request.eventSourceMessages();for(var i=0;i<messages.length;++i)
this._dataGrid.insertChild(new WebInspector.EventSourceMessageNode(messages[i]));this._request.addEventListener(WebInspector.NetworkRequest.Events.EventSourceMessageAdded,this._messageAdded,this);},willHide:function()
{this._request.removeEventListener(WebInspector.NetworkRequest.Events.EventSourceMessageAdded,this._messageAdded,this);},_messageAdded:function(event)
{var message=(event.data);this._dataGrid.insertChild(new WebInspector.EventSourceMessageNode(message));},_sortItems:function()
{var sortColumnIdentifier=this._dataGrid.sortColumnIdentifier();if(!sortColumnIdentifier)
return;var comparator=WebInspector.EventSourceMessageNode.Comparators[sortColumnIdentifier];if(!comparator)
return;this._dataGrid.sortNodes(comparator,!this._dataGrid.isSortOrderAscending());},__proto__:WebInspector.VBox.prototype}
WebInspector.EventSourceMessageNode=function(message)
{this._message=message;var time=new Date(message.time*1000);var timeText=("0"+time.getHours()).substr(-2)+":"+("0"+time.getMinutes()).substr(-2)+":"+("0"+time.getSeconds()).substr(-2)+"."+("00"+time.getMilliseconds()).substr(-3);var timeNode=createElement("div");timeNode.createTextChild(timeText);timeNode.title=time.toLocaleString();WebInspector.SortableDataGridNode.call(this,{id:message.eventId,type:message.eventName,data:message.data,time:timeNode});}
WebInspector.EventSourceMessageNode.prototype={__proto__:WebInspector.SortableDataGridNode.prototype}
WebInspector.EventSourceMessageNodeComparator=function(field,a,b)
{var aValue=a._message[field];var bValue=b._message[field];return aValue<bValue?-1:aValue>bValue?1:0;}
WebInspector.EventSourceMessageNode.Comparators={"id":WebInspector.EventSourceMessageNodeComparator.bind(null,"eventId"),"type":WebInspector.EventSourceMessageNodeComparator.bind(null,"eventName"),"time":WebInspector.EventSourceMessageNodeComparator.bind(null,"time")};;WebInspector.FilterSuggestionBuilder=function(keys)
{this._keys=keys;this._valueSets={};this._valueLists={};}
WebInspector.FilterSuggestionBuilder.Filter;WebInspector.FilterSuggestionBuilder.prototype={buildSuggestions:function(input)
{var text=input.value;var end=input.selectionEnd;if(end!=text.length)
return null;var start=input.selectionStart;text=text.substring(0,start);var prefixIndex=text.lastIndexOf(" ")+1;var prefix=text.substring(prefixIndex);if(!prefix)
return[];var negative=prefix.startsWith("-");if(negative)
prefix=prefix.substring(1);var modifier=negative?"-":"";var valueDelimiterIndex=prefix.indexOf(":");var suggestions=[];if(valueDelimiterIndex===-1){var matcher=new RegExp("^"+prefix.escapeForRegExp(),"i");for(var j=0;j<this._keys.length;++j){if(this._keys[j].match(matcher))
suggestions.push(modifier+this._keys[j]+":");}}else{var key=prefix.substring(0,valueDelimiterIndex).toLowerCase();var value=prefix.substring(valueDelimiterIndex+1);var matcher=new RegExp("^"+value.escapeForRegExp(),"i");var items=this._values(key);for(var i=0;i<items.length;++i){if(items[i].match(matcher)&&(items[i]!==value))
suggestions.push(modifier+key+":"+items[i]);}}
return suggestions;},applySuggestion:function(input,suggestion,isIntermediate)
{var text=input.value;var start=input.selectionStart;text=text.substring(0,start);var prefixIndex=text.lastIndexOf(" ")+1;if(isIntermediate){text=text+suggestion.substring(text.length-prefixIndex);input.value=text;}else{text=text.substring(0,prefixIndex)+suggestion;input.value=text;start=text.length;}
input.setSelectionRange(start,text.length);},unapplySuggestion:function(input)
{var start=input.selectionStart;var end=input.selectionEnd;var text=input.value;if(start!==end&&end===text.length)
input.value=text.substring(0,start);},_values:function(key)
{var result=this._valueLists[key];if(!result)
return[];result.sort();return result;},addItem:function(key,value)
{if(!value)
return;var set=this._valueSets[key];var list=this._valueLists[key];if(!set){set={};this._valueSets[key]=set;list=[];this._valueLists[key]=list;}
if(set[value])
return;set[value]=true;list.push(value);},parseQuery:function(query)
{var filters=[];var text=[];var parts=query.split(/\s+/);for(var i=0;i<parts.length;++i){var part=parts[i];if(!part)
continue;var colonIndex=part.indexOf(":");if(colonIndex===-1){text.push(part);continue;}
var key=part.substring(0,colonIndex);var negative=key.startsWith("-");if(negative)
key=key.substring(1);if(this._keys.indexOf(key)==-1){text.push(part);continue;}
var value=part.substring(colonIndex+1);filters.push({type:key,data:value,negative:negative});}
return{text:text,filters:filters};}};;WebInspector.HARWriter=function()
{}
WebInspector.HARWriter.prototype={write:function(stream,requests,progress)
{this._stream=stream;this._harLog=(new WebInspector.HARLog(requests)).build();this._pendingRequests=1;var entries=this._harLog.entries;for(var i=0;i<entries.length;++i){var content=requests[i].content;if(typeof content==="undefined"&&requests[i].finished){++this._pendingRequests;requests[i].requestContent(this._onContentAvailable.bind(this,entries[i],requests[i]));}else if(content!==null)
this._setEntryContent(entries[i],requests[i]);}
var compositeProgress=new WebInspector.CompositeProgress(progress);this._writeProgress=compositeProgress.createSubProgress();if(--this._pendingRequests){this._requestsProgress=compositeProgress.createSubProgress();this._requestsProgress.setTitle(WebInspector.UIString("Collecting content…"));this._requestsProgress.setTotalWork(this._pendingRequests);}else
this._beginWrite();},_setEntryContent:function(entry,request)
{if(request.content!==null)
entry.response.content.text=request.content;if(request.contentEncoded)
entry.response.content.encoding="base64";},_onContentAvailable:function(entry,request,content)
{this._setEntryContent(entry,request);if(this._requestsProgress)
this._requestsProgress.worked();if(!--this._pendingRequests){this._requestsProgress.done();this._beginWrite();}},_beginWrite:function()
{const jsonIndent=2;this._text=JSON.stringify({log:this._harLog},null,jsonIndent);this._writeProgress.setTitle(WebInspector.UIString("Writing file…"));this._writeProgress.setTotalWork(this._text.length);this._bytesWritten=0;this._writeNextChunk(this._stream);},_writeNextChunk:function(stream,error)
{if(this._bytesWritten>=this._text.length||error){stream.close();this._writeProgress.done();return;}
const chunkSize=100000;var text=this._text.substring(this._bytesWritten,this._bytesWritten+chunkSize);this._bytesWritten+=text.length;stream.write(text,this._writeNextChunk.bind(this));this._writeProgress.setWorked(this._bytesWritten);}};WebInspector.RequestView=function(request)
{WebInspector.VBox.call(this);this.element.classList.add("request-view");this.request=request;}
WebInspector.RequestView.prototype={__proto__:WebInspector.VBox.prototype}
WebInspector.RequestView.hasTextContent=function(request)
{if(request.resourceType().isTextType())
return true;if(request.resourceType()===WebInspector.resourceTypes.Other||request.hasErrorStatusCode())
return!!request.content&&!request.contentEncoded;return false;}
WebInspector.RequestView.nonSourceViewForRequest=function(request)
{switch(request.resourceType()){case WebInspector.resourceTypes.Image:return new WebInspector.ImageView(request.url,request.mimeType,request);case WebInspector.resourceTypes.Font:return new WebInspector.FontView(request.url,request.mimeType,request);default:return new WebInspector.RequestView(request);}};WebInspector.NetworkDataGridNode=function(parentView,request)
{WebInspector.SortableDataGridNode.call(this,{});this._parentView=parentView;this._request=request;this._staleGraph=true;this._isNavigationRequest=false;this.selectable=true;}
WebInspector.NetworkDataGridNode._hoveredRowSymbol=Symbol("hoveredRow");WebInspector.NetworkDataGridNode.prototype={request:function()
{return this._request;},markAsNavigationRequest:function()
{this._isNavigationRequest=true;this.refresh();},nodeSelfHeight:function()
{return this._parentView.rowHeight();},createCells:function()
{this._showTiming=!WebInspector.settings.networkColorCodeResourceTypes.get()&&!this._parentView.calculator().startAtZero;this._nameCell=null;this._timelineCell=null;this._initiatorCell=null;this._element.classList.toggle("network-error-row",this._isFailed());this._element.classList.toggle("network-navigation-row",this._isNavigationRequest);WebInspector.SortableDataGridNode.prototype.createCells.call(this);this._updateGraph();},createCell:function(columnIdentifier)
{var cell=this.createTD(columnIdentifier);switch(columnIdentifier){case"name":this._renderNameCell(cell);break;case"timeline":this._createTimelineBar(cell);break;case"method":cell.setTextAndTitle(this._request.requestMethod);break;case"status":this._renderStatusCell(cell);break;case"protocol":cell.setTextAndTitle(this._request.protocol);break;case"scheme":cell.setTextAndTitle(this._request.scheme);break;case"domain":cell.setTextAndTitle(this._request.domain);break;case"remoteAddress":cell.setTextAndTitle(this._request.remoteAddress());break;case"cookies":cell.setTextAndTitle(this._arrayLength(this._request.requestCookies));break;case"setCookies":cell.setTextAndTitle(this._arrayLength(this._request.responseCookies));break;case"connectionId":cell.setTextAndTitle(this._request.connectionId);break;case"type":this._renderTypeCell(cell);break;case"initiator":this._renderInitiatorCell(cell);break;case"size":this._renderSizeCell(cell);break;case"time":this._renderTimeCell(cell);break;default:cell.setTextAndTitle(this._request.responseHeaderValue(columnIdentifier)||"");break;}
return cell;},_arrayLength:function(array)
{return array?""+array.length:"";},willAttach:function()
{if(this._staleGraph)
this._updateGraph();if(this._initiatorCell&&this._request.initiatorInfo().type===WebInspector.NetworkRequest.InitiatorType.Script)
this._initiatorCell.insertBefore(this._linkifiedInitiatorAnchor,this._initiatorCell.firstChild);},wasDetached:function()
{if(this._linkifiedInitiatorAnchor)
this._linkifiedInitiatorAnchor.remove();},dispose:function()
{if(this._linkifiedInitiatorAnchor)
this._parentView.linkifier.disposeAnchor(this._request.target(),this._linkifiedInitiatorAnchor);},select:function()
{WebInspector.SortableDataGridNode.prototype.select.apply(this,arguments);this._parentView.dispatchEventToListeners(WebInspector.NetworkLogView.EventTypes.RequestSelected,this._request);WebInspector.notifications.dispatchEventToListeners(WebInspector.UserMetrics.UserAction,{action:WebInspector.UserMetrics.UserActionNames.NetworkRequestSelected,url:this._request.url});},highlightMatchedSubstring:function(regexp)
{this.element();var domChanges=[];var matchInfo=this._nameCell.textContent.match(regexp);if(matchInfo)
WebInspector.highlightSearchResult(this._nameCell,matchInfo.index,matchInfo[0].length,domChanges);return domChanges;},_openInNewTab:function()
{InspectorFrontendHost.openInNewTab(this._request.url);},_createTimelineBar:function(cell)
{cell=cell.createChild("div");this._timelineCell=cell;cell.className="network-graph-side";this._barAreaElement=cell.createChild("div","network-graph-bar-area");this._barAreaElement.request=this._request;if(this._showTiming)
return;var type=this._request.resourceType().name();var cached=this._request.cached();this._barLeftElement=this._barAreaElement.createChild("div","network-graph-bar");this._barLeftElement.classList.add(type,"waiting");this._barLeftElement.classList.toggle("cached",cached);this._barRightElement=this._barAreaElement.createChild("div","network-graph-bar");this._barRightElement.classList.add(type);this._barRightElement.classList.toggle("cached",cached);this._labelLeftElement=this._barAreaElement.createChild("div","network-graph-label");this._labelLeftElement.classList.add("waiting");this._labelRightElement=this._barAreaElement.createChild("div","network-graph-label");cell.addEventListener("mouseover",this._onMouseOver.bind(this),false);},_onMouseOver:function(event)
{this._refreshLabelPositions();this._parentView[WebInspector.NetworkDataGridNode._hoveredRowSymbol]=this;},_isFailed:function()
{return(this._request.failed&&!this._request.statusCode)||(this._request.statusCode>=400);},_renderNameCell:function(cell)
{this._nameCell=cell;cell.addEventListener("dblclick",this._openInNewTab.bind(this),false);var iconElement;if(this._request.resourceType()===WebInspector.resourceTypes.Image){var previewImage=createElementWithClass("img","image-network-icon-preview");this._request.populateImageSource(previewImage);iconElement=createElementWithClass("div","icon");iconElement.appendChild(previewImage);}else{iconElement=createElementWithClass("img","icon");}
iconElement.classList.add(this._request.resourceType().name());cell.appendChild(iconElement);cell.createTextChild(this._request.target().decorateLabel(this._request.name()));this._appendSubtitle(cell,this._request.path());cell.title=this._request.url;},_renderStatusCell:function(cell)
{cell.classList.toggle("network-dim-cell",!this._isFailed()&&(this._request.cached()||!this._request.statusCode));if(this._request.failed&&!this._request.canceled){var failText=WebInspector.UIString("(failed)");if(this._request.localizedFailDescription){cell.createTextChild(failText);this._appendSubtitle(cell,this._request.localizedFailDescription);cell.title=failText+" "+this._request.localizedFailDescription;}else
cell.setTextAndTitle(failText);}else if(this._request.statusCode){cell.createTextChild(""+this._request.statusCode);this._appendSubtitle(cell,this._request.statusText);cell.title=this._request.statusCode+" "+this._request.statusText;}else if(this._request.parsedURL.isDataURL()){cell.setTextAndTitle(WebInspector.UIString("(data)"));}else if(this._request.canceled){cell.setTextAndTitle(WebInspector.UIString("(canceled)"));}else if(this._request.finished){cell.setTextAndTitle(WebInspector.UIString("Finished"));}else{cell.setTextAndTitle(WebInspector.UIString("(pending)"));}},_renderTypeCell:function(cell)
{var mimeType=this._request.mimeType||this._request.requestContentType()||"";var resourceType=this._request.resourceType();var simpleType=resourceType.name();if(resourceType==WebInspector.resourceTypes.Other||resourceType==WebInspector.resourceTypes.Image)
simpleType=mimeType.replace(/^(application|image)\//,"");cell.setTextAndTitle(simpleType);},_renderInitiatorCell:function(cell)
{this._initiatorCell=cell;var request=this._request;var initiator=request.initiatorInfo();switch(initiator.type){case WebInspector.NetworkRequest.InitiatorType.Parser:cell.title=initiator.url+":"+initiator.lineNumber;var uiSourceCode=WebInspector.networkMapping.uiSourceCodeForURLForAnyTarget(initiator.url);cell.appendChild(WebInspector.linkifyResourceAsNode(initiator.url,initiator.lineNumber-1,undefined,undefined,uiSourceCode?uiSourceCode.displayName():undefined));this._appendSubtitle(cell,WebInspector.UIString("Parser"));break;case WebInspector.NetworkRequest.InitiatorType.Redirect:cell.title=initiator.url;console.assert(request.redirectSource);var redirectSource=(request.redirectSource);cell.appendChild(WebInspector.linkifyRequestAsNode(redirectSource));this._appendSubtitle(cell,WebInspector.UIString("Redirect"));break;case WebInspector.NetworkRequest.InitiatorType.Script:if(!this._linkifiedInitiatorAnchor){this._linkifiedInitiatorAnchor=this._parentView.linkifier.linkifyScriptLocation(request.target(),null,initiator.url,initiator.lineNumber-1,initiator.columnNumber-1);this._linkifiedInitiatorAnchor.title="";}
cell.appendChild(this._linkifiedInitiatorAnchor);this._appendSubtitle(cell,WebInspector.UIString("Script"));cell.classList.add("network-script-initiated");cell.request=request;break;default:cell.title="";cell.classList.add("network-dim-cell");cell.setTextAndTitle(WebInspector.UIString("Other"));}},_renderSizeCell:function(cell)
{if(this._request.fetchedViaServiceWorker){cell.setTextAndTitle(WebInspector.UIString("(from ServiceWorker)"));cell.classList.add("network-dim-cell");}else if(this._request.cached()){cell.setTextAndTitle(WebInspector.UIString("(from cache)"));cell.classList.add("network-dim-cell");}else{var resourceSize=Number.bytesToString(this._request.resourceSize);var transferSize=Number.bytesToString(this._request.transferSize);cell.setTextAndTitle(transferSize);this._appendSubtitle(cell,resourceSize);}},_renderTimeCell:function(cell)
{if(this._request.duration>0){cell.setTextAndTitle(Number.secondsToString(this._request.duration));this._appendSubtitle(cell,Number.secondsToString(this._request.latency));}else{cell.classList.add("network-dim-cell");cell.setTextAndTitle(WebInspector.UIString("Pending"));}},_appendSubtitle:function(cellElement,subtitleText)
{var subtitleElement=createElement("div");subtitleElement.className="network-cell-subtitle";subtitleElement.textContent=subtitleText;cellElement.appendChild(subtitleElement);},refreshGraph:function()
{if(!this._timelineCell)
return;this._staleGraph=true;if(this.attached())
this.dataGrid.scheduleUpdate();},_updateTimingGraph:function()
{var calculator=this._parentView.calculator();var timeRanges=WebInspector.RequestTimingView.calculateRequestTimeRanges(this._request);var right=timeRanges[0].end;var container=this._barAreaElement;var nextBar=container.firstChild;for(var i=0;i<timeRanges.length;++i){var range=timeRanges[i];var start=calculator.computePercentageFromEventTime(range.start);var end=(range.end!==Number.MAX_VALUE)?calculator.computePercentageFromEventTime(range.end):100;if(!nextBar)
nextBar=container.createChild("div");nextBar.className="network-graph-bar request-timing";nextBar.classList.add(range.name);nextBar.style.setProperty("left",start+"%");nextBar.style.setProperty("right",(100-end)+"%");nextBar=nextBar.nextSibling;}
while(nextBar){var nextSibling=nextBar.nextSibling;nextBar.remove();nextBar=nextSibling;}},_updateGraph:function()
{this._staleGraph=false;if(!this._timelineCell)
return;if(this._showTiming){this._updateTimingGraph();return;}
var calculator=this._parentView.calculator();var percentages=calculator.computeBarGraphPercentages(this._request);this._percentages=percentages;this._barAreaElement.classList.remove("hidden");this._barLeftElement.style.setProperty("left",percentages.start+"%");this._barLeftElement.style.setProperty("right",(100-percentages.middle)+"%");this._barRightElement.style.setProperty("left",percentages.middle+"%");this._barRightElement.style.setProperty("right",(100-percentages.end)+"%");var labels=calculator.computeBarGraphLabels(this._request);this._labelLeftElement.textContent=labels.left;this._labelRightElement.textContent=labels.right;var tooltip=(labels.tooltip||"");this._barLeftElement.title=tooltip;this._labelLeftElement.title=tooltip;this._labelRightElement.title=tooltip;this._barRightElement.title=tooltip;if(this._parentView[WebInspector.NetworkDataGridNode._hoveredRowSymbol]===this)
this._refreshLabelPositions();},_refreshLabelPositions:function()
{if(!this._percentages)
return;this._labelLeftElement.style.removeProperty("left");this._labelLeftElement.style.removeProperty("right");this._labelLeftElement.classList.remove("before");this._labelLeftElement.classList.remove("hidden");this._labelRightElement.style.removeProperty("left");this._labelRightElement.style.removeProperty("right");this._labelRightElement.classList.remove("after");this._labelRightElement.classList.remove("hidden");const labelPadding=10;const barRightElementOffsetWidth=this._barRightElement.offsetWidth;const barLeftElementOffsetWidth=this._barLeftElement.offsetWidth;if(this._barLeftElement){var leftBarWidth=barLeftElementOffsetWidth-labelPadding;var rightBarWidth=(barRightElementOffsetWidth-barLeftElementOffsetWidth)-labelPadding;}else{var leftBarWidth=(barLeftElementOffsetWidth-barRightElementOffsetWidth)-labelPadding;var rightBarWidth=barRightElementOffsetWidth-labelPadding;}
const labelLeftElementOffsetWidth=this._labelLeftElement.offsetWidth;const labelRightElementOffsetWidth=this._labelRightElement.offsetWidth;const labelBefore=(labelLeftElementOffsetWidth>leftBarWidth);const labelAfter=(labelRightElementOffsetWidth>rightBarWidth);const graphElementOffsetWidth=this._timelineCell.offsetWidth;if(labelBefore&&(graphElementOffsetWidth*(this._percentages.start/100))<(labelLeftElementOffsetWidth+10))
var leftHidden=true;if(labelAfter&&(graphElementOffsetWidth*((100-this._percentages.end)/100))<(labelRightElementOffsetWidth+10))
var rightHidden=true;if(barLeftElementOffsetWidth==barRightElementOffsetWidth){if(labelBefore&&!labelAfter)
leftHidden=true;else if(labelAfter&&!labelBefore)
rightHidden=true;}
if(labelBefore){if(leftHidden)
this._labelLeftElement.classList.add("hidden");this._labelLeftElement.style.setProperty("right",(100-this._percentages.start)+"%");this._labelLeftElement.classList.add("before");}else{this._labelLeftElement.style.setProperty("left",this._percentages.start+"%");this._labelLeftElement.style.setProperty("right",(100-this._percentages.middle)+"%");}
if(labelAfter){if(rightHidden)
this._labelRightElement.classList.add("hidden");this._labelRightElement.style.setProperty("left",this._percentages.end+"%");this._labelRightElement.classList.add("after");}else{this._labelRightElement.style.setProperty("left",this._percentages.middle+"%");this._labelRightElement.style.setProperty("right",(100-this._percentages.end)+"%");}},__proto__:WebInspector.SortableDataGridNode.prototype}
WebInspector.NetworkDataGridNode.NameComparator=function(a,b)
{var aFileName=a._request.name();var bFileName=b._request.name();if(aFileName>bFileName)
return 1;if(bFileName>aFileName)
return-1;return a._request.indentityCompare(b._request);}
WebInspector.NetworkDataGridNode.RemoteAddressComparator=function(a,b)
{var aRemoteAddress=a._request.remoteAddress();var bRemoteAddress=b._request.remoteAddress();if(aRemoteAddress>bRemoteAddress)
return 1;if(bRemoteAddress>aRemoteAddress)
return-1;return a._request.indentityCompare(b._request);}
WebInspector.NetworkDataGridNode.SizeComparator=function(a,b)
{if(b._request.cached()&&!a._request.cached())
return 1;if(a._request.cached()&&!b._request.cached())
return-1;return(a._request.transferSize-b._request.transferSize)||a._request.indentityCompare(b._request);}
WebInspector.NetworkDataGridNode.InitiatorComparator=function(a,b)
{var aInitiator=a._request.initiatorInfo();var bInitiator=b._request.initiatorInfo();if(aInitiator.type<bInitiator.type)
return-1;if(aInitiator.type>bInitiator.type)
return 1;if(typeof aInitiator.__source==="undefined")
aInitiator.__source=WebInspector.displayNameForURL(aInitiator.url);if(typeof bInitiator.__source==="undefined")
bInitiator.__source=WebInspector.displayNameForURL(bInitiator.url);if(aInitiator.__source<bInitiator.__source)
return-1;if(aInitiator.__source>bInitiator.__source)
return 1;if(aInitiator.lineNumber<bInitiator.lineNumber)
return-1;if(aInitiator.lineNumber>bInitiator.lineNumber)
return 1;if(aInitiator.columnNumber<bInitiator.columnNumber)
return-1;if(aInitiator.columnNumber>bInitiator.columnNumber)
return 1;return a._request.indentityCompare(b._request);}
WebInspector.NetworkDataGridNode.RequestCookiesCountComparator=function(a,b)
{var aScore=a._request.requestCookies?a._request.requestCookies.length:0;var bScore=b._request.requestCookies?b._request.requestCookies.length:0;return(aScore-bScore)||a._request.indentityCompare(b._request);}
WebInspector.NetworkDataGridNode.ResponseCookiesCountComparator=function(a,b)
{var aScore=a._request.responseCookies?a._request.responseCookies.length:0;var bScore=b._request.responseCookies?b._request.responseCookies.length:0;return(aScore-bScore)||a._request.indentityCompare(b._request);}
WebInspector.NetworkDataGridNode.RequestPropertyComparator=function(propertyName,revert,a,b)
{var aValue=a._request[propertyName];var bValue=b._request[propertyName];if(aValue>bValue)
return revert?-1:1;if(bValue>aValue)
return revert?1:-1;return a._request.indentityCompare(b._request);};WebInspector.NetworkItemView=function(request,calculator)
{WebInspector.TabbedPane.call(this);this.element.classList.add("network-item-view");var headersView=new WebInspector.RequestHeadersView(request);this.appendTab("headers",WebInspector.UIString("Headers"),headersView);this.addEventListener(WebInspector.TabbedPane.EventTypes.TabSelected,this._tabSelected,this);if(request.resourceType()===WebInspector.resourceTypes.WebSocket){var frameView=new WebInspector.ResourceWebSocketFrameView(request);this.appendTab("webSocketFrames",WebInspector.UIString("Frames"),frameView);}else if(request.mimeType==="text/event-stream"){this.appendTab("eventSource",WebInspector.UIString("EventStream"),new WebInspector.EventSourceMessagesView(request));}else{var responseView=new WebInspector.RequestResponseView(request);var previewView=new WebInspector.RequestPreviewView(request,responseView);this.appendTab("preview",WebInspector.UIString("Preview"),previewView);this.appendTab("response",WebInspector.UIString("Response"),responseView);}
if(request.requestCookies||request.responseCookies){this._cookiesView=new WebInspector.RequestCookiesView(request);this.appendTab("cookies",WebInspector.UIString("Cookies"),this._cookiesView);}
this.appendTab("timing",WebInspector.UIString("Timing"),new WebInspector.RequestTimingView(request,calculator));this._request=request;}
WebInspector.NetworkItemView.prototype={wasShown:function()
{WebInspector.TabbedPane.prototype.wasShown.call(this);this._selectTab();},currentSourceFrame:function()
{var view=this.visibleView;if(view&&view instanceof WebInspector.SourceFrame)
return(view);return null;},_selectTab:function(tabId)
{if(!tabId)
tabId=WebInspector.settings.resourceViewTab.get();if(!this.selectTab(tabId))
this.selectTab("headers");},_tabSelected:function(event)
{if(!event.data.isUserGesture)
return;WebInspector.settings.resourceViewTab.set(event.data.tabId);WebInspector.notifications.dispatchEventToListeners(WebInspector.UserMetrics.UserAction,{action:WebInspector.UserMetrics.UserActionNames.NetworkRequestTabSelected,tab:event.data.tabId,url:this._request.url});},request:function()
{return this._request;},__proto__:WebInspector.TabbedPane.prototype}
WebInspector.RequestContentView=function(request)
{WebInspector.RequestView.call(this,request);}
WebInspector.RequestContentView.prototype={get innerView()
{return this._innerView;},set innerView(innerView)
{this._innerView=innerView;},wasShown:function()
{this._ensureInnerViewShown();},_ensureInnerViewShown:function()
{if(this._innerViewShowRequested)
return;this._innerViewShowRequested=true;function callback(content)
{this._innerViewShowRequested=false;this.contentLoaded();}
this.request.requestContent(callback.bind(this));},contentLoaded:function()
{},__proto__:WebInspector.RequestView.prototype};WebInspector.NetworkFilmStripView=function(calculator)
{WebInspector.HBox.call(this,true);this.registerRequiredCSS("network/networkFilmStripView.css");this.element.classList.add("network-film-strip-view");this.contentElement.classList.add("shadow-network-film-strip-view");this._calculator=calculator;this._timeOffset=null;this._frames=[];this._selectedFrame=null;this._target=null;this._recording=false;this._loadTime=null;this._dclTime=null;this._scrolling=false;this._tracingModel=null;this._label=this.contentElement.createChild("div","label");this._label.createChild("div","spinner");this._label.createTextChild(WebInspector.UIString("Recording..."));WebInspector.targetManager.observeTargets(this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.Load,this._loadEventFired,this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.DOMContentLoaded,this._dclEventFired,this);}
WebInspector.NetworkFilmStripView._maximumFrameCount=60;WebInspector.NetworkFilmStripView.Events={FrameSelected:"FrameSelected",RecordingFinished:"RecordingFinished"}
WebInspector.NetworkFilmStripView.prototype={targetAdded:function(target)
{if(this._target)
return;this._target=target;},targetRemoved:function(target)
{if(this._target===target&&this._recording){this._label.textContent=WebInspector.UIString("Detached.");this._recording=false;this.dispatchEventToListeners(WebInspector.NetworkFilmStripView.Events.RecordingFinished);this._unsubscribe();}},tracingStarted:function(){},traceEventsCollected:function(events)
{if(this._tracingModel)
this._tracingModel.addEvents(events);},tracingComplete:function()
{if(!this._tracingModel)
return;this._tracingModel.tracingComplete();var frames=[];var browserProcess=this._tracingModel.processByName("Browser");if(browserProcess){var mainThread=browserProcess.threadByName("CrBrowserMain");if(mainThread){var events=mainThread.events();for(var i=0;i<events.length;++i){if(events[i].category==="disabled-by-default-devtools.screenshot"&&events[i].name==="CaptureFrame"){var data=events[i].args.data;var timestamp=events[i].startTime/1000.0;this._appendEventDividers(timestamp,frames);if(data)
frames.push(new WebInspector.NetworkFilmStripFrame(this,data,timestamp));}}}}
this._appendEventDividers(Number.MAX_VALUE,frames);this._unsubscribe();if(!frames.length){this._label.textContent=WebInspector.UIString("No frames recorded.");return;}
this._label.remove();for(var i=0;i<frames.length;++i)
frames[i].show(this.contentElement);this._frames=frames;this._updateTimeOffset(true);},tracingBufferUsage:function(){},eventsRetrievalProgress:function(progress){},recording:function()
{return this._recording;},_loadEventFired:function(event)
{this._loadTime=(event.data);},_dclEventFired:function(event)
{this._dclTime=(event.data);},selectFrame:function(time)
{var frames=this._frames;var frameCount=frames.length;if(!frameCount)
return;var selectedFrame=frames[frameCount-1];for(var i=frameCount-2;i>=0;--i){var frame=frames[i];if(time<frame.timestamp())
selectedFrame=frame;}
this._selectFrame(selectedFrame,true);},_unsubscribe:function()
{if(this._tracingModel){this._tracingModel.reset();this._tracingModel=null;}
WebInspector.targetManager.unobserveTargets(this);this._target=null;},wasShown:function()
{this._calculator.addEventListener(WebInspector.NetworkTimeCalculator.Events.BoundariesChanged,this._onTimeOffsetChanged,this);this._updateTimeOffset();},willHide:function()
{this._calculator.removeEventListener(WebInspector.NetworkTimeCalculator.Events.BoundariesChanged,this._onTimeOffsetChanged,this);},_onTimeOffsetChanged:function(event)
{this._updateTimeOffset();},_updateTimeOffset:function(force)
{var offset=this._calculator.zeroTime();if(offset===this._timeOffset&&!force)
return;this._timeOffset=offset;for(var i=0;i<this._frames.length;++i)
this._frames[i]._setTimeOffset(offset);},_appendEventDividers:function(time,frames)
{if(this._dclTime&&time>this._dclTime){frames.push(new WebInspector.NetworkFilmStripFrame(this,null,this._dclTime,"dcl-event",WebInspector.UIString("DOM Content Loaded")));this._dclTime=null;}
if(this._loadTime&&time>this._loadTime){frames.push(new WebInspector.NetworkFilmStripFrame(this,null,this._loadTime,"load-event",WebInspector.UIString("Document Load")));this._loadTime=null;}},startRecording:function()
{this._recording=true;this._tracingModel=new WebInspector.TracingModel(new WebInspector.TempFileBackingStorage("tracing"));this._target.tracingManager.start(this,"-*,disabled-by-default-devtools.screenshot","");},stopRecording:function()
{if(this._target&&this._recording){this._recording=false;this._target.tracingManager.stop();this.dispatchEventToListeners(WebInspector.NetworkFilmStripView.Events.RecordingFinished);}},_selectFrame:function(frame,reveal)
{if(this._selectedFrame===frame)
return;if(this._selectedFrame)
this._selectedFrame.unselect();frame.select(reveal);this._selectedFrame=frame;this.dispatchEventToListeners(WebInspector.NetworkFilmStripView.Events.FrameSelected,frame.timestamp());},_smoothScroll:function(to)
{var height=this.contentElement.offsetHeight;var max=this.contentElement.scrollHeight-height;if(max<0)
max=0;if(to>max)
to=max;this._scrollStartTime=Date.now();var maxMove=2.5*height;var from=Number.constrain(this.contentElement.scrollTop,to-maxMove,to+maxMove);this._scrollStartPosition=from;this._scrollEndPosition=to;if(!this._scrolling){this._scrolling=true;this.contentElement.window().requestAnimationFrame(this._scroll.bind(this));}},_scroll:function()
{if(!this._scrolling)
return;var duration=500;var t=(Date.now()-this._scrollStartTime)/duration;if(t>1)
t=1;var x=t*t*t*(6*t*t-15*t+10);var position=this._scrollStartPosition+x*(this._scrollEndPosition-this._scrollStartPosition);this.contentElement.scrollTop=position;if(t<1)
this.contentElement.window().requestAnimationFrame(this._scroll.bind(this));else
this._scrolling=false;},__proto__:WebInspector.HBox.prototype}
WebInspector.NetworkFilmStripFrame=function(parent,imageData,timestamp,eventType,eventText)
{this._parent=parent;this._timestamp=timestamp;this._element=createElementWithClass("div","frame");if(imageData){this._element.createChild("div","thumbnail").createChild("img").src="data:image/jpg;base64,"+imageData;}else{if(eventType)
this._element.classList.add("event",eventType);if(eventText)
this._element.createChild("div","event-text").createTextChild(eventText);}
this._timeLabel=this._element.createChild("div","time");this._element.addEventListener("mouseover",this._onMouseOver.bind(this),false);}
WebInspector.NetworkFilmStripFrame.prototype={show:function(parent)
{parent.appendChild(this._element);},_onMouseOver:function(event)
{this._parent._selectFrame(this,false);},select:function(reveal)
{this._element.classList.add("selected");if(reveal)
this._parent._smoothScroll(this._element.offsetTop);},unselect:function()
{this._element.classList.remove("selected");},timestamp:function()
{return this._timestamp;},_setTimeOffset:function(offset)
{this._timeLabel.textContent=Number.secondsToString(this._timestamp-offset);}};WebInspector.NetworkTimeBoundary=function(minimum,maximum)
{this.minimum=minimum;this.maximum=maximum;}
WebInspector.NetworkTimeBoundary.prototype={equals:function(other)
{return(this.minimum===other.minimum)&&(this.maximum===other.maximum);}}
WebInspector.NetworkTimeCalculator=function(startAtZero)
{this.startAtZero=startAtZero;this._boundryChangedEventThrottler=new WebInspector.Throttler(0);this._window=null;}
WebInspector.NetworkTimeCalculator.Events={BoundariesChanged:"BoundariesChanged"}
WebInspector.NetworkTimeCalculator._latencyDownloadTotalFormat=new WebInspector.UIStringFormat("%s latency, %s download (%s total)");WebInspector.NetworkTimeCalculator._latencyFormat=new WebInspector.UIStringFormat("%s latency");WebInspector.NetworkTimeCalculator._downloadFormat=new WebInspector.UIStringFormat("%s download");WebInspector.NetworkTimeCalculator._fromServiceWorkerFormat=new WebInspector.UIStringFormat("%s (from ServiceWorker)");WebInspector.NetworkTimeCalculator._fromCacheFormat=new WebInspector.UIStringFormat("%s (from cache)");WebInspector.NetworkTimeCalculator.prototype={setWindow:function(window)
{this._window=window;this._boundaryChanged();},setInitialUserFriendlyBoundaries:function()
{this._minimumBoundary=0;this._maximumBoundary=1;},paddingLeft:function()
{return 0;},computePosition:function(time)
{return(time-this.minimumBoundary())/this.boundarySpan()*this._workingArea;},formatTime:function(value,precision)
{return Number.secondsToString(value);},minimumBoundary:function()
{return this._window?this._window.minimum:this._minimumBoundary;},zeroTime:function()
{return this._minimumBoundary;},maximumBoundary:function()
{return this._window?this._window.maximum:this._maximumBoundary;},boundary:function()
{return new WebInspector.NetworkTimeBoundary(this.minimumBoundary(),this.maximumBoundary());},boundarySpan:function()
{return this.maximumBoundary()-this.minimumBoundary();},reset:function()
{delete this._minimumBoundary;delete this._maximumBoundary;this._boundaryChanged();},_value:function(item)
{return 0;},setDisplayWindow:function(clientWidth)
{this._workingArea=clientWidth;},computeBarGraphPercentages:function(request)
{if(request.startTime!==-1)
var start=((request.startTime-this.minimumBoundary())/this.boundarySpan())*100;else
var start=0;if(request.responseReceivedTime!==-1)
var middle=((request.responseReceivedTime-this.minimumBoundary())/this.boundarySpan())*100;else
var middle=(this.startAtZero?start:100);if(request.endTime!==-1)
var end=((request.endTime-this.minimumBoundary())/this.boundarySpan())*100;else
var end=(this.startAtZero?middle:100);if(this.startAtZero){end-=start;middle-=start;start=0;}
return{start:start,middle:middle,end:end};},computePercentageFromEventTime:function(eventTime)
{if(eventTime!==-1&&!this.startAtZero)
return((eventTime-this.minimumBoundary())/this.boundarySpan())*100;return 0;},percentageToTime:function(percentage)
{return percentage*this.boundarySpan()/100+this.minimumBoundary();},_boundaryChanged:function()
{this._boundryChangedEventThrottler.schedule(this.dispatchEventToListeners.bind(this,WebInspector.NetworkTimeCalculator.Events.BoundariesChanged));},updateBoundariesForEventTime:function(eventTime)
{if(eventTime===-1||this.startAtZero)
return;if(this._maximumBoundary===undefined||eventTime>this._maximumBoundary){this._maximumBoundary=eventTime;this._boundaryChanged();}},computeBarGraphLabels:function(request)
{var rightLabel="";if(request.responseReceivedTime!==-1&&request.endTime!==-1)
rightLabel=Number.secondsToString(request.endTime-request.responseReceivedTime);var hasLatency=request.latency>0;if(hasLatency)
var leftLabel=Number.secondsToString(request.latency);else
var leftLabel=rightLabel;if(request.timing)
return{left:leftLabel,right:rightLabel};if(hasLatency&&rightLabel){var total=Number.secondsToString(request.duration);var tooltip=WebInspector.NetworkTimeCalculator._latencyDownloadTotalFormat.format(leftLabel,rightLabel,total);}else if(hasLatency){var tooltip=WebInspector.NetworkTimeCalculator._latencyFormat.format(leftLabel);}else if(rightLabel){var tooltip=WebInspector.NetworkTimeCalculator._downloadFormat.format(rightLabel);}
if(request.fetchedViaServiceWorker)
tooltip=WebInspector.NetworkTimeCalculator._fromServiceWorkerFormat.format(tooltip);else if(request.cached())
tooltip=WebInspector.NetworkTimeCalculator._fromCacheFormat.format(tooltip);return{left:leftLabel,right:rightLabel,tooltip:tooltip};},updateBoundaries:function(request)
{var lowerBound;if(this.startAtZero)
lowerBound=0;else
lowerBound=this._lowerBound(request);if(lowerBound!==-1&&(typeof this._minimumBoundary==="undefined"||lowerBound<this._minimumBoundary)){this._minimumBoundary=lowerBound;this._boundaryChanged();}
var upperBound=this._upperBound(request);if(upperBound!==-1&&(typeof this._maximumBoundary==="undefined"||upperBound>this._maximumBoundary)){this._maximumBoundary=upperBound;this._boundaryChanged();}},_lowerBound:function(request)
{return 0;},_upperBound:function(request)
{return 0;},__proto__:WebInspector.Object.prototype}
WebInspector.NetworkTransferTimeCalculator=function()
{WebInspector.NetworkTimeCalculator.call(this,false);}
WebInspector.NetworkTransferTimeCalculator.prototype={formatTime:function(value,precision)
{return Number.secondsToString(value-this.zeroTime());},_lowerBound:function(request)
{return request.startTime;},_upperBound:function(request)
{return request.endTime;},__proto__:WebInspector.NetworkTimeCalculator.prototype}
WebInspector.NetworkTransferDurationCalculator=function()
{WebInspector.NetworkTimeCalculator.call(this,true);}
WebInspector.NetworkTransferDurationCalculator.prototype={formatTime:function(value,precision)
{return Number.secondsToString(value);},_upperBound:function(request)
{return request.duration;},__proto__:WebInspector.NetworkTimeCalculator.prototype};WebInspector.NetworkLogView=function(overview,filterBar,progressBarContainer)
{WebInspector.VBox.call(this);this.registerRequiredCSS("network/networkLogView.css");this.registerRequiredCSS("ui/filter.css");this._filterBar=filterBar;this._overview=overview;this._progressBarContainer=progressBarContainer;var defaultColumnsVisibility=WebInspector.NetworkLogView._defaultColumnsVisibility;this._columnsVisibilitySetting=WebInspector.settings.createSetting("networkLogColumnsVisibility",defaultColumnsVisibility);var savedColumnsVisibility=this._columnsVisibilitySetting.get();var columnsVisibility={};for(var columnId in defaultColumnsVisibility)
columnsVisibility[columnId]=savedColumnsVisibility.hasOwnProperty(columnId)?savedColumnsVisibility[columnId]:defaultColumnsVisibility[columnId];this._columnsVisibilitySetting.set(columnsVisibility);this._nodesByRequestId=new Map();this._staleRequestIds={};this._mainRequestLoadTime=-1;this._mainRequestDOMContentLoadedTime=-1;this._selectedFrameTime=-1;this._showSelectedFrame=false;this._matchedRequestCount=0;this._highlightedSubstringChanges=[];this._filters=[];this._timeFilter=null;this._currentMatchedRequestNode=null;this._currentMatchedRequestIndex=-1;this._popupLinkifier=new WebInspector.Linkifier();this.linkifier=new WebInspector.Linkifier();this._gridMode=true;this._recording=false;this._preserveLog=false;this._rowHeight=0;this._addFilters();this._resetSuggestionBuilder();this._initializeView();this._overview.addEventListener(WebInspector.NetworkOverview.Events.WindowChanged,this._onWindowChanged,this);WebInspector.settings.networkColorCodeResourceTypes.addChangeListener(this._invalidateAllItems,this);WebInspector.settings.networkLogLargeRows.addChangeListener(this._updateRowsSize,this);WebInspector.targetManager.observeTargets(this);WebInspector.targetManager.addModelListener(WebInspector.NetworkManager,WebInspector.NetworkManager.EventTypes.RequestStarted,this._onRequestStarted,this);WebInspector.targetManager.addModelListener(WebInspector.NetworkManager,WebInspector.NetworkManager.EventTypes.RequestUpdated,this._onRequestUpdated,this);WebInspector.targetManager.addModelListener(WebInspector.NetworkManager,WebInspector.NetworkManager.EventTypes.RequestFinished,this._onRequestUpdated,this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.MainFrameNavigated,this._mainFrameNavigated,this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.Load,this._loadEventFired,this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.DOMContentLoaded,this._domContentLoadedEventFired,this);}
WebInspector.NetworkLogView._isFilteredOutSymbol=Symbol("isFilteredOut");WebInspector.NetworkLogView._isMatchingSearchQuerySymbol=Symbol("isMatchingSearchQuery");WebInspector.NetworkLogView.HTTPSchemas={"http":true,"https":true,"ws":true,"wss":true};WebInspector.NetworkLogView._responseHeaderColumns=["Cache-Control","Connection","Content-Encoding","Content-Length","ETag","Keep-Alive","Last-Modified","Server","Vary"];WebInspector.NetworkLogView._defaultColumnsVisibility={method:false,status:true,protocol:false,scheme:false,domain:false,remoteAddress:false,type:true,initiator:true,cookies:false,setCookies:false,size:true,time:true,connectionId:false,"Cache-Control":false,"Connection":false,"Content-Encoding":false,"Content-Length":false,"ETag":false,"Keep-Alive":false,"Last-Modified":false,"Server":false,"Vary":false};WebInspector.NetworkLogView._defaultRefreshDelay=200;WebInspector.NetworkLogView._waterfallMinOvertime=1;WebInspector.NetworkLogView._waterfallMaxOvertime=3;WebInspector.NetworkLogView.FilterType={Domain:"domain",HasResponseHeader:"has-response-header",Is:"is",LargerThan:"larger-than",Method:"method",MimeType:"mime-type",Scheme:"scheme",SetCookieDomain:"set-cookie-domain",SetCookieName:"set-cookie-name",SetCookieValue:"set-cookie-value",StatusCode:"status-code"};WebInspector.NetworkLogView.IsFilterType={Running:"running"};WebInspector.NetworkLogView._searchKeys=Object.values(WebInspector.NetworkLogView.FilterType);WebInspector.NetworkLogView._columnTitles={"name":WebInspector.UIString("Name"),"method":WebInspector.UIString("Method"),"status":WebInspector.UIString("Status"),"protocol":WebInspector.UIString("Protocol"),"scheme":WebInspector.UIString("Scheme"),"domain":WebInspector.UIString("Domain"),"remoteAddress":WebInspector.UIString("Remote Address"),"type":WebInspector.UIString("Type"),"initiator":WebInspector.UIString("Initiator"),"cookies":WebInspector.UIString("Cookies"),"setCookies":WebInspector.UIString("Set-Cookies"),"size":WebInspector.UIString("Size"),"time":WebInspector.UIString("Time"),"connectionId":WebInspector.UIString("Connection Id"),"timeline":WebInspector.UIString("Timeline"),"Cache-Control":WebInspector.UIString("Cache-Control"),"Connection":WebInspector.UIString("Connection"),"Content-Encoding":WebInspector.UIString("Content-Encoding"),"Content-Length":WebInspector.UIString("Content-Length"),"ETag":WebInspector.UIString("ETag"),"Keep-Alive":WebInspector.UIString("Keep-Alive"),"Last-Modified":WebInspector.UIString("Last-Modified"),"Server":WebInspector.UIString("Server"),"Vary":WebInspector.UIString("Vary")};WebInspector.NetworkLogView.prototype={setShowSelectedFrame:function(showSelectedFrame)
{this._showSelectedFrame=showSelectedFrame;this._updateEventDividers();},setSelectedFrameTime:function(frameTime)
{this._selectedFrameTime=frameTime;this._updateEventDividers();},setRecording:function(recording)
{this._recording=recording;},setPreserveLog:function(preserveLog)
{this._preserveLog=preserveLog;},targetAdded:function(target)
{target.networkLog.requests().forEach(this._appendRequest.bind(this));},targetRemoved:function(target)
{},_onWindowChanged:function(event)
{var start=(event.data.start);var end=(event.data.end);if(!start&&!end){this._timeFilter=null;this._timeCalculator.setWindow(null);}else{this._timeFilter=WebInspector.NetworkLogView._requestTimeFilter.bind(null,start,end);this._timeCalculator.setWindow(new WebInspector.NetworkTimeBoundary(start,end));}
this._updateDividersIfNeeded();this._filterRequests();},clearSelection:function()
{if(this._dataGrid.selectedNode)
this._dataGrid.selectedNode.deselect();},_addFilters:function()
{this._textFilterUI=new WebInspector.TextFilterUI();this._textFilterUI.addEventListener(WebInspector.FilterUI.Events.FilterChanged,this._filterChanged,this);this._filterBar.addFilter(this._textFilterUI);var types=[];for(var typeId in WebInspector.resourceTypes){var resourceType=WebInspector.resourceTypes[typeId];if(resourceType===WebInspector.resourceTypes.TextTrack)
continue;types.push({name:resourceType.name(),label:resourceType.categoryTitle()});}
this._resourceTypeFilterUI=new WebInspector.NamedBitSetFilterUI(types,WebInspector.settings.networkResourceTypeFilters);this._resourceTypeFilterUI.addEventListener(WebInspector.FilterUI.Events.FilterChanged,this._filterChanged.bind(this),this);this._filterBar.addFilter(this._resourceTypeFilterUI);var dataURLSetting=WebInspector.settings.networkHideDataURL;this._dataURLFilterUI=new WebInspector.CheckboxFilterUI("hide-data-url",WebInspector.UIString("Hide data URLs"),true,dataURLSetting);this._dataURLFilterUI.addEventListener(WebInspector.FilterUI.Events.FilterChanged,this._filterChanged.bind(this),this);this._filterBar.addFilter(this._dataURLFilterUI);},_resetSuggestionBuilder:function()
{this._suggestionBuilder=new WebInspector.FilterSuggestionBuilder(WebInspector.NetworkLogView._searchKeys);this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.Is,WebInspector.NetworkLogView.IsFilterType.Running);this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.LargerThan,"100");this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.LargerThan,"10k");this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.LargerThan,"1M");this._textFilterUI.setSuggestionBuilder(this._suggestionBuilder);},_filterChanged:function(event)
{this._removeAllNodeHighlights();this._parseFilterQuery(this._textFilterUI.value());this._filterRequests();},_initializeView:function()
{this.element.id="network-container";this._createSortingFunctions();this._createCalculators();this._createTable();this._createTimelineGrid();this._summaryBarElement=this.element.createChild("div","network-summary-bar");this._updateRowsSize();this._popoverHelper=new WebInspector.PopoverHelper(this.element,this._getPopoverAnchor.bind(this),this._showPopover.bind(this),this._onHidePopover.bind(this));this._popoverHelper.setTimeout(250,250);this.switchViewMode(true);},elementsToRestoreScrollPositionsFor:function()
{if(!this._dataGrid)
return[];return[this._dataGrid.scrollContainer];},_createTimelineGrid:function()
{this._timelineGrid=new WebInspector.TimelineGrid();this._timelineGrid.element.classList.add("network-timeline-grid");this._dataGrid.element.appendChild(this._timelineGrid.element);this._selectedFrameDivider=createElementWithClass("div","network-event-divider network-orange-divider invisible");this._timelineGrid.addEventDivider(this._selectedFrameDivider);this._loadDivider=createElementWithClass("div","network-event-divider network-red-divider invisible");this._timelineGrid.addEventDivider(this._loadDivider);this._domContentLoadedDivider=createElementWithClass("div","network-event-divider network-blue-divider invisible");this._timelineGrid.addEventDivider(this._domContentLoadedDivider);},_createTable:function()
{var columns=[];columns.push({id:"name",titleDOMFragment:this._makeHeaderFragment(WebInspector.UIString("Name"),WebInspector.UIString("Path")),title:WebInspector.NetworkLogView._columnTitles["name"],sortable:true,weight:20});columns.push({id:"method",title:WebInspector.NetworkLogView._columnTitles["method"],sortable:true,weight:6});columns.push({id:"status",titleDOMFragment:this._makeHeaderFragment(WebInspector.UIString("Status"),WebInspector.UIString("Text")),title:WebInspector.NetworkLogView._columnTitles["status"],sortable:true,weight:6});columns.push({id:"protocol",title:WebInspector.NetworkLogView._columnTitles["protocol"],sortable:true,weight:6});columns.push({id:"scheme",title:WebInspector.NetworkLogView._columnTitles["scheme"],sortable:true,weight:6});columns.push({id:"domain",title:WebInspector.NetworkLogView._columnTitles["domain"],sortable:true,weight:6});columns.push({id:"remoteAddress",title:WebInspector.NetworkLogView._columnTitles["remoteAddress"],sortable:true,weight:10,align:WebInspector.DataGrid.Align.Right});columns.push({id:"type",title:WebInspector.NetworkLogView._columnTitles["type"],sortable:true,weight:6});columns.push({id:"initiator",title:WebInspector.NetworkLogView._columnTitles["initiator"],sortable:true,weight:10});columns.push({id:"cookies",title:WebInspector.NetworkLogView._columnTitles["cookies"],sortable:true,weight:6,align:WebInspector.DataGrid.Align.Right});columns.push({id:"setCookies",title:WebInspector.NetworkLogView._columnTitles["setCookies"],sortable:true,weight:6,align:WebInspector.DataGrid.Align.Right});columns.push({id:"size",titleDOMFragment:this._makeHeaderFragment(WebInspector.UIString("Size"),WebInspector.UIString("Content")),title:WebInspector.NetworkLogView._columnTitles["size"],sortable:true,weight:6,align:WebInspector.DataGrid.Align.Right});columns.push({id:"time",titleDOMFragment:this._makeHeaderFragment(WebInspector.UIString("Time"),WebInspector.UIString("Latency")),title:WebInspector.NetworkLogView._columnTitles["time"],sortable:true,weight:6,align:WebInspector.DataGrid.Align.Right});columns.push({id:"connectionId",title:WebInspector.NetworkLogView._columnTitles["connectionId"],sortable:true,weight:6});var responseHeaderColumns=WebInspector.NetworkLogView._responseHeaderColumns;for(var i=0;i<responseHeaderColumns.length;++i){var headerName=responseHeaderColumns[i];var descriptor={id:headerName,title:WebInspector.NetworkLogView._columnTitles[headerName],weight:6};if(headerName==="Content-Length")
descriptor.align=WebInspector.DataGrid.Align.Right;columns.push(descriptor);}
columns.push({id:"timeline",title:WebInspector.NetworkLogView._columnTitles["timeline"],sortable:false,weight:40,sort:WebInspector.DataGrid.Order.Ascending});this._dataGrid=new WebInspector.SortableDataGrid(columns);this._dataGrid.setStickToBottom(true);this._updateColumns();this._dataGrid.setName("networkLog");this._dataGrid.setResizeMethod(WebInspector.DataGrid.ResizeMethod.Last);this._dataGrid.element.classList.add("network-log-grid");this._dataGrid.element.addEventListener("contextmenu",this._contextMenu.bind(this),true);this._dataGrid.element.addEventListener("mousedown",this._dataGridMouseDown.bind(this),true);this._dataGrid.element.addEventListener("mousemove",this._mouseMove.bind(this),true);this._dataGrid.show(this.element);this._dataGrid.addEventListener(WebInspector.DataGrid.Events.SortingChanged,this._sortItems,this);this._dataGrid.addEventListener(WebInspector.DataGrid.Events.ColumnsResized,this._updateDividersIfNeeded,this);this._patchTimelineHeader();this._dataGrid.sortNodes(this._sortingFunctions.startTime,false);},_dataGridMouseDown:function(event)
{if((!this._dataGrid.selectedNode&&event.button)||event.target.enclosingNodeOrSelfWithNodeName("a"))
event.consume();},_mouseMove:function(event)
{var target=(event.target);var cell=target.enclosingNodeOrSelfWithNodeName("td");if(!cell)
return;if(this._dataGrid.columnIdentifierFromNode(cell)!=="timeline")
return;var container=this._selectedFrameDivider.enclosingNodeOrSelfWithClass("resources-event-dividers");var percentOffset=100.0*(event.x-container.totalOffsetLeft())/container.clientWidth;var time=this._calculator.percentageToTime(percentOffset);this.dispatchEventToListeners(WebInspector.NetworkLogView.EventTypes.TimeHovered,time);this._selectedFrameTime=time;this._updateEventDividers();},_makeHeaderFragment:function(title,subtitle)
{var fragment=createDocumentFragment();fragment.createTextChild(title);var subtitleDiv=fragment.createChild("div","network-header-subtitle");subtitleDiv.createTextChild(subtitle);return fragment;},_patchTimelineHeader:function()
{var timelineSorting=createElement("select");var option=createElement("option");option.value="startTime";option.label=WebInspector.UIString("Timeline");timelineSorting.appendChild(option);option=createElement("option");option.value="startTime";option.label=WebInspector.UIString("Start Time");timelineSorting.appendChild(option);option=createElement("option");option.value="responseTime";option.label=WebInspector.UIString("Response Time");timelineSorting.appendChild(option);option=createElement("option");option.value="endTime";option.label=WebInspector.UIString("End Time");timelineSorting.appendChild(option);option=createElement("option");option.value="duration";option.label=WebInspector.UIString("Duration");timelineSorting.appendChild(option);option=createElement("option");option.value="latency";option.label=WebInspector.UIString("Latency");timelineSorting.appendChild(option);var header=this._dataGrid.headerTableHeader("timeline");header.replaceChild(timelineSorting,header.firstChild);timelineSorting.addEventListener("click",function(event){event.consume();},false);timelineSorting.addEventListener("change",this._sortByTimeline.bind(this),false);this._timelineSortSelector=timelineSorting;},_createSortingFunctions:function()
{this._sortingFunctions={};this._sortingFunctions.name=WebInspector.NetworkDataGridNode.NameComparator;this._sortingFunctions.method=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"method",false);this._sortingFunctions.status=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"statusCode",false);this._sortingFunctions.protocol=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"protocol",false);this._sortingFunctions.scheme=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"scheme",false);this._sortingFunctions.domain=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"domain",false);this._sortingFunctions.remoteAddress=WebInspector.NetworkDataGridNode.RemoteAddressComparator;this._sortingFunctions.type=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"mimeType",false);this._sortingFunctions.initiator=WebInspector.NetworkDataGridNode.InitiatorComparator;this._sortingFunctions.cookies=WebInspector.NetworkDataGridNode.RequestCookiesCountComparator;this._sortingFunctions.setCookies=WebInspector.NetworkDataGridNode.ResponseCookiesCountComparator;this._sortingFunctions.size=WebInspector.NetworkDataGridNode.SizeComparator;this._sortingFunctions.time=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"duration",false);this._sortingFunctions.connectionId=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"connectionId",false);this._sortingFunctions.timeline=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"startTime",false);this._sortingFunctions.startTime=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"startTime",false);this._sortingFunctions.endTime=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"endTime",false);this._sortingFunctions.responseTime=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"responseReceivedTime",false);this._sortingFunctions.duration=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"duration",true);this._sortingFunctions.latency=WebInspector.NetworkDataGridNode.RequestPropertyComparator.bind(null,"latency",true);},_createCalculators:function()
{this._timeCalculator=new WebInspector.NetworkTransferTimeCalculator();this._durationCalculator=new WebInspector.NetworkTransferDurationCalculator();this._calculators={};this._calculators.timeline=this._timeCalculator;this._calculators.startTime=this._timeCalculator;this._calculators.endTime=this._timeCalculator;this._calculators.responseTime=this._timeCalculator;this._calculators.duration=this._durationCalculator;this._calculators.latency=this._durationCalculator;this._calculator=this._timeCalculator;},_sortItems:function()
{this._removeAllNodeHighlights();var columnIdentifier=this._dataGrid.sortColumnIdentifier();if(columnIdentifier==="timeline"){this._sortByTimeline();return;}
var sortingFunction=this._sortingFunctions[columnIdentifier];if(!sortingFunction)
return;this._dataGrid.sortNodes(sortingFunction,!this._dataGrid.isSortOrderAscending());this._highlightNthMatchedRequestForSearch(this._updateMatchCountAndFindMatchIndex(this._currentMatchedRequestNode),false);this._timelineSortSelector.selectedIndex=0;WebInspector.notifications.dispatchEventToListeners(WebInspector.UserMetrics.UserAction,{action:WebInspector.UserMetrics.UserActionNames.NetworkSort,column:columnIdentifier,sortOrder:this._dataGrid.sortOrder()});},_sortByTimeline:function()
{this._removeAllNodeHighlights();var selectedIndex=this._timelineSortSelector.selectedIndex;if(!selectedIndex)
selectedIndex=1;var selectedOption=this._timelineSortSelector[selectedIndex];var value=selectedOption.value;this._setCalculator(this._calculators[value]);var sortingFunction=this._sortingFunctions[value];this._dataGrid.sortNodes(sortingFunction);this._highlightNthMatchedRequestForSearch(this._updateMatchCountAndFindMatchIndex(this._currentMatchedRequestNode),false);this._dataGrid.markColumnAsSortedBy("timeline",WebInspector.DataGrid.Order.Ascending);},_updateSummaryBar:function()
{var requestsNumber=this._nodesByRequestId.size;if(!requestsNumber){if(this._summaryBarElement._isDisplayingWarning)
return;this._summaryBarElement._isDisplayingWarning=true;this._summaryBarElement.removeChildren();this._summaryBarElement.createChild("label","","dt-icon-label").type="warning-icon";var text=WebInspector.UIString("No requests captured. Reload the page to see detailed information on the network activity.");this._summaryBarElement.createTextChild(text);this._summaryBarElement.title=text;return;}
delete this._summaryBarElement._isDisplayingWarning;var transferSize=0;var selectedRequestsNumber=0;var selectedTransferSize=0;var baseTime=-1;var maxTime=-1;var nodes=this._nodesByRequestId.valuesArray();for(var i=0;i<nodes.length;++i){var request=nodes[i].request();var requestTransferSize=request.transferSize;transferSize+=requestTransferSize;if(!nodes[i][WebInspector.NetworkLogView._isFilteredOutSymbol]){selectedRequestsNumber++;selectedTransferSize+=requestTransferSize;}
if(request.url===request.target().resourceTreeModel.inspectedPageURL()&&request.resourceType()===WebInspector.resourceTypes.Document)
baseTime=request.startTime;if(request.endTime>maxTime)
maxTime=request.endTime;}
var summaryBar=this._summaryBarElement;summaryBar.removeChildren();var separator="\u2002\u2758\u2002";var text="";function appendChunk(chunk)
{var span=summaryBar.createChild("span");span.textContent=chunk;text+=chunk;return span;}
if(selectedRequestsNumber!==requestsNumber){appendChunk(WebInspector.UIString("%d / %d requests",selectedRequestsNumber,requestsNumber));appendChunk(separator);appendChunk(WebInspector.UIString("%s / %s transferred",Number.bytesToString(selectedTransferSize),Number.bytesToString(transferSize)));}else{appendChunk(WebInspector.UIString("%d requests",requestsNumber));appendChunk(separator);appendChunk(WebInspector.UIString("%s transferred",Number.bytesToString(transferSize)));}
if(baseTime!==-1){appendChunk(separator);appendChunk(WebInspector.UIString("Finish: %s",Number.secondsToString(maxTime-baseTime)));if(this._mainRequestDOMContentLoadedTime!==-1&&this._mainRequestDOMContentLoadedTime>baseTime){appendChunk(separator);var domContentLoadedText=WebInspector.UIString("DOMContentLoaded: %s",Number.secondsToString(this._mainRequestDOMContentLoadedTime-baseTime));appendChunk(domContentLoadedText).classList.add("summary-blue");}
if(this._mainRequestLoadTime!==-1){appendChunk(separator);var loadText=WebInspector.UIString("Load: %s",Number.secondsToString(this._mainRequestLoadTime-baseTime));appendChunk(loadText).classList.add("summary-red");}}
summaryBar.title=text;},_scheduleRefresh:function()
{if(this._needsRefresh)
return;this._needsRefresh=true;if(this.isShowing()&&!this._refreshTimeout)
this._refreshTimeout=setTimeout(this.refresh.bind(this),WebInspector.NetworkLogView._defaultRefreshDelay);},_updateDividersIfNeeded:function()
{if(!this.isShowing()){this._scheduleRefresh();return;}
var timelineOffset=this._dataGrid.columnOffset("timeline");if(timelineOffset)
this._timelineGrid.element.style.left=timelineOffset+"px";var calculator=this.calculator();calculator.setDisplayWindow(this._timelineGrid.dividersElement.clientWidth);this._timelineGrid.updateDividers(calculator,50);if(calculator.startAtZero){return;}
this._updateEventDividers();},_updateEventDividers:function()
{var calculator=this.calculator();var selectedFrameTime=this._showSelectedFrame?this._selectedFrameTime:-1;var selectedFrameTimePercent=calculator.computePercentageFromEventTime(selectedFrameTime);this._selectedFrameDivider.classList.toggle("invisible",selectedFrameTime===-1||selectedFrameTimePercent<0);this._selectedFrameDivider.style.left=selectedFrameTimePercent+"%";var loadTimePercent=calculator.computePercentageFromEventTime(this._mainRequestLoadTime);this._loadDivider.classList.toggle("invisible",this._mainRequestLoadTime===-1||loadTimePercent<0);this._loadDivider.style.left=loadTimePercent+"%";var domLoadTimePrecent=calculator.computePercentageFromEventTime(this._mainRequestDOMContentLoadedTime);this._domContentLoadedDivider.classList.toggle("invisible",this._mainRequestDOMContentLoadedTime===-1||domLoadTimePrecent<0);this._domContentLoadedDivider.style.left=domLoadTimePrecent+"%";},_refreshIfNeeded:function()
{if(this._needsRefresh)
this.refresh();},_invalidateAllItems:function()
{var requestIds=this._nodesByRequestId.keysArray();for(var i=0;i<requestIds.length;++i)
this._staleRequestIds[requestIds[i]]=true;this.refresh();},timeCalculator:function()
{return this._timeCalculator;},calculator:function()
{return this._calculator;},_setCalculator:function(x)
{if(!x||this._calculator===x)
return;this._calculator=x;this._calculator.reset();if(this._calculator.startAtZero)
this._timelineGrid.hideEventDividers();else
this._timelineGrid.showEventDividers();this._invalidateAllItems();},_loadEventFired:function(event)
{if(!this._recording)
return;var data=(event.data);this._mainRequestLoadTime=data||-1;this._scheduleRefresh();},_domContentLoadedEventFired:function(event)
{if(!this._recording)
return;var data=(event.data);this._mainRequestDOMContentLoadedTime=data||-1;this._scheduleRefresh();},wasShown:function()
{this._refreshIfNeeded();},willHide:function()
{this._popoverHelper.hidePopover();},refresh:function()
{this._needsRefresh=false;if(this._refreshTimeout){clearTimeout(this._refreshTimeout);delete this._refreshTimeout;}
this._removeAllNodeHighlights();var oldBoundary=this.calculator().boundary();this._timeCalculator.updateBoundariesForEventTime(this._mainRequestLoadTime);this._durationCalculator.updateBoundariesForEventTime(this._mainRequestLoadTime);this._timeCalculator.updateBoundariesForEventTime(this._mainRequestDOMContentLoadedTime);this._durationCalculator.updateBoundariesForEventTime(this._mainRequestDOMContentLoadedTime);var dataGrid=this._dataGrid;var rootNode=dataGrid.rootNode();var nodesToInsert=[];for(var requestId in this._staleRequestIds){var node=this._nodesByRequestId.get(requestId);if(!node)
continue;if(!node[WebInspector.NetworkLogView._isFilteredOutSymbol])
rootNode.removeChild(node);node[WebInspector.NetworkLogView._isFilteredOutSymbol]=!this._applyFilter(node);if(!node[WebInspector.NetworkLogView._isFilteredOutSymbol])
nodesToInsert.push(node);var request=node.request();this._timeCalculator.updateBoundaries(request);this._durationCalculator.updateBoundaries(request);}
for(var i=0;i<nodesToInsert.length;++i){var node=nodesToInsert[i];var request=node.request();node.refresh();dataGrid.insertChild(node);node[WebInspector.NetworkLogView._isMatchingSearchQuerySymbol]=this._matchRequest(request);}
this._highlightNthMatchedRequestForSearch(this._updateMatchCountAndFindMatchIndex(this._currentMatchedRequestNode),false);if(this._shouldSetWaterfallWindow&&this._mainRequestLoadTime!==-1){var waterfallWindow=this.calculator().boundary();var overtime=this._mainRequestLoadTime-waterfallWindow.minimum;overtime=Number.constrain(overtime,WebInspector.NetworkLogView._waterfallMinOvertime,WebInspector.NetworkLogView._waterfallMaxOvertime)
var waterfallEnd=this._mainRequestLoadTime+overtime;if(waterfallEnd<=waterfallWindow.maximum){waterfallWindow.maximum=waterfallEnd;this._shouldSetWaterfallWindow=false;this._timeCalculator.setWindow(waterfallWindow);}}
if(!this.calculator().boundary().equals(oldBoundary)){this._updateDividersIfNeeded();var nodes=this._nodesByRequestId.valuesArray();for(var i=0;i<nodes.length;++i)
nodes[i].refreshGraph();}
this._staleRequestIds={};this._updateSummaryBar();},reset:function()
{this.dispatchEventToListeners(WebInspector.NetworkLogView.EventTypes.RequestSelected,null);this._shouldSetWaterfallWindow=Runtime.experiments.isEnabled("showPrimaryLoadWaterfallInNetworkTimeline")&&WebInspector.settings.networkShowPrimaryLoadWaterfall.get();this._clearSearchMatchedList();if(this._popoverHelper)
this._popoverHelper.hidePopover();this._overview.reset();this._timeFilter=null;this._calculator.reset();this._timeCalculator.setWindow(null);var nodes=this._nodesByRequestId.valuesArray();for(var i=0;i<nodes.length;++i)
nodes[i].dispose();this._nodesByRequestId.clear();this._staleRequestIds={};this._resetSuggestionBuilder();this._selectedFrameTime=-1;this._mainRequestLoadTime=-1;this._mainRequestDOMContentLoadedTime=-1;if(this._dataGrid){this._dataGrid.rootNode().removeChildren();this._updateDividersIfNeeded();this._updateSummaryBar();}},_onRequestStarted:function(event)
{if(!this._recording)
return;var request=(event.data);this._appendRequest(request);},_appendRequest:function(request)
{var node=new WebInspector.NetworkDataGridNode(this,request);node[WebInspector.NetworkLogView._isFilteredOutSymbol]=true;node[WebInspector.NetworkLogView._isMatchingSearchQuerySymbol]=false;var originalRequestNode=this._nodesByRequestId.get(request.requestId);if(originalRequestNode)
this._nodesByRequestId.set(originalRequestNode.request().requestId,originalRequestNode);this._nodesByRequestId.set(request.requestId,node);if(request.redirects){for(var i=0;i<request.redirects.length;++i)
this._refreshRequest(request.redirects[i]);}
this._refreshRequest(request);},_onRequestUpdated:function(event)
{var request=(event.data);this._refreshRequest(request);},_refreshRequest:function(request)
{if(!this._nodesByRequestId.get(request.requestId))
return;WebInspector.NetworkLogView._subdomains(request.domain).forEach(this._suggestionBuilder.addItem.bind(this._suggestionBuilder,WebInspector.NetworkLogView.FilterType.Domain));this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.Method,request.requestMethod);this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.MimeType,request.mimeType);this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.Scheme,""+request.scheme);this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.StatusCode,""+request.statusCode);var responseHeaders=request.responseHeaders;for(var i=0,l=responseHeaders.length;i<l;++i)
this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.HasResponseHeader,responseHeaders[i].name);var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){var cookie=cookies[i];this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.SetCookieDomain,cookie.domain());this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.SetCookieName,cookie.name());this._suggestionBuilder.addItem(WebInspector.NetworkLogView.FilterType.SetCookieValue,cookie.value());}
this._staleRequestIds[request.requestId]=true;this._overview.updateRequest(request);this._scheduleRefresh();},_mainFrameNavigated:function(event)
{if(!this._recording)
return;var frame=(event.data);var loaderId=frame.loaderId;var requestsToPick=[];var requests=frame.target().networkLog.requests();for(var i=0;i<requests.length;++i){var request=requests[i];if(request.loaderId===loaderId)
requestsToPick.push(request);}
if(!this._preserveLog){this.reset();for(var i=0;i<requestsToPick.length;++i)
this._appendRequest(requestsToPick[i]);}
for(var i=0;i<requestsToPick.length;++i){var request=requestsToPick[i];var node=this._nodesByRequestId.get(request.requestId);if(node){node.markAsNavigationRequest();break;}}},switchViewMode:function(gridMode)
{if(this._gridMode===gridMode)
return;this._gridMode=gridMode;if(gridMode){if(this._dataGrid.selectedNode)
this._dataGrid.selectedNode.selected=false;}else{this._removeAllNodeHighlights();this._popoverHelper.hidePopover();}
this.element.classList.toggle("brief-mode",!gridMode);this._updateColumns();},revealSelectedItem:function()
{if(this._dataGrid.selectedNode)
this._dataGrid.selectedNode.reveal();},rowHeight:function()
{return this._rowHeight;},_updateRowsSize:function()
{var largeRows=!!WebInspector.settings.networkLogLargeRows.get();this._rowHeight=largeRows?41:21;this._dataGrid.element.classList.toggle("small",!largeRows);this._timelineGrid.element.classList.toggle("small",!largeRows);this._dataGrid.scheduleUpdate();},_getPopoverAnchor:function(element,event)
{if(!this._gridMode)
return;var anchor=element.enclosingNodeOrSelfWithClass("network-graph-bar")||element.enclosingNodeOrSelfWithClass("network-graph-label");if(anchor&&anchor.parentElement.request&&anchor.parentElement.request.timing)
return anchor;anchor=element.enclosingNodeOrSelfWithClass("network-script-initiated");if(anchor&&anchor.request){var initiator=(anchor.request).initiator();if(initiator&&(initiator.stackTrace||initiator.asyncStackTrace))
return anchor;}},_showPopover:function(anchor,popover)
{var content;if(anchor.classList.contains("network-script-initiated")){var request=(anchor.request);var initiator=(request.initiator());content=WebInspector.DOMPresentationUtils.buildStackTracePreviewContents(request.target(),this._popupLinkifier,initiator.stackTrace,initiator.asyncStackTrace);popover.setCanShrink(true);}else{content=WebInspector.RequestTimingView.createTimingTable(anchor.parentElement.request,this._timeCalculator.minimumBoundary());popover.setCanShrink(false);}
popover.showForAnchor(content,anchor);},_onHidePopover:function()
{this._popupLinkifier.reset();},_updateColumns:function()
{if(!this._dataGrid)
return;var gridMode=this._gridMode;var visibleColumns={"name":true};if(gridMode)
visibleColumns["timeline"]=true;if(gridMode){var columnsVisibility=this._columnsVisibilitySetting.get();for(var columnIdentifier in columnsVisibility)
visibleColumns[columnIdentifier]=columnsVisibility[columnIdentifier];}
this._dataGrid.setColumnsVisiblity(visibleColumns);},_toggleColumnVisibility:function(columnIdentifier)
{var columnsVisibility=this._columnsVisibilitySetting.get();columnsVisibility[columnIdentifier]=!columnsVisibility[columnIdentifier];this._columnsVisibilitySetting.set(columnsVisibility);this._updateColumns();},_getConfigurableColumnIDs:function()
{if(this._configurableColumnIDs)
return this._configurableColumnIDs;var columnTitles=WebInspector.NetworkLogView._columnTitles;function compare(id1,id2)
{return columnTitles[id1].compareTo(columnTitles[id2]);}
var columnIDs=Object.keys(this._columnsVisibilitySetting.get());this._configurableColumnIDs=columnIDs.sort(compare);return this._configurableColumnIDs;},_contextMenu:function(event)
{var contextMenu=new WebInspector.ContextMenu(event);if(this._gridMode&&event.target.isSelfOrDescendant(this._dataGrid.headerTableBody)){var columnsVisibility=this._columnsVisibilitySetting.get();var columnIDs=this._getConfigurableColumnIDs();var columnTitles=WebInspector.NetworkLogView._columnTitles;for(var i=0;i<columnIDs.length;++i){var columnIdentifier=columnIDs[i];contextMenu.appendCheckboxItem(columnTitles[columnIdentifier],this._toggleColumnVisibility.bind(this,columnIdentifier),!!columnsVisibility[columnIdentifier]);}
contextMenu.show();return;}
var gridNode=this._dataGrid.dataGridNodeFromNode(event.target);var request=gridNode&&gridNode.request();function openResourceInNewTab(url)
{InspectorFrontendHost.openInNewTab(url);}
if(request){contextMenu.appendApplicableItems(request);if(request.requestHeadersText())
contextMenu.appendItem(WebInspector.UIString.capitalize("Copy ^request ^headers"),this._copyRequestHeaders.bind(this,request));if(request.responseHeadersText)
contextMenu.appendItem(WebInspector.UIString.capitalize("Copy ^response ^headers"),this._copyResponseHeaders.bind(this,request));if(request.finished)
contextMenu.appendItem(WebInspector.UIString.capitalize("Copy ^response"),this._copyResponse.bind(this,request));contextMenu.appendItem(WebInspector.UIString("Copy as cURL"),this._copyCurlCommand.bind(this,request));}
contextMenu.appendItem(WebInspector.UIString.capitalize("Copy ^all as HAR"),this._copyAll.bind(this));contextMenu.appendSeparator();contextMenu.appendItem(WebInspector.UIString.capitalize("Save as HAR with ^content"),this._exportAll.bind(this));contextMenu.appendSeparator();contextMenu.appendItem(WebInspector.UIString.capitalize("Clear ^browser ^cache"),this._clearBrowserCache.bind(this));contextMenu.appendItem(WebInspector.UIString.capitalize("Clear ^browser ^cookies"),this._clearBrowserCookies.bind(this));if(request&&request.resourceType()===WebInspector.resourceTypes.XHR){contextMenu.appendSeparator();contextMenu.appendItem(WebInspector.UIString("Replay XHR"),request.replayXHR.bind(request));contextMenu.appendSeparator();}
contextMenu.show();},_harRequests:function()
{var requests=this._nodesByRequestId.valuesArray().map(function(node){return node.request();});var httpRequests=requests.filter(WebInspector.NetworkLogView.HTTPRequestsFilter);return httpRequests.filter(WebInspector.NetworkLogView.FinishedRequestsFilter);},_copyAll:function()
{var harArchive={log:(new WebInspector.HARLog(this._harRequests())).build()};InspectorFrontendHost.copyText(JSON.stringify(harArchive,null,2));},_copyRequestHeaders:function(request)
{InspectorFrontendHost.copyText(request.requestHeadersText());},_copyResponse:function(request)
{function callback(content)
{if(request.contentEncoded)
content=request.asDataURL();InspectorFrontendHost.copyText(content||"");}
request.requestContent(callback);},_copyResponseHeaders:function(request)
{InspectorFrontendHost.copyText(request.responseHeadersText);},_copyCurlCommand:function(request)
{InspectorFrontendHost.copyText(this._generateCurlCommand(request));},_exportAll:function()
{var filename=WebInspector.targetManager.inspectedPageDomain()+".har";var stream=new WebInspector.FileOutputStream();stream.open(filename,openCallback.bind(this));function openCallback(accepted)
{if(!accepted)
return;var progressIndicator=new WebInspector.ProgressIndicator();this._progressBarContainer.appendChild(progressIndicator.element);var harWriter=new WebInspector.HARWriter();harWriter.write(stream,this._harRequests(),progressIndicator);}},_clearBrowserCache:function()
{if(confirm(WebInspector.UIString("Are you sure you want to clear browser cache?"))){var target=WebInspector.targetManager.mainTarget()
if(target)
target.networkManager.clearBrowserCache();}},_clearBrowserCookies:function()
{if(confirm(WebInspector.UIString("Are you sure you want to clear browser cookies?"))){var target=WebInspector.targetManager.mainTarget()
if(target)
target.networkManager.clearBrowserCookies();}},_matchRequest:function(request)
{var re=this._searchRegExp;if(!re)
return false;return re.test(request.name())||(WebInspector.settings.networkLogLargeRows.get()&&re.test(request.path()));},_clearSearchMatchedList:function()
{this._matchedRequestCount=-1;this._currentMatchedRequestNode=null;this._removeAllHighlights();},_removeAllHighlights:function()
{this._removeAllNodeHighlights();for(var i=0;i<this._highlightedSubstringChanges.length;++i)
WebInspector.revertDomChanges(this._highlightedSubstringChanges[i]);this._highlightedSubstringChanges=[];},_highlightNthMatchedRequestForSearch:function(n,reveal)
{this._removeAllHighlights();var nodes=this._dataGrid.rootNode().children;var matchCount=0;var node=null;for(var i=0;i<nodes.length;++i){if(nodes[i][WebInspector.NetworkLogView._isMatchingSearchQuerySymbol]){if(matchCount===n){node=nodes[i];break;}
matchCount++;}}
if(!node){this._currentMatchedRequestNode=null;return;}
var request=node.request();if(reveal)
WebInspector.Revealer.reveal(request);var highlightedSubstringChanges=node.highlightMatchedSubstring(this._searchRegExp);this._highlightedSubstringChanges.push(highlightedSubstringChanges);this._currentMatchedRequestNode=node;this._currentMatchedRequestIndex=n;this.dispatchEventToListeners(WebInspector.NetworkLogView.EventTypes.SearchIndexUpdated,n);},performSearch:function(searchConfig,shouldJump,jumpBackwards)
{var query=searchConfig.query;var currentMatchedRequestNode=this._currentMatchedRequestNode;this._clearSearchMatchedList();this._searchRegExp=createPlainTextSearchRegex(query,"i");var nodes=this._dataGrid.rootNode().children;for(var i=0;i<nodes.length;++i)
nodes[i][WebInspector.NetworkLogView._isMatchingSearchQuerySymbol]=this._matchRequest(nodes[i].request());var newMatchedRequestIndex=this._updateMatchCountAndFindMatchIndex(currentMatchedRequestNode);if(!newMatchedRequestIndex&&jumpBackwards)
newMatchedRequestIndex=this._matchedRequestCount-1;this._highlightNthMatchedRequestForSearch(newMatchedRequestIndex,shouldJump);},supportsCaseSensitiveSearch:function()
{return false;},supportsRegexSearch:function()
{return false;},_updateMatchCountAndFindMatchIndex:function(node)
{var nodes=this._dataGrid.rootNode().children;var matchCount=0;var matchIndex=0;for(var i=0;i<nodes.length;++i){if(!nodes[i][WebInspector.NetworkLogView._isMatchingSearchQuerySymbol])
continue;if(node===nodes[i])
matchIndex=matchCount;matchCount++;}
if(this._matchedRequestCount!==matchCount){this._matchedRequestCount=matchCount;this.dispatchEventToListeners(WebInspector.NetworkLogView.EventTypes.SearchCountUpdated,matchCount);}
return matchIndex;},_normalizeSearchResultIndex:function(index)
{return(index+this._matchedRequestCount)%this._matchedRequestCount;},_applyFilter:function(node)
{var request=node.request();if(this._timeFilter&&!this._timeFilter(request))
return false;var resourceType=request.resourceType();if(resourceType===WebInspector.resourceTypes.TextTrack)
resourceType=WebInspector.resourceTypes.Other;if(!this._resourceTypeFilterUI.accept(resourceType.name()))
return false;if(this._dataURLFilterUI.checked()&&request.parsedURL.isDataURL())
return false;for(var i=0;i<this._filters.length;++i){if(!this._filters[i](request))
return false;}
return true;},_parseFilterQuery:function(query)
{var parsedQuery=this._suggestionBuilder.parseQuery(query);this._filters=parsedQuery.text.map(this._createTextFilter);var n=parsedQuery.filters.length;for(var i=0;i<n;++i){var filter=parsedQuery.filters[i];var filterType=(filter.type.toLowerCase());this._filters.push(this._createFilter(filterType,filter.data,filter.negative));}},_createTextFilter:function(text)
{var negative=false;if(text[0]==="-"&&text.length>1){negative=true;text=text.substring(1);}
var regexp=new RegExp(text.escapeForRegExp(),"i");var filter=WebInspector.NetworkLogView._requestNameOrPathFilter.bind(null,regexp);if(negative)
filter=WebInspector.NetworkLogView._negativeFilter.bind(null,filter);return filter;},_createFilter:function(type,value,negative)
{var filter=this._createSpecialFilter(type,value);if(!filter)
return this._createTextFilter((negative?"-":"")+type+":"+value);if(negative)
return WebInspector.NetworkLogView._negativeFilter.bind(null,filter);return filter;},_createSpecialFilter:function(type,value)
{switch(type){case WebInspector.NetworkLogView.FilterType.Domain:return WebInspector.NetworkLogView._createRequestDomainFilter(value);case WebInspector.NetworkLogView.FilterType.HasResponseHeader:return WebInspector.NetworkLogView._requestResponseHeaderFilter.bind(null,value);case WebInspector.NetworkLogView.FilterType.Is:if(value.toLowerCase()===WebInspector.NetworkLogView.IsFilterType.Running)
return WebInspector.NetworkLogView._runningRequestFilter;break;case WebInspector.NetworkLogView.FilterType.LargerThan:return this._createSizeFilter(value.toLowerCase());case WebInspector.NetworkLogView.FilterType.Method:return WebInspector.NetworkLogView._requestMethodFilter.bind(null,value);case WebInspector.NetworkLogView.FilterType.MimeType:return WebInspector.NetworkLogView._requestMimeTypeFilter.bind(null,value);case WebInspector.NetworkLogView.FilterType.Scheme:return WebInspector.NetworkLogView._requestSchemeFilter.bind(null,value);case WebInspector.NetworkLogView.FilterType.SetCookieDomain:return WebInspector.NetworkLogView._requestSetCookieDomainFilter.bind(null,value);case WebInspector.NetworkLogView.FilterType.SetCookieName:return WebInspector.NetworkLogView._requestSetCookieNameFilter.bind(null,value);case WebInspector.NetworkLogView.FilterType.SetCookieValue:return WebInspector.NetworkLogView._requestSetCookieValueFilter.bind(null,value);case WebInspector.NetworkLogView.FilterType.StatusCode:return WebInspector.NetworkLogView._statusCodeFilter.bind(null,value);}
return null;},_createSizeFilter:function(value)
{var multiplier=1;if(value.endsWith("k")){multiplier=1024;value=value.substring(0,value.length-1);}else if(value.endsWith("m")){multiplier=1024*1024;value=value.substring(0,value.length-1);}
var quantity=Number(value);if(isNaN(quantity))
return null;return WebInspector.NetworkLogView._requestSizeLargerThanFilter.bind(null,quantity*multiplier);},_filterRequests:function()
{this._removeAllHighlights();this._invalidateAllItems();},jumpToPreviousSearchResult:function()
{if(!this._matchedRequestCount)
return;var index=this._normalizeSearchResultIndex(this._currentMatchedRequestIndex-1);this._highlightNthMatchedRequestForSearch(index,true);},jumpToNextSearchResult:function()
{if(!this._matchedRequestCount)
return;var index=this._normalizeSearchResultIndex(this._currentMatchedRequestIndex+1);this._highlightNthMatchedRequestForSearch(index,true);},searchCanceled:function()
{delete this._searchRegExp;this._clearSearchMatchedList();this.dispatchEventToListeners(WebInspector.NetworkLogView.EventTypes.SearchCountUpdated,0);},revealAndHighlightRequest:function(request)
{this._removeAllNodeHighlights();var node=this._nodesByRequestId.get(request.requestId);if(node){node.reveal();this._highlightNode(node);}},_removeAllNodeHighlights:function()
{if(this._highlightedNode){this._highlightedNode.element().classList.remove("highlighted-row");delete this._highlightedNode;}},_highlightNode:function(node)
{WebInspector.runCSSAnimationOnce(node.element(),"highlighted-row");this._highlightedNode=node;},_generateCurlCommand:function(request)
{var command=["curl"];var ignoredHeaders={"host":1,"method":1,"path":1,"scheme":1,"version":1};function escapeStringWin(str)
{return"\""+str.replace(/"/g,"\"\"").replace(/%/g,"\"%\"").replace(/\\/g,"\\\\").replace(/[\r\n]+/g,"\"^$&\"")+"\"";}
function escapeStringPosix(str)
{function escapeCharacter(x)
{var code=x.charCodeAt(0);if(code<256){return code<16?"\\x0"+code.toString(16):"\\x"+code.toString(16);}
code=code.toString(16);return"\\u"+("0000"+code).substr(code.length,4);}
if(/[^\x20-\x7E]|\'/.test(str)){return"$\'"+str.replace(/\\/g,"\\\\").replace(/\'/g,"\\\'").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[^\x20-\x7E]/g,escapeCharacter)+"'";}else{return"'"+str+"'";}}
var escapeString=WebInspector.isWin()?escapeStringWin:escapeStringPosix;command.push(escapeString(request.url).replace(/[[{}\]]/g,"\\$&"));var inferredMethod="GET";var data=[];var requestContentType=request.requestContentType();if(requestContentType&&requestContentType.startsWith("application/x-www-form-urlencoded")&&request.requestFormData){data.push("--data");data.push(escapeString(request.requestFormData));ignoredHeaders["content-length"]=true;inferredMethod="POST";}else if(request.requestFormData){data.push("--data-binary");data.push(escapeString(request.requestFormData));ignoredHeaders["content-length"]=true;inferredMethod="POST";}
if(request.requestMethod!==inferredMethod){command.push("-X");command.push(request.requestMethod);}
var requestHeaders=request.requestHeaders();for(var i=0;i<requestHeaders.length;i++){var header=requestHeaders[i];var name=header.name.replace(/^:/,"");if(name.toLowerCase()in ignoredHeaders)
continue;command.push("-H");command.push(escapeString(name+": "+header.value));}
command=command.concat(data);command.push("--compressed");return command.join(" ");},__proto__:WebInspector.VBox.prototype}
WebInspector.NetworkLogView.Filter;WebInspector.NetworkLogView._negativeFilter=function(filter,request)
{return!filter(request);}
WebInspector.NetworkLogView._requestNameOrPathFilter=function(regex,request)
{return regex.test(request.name())||regex.test(request.path());}
WebInspector.NetworkLogView._subdomains=function(domain)
{var result=[domain];var indexOfPeriod=domain.indexOf(".");while(indexOfPeriod!==-1){result.push("*"+domain.substring(indexOfPeriod));indexOfPeriod=domain.indexOf(".",indexOfPeriod+1);}
return result;}
WebInspector.NetworkLogView._createRequestDomainFilter=function(value)
{function escapeForRegExp(string)
{return string.escapeForRegExp();}
var escapedPattern=value.split("*").map(escapeForRegExp).join(".*");return WebInspector.NetworkLogView._requestDomainFilter.bind(null,new RegExp("^"+escapedPattern+"$","i"));}
WebInspector.NetworkLogView._requestDomainFilter=function(regex,request)
{return regex.test(request.domain);}
WebInspector.NetworkLogView._runningRequestFilter=function(request)
{return!request.finished;}
WebInspector.NetworkLogView._requestResponseHeaderFilter=function(value,request)
{return request.responseHeaderValue(value)!==undefined;}
WebInspector.NetworkLogView._requestMethodFilter=function(value,request)
{return request.requestMethod===value;}
WebInspector.NetworkLogView._requestMimeTypeFilter=function(value,request)
{return request.mimeType===value;}
WebInspector.NetworkLogView._requestSchemeFilter=function(value,request)
{return request.scheme===value;}
WebInspector.NetworkLogView._requestSetCookieDomainFilter=function(value,request)
{var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].domain()===value)
return true;}
return false;}
WebInspector.NetworkLogView._requestSetCookieNameFilter=function(value,request)
{var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].name()===value)
return true;}
return false;}
WebInspector.NetworkLogView._requestSetCookieValueFilter=function(value,request)
{var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].value()===value)
return true;}
return false;}
WebInspector.NetworkLogView._requestSizeLargerThanFilter=function(value,request)
{return request.transferSize>=value;}
WebInspector.NetworkLogView._statusCodeFilter=function(value,request)
{return(""+request.statusCode)===value;}
WebInspector.NetworkLogView.HTTPRequestsFilter=function(request)
{return request.parsedURL.isValid&&(request.scheme in WebInspector.NetworkLogView.HTTPSchemas);}
WebInspector.NetworkLogView.FinishedRequestsFilter=function(request)
{return request.finished;}
WebInspector.NetworkLogView._requestTimeFilter=function(windowStart,windowEnd,request)
{if(request.issueTime()>windowEnd)
return false;if(request.endTime!==-1&&request.endTime<windowStart)
return false;return true;}
WebInspector.NetworkLogView.EventTypes={RequestSelected:"RequestSelected",SearchCountUpdated:"SearchCountUpdated",SearchIndexUpdated:"SearchIndexUpdated",TimeHovered:"TimeHovered"};;WebInspector.NetworkOverview=function()
{WebInspector.VBox.call(this);this.element.classList.add("network-overview");this._overviewGrid=new WebInspector.OverviewGrid("network");this._overviewContainer=this._overviewGrid.element.createChild("div","network-overview-canvas-container");this._overviewCanvas=this._overviewContainer.createChild("canvas","network-overview-canvas");this._calculator=new WebInspector.NetworkTransferTimeCalculator();this._numBands=1;this._windowStart=0;this._windowEnd=0;this._restoringWindow=false;this._updateScheduled=false;this._canvasWidth=0;this._canvasHeight=0;this._overviewGrid.addEventListener(WebInspector.OverviewGrid.Events.WindowChanged,this._onWindowChanged,this);this.element.appendChild(this._overviewGrid.element);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.Load,this._loadEventFired,this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.DOMContentLoaded,this._domContentLoadedEventFired,this);this.reset();}
WebInspector.NetworkOverview._bandHeight=3;WebInspector.NetworkOverview._dividersBarHeight=20;WebInspector.NetworkOverview.Events={WindowChanged:"WindowChanged"}
WebInspector.NetworkOverview.Window;WebInspector.NetworkOverview.prototype={_onWindowChanged:function(event)
{if(this._restoringWindow)
return;var startTime=this._calculator.minimumBoundary();var totalTime=this._calculator.boundarySpan();var left=this._overviewGrid.windowLeft();var right=this._overviewGrid.windowRight();if(left===0&&right===1){this._windowStart=0;this._windowEnd=0;}else{this._windowStart=startTime+left*totalTime;this._windowEnd=startTime+right*totalTime;}
this.dispatchEventToListeners(WebInspector.NetworkOverview.Events.WindowChanged,{start:this._windowStart,end:this._windowEnd});},_loadEventFired:function(event)
{var data=(event.data);if(data)
this._loadEvents.push(data);this.scheduleUpdate();},_domContentLoadedEventFired:function(event)
{var data=(event.data);if(data)
this._domContentLoadedEvents.push(data);this.scheduleUpdate();},_bandId:function(connectionId)
{if(!connectionId||connectionId==="0")
return-1;if(this._bandMap.has(connectionId))
return(this._bandMap.get(connectionId));var result=this._nextBand++;this._bandMap.set(connectionId,result);return result;},updateRequest:function(request)
{if(!this._requestsList.length){this._calculator.reset();this.onResize();}
this._calculator.updateBoundaries(request);if(!this._requestsSet.has(request)){this._requestsSet.add(request);this._requestsList.push(request);}
this.scheduleUpdate();},wasShown:function()
{this.onResize();},onResize:function()
{var width=this._overviewContainer.offsetWidth;var height=this._overviewContainer.offsetHeight;this._calculator.setDisplayWindow(width);this._resetCanvas(width,height);var numBands=(((height-WebInspector.NetworkOverview._dividersBarHeight-1)/WebInspector.NetworkOverview._bandHeight)-1)|0;this._numBands=(numBands>0)?numBands:1;this.scheduleUpdate();},reset:function()
{this._calculator.reset();this._calculator.setInitialUserFriendlyBoundaries();this._overviewGrid.reset();this._windowStart=0;this._windowEnd=0;this._span=1;this._lastBoundary=this._calculator.boundary();this._nextBand=0;this._bandMap=new Map();this._requestsList=[];this._requestsSet=new Set();this._loadEvents=[];this._domContentLoadedEvents=[];var width=this._overviewContainer.offsetWidth;var height=this._overviewContainer.offsetHeight;this._resetCanvas(width,height);this._update();},scheduleUpdate:function()
{if(this._updateScheduled||!this.isShowing())
return;this._updateScheduled=true;this.element.window().requestAnimationFrame(this._update.bind(this));},_update:function()
{this._updateScheduled=false;var newBoundary=this._calculator.boundary();if(!newBoundary.equals(this._lastBoundary)){var span=this._calculator.boundarySpan();while(this._span<span)
this._span*=1.25;this._calculator.updateBoundariesForEventTime(this._calculator.minimumBoundary()+this._span);this._lastBoundary=this._calculator.boundary();this._overviewGrid.updateDividers(this._calculator);if(this._windowStart||this._windowEnd){this._restoringWindow=true;var startTime=this._calculator.minimumBoundary();var totalTime=this._calculator.boundarySpan();var left=(this._windowStart-startTime)/totalTime;var right=(this._windowEnd-startTime)/totalTime;this._overviewGrid.setWindow(left,right);this._restoringWindow=false;}}
var context=this._overviewCanvas.getContext("2d");var calculator=this._calculator;var linesByType={};var paddingTop=WebInspector.NetworkOverview._dividersBarHeight;function drawLines(type,strokeStyle)
{var lines=linesByType[type];if(!lines)
return;var n=lines.length;context.beginPath();context.strokeStyle=strokeStyle;for(var i=0;i<n;){var y=lines[i++]*WebInspector.NetworkOverview._bandHeight+2+paddingTop;var startTime=lines[i++];var endTime=lines[i++];if(endTime===Number.MAX_VALUE)
endTime=calculator.maximumBoundary();context.moveTo(calculator.computePosition(startTime),y);context.lineTo(calculator.computePosition(endTime)+1,y);}
context.stroke();}
function addLine(type,y,start,end)
{var lines=linesByType[type];if(!lines){lines=[];linesByType[type]=lines;}
lines.push(y,start,end);}
var requests=this._requestsList;var n=requests.length;for(var i=0;i<n;++i){var request=requests[i];var band=this._bandId(request.connectionId);var y=(band===-1)?0:(band%this._numBands+1);var timeRanges=WebInspector.RequestTimingView.calculateRequestTimeRanges(request);for(var j=0;j<timeRanges.length;++j){var type=timeRanges[j].name;if(band!==-1||type===WebInspector.RequestTimeRangeNames.Total)
addLine(type,y,timeRanges[j].start,timeRanges[j].end);}}
context.clearRect(0,0,this._overviewCanvas.width,this._overviewCanvas.height);context.save();context.scale(window.devicePixelRatio,window.devicePixelRatio);context.fillStyle="white";context.lineWidth=0;context.fillRect(0,paddingTop,this._canvasWidth,this._canvasHeight-paddingTop);context.lineWidth=2;drawLines(WebInspector.RequestTimeRangeNames.Total,"#CCCCCC");drawLines(WebInspector.RequestTimeRangeNames.Blocking,"#AAAAAA");drawLines(WebInspector.RequestTimeRangeNames.Connecting,"#FF9800");drawLines(WebInspector.RequestTimeRangeNames.ServiceWorker,"#FF9800");drawLines(WebInspector.RequestTimeRangeNames.ServiceWorkerPreparation,"#FF9800");drawLines(WebInspector.RequestTimeRangeNames.Proxy,"#A1887F");drawLines(WebInspector.RequestTimeRangeNames.DNS,"#009688");drawLines(WebInspector.RequestTimeRangeNames.SSL,"#9C27B0");drawLines(WebInspector.RequestTimeRangeNames.Sending,"#B0BEC5");drawLines(WebInspector.RequestTimeRangeNames.Waiting,"#00C853");drawLines(WebInspector.RequestTimeRangeNames.Receiving,"#03A9F4");context.lineWidth=1;context.beginPath();context.strokeStyle="#8080FF";for(var i=this._domContentLoadedEvents.length;i>=0;--i){var x=Math.round(calculator.computePosition(this._domContentLoadedEvents[i]));context.moveTo(x+0.5,0);context.lineTo(x+0.5,this._canvasHeight);}
context.stroke();context.beginPath();context.strokeStyle="#FF8080";for(var i=this._loadEvents.length;i>=0;--i){var x=Math.round(calculator.computePosition(this._loadEvents[i]));context.moveTo(x+0.5,0);context.lineTo(x+0.5,this._canvasHeight);}
context.stroke();context.restore();},_resetCanvas:function(width,height)
{this._canvasWidth=width;this._canvasHeight=height;this._overviewCanvas.width=width*window.devicePixelRatio;this._overviewCanvas.height=height*window.devicePixelRatio;this._overviewGrid.updateDividers(this._calculator);},__proto__:WebInspector.VBox.prototype};WebInspector.RequestCookiesView=function(request)
{WebInspector.VBox.call(this);this.registerRequiredCSS("network/requestCookiesView.css");this.element.classList.add("request-cookies-view");this._request=request;}
WebInspector.RequestCookiesView.prototype={wasShown:function()
{this._request.addEventListener(WebInspector.NetworkRequest.Events.RequestHeadersChanged,this._refreshCookies,this);this._request.addEventListener(WebInspector.NetworkRequest.Events.ResponseHeadersChanged,this._refreshCookies,this);if(!this._gotCookies){if(!this._emptyView){this._emptyView=new WebInspector.EmptyView(WebInspector.UIString("This request has no cookies."));this._emptyView.show(this.element);}
return;}
if(!this._cookiesTable)
this._buildCookiesTable();},willHide:function()
{this._request.removeEventListener(WebInspector.NetworkRequest.Events.RequestHeadersChanged,this._refreshCookies,this);this._request.removeEventListener(WebInspector.NetworkRequest.Events.ResponseHeadersChanged,this._refreshCookies,this);},get _gotCookies()
{return(this._request.requestCookies&&this._request.requestCookies.length)||(this._request.responseCookies&&this._request.responseCookies.length);},_buildCookiesTable:function()
{this.detachChildViews();this._cookiesTable=new WebInspector.CookiesTable(true);this._cookiesTable.setCookieFolders([{folderName:WebInspector.UIString("Request Cookies"),cookies:this._request.requestCookies},{folderName:WebInspector.UIString("Response Cookies"),cookies:this._request.responseCookies}]);this._cookiesTable.show(this.element);},_refreshCookies:function()
{delete this._cookiesTable;if(!this._gotCookies||!this.isShowing())
return;this._buildCookiesTable();},__proto__:WebInspector.VBox.prototype};WebInspector.RequestHeadersView=function(request)
{WebInspector.VBox.call(this);this.registerRequiredCSS("network/requestHeadersView.css");this.element.classList.add("request-headers-view");this._request=request;this._decodeRequestParameters=true;this._showRequestHeadersText=false;this._showResponseHeadersText=false;this._filterRegex=null;if(Runtime.experiments.isEnabled("networkRequestHeadersFilterInDetailsView")){this._filterInput=this.element.createChild("input","filter-input");this._filterInput.type="text";this._filterInput.placeholder=WebInspector.UIString("Filter headers");this._filterInput.addEventListener("input",this._updateFilter.bind(this),false);this._filterInput.addEventListener("keydown",this._onFilterKeyDown.bind(this),false);this._filterInput.value=WebInspector.RequestHeadersView._requestHeaderFilterSetting.get()||"";}
var root=new TreeOutline(true);root.element.classList.add("outline-disclosure");root.expandTreeElementsWhenArrowing=true;this.element.appendChild(root.element);var generalCategory=new WebInspector.RequestHeadersView.Category(root,"general",WebInspector.UIString("General"));generalCategory.hidden=false;this._remoteAddressItem=generalCategory.createLeaf();this._remoteAddressItem.hidden=true;this._urlItem=generalCategory.createLeaf();this._requestMethodItem=generalCategory.createLeaf();this._statusCodeItem=generalCategory.createLeaf();this._responseHeadersCategory=new WebInspector.RequestHeadersView.Category(root,"responseHeaders","");this._requestHeadersCategory=new WebInspector.RequestHeadersView.Category(root,"requestHeaders","");this._queryStringCategory=new WebInspector.RequestHeadersView.Category(root,"queryString","");this._formDataCategory=new WebInspector.RequestHeadersView.Category(root,"formData","");this._requestPayloadCategory=new WebInspector.RequestHeadersView.Category(root,"requestPayload",WebInspector.UIString("Request Payload"));if(Runtime.experiments.isEnabled("networkRequestHeadersFilterInDetailsView")){this._updateFilter();}}
WebInspector.RequestHeadersView._requestHeaderFilterSetting=new WebInspector.Setting("requestHeaderFilterSetting","",new WebInspector.Object(),null);WebInspector.RequestHeadersView.prototype={_updateFilter:function()
{var text=this._filterInput.value;WebInspector.RequestHeadersView._requestHeaderFilterSetting.set(text);this._filterRegex=text?new RegExp(text.escapeForRegExp(),"i"):null;this._updateHeaders();},_onFilterKeyDown:function(event)
{var text=this._filterInput.value;if(!text)
return;if(event.keyCode===WebInspector.KeyboardShortcut.Keys.Esc.code||event.keyIdentifier==="U+001B"){event.consume(true);this._filterInput.value="";this._updateFilter();}},_updateHeaders:function()
{this._refreshRequestHeaders();this._refreshResponseHeaders();},wasShown:function()
{this._request.addEventListener(WebInspector.NetworkRequest.Events.RemoteAddressChanged,this._refreshRemoteAddress,this);this._request.addEventListener(WebInspector.NetworkRequest.Events.RequestHeadersChanged,this._refreshRequestHeaders,this);this._request.addEventListener(WebInspector.NetworkRequest.Events.ResponseHeadersChanged,this._refreshResponseHeaders,this);this._request.addEventListener(WebInspector.NetworkRequest.Events.FinishedLoading,this._refreshHTTPInformation,this);this._refreshURL();this._refreshQueryString();this._updateHeaders();this._refreshHTTPInformation();this._refreshRemoteAddress();},willHide:function()
{this._request.removeEventListener(WebInspector.NetworkRequest.Events.RemoteAddressChanged,this._refreshRemoteAddress,this);this._request.removeEventListener(WebInspector.NetworkRequest.Events.RequestHeadersChanged,this._refreshRequestHeaders,this);this._request.removeEventListener(WebInspector.NetworkRequest.Events.ResponseHeadersChanged,this._refreshResponseHeaders,this);this._request.removeEventListener(WebInspector.NetworkRequest.Events.FinishedLoading,this._refreshHTTPInformation,this);},_formatHeader:function(name,value)
{var fragment=createDocumentFragment();fragment.createChild("div","header-name").textContent=name+":";fragment.createChild("div","header-value source-code").textContent=value;return fragment;},_formatParameter:function(value,className,decodeParameters)
{var errorDecoding=false;if(decodeParameters){value=value.replace(/\+/g," ");if(value.indexOf("%")>=0){try{value=decodeURIComponent(value);}catch(e){errorDecoding=true;}}}
var div=createElementWithClass("div",className);if(errorDecoding)
div.createChild("span","error-message").textContent=WebInspector.UIString("(unable to decode value)");else
div.textContent=value;return div;},_refreshURL:function()
{this._urlItem.title=this._formatHeader(WebInspector.UIString("Request URL"),this._request.url);},_refreshQueryString:function()
{var queryString=this._request.queryString();var queryParameters=this._request.queryParameters;this._queryStringCategory.hidden=!queryParameters;if(queryParameters)
this._refreshParams(WebInspector.UIString("Query String Parameters"),queryParameters,queryString,this._queryStringCategory);},_refreshFormData:function()
{this._formDataCategory.hidden=true;this._requestPayloadCategory.hidden=true;var formData=this._request.requestFormData;if(!formData)
return;var formParameters=this._request.formParameters;if(formParameters){this._formDataCategory.hidden=false;this._refreshParams(WebInspector.UIString("Form Data"),formParameters,formData,this._formDataCategory);}else{this._requestPayloadCategory.hidden=false;try{var json=JSON.parse(formData);this._refreshRequestJSONPayload(json,formData);}catch(e){this._populateTreeElementWithSourceText(this._requestPayloadCategory,formData);}}},_populateTreeElementWithSourceText:function(treeElement,sourceText)
{var sourceTextElement=createElementWithClass("span","header-value source-code");sourceTextElement.textContent=String(sourceText||"").trim();var sourceTreeElement=new TreeElement(sourceTextElement);sourceTreeElement.selectable=false;treeElement.removeChildren();treeElement.appendChild(sourceTreeElement);},_refreshParams:function(title,params,sourceText,paramsTreeElement)
{paramsTreeElement.removeChildren();paramsTreeElement.listItemElement.removeChildren();paramsTreeElement.listItemElement.createTextChild(title);var headerCount=createElementWithClass("span","header-count");headerCount.textContent=WebInspector.UIString("\u00A0(%d)",params.length);paramsTreeElement.listItemElement.appendChild(headerCount);function toggleViewSource(event)
{paramsTreeElement._viewSource=!paramsTreeElement._viewSource;this._refreshParams(title,params,sourceText,paramsTreeElement);event.consume();}
paramsTreeElement.listItemElement.appendChild(this._createViewSourceToggle(paramsTreeElement._viewSource,toggleViewSource.bind(this)));if(paramsTreeElement._viewSource){this._populateTreeElementWithSourceText(paramsTreeElement,sourceText);return;}
var toggleTitle=this._decodeRequestParameters?WebInspector.UIString("view URL encoded"):WebInspector.UIString("view decoded");var toggleButton=this._createToggleButton(toggleTitle);toggleButton.addEventListener("click",this._toggleURLDecoding.bind(this),false);paramsTreeElement.listItemElement.appendChild(toggleButton);for(var i=0;i<params.length;++i){var paramNameValue=createDocumentFragment();var name=this._formatParameter(params[i].name+":","header-name",this._decodeRequestParameters);var value=this._formatParameter(params[i].value,"header-value source-code",this._decodeRequestParameters);paramNameValue.appendChild(name);paramNameValue.appendChild(value);var parmTreeElement=new TreeElement(paramNameValue);parmTreeElement.selectable=false;paramsTreeElement.appendChild(parmTreeElement);}},_refreshRequestJSONPayload:function(parsedObject,sourceText)
{var treeElement=this._requestPayloadCategory;treeElement.removeChildren();var listItem=this._requestPayloadCategory.listItemElement;listItem.removeChildren();listItem.createTextChild(this._requestPayloadCategory.title);function toggleViewSource(event)
{treeElement._viewSource=!treeElement._viewSource;this._refreshRequestJSONPayload(parsedObject,sourceText);event.consume();}
listItem.appendChild(this._createViewSourceToggle(treeElement._viewSource,toggleViewSource.bind(this)));if(treeElement._viewSource){this._populateTreeElementWithSourceText(this._requestPayloadCategory,sourceText);}else{var object=WebInspector.RemoteObject.fromLocalObject(parsedObject);var section=new WebInspector.ObjectPropertiesSection(object,object.description);section.expand();section.editable=false;treeElement.appendChild(new TreeElement(section.element));}},_createViewSourceToggle:function(viewSource,handler)
{var viewSourceToggleTitle=viewSource?WebInspector.UIString("view parsed"):WebInspector.UIString("view source");var viewSourceToggleButton=this._createToggleButton(viewSourceToggleTitle);viewSourceToggleButton.addEventListener("click",handler,false);return viewSourceToggleButton;},_toggleURLDecoding:function(event)
{this._decodeRequestParameters=!this._decodeRequestParameters;this._refreshQueryString();this._refreshFormData();event.consume();},_refreshRequestHeaders:function()
{var treeElement=this._requestHeadersCategory;var headers=this._request.requestHeaders().slice();var filterRegex=this._filterRegex;if(filterRegex)
headers=headers.filter(function(header){return filterRegex.test(header.name)||filterRegex.test(header.value);});headers.sort(function(a,b){return a.name.toLowerCase().compareTo(b.name.toLowerCase());});var headersText=this._request.requestHeadersText();if(this._showRequestHeadersText&&headersText)
this._refreshHeadersText(WebInspector.UIString("Request Headers"),headers.length,headersText,treeElement);else
this._refreshHeaders(WebInspector.UIString("Request Headers"),headers,treeElement,headersText===undefined);if(headersText){var toggleButton=this._createHeadersToggleButton(this._showRequestHeadersText);toggleButton.addEventListener("click",this._toggleRequestHeadersText.bind(this),false);treeElement.listItemElement.appendChild(toggleButton);}
this._refreshFormData();},_refreshResponseHeaders:function()
{var treeElement=this._responseHeadersCategory;var headers=this._request.sortedResponseHeaders.slice();var filterRegex=this._filterRegex;if(filterRegex)
headers=headers.filter(function(header){return filterRegex.test(header.name)||filterRegex.test(header.value);});var headersText=this._request.responseHeadersText;if(this._showResponseHeadersText)
this._refreshHeadersText(WebInspector.UIString("Response Headers"),headers.length,headersText,treeElement);else
this._refreshHeaders(WebInspector.UIString("Response Headers"),headers,treeElement);if(headersText){var toggleButton=this._createHeadersToggleButton(this._showResponseHeadersText);toggleButton.addEventListener("click",this._toggleResponseHeadersText.bind(this),false);treeElement.listItemElement.appendChild(toggleButton);}},_refreshHTTPInformation:function()
{var requestMethodElement=this._requestMethodItem;requestMethodElement.hidden=!this._request.statusCode;var statusCodeElement=this._statusCodeItem;statusCodeElement.hidden=!this._request.statusCode;if(this._request.statusCode){var statusCodeFragment=createDocumentFragment();statusCodeFragment.createChild("div","header-name").textContent=WebInspector.UIString("Status Code")+":";var statusCodeImage=statusCodeFragment.createChild("label","resource-status-image","dt-icon-label");statusCodeImage.title=this._request.statusCode+" "+this._request.statusText;if(this._request.statusCode<300||this._request.statusCode===304)
statusCodeImage.type="green-ball";else if(this._request.statusCode<400)
statusCodeImage.type="orange-ball";else
statusCodeImage.type="red-ball";requestMethodElement.title=this._formatHeader(WebInspector.UIString("Request Method"),this._request.requestMethod);var statusTextElement=statusCodeFragment.createChild("div","header-value source-code");var statusText=this._request.statusCode+" "+this._request.statusText;if(this._request.fetchedViaServiceWorker){statusText+=" "+WebInspector.UIString("(from ServiceWorker)");statusTextElement.classList.add("status-from-cache");}else if(this._request.cached()){statusText+=" "+WebInspector.UIString("(from cache)");statusTextElement.classList.add("status-from-cache");}
statusTextElement.textContent=statusText;statusCodeElement.title=statusCodeFragment;}},_refreshHeadersTitle:function(title,headersTreeElement,headersLength)
{headersTreeElement.listItemElement.removeChildren();headersTreeElement.listItemElement.createTextChild(title);var headerCount=WebInspector.UIString("\u00A0(%d)",headersLength);headersTreeElement.listItemElement.createChild("span","header-count").textContent=headerCount;},_refreshHeaders:function(title,headers,headersTreeElement,provisionalHeaders)
{headersTreeElement.removeChildren();var length=headers.length;this._refreshHeadersTitle(title,headersTreeElement,length);if(provisionalHeaders){var cautionText=WebInspector.UIString("Provisional headers are shown");var cautionFragment=createDocumentFragment();cautionFragment.createChild("label","","dt-icon-label").type="warning-icon";cautionFragment.createChild("div","caution").textContent=cautionText;var cautionTreeElement=new TreeElement(cautionFragment);cautionTreeElement.selectable=false;headersTreeElement.appendChild(cautionTreeElement);}
headersTreeElement.hidden=!length&&!provisionalHeaders;for(var i=0;i<length;++i){var headerTreeElement=new TreeElement(this._formatHeader(headers[i].name,headers[i].value));headerTreeElement.selectable=false;headersTreeElement.appendChild(headerTreeElement);}},_refreshHeadersText:function(title,count,headersText,headersTreeElement)
{this._populateTreeElementWithSourceText(headersTreeElement,headersText);this._refreshHeadersTitle(title,headersTreeElement,count);},_refreshRemoteAddress:function()
{var remoteAddress=this._request.remoteAddress();var treeElement=this._remoteAddressItem;treeElement.hidden=!remoteAddress;if(remoteAddress)
treeElement.title=this._formatHeader(WebInspector.UIString("Remote Address"),remoteAddress);},_toggleRequestHeadersText:function(event)
{this._showRequestHeadersText=!this._showRequestHeadersText;this._refreshRequestHeaders();event.consume();},_toggleResponseHeadersText:function(event)
{this._showResponseHeadersText=!this._showResponseHeadersText;this._refreshResponseHeaders();event.consume();},_createToggleButton:function(title)
{var button=createElementWithClass("span","header-toggle");button.textContent=title;return button;},_createHeadersToggleButton:function(isHeadersTextShown)
{var toggleTitle=isHeadersTextShown?WebInspector.UIString("view parsed"):WebInspector.UIString("view source");return this._createToggleButton(toggleTitle);},__proto__:WebInspector.VBox.prototype}
WebInspector.RequestHeadersView.Category=function(root,name,title)
{TreeElement.call(this,title||"",true);this.selectable=false;this.toggleOnClick=true;this.hidden=true;this._expandedSetting=WebInspector.settings.createSetting("request-info-"+name+"-category-expanded",true);this.expanded=this._expandedSetting.get();root.appendChild(this);}
WebInspector.RequestHeadersView.Category.prototype={createLeaf:function()
{var leaf=new TreeElement();leaf.selectable=false;this.appendChild(leaf);return leaf;},onexpand:function()
{this._expandedSetting.set(true);},oncollapse:function()
{this._expandedSetting.set(false);},__proto__:TreeElement.prototype};WebInspector.RequestHTMLView=function(request,dataURL)
{WebInspector.RequestView.call(this,request);this._dataURL=dataURL;this.element.classList.add("html");}
WebInspector.RequestHTMLView.prototype={wasShown:function()
{this._createIFrame();},willHide:function(parentElement)
{this.element.removeChildren();},_createIFrame:function()
{this.element.removeChildren();var iframe=createElement("iframe");iframe.setAttribute("sandbox","");iframe.setAttribute("src",this._dataURL);this.element.appendChild(iframe);},__proto__:WebInspector.RequestView.prototype};WebInspector.RequestJSONView=function(request,parsedJSON)
{WebInspector.RequestView.call(this,request);this._parsedJSON=parsedJSON;this.element.classList.add("json");}
WebInspector.RequestJSONView._jsonToken=new RegExp('(?:false|true|null|[/*&\\|;=\\(\\),\\{\\}\\[\\]]|(?:-?\\b(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?\\b)|(?:\"(?:[^\\0-\\x08\\x0a-\\x1f\"\\\\]|\\\\(?:[\"/\\\\bfnrt]|u[0-9A-Fa-f]{4}))*\"))','g');WebInspector.RequestJSONView._escapedUnicode=new RegExp('\\\\(?:([^u])|u(.{4}))','g');WebInspector.RequestJSONView._standardEscapes={'"':'"','/':'/','\\':'\\','b':'\b','f':'\f','n':'\n','r':'\r','t':'\t'};WebInspector.RequestJSONView._unescape=function(full,standard,unicode)
{return standard?WebInspector.RequestJSONView._standardEscapes[standard]:String.fromCharCode(parseInt(unicode,16));}
WebInspector.RequestJSONView._unescapeString=function(text)
{return text.indexOf("\\")===-1?text:text.replace(WebInspector.RequestJSONView._escapedUnicode,WebInspector.RequestJSONView._unescape);}
WebInspector.RequestJSONView._buildObjectFromJSON=function(text)
{var regExp=WebInspector.RequestJSONView._jsonToken;regExp.lastIndex=0;var result=[];var tip=result;var stack=[];var key=undefined;var token=undefined;var lastToken=undefined;while(true){var match=regExp.exec(text);if(match===null)
break;lastToken=token;token=match[0];var code=token.charCodeAt(0);if((code===0x5b)||(code===0x7b)){var newTip=(code===0x5b)?[]:{};tip[key||tip.length]=newTip;stack.push(tip);tip=newTip;}else if((code===0x5d)||(code===0x7d)){tip=stack.pop();if(!tip)
break;}else if(code===0x2C){if(Array.isArray(tip)&&(lastToken===undefined||lastToken==="["||lastToken===","))
tip[tip.length]=undefined;}else if(code===0x22){token=WebInspector.RequestJSONView._unescapeString(token.substring(1,token.length-1));if(!key){if(Array.isArray(tip)){key=tip.length;}else{key=token||"";continue;}}
tip[key]=token;}else if(code===0x66){tip[key||tip.length]=false;}else if(code===0x6e){tip[key||tip.length]=null;}else if(code===0x74){tip[key||tip.length]=true;}else if(code===0x2f||code===0x2a||code===0x26||code===0x7c||code===0x3b||code===0x3d||code===0x28||code===0x29){throw"Invalid JSON";}else{tip[key||tip.length]=+(token);}
key=undefined;}
return(result.length>1)?result:result[0];}
WebInspector.RequestJSONView.parseJSON=function(text)
{var inner=WebInspector.RequestJSONView._findBrackets(text,"{","}");var inner2=WebInspector.RequestJSONView._findBrackets(text,"[","]");inner=inner2.length>inner.length?inner2:inner;var inner3=WebInspector.RequestJSONView._findBrackets(text,"(",")");if(inner3.length-2>inner.length){inner=inner3;++inner.start;--inner.end;}
if(inner.length===-1)
return null;var prefix=text.substring(0,inner.start);var suffix=text.substring(inner.end+1);text=text.substring(inner.start,inner.end+1);try{return new WebInspector.ParsedJSON(WebInspector.RequestJSONView._buildObjectFromJSON(text),prefix,suffix);}catch(e){return null;}}
WebInspector.RequestJSONView._findBrackets=function(text,open,close)
{var start=text.indexOf(open);var end=text.lastIndexOf(close);var length=end-start-1;if(start==-1||end==-1||end<start)
length=-1;return{start:start,end:end,length:length};}
WebInspector.RequestJSONView.prototype={wasShown:function()
{this._initialize();},_initialize:function()
{if(this._initialized)
return;this._initialized=true;var obj=WebInspector.RemoteObject.fromLocalObject(this._parsedJSON.data);var title=this._parsedJSON.prefix+obj.description+this._parsedJSON.suffix;var section=new WebInspector.ObjectPropertiesSection(obj,title);section.expand();section.editable=false;this.element.appendChild(section.element);},__proto__:WebInspector.RequestView.prototype}
WebInspector.ParsedJSON=function(data,prefix,suffix)
{this.data=data;this.prefix=prefix;this.suffix=suffix;};WebInspector.RequestPreviewView=function(request,responseView)
{WebInspector.RequestContentView.call(this,request);this._responseView=responseView;}
WebInspector.RequestPreviewView.prototype={contentLoaded:function()
{if(!this.request.content&&!this.request.contentError()){if(!this._emptyView){this._emptyView=this._createEmptyView();this._emptyView.show(this.element);this.innerView=this._emptyView;}}else{if(this._emptyView){this._emptyView.detach();delete this._emptyView;}
if(!this._previewView)
this._previewView=this._createPreviewView();this._previewView.show(this.element);this.innerView=this._previewView;}},_createEmptyView:function()
{return this._createMessageView(WebInspector.UIString("This request has no preview available."));},_createMessageView:function(message)
{return new WebInspector.EmptyView(message);},_requestContent:function()
{var content=this.request.content;return this.request.contentEncoded?window.atob(content||""):(content||"");},_jsonView:function()
{var content=this._requestContent();var parsedJSON=WebInspector.RequestJSONView.parseJSON(content);return parsedJSON?new WebInspector.RequestJSONView(this.request,parsedJSON):null;},_xmlView:function()
{var content=this._requestContent();var parsedXML=WebInspector.XMLView.parseXML(content,this.request.mimeType);return parsedXML?new WebInspector.XMLView(parsedXML):null;},_htmlErrorPreview:function()
{var whitelist=["text/html","text/plain","application/xhtml+xml"];if(whitelist.indexOf(this.request.mimeType)===-1)
return null;var dataURL=this.request.asDataURL();if(dataURL===null)
return null;return new WebInspector.RequestHTMLView(this.request,dataURL);},_createPreviewView:function()
{if(this.request.contentError())
return this._createMessageView(WebInspector.UIString("Failed to load response data"));var mimeType=this.request.mimeType||"";if(mimeType.endsWith("json")||mimeType.endsWith("javascript")){var jsonView=this._jsonView();if(jsonView)
return jsonView;}
if(this.request.hasErrorStatusCode()){var htmlErrorPreview=this._htmlErrorPreview();if(htmlErrorPreview)
return htmlErrorPreview;}
var xmlView=this._xmlView();if(xmlView)
return xmlView;if(this.request.resourceType()===WebInspector.resourceTypes.XHR){var isHtml=false;try{isHtml=!!((new DOMParser()).parseFromString(this._requestContent(),mimeType)).body;}catch(e){}
if(!isHtml){var jsonView=this._jsonView();if(jsonView)
return jsonView;}else{var htmlErrorPreview=this._htmlErrorPreview();if(htmlErrorPreview)
return htmlErrorPreview;}}
if(this._responseView.sourceView)
return this._responseView.sourceView;if(this.request.resourceType()===WebInspector.resourceTypes.Other)
return this._createEmptyView();return WebInspector.RequestView.nonSourceViewForRequest(this.request);},__proto__:WebInspector.RequestContentView.prototype};WebInspector.RequestResponseView=function(request)
{WebInspector.RequestContentView.call(this,request);}
WebInspector.RequestResponseView._maxFormattedResourceSize=100000;WebInspector.RequestResponseView.prototype={get sourceView()
{if(this._sourceView||!WebInspector.RequestView.hasTextContent(this.request))
return this._sourceView;var contentProvider=new WebInspector.RequestResponseView.ContentProvider(this.request);if(this.request.resourceSize>=WebInspector.RequestResponseView._maxFormattedResourceSize){this._sourceView=new WebInspector.ResourceSourceFrameFallback(contentProvider);return this._sourceView;}
var sourceFrame=new WebInspector.ResourceSourceFrame(contentProvider);sourceFrame.setHighlighterType(this.request.resourceType().canonicalMimeType()||this.request.mimeType);this._sourceView=sourceFrame;return this._sourceView;},_createMessageView:function(message)
{return new WebInspector.EmptyView(message);},contentLoaded:function()
{if((!this.request.content||!this.sourceView)&&!this.request.contentError()){if(!this._emptyView){this._emptyView=this._createMessageView(WebInspector.UIString("This request has no response data available."));this._emptyView.show(this.element);this.innerView=this._emptyView;}}else{if(this._emptyView){this._emptyView.detach();delete this._emptyView;}
if(this.request.content&&this.sourceView){this.sourceView.show(this.element);this.innerView=this.sourceView;}else{if(!this._errorView)
this._errorView=this._createMessageView(WebInspector.UIString("Failed to load response data"));this._errorView.show(this.element);this.innerView=this._errorView;}}},__proto__:WebInspector.RequestContentView.prototype}
WebInspector.RequestResponseView.ContentProvider=function(request){this._request=request;}
WebInspector.RequestResponseView.ContentProvider.prototype={contentURL:function()
{return this._request.contentURL();},contentType:function()
{return this._request.resourceType();},requestContent:function(callback)
{function decodeContent(content)
{callback(this._request.contentEncoded?window.atob(content||""):content);}
this._request.requestContent(decodeContent.bind(this));},searchInContent:function(query,caseSensitive,isRegex,callback)
{this._request.searchInContent(query,caseSensitive,isRegex,callback);}};WebInspector.RequestTimingView=function(request,calculator)
{WebInspector.VBox.call(this);this.element.classList.add("resource-timing-view");this._request=request;this._calculator=calculator;}
WebInspector.RequestTimingView.prototype={wasShown:function()
{this._request.addEventListener(WebInspector.NetworkRequest.Events.TimingChanged,this._refresh,this);this._request.addEventListener(WebInspector.NetworkRequest.Events.FinishedLoading,this._refresh,this);this._calculator.addEventListener(WebInspector.NetworkTimeCalculator.Events.BoundariesChanged,this._refresh,this);this._refresh();},willHide:function()
{this._request.removeEventListener(WebInspector.NetworkRequest.Events.TimingChanged,this._refresh,this);this._request.removeEventListener(WebInspector.NetworkRequest.Events.FinishedLoading,this._refresh,this);this._calculator.removeEventListener(WebInspector.NetworkTimeCalculator.Events.BoundariesChanged,this._refresh,this);},_refresh:function()
{if(this._tableElement)
this._tableElement.remove();this._tableElement=WebInspector.RequestTimingView.createTimingTable(this._request,this._calculator.minimumBoundary());this.element.appendChild(this._tableElement);},__proto__:WebInspector.VBox.prototype}
WebInspector.RequestTimeRangeNames={Blocking:"blocking",Connecting:"connecting",DNS:"dns",Proxy:"proxy",Receiving:"receiving",Sending:"sending",ServiceWorker:"serviceworker",ServiceWorkerPreparation:"serviceworker-preparation",SSL:"ssl",Total:"total",Waiting:"waiting"};WebInspector.RequestTimingView.ConnectionSetupRangeNames=[WebInspector.RequestTimeRangeNames.Blocking,WebInspector.RequestTimeRangeNames.Connecting,WebInspector.RequestTimeRangeNames.DNS,WebInspector.RequestTimeRangeNames.Proxy,WebInspector.RequestTimeRangeNames.SSL].keySet();WebInspector.RequestTimeRange;WebInspector.RequestTimingView._timeRangeTitle=function(name)
{switch(name){case WebInspector.RequestTimeRangeNames.Blocking:return WebInspector.UIString("Stalled");case WebInspector.RequestTimeRangeNames.Connecting:return WebInspector.UIString("Initial connection");case WebInspector.RequestTimeRangeNames.DNS:return WebInspector.UIString("DNS Lookup");case WebInspector.RequestTimeRangeNames.Proxy:return WebInspector.UIString("Proxy negotiation");case WebInspector.RequestTimeRangeNames.Receiving:return WebInspector.UIString("Content Download");case WebInspector.RequestTimeRangeNames.Sending:return WebInspector.UIString("Request sent");case WebInspector.RequestTimeRangeNames.ServiceWorker:return WebInspector.UIString("Request to ServiceWorker");case WebInspector.RequestTimeRangeNames.ServiceWorkerPreparation:return WebInspector.UIString("ServiceWorker Preparation");case WebInspector.RequestTimeRangeNames.SSL:return WebInspector.UIString("SSL");case WebInspector.RequestTimeRangeNames.Total:return WebInspector.UIString("Total");case WebInspector.RequestTimeRangeNames.Waiting:return WebInspector.UIString("Waiting (TTFB)");default:return WebInspector.UIString(name);}}
WebInspector.RequestTimingView.calculateRequestTimeRanges=function(request)
{var result=[];function addRange(name,start,end)
{if(start<Number.MAX_VALUE&&start<=end)
result.push({name:name,start:start,end:end});}
function firstPositive(numbers)
{for(var i=0;i<numbers.length;++i){if(numbers[i]>0)
return numbers[i];}
return undefined;}
function addOffsetRange(name,start,end)
{if(start>=0&&end>=0)
addRange(name,startTime+(start/1000),startTime+(end/1000));}
var timing=request.timing;if(!timing){var start=request.issueTime()!==-1?request.issueTime():request.startTime!==-1?request.startTime:0;var middle=(request.responseReceivedTime===-1)?Number.MAX_VALUE:request.responseReceivedTime;var end=(request.endTime===-1)?Number.MAX_VALUE:request.endTime;addRange(WebInspector.RequestTimeRangeNames.Total,start,end);addRange(WebInspector.RequestTimeRangeNames.Blocking,start,middle);addRange(WebInspector.RequestTimeRangeNames.Receiving,middle,end);return result;}
var issueTime=request.issueTime();var startTime=timing.requestTime;var endTime=firstPositive([request.endTime,request.responseReceivedTime])||startTime;addRange(WebInspector.RequestTimeRangeNames.Total,issueTime<startTime?issueTime:startTime,endTime);if(request.fetchedViaServiceWorker){addOffsetRange(WebInspector.RequestTimeRangeNames.Blocking,0,timing.serviceWorkerFetchStart);addOffsetRange(WebInspector.RequestTimeRangeNames.ServiceWorker,timing.serviceWorkerFetchStart,timing.serviceWorkerFetchEnd);addOffsetRange(WebInspector.RequestTimeRangeNames.ServiceWorkerPreparation,timing.serviceWorkerFetchStart,timing.serviceWorkerFetchReady);addOffsetRange(WebInspector.RequestTimeRangeNames.Waiting,timing.serviceWorkerFetchEnd,timing.receiveHeadersEnd);}else{var blocking=firstPositive([timing.dnsStart,timing.connectStart,timing.sendStart])||0;addOffsetRange(WebInspector.RequestTimeRangeNames.Blocking,0,blocking);addOffsetRange(WebInspector.RequestTimeRangeNames.Proxy,timing.proxyStart,timing.proxyEnd);addOffsetRange(WebInspector.RequestTimeRangeNames.DNS,timing.dnsStart,timing.dnsEnd);addOffsetRange(WebInspector.RequestTimeRangeNames.Connecting,timing.connectStart,timing.connectEnd);addOffsetRange(WebInspector.RequestTimeRangeNames.SSL,timing.sslStart,timing.sslEnd);addOffsetRange(WebInspector.RequestTimeRangeNames.Sending,timing.sendStart,timing.sendEnd);addOffsetRange(WebInspector.RequestTimeRangeNames.Waiting,timing.sendEnd,timing.receiveHeadersEnd);}
if(request.endTime!==-1)
addRange(WebInspector.RequestTimeRangeNames.Receiving,request.responseReceivedTime,endTime);return result;}
WebInspector.RequestTimingView.createTimingTable=function(request,navigationStart)
{var tableElement=createElementWithClass("table","network-timing-table");var colgroup=tableElement.createChild("colgroup");colgroup.createChild("col","labels");colgroup.createChild("col","bars");colgroup.createChild("col","duration");var timeRanges=WebInspector.RequestTimingView.calculateRequestTimeRanges(request);var startTime=timeRanges[0].start;var endTime=timeRanges[0].end;var scale=100/(endTime-startTime);var connectionHeader;var dataHeader;var totalDuration=0;for(var i=0;i<timeRanges.length;++i){var range=timeRanges[i];var rangeName=range.name;if(rangeName===WebInspector.RequestTimeRangeNames.Total){totalDuration=range.end-range.start;continue;}
if(WebInspector.RequestTimingView.ConnectionSetupRangeNames[rangeName]){if(!connectionHeader){connectionHeader=tableElement.createChild("tr","network-timing-table-header");connectionHeader.createChild("td").createTextChild("Connection Setup");connectionHeader.createChild("td").createTextChild("");connectionHeader.createChild("td").createTextChild("TIME");}}else{if(!dataHeader){dataHeader=tableElement.createChild("tr","network-timing-table-header");dataHeader.createChild("td").createTextChild("Request/Response");dataHeader.createChild("td").createTextChild("");dataHeader.createChild("td").createTextChild("TIME");}}
var left=(scale*(range.start-startTime));var right=(scale*(endTime-range.end));var duration=range.end-range.start;var tr=tableElement.createChild("tr");tr.createChild("td").createTextChild(WebInspector.RequestTimingView._timeRangeTitle(rangeName));var row=tr.createChild("td").createChild("div","network-timing-row");var bar=row.createChild("span","network-timing-bar "+rangeName);bar.style.left=left+"%";bar.style.right=right+"%";bar.textContent="\u200B";var label=tr.createChild("td").createChild("div","network-timing-bar-title");label.textContent=Number.secondsToString(duration,true);}
if(!request.finished){var cell=tableElement.createChild("tr").createChild("td","caution");cell.colSpan=3;cell.createTextChild(WebInspector.UIString("CAUTION: request is not finished yet!"));}
var footer=tableElement.createChild("tr","network-timing-footer");var note=footer.createChild("td");note.colSpan=2;note.appendChild(WebInspector.linkifyDocumentationURLAsNode("network#resource-network-timing",WebInspector.UIString("Explanation")));footer.createChild("td").createTextChild(Number.secondsToString(totalDuration,true));return tableElement;};WebInspector.ResourceWebSocketFrameView=function(request)
{WebInspector.VBox.call(this);this.registerRequiredCSS("network/webSocketFrameView.css");this.element.classList.add("websocket-frame-view");this._request=request;this._splitView=new WebInspector.SplitView(false,true,"resourceWebSocketFrameSplitViewState");this._splitView.show(this.element);var columns=[{id:"data",title:WebInspector.UIString("Data"),sortable:false,weight:88},{id:"length",title:WebInspector.UIString("Length"),sortable:false,align:WebInspector.DataGrid.Align.Right,weight:5},{id:"time",title:WebInspector.UIString("Time"),sortable:true,weight:7}];this._dataGrid=new WebInspector.SortableDataGrid(columns,undefined,undefined,undefined,this._onContextMenu.bind(this));this._dataGrid.setStickToBottom(true);this._dataGrid.setCellClass("websocket-frame-view-td");this._timeComparator=(WebInspector.ResourceWebSocketFrameNodeTimeComparator);this._dataGrid.sortNodes(this._timeComparator,false);this._dataGrid.markColumnAsSortedBy("time",WebInspector.DataGrid.Order.Ascending);this._dataGrid.addEventListener(WebInspector.DataGrid.Events.SortingChanged,this._sortItems,this);this._dataGrid.setName("ResourceWebSocketFrameView");this._dataGrid.addEventListener(WebInspector.DataGrid.Events.SelectedNode,this._onFrameSelected,this);this._splitView.setMainView(this._dataGrid);this._messageView=new WebInspector.EmptyView("Select frame to browse its content.");this._splitView.setSidebarView(this._messageView);}
WebInspector.ResourceWebSocketFrameView.OpCodes={ContinuationFrame:0,TextFrame:1,BinaryFrame:2,ConnectionCloseFrame:8,PingFrame:9,PongFrame:10};WebInspector.ResourceWebSocketFrameView.opCodeDescriptions=(function()
{var opCodes=WebInspector.ResourceWebSocketFrameView.OpCodes;var map=[];map[opCodes.ContinuationFrame]="Continuation Frame";map[opCodes.TextFrame]="Text Frame";map[opCodes.BinaryFrame]="Binary Frame";map[opCodes.ContinuationFrame]="Connection Close Frame";map[opCodes.PingFrame]="Ping Frame";map[opCodes.PongFrame]="Pong Frame";return map;})();WebInspector.ResourceWebSocketFrameView.opCodeDescription=function(opCode,mask)
{var rawDescription=WebInspector.ResourceWebSocketFrameView.opCodeDescriptions[opCode]||"";var localizedDescription=WebInspector.UIString(rawDescription);return WebInspector.UIString("%s (Opcode %d%s)",localizedDescription,opCode,(mask?", mask":""));}
WebInspector.ResourceWebSocketFrameView.prototype={wasShown:function()
{this.refresh();this._request.addEventListener(WebInspector.NetworkRequest.Events.WebsocketFrameAdded,this._frameAdded,this);},willHide:function()
{this._request.removeEventListener(WebInspector.NetworkRequest.Events.WebsocketFrameAdded,this._frameAdded,this);},_frameAdded:function(event)
{var frame=(event.data);this._dataGrid.insertChild(new WebInspector.ResourceWebSocketFrameNode(frame));},_onFrameSelected:function(event)
{var selectedNode=(event.target.selectedNode);if(this._messageView)
this._messageView.detach();if(this._dataView)
this._dataView.detach();this._dataView=new WebInspector.ResourceSourceFrame(selectedNode.contentProvider());this._splitView.setSidebarView(this._dataView);},refresh:function()
{this._dataGrid.rootNode().removeChildren();var frames=this._request.frames();for(var i=0;i<frames.length;++i)
this._dataGrid.insertChild(new WebInspector.ResourceWebSocketFrameNode(frames[i]));},_onContextMenu:function(contextMenu,node)
{contextMenu.appendItem(WebInspector.UIString.capitalize("Copy ^message"),this._copyMessage.bind(this,node.data));},_copyMessage:function(row)
{InspectorFrontendHost.copyText(row.data);},_sortItems:function()
{this._dataGrid.sortNodes(this._timeComparator,!this._dataGrid.isSortOrderAscending());},__proto__:WebInspector.VBox.prototype}
WebInspector.ResourceWebSocketFrameNode=function(frame)
{this._frame=frame;this._dataText=frame.text;var length=frame.text.length;var time=new Date(frame.time*1000);var timeText=("0"+time.getHours()).substr(-2)+":"+("0"+time.getMinutes()).substr(-2)+":"+("0"+time.getSeconds()).substr(-2)+"."+("00"+time.getMilliseconds()).substr(-3);var timeNode=createElement("div");timeNode.createTextChild(timeText);timeNode.title=time.toLocaleString();this._isTextFrame=frame.opCode===WebInspector.ResourceWebSocketFrameView.OpCodes.TextFrame;if(!this._isTextFrame)
this._dataText=WebInspector.ResourceWebSocketFrameView.opCodeDescription(frame.opCode,frame.mask);WebInspector.SortableDataGridNode.call(this,{data:this._dataText,length:length,time:timeNode});}
WebInspector.ResourceWebSocketFrameNode.prototype={createCells:function()
{var element=this._element;element.classList.toggle("websocket-frame-view-row-error",this._frame.type===WebInspector.NetworkRequest.WebSocketFrameType.Error);element.classList.toggle("websocket-frame-view-row-outcoming",this._frame.type===WebInspector.NetworkRequest.WebSocketFrameType.Send);element.classList.toggle("websocket-frame-view-row-opcode",!this._isTextFrame);WebInspector.SortableDataGridNode.prototype.createCells.call(this);},nodeSelfHeight:function()
{return 17;},contentProvider:function()
{return new WebInspector.StaticContentProvider(WebInspector.resourceTypes.WebSocket,this._dataText);},__proto__:WebInspector.SortableDataGridNode.prototype}
WebInspector.ResourceWebSocketFrameNodeTimeComparator=function(a,b)
{return a._frame.time-b._frame.time;};WebInspector.NetworkPanel=function()
{WebInspector.Panel.call(this,"network");this.registerRequiredCSS("network/networkPanel.css");this._filmStripView=null;this._shouldRecordFilmStrip=false;this._panelStatusBar=new WebInspector.StatusBar(this.element);this._filterBar=new WebInspector.FilterBar();this._filtersContainer=this.element.createChild("div","network-filters-header hidden");this._filtersContainer.appendChild(this._filterBar.filtersElement());this._filterBar.addEventListener(WebInspector.FilterBar.Events.FiltersToggled,this._onFiltersToggled,this);this._filterBar.setName("networkPanel",true);this._searchableView=new WebInspector.SearchableView(this);this._searchableView.show(this.element);this._overview=new WebInspector.NetworkOverview();this._splitView=new WebInspector.SplitView(true,false,"networkPanelSplitViewState");this._splitView.hideMain();this._splitView.show(this._searchableView.element);this._progressBarContainer=createElement("div");this._createStatusbarButtons();this._networkLogView=new WebInspector.NetworkLogView(this._overview,this._filterBar,this._progressBarContainer);this._splitView.setSidebarView(this._networkLogView);this._detailsView=new WebInspector.VBox();this._detailsView.element.classList.add("network-details-view");this._splitView.setMainView(this._detailsView);this._closeButtonElement=createElementWithClass("div","close-button");this._closeButtonElement.classList.add("network-close-button");this._closeButtonElement.addEventListener("click",this._showRequest.bind(this,null),false);this._toggleRecordButton(true);this._toggleShowOverviewButton(WebInspector.settings.networkLogShowOverview.get());this._toggleLargerRequests(WebInspector.settings.networkLogLargeRows.get());this._dockSideChanged();WebInspector.dockController.addEventListener(WebInspector.DockController.Events.DockSideChanged,this._dockSideChanged.bind(this));WebInspector.settings.splitVerticallyWhenDockedToRight.addChangeListener(this._dockSideChanged.bind(this));WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.WillReloadPage,this._willReloadPage,this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.Load,this._load,this);WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.MainFrameNavigated,this._mainFrameNavigated,this);WebInspector.targetManager.addEventListener(WebInspector.TargetManager.Events.SuspendStateChanged,this._onSuspendStateChange,this);this._networkLogView.addEventListener(WebInspector.NetworkLogView.EventTypes.RequestSelected,this._onRequestSelected,this);this._networkLogView.addEventListener(WebInspector.NetworkLogView.EventTypes.SearchCountUpdated,this._onSearchCountUpdated,this);this._networkLogView.addEventListener(WebInspector.NetworkLogView.EventTypes.SearchIndexUpdated,this._onSearchIndexUpdated,this);this._networkLogView.addEventListener(WebInspector.NetworkLogView.EventTypes.TimeHovered,this._onTimeHovered,this);function sourceFrameGetter()
{return this._networkItemView.currentSourceFrame();}
WebInspector.GoToLineDialog.install(this,sourceFrameGetter.bind(this));}
WebInspector.NetworkPanel.prototype={_onFilmFrameSelected:function(event)
{var frameTime=(event.data);this._networkLogView.setSelectedFrameTime(frameTime);},_onSuspendStateChange:function(event)
{this._toggleRecordFilmStripButton(this._recordFilmStripButton.toggled());},_onFilmRecordingFinished:function(event)
{this._toggleRecordFilmStripButton(false);},_toggleRecordFilmStripButton:function(toggled)
{this._recordFilmStripButton.setEnabled(toggled||!WebInspector.targetManager.allTargetsSuspended());this._recordFilmStripButton.setToggled(toggled);this._recordFilmStripButton.setTitle(WebInspector.UIString(toggled?"Stop Recording Film Strip":"Clear Log, Reload Page and Record Film Strip"));},_onTimeHovered:function(event)
{var time=(event.data);if(this._filmStripView)
this._filmStripView.selectFrame(time);},_createStatusbarButtons:function()
{this._recordButton=new WebInspector.StatusBarButton("","record-status-bar-item");this._recordButton.addEventListener("click",this._onRecordButtonClicked,this);this._panelStatusBar.appendStatusBarItem(this._recordButton);this._recordFilmStripButton=new WebInspector.StatusBarButton("","record-filmstrip-status-bar-item");this._toggleRecordFilmStripButton(false);this._recordFilmStripButton.addEventListener("click",this._onRecordFilmStripButtonClicked,this);if(Runtime.experiments.isEnabled("recordFilmStrimInNetworkPanel"))
this._panelStatusBar.appendStatusBarItem(this._recordFilmStripButton);this._clearButton=new WebInspector.StatusBarButton(WebInspector.UIString("Clear"),"clear-status-bar-item");this._clearButton.addEventListener("click",this._onClearButtonClicked,this);this._panelStatusBar.appendStatusBarItem(this._clearButton);this._panelStatusBar.appendStatusBarItem(this._filterBar.filterButton());var viewModeLabel=new WebInspector.StatusBarText(WebInspector.UIString("View:"),"status-bar-group-label");this._panelStatusBar.appendStatusBarItem(viewModeLabel);this._largerRequestsButton=new WebInspector.StatusBarButton(WebInspector.UIString(""),"large-list-status-bar-item");this._largerRequestsButton.addEventListener("click",this._onLargerRequestsClicked,this);this._panelStatusBar.appendStatusBarItem(this._largerRequestsButton);this._showOverviewButton=new WebInspector.StatusBarButton(WebInspector.UIString(""),"waterfall-status-bar-item");this._showOverviewButton.addEventListener("click",this._onShowOverviewButtonClicked,this);this._panelStatusBar.appendStatusBarItem(this._showOverviewButton);var optionsLabel=new WebInspector.StatusBarText(WebInspector.UIString("Options:"),"status-bar-group-label");this._panelStatusBar.appendStatusBarItem(optionsLabel);this._preserveLogCheckbox=new WebInspector.StatusBarCheckbox(WebInspector.UIString("Preserve log"),WebInspector.UIString("Do not clear log on page reload / navigation."));this._preserveLogCheckbox.inputElement.addEventListener("change",this._onPreserveLogCheckboxChanged.bind(this),false);this._panelStatusBar.appendStatusBarItem(this._preserveLogCheckbox);this._disableCacheCheckbox=new WebInspector.StatusBarCheckbox(WebInspector.UIString("Disable cache"),WebInspector.UIString("Disable cache (while DevTools is open)."),WebInspector.settings.cacheDisabled);this._panelStatusBar.appendStatusBarItem(this._disableCacheCheckbox);this._panelStatusBar.appendStatusBarItem(new WebInspector.StatusBarItem(this._progressBarContainer));},_onRecordFilmStripButtonClicked:function(event)
{if(this._recordFilmStripButton.toggled()){this._filmStripView.stopRecording();}else{this._shouldRecordFilmStrip=true;WebInspector.targetManager.reloadPage();}},_onRecordButtonClicked:function(event)
{if(!this._recordButton.toggled())
this._networkLogView.reset();this._toggleRecordButton(!this._recordButton.toggled());},_toggleRecordButton:function(toggled)
{this._recordButton.setToggled(toggled);this._recordButton.setTitle(toggled?WebInspector.UIString("Stop Recording Network Log"):WebInspector.UIString("Record Network Log"));this._networkLogView.setRecording(toggled);},_onPreserveLogCheckboxChanged:function(event)
{this._networkLogView.setPreserveLog(this._preserveLogCheckbox.checked());},_onClearButtonClicked:function(event)
{this._overview.reset();this._hideFilmStrip();this._networkLogView.reset();},_mainFrameNavigated:function(event)
{if(this._preserveLogCheckbox.checked()||!this._filmStripView||this._filmStripView.recording())
return;this._hideFilmStrip();},_willReloadPage:function(event)
{this._toggleRecordButton(true);this._hideFilmStrip();if(!this._preserveLogCheckbox.checked()||this._shouldRecordFilmStrip)
this._networkLogView.reset();if(this._shouldRecordFilmStrip){this._shouldRecordFilmStrip=false;this._toggleRecordFilmStripButton(true);this._networkLogView.setShowSelectedFrame(true);this._filmStripView=new WebInspector.NetworkFilmStripView(this._networkLogView.timeCalculator());this._filmStripView.show(this._searchableView.element,this._showOverviewButton.toggled()?this._overview.element:this._splitView.element);this._filmStripView.addEventListener(WebInspector.NetworkFilmStripView.Events.FrameSelected,this._onFilmFrameSelected,this);this._filmStripView.addEventListener(WebInspector.NetworkFilmStripView.Events.RecordingFinished,this._onFilmRecordingFinished,this);this._filmStripView.startRecording();}},_load:function(event)
{if(this._filmStripView)
setTimeout(this._filmStripView.stopRecording.bind(this._filmStripView),1000);},_hideFilmStrip:function()
{if(!this._filmStripView)
return;this._networkLogView.setSelectedFrameTime(-1);this._filmStripView.stopRecording();this._filmStripView.detach();this._filmStripView=null;this._networkLogView.setShowSelectedFrame(false);},_onLargerRequestsClicked:function(event)
{this._toggleLargerRequests(!this._largerRequestsButton.toggled());},_toggleLargerRequests:function(toggled)
{WebInspector.settings.networkLogLargeRows.set(toggled);this._largerRequestsButton.setToggled(toggled);this._largerRequestsButton.setTitle(WebInspector.UIString(toggled?"Use small request rows.":"Use large request rows."));this._updateUI();},_onShowOverviewButtonClicked:function(event)
{this._toggleShowOverviewButton(!WebInspector.settings.networkLogShowOverview.get());this.doResize();},_toggleShowOverviewButton:function(toggled)
{WebInspector.settings.networkLogShowOverview.set(toggled);this._showOverviewButton.setTitle(toggled?WebInspector.UIString("Hide overview."):WebInspector.UIString("Show overview."));this._showOverviewButton.setToggled(toggled);if(toggled){this._overview.show(this._searchableView.element,this._splitView.element);}else{this._overview.detach();}},_isDetailsPaneAtBottom:function()
{return WebInspector.settings.splitVerticallyWhenDockedToRight.get()&&WebInspector.dockController.isVertical();},_dockSideChanged:function()
{var detailsViewAtBottom=this._isDetailsPaneAtBottom();this._splitView.setVertical(!detailsViewAtBottom);this._updateUI();},_onFiltersToggled:function(event)
{var toggled=(event.data);this._filtersContainer.classList.toggle("hidden",!toggled);this.doResize();},elementsToRestoreScrollPositionsFor:function()
{return this._networkLogView.elementsToRestoreScrollPositionsFor();},searchableView:function()
{return this._searchableView;},handleShortcut:function(event)
{if(this._networkItemView&&event.keyCode===WebInspector.KeyboardShortcut.Keys.Esc.code){this._showRequest(null);event.handled=true;return;}
WebInspector.Panel.prototype.handleShortcut.call(this,event);},wasShown:function()
{WebInspector.Panel.prototype.wasShown.call(this);},revealAndHighlightRequest:function(request)
{this._showRequest(null);if(request)
this._networkLogView.revealAndHighlightRequest(request);},_onRowSizeChanged:function(event)
{this._updateUI();},_onSearchCountUpdated:function(event)
{var count=(event.data);this._searchableView.updateSearchMatchesCount(count);},_onSearchIndexUpdated:function(event)
{var index=(event.data);this._searchableView.updateCurrentMatchIndex(index);},_onRequestSelected:function(event)
{var request=(event.data);this._showRequest(request);},_showRequest:function(request)
{if(this._networkItemView){this._networkItemView.detach();this._networkItemView=null;}
if(request){this._networkItemView=new WebInspector.NetworkItemView(request,this._networkLogView.timeCalculator());this._networkItemView.insertBeforeTabStrip(this._closeButtonElement);this._networkItemView.show(this._detailsView.element);this._splitView.showBoth();this._networkLogView.revealSelectedItem();}else{this._splitView.hideMain();this._networkLogView.clearSelection();}
this._updateUI();},_updateUI:function()
{var detailsPaneAtBottom=this._isDetailsPaneAtBottom();this._detailsView.element.classList.toggle("network-details-view-tall-header",WebInspector.settings.networkLogLargeRows.get()&&!detailsPaneAtBottom);this._networkLogView.switchViewMode(!this._splitView.isResizable()||detailsPaneAtBottom);},performSearch:function(searchConfig,shouldJump,jumpBackwards)
{this._networkLogView.performSearch(searchConfig,shouldJump,jumpBackwards);},jumpToPreviousSearchResult:function()
{this._networkLogView.jumpToPreviousSearchResult();},supportsCaseSensitiveSearch:function()
{return false;},supportsRegexSearch:function()
{return false;},jumpToNextSearchResult:function()
{this._networkLogView.jumpToNextSearchResult();},searchCanceled:function()
{this._networkLogView.searchCanceled();},appendApplicableItems:function(event,contextMenu,target)
{function reveal(request)
{WebInspector.inspectorView.setCurrentPanel(this);this.revealAndHighlightRequest(request);}
function appendRevealItem(request)
{contextMenu.appendItem(WebInspector.UIString.capitalize("Reveal in Network ^panel"),reveal.bind(this,request));}
if(event.target.isSelfOrDescendant(this.element))
return;if(target instanceof WebInspector.Resource){var resource=(target);if(resource.request)
appendRevealItem.call(this,resource.request);return;}
if(target instanceof WebInspector.UISourceCode){var uiSourceCode=(target);var resource=WebInspector.resourceForURL(WebInspector.networkMapping.networkURL(uiSourceCode));if(resource&&resource.request)
appendRevealItem.call(this,resource.request);return;}
if(!(target instanceof WebInspector.NetworkRequest))
return;var request=(target);if(this._networkItemView&&this._networkItemView.isShowing()&&this._networkItemView.request()===request)
return;appendRevealItem.call(this,request);},__proto__:WebInspector.Panel.prototype}
WebInspector.NetworkPanel.ContextMenuProvider=function()
{}
WebInspector.NetworkPanel.ContextMenuProvider.prototype={appendApplicableItems:function(event,contextMenu,target)
{WebInspector.NetworkPanel._instance().appendApplicableItems(event,contextMenu,target);}}
WebInspector.NetworkPanel.RequestRevealer=function()
{}
WebInspector.NetworkPanel.RequestRevealer.prototype={reveal:function(request,lineNumber)
{if(!(request instanceof WebInspector.NetworkRequest))
return Promise.reject(new Error("Internal error: not a network request"));var panel=WebInspector.NetworkPanel._instance();WebInspector.inspectorView.setCurrentPanel(panel);panel.revealAndHighlightRequest(request);return Promise.resolve();}}
WebInspector.NetworkPanel.show=function()
{WebInspector.inspectorView.setCurrentPanel(WebInspector.NetworkPanel._instance());}
WebInspector.NetworkPanel._instance=function()
{if(!WebInspector.NetworkPanel._instanceObject)
WebInspector.NetworkPanel._instanceObject=new WebInspector.NetworkPanel();return WebInspector.NetworkPanel._instanceObject;}
WebInspector.NetworkPanelFactory=function()
{}
WebInspector.NetworkPanelFactory.prototype={createPanel:function()
{return WebInspector.NetworkPanel._instance();}};WebInspector.XMLView=function(parsedXML)
{WebInspector.View.call(this,true);this.registerRequiredCSS("network/xmlView.css");this.contentElement.classList.add("shadow-xml-view","source-code");var treeOutline=new TreeOutline();this.contentElement.appendChild(treeOutline.element);WebInspector.XMLView.Node.populate(treeOutline,parsedXML);}
WebInspector.XMLView.parseXML=function(text,mimeType)
{var parsedXML;try{parsedXML=(new DOMParser()).parseFromString(text,mimeType);}catch(e){return null;}
if(parsedXML.body)
return null;return parsedXML;}
WebInspector.XMLView.prototype={__proto__:WebInspector.View.prototype}
WebInspector.XMLView.Node=function(node,closeTag)
{TreeElement.call(this,"",!closeTag&&!!node.childElementCount);this._node=node;this._closeTag=closeTag;this.selectable=false;this._updateTitle();}
WebInspector.XMLView.Node.populate=function(root,xmlNode)
{var node=xmlNode.firstChild;while(node){var currentNode=node;node=node.nextSibling;var nodeType=currentNode.nodeType;if(nodeType===3&&currentNode.nodeValue.match(/\s+/))
continue;if((nodeType!==1)&&(nodeType!==3)&&(nodeType!==4)&&(nodeType!==7)&&(nodeType!==8))
continue;root.appendChild(new WebInspector.XMLView.Node(currentNode,false));}}
WebInspector.XMLView.Node.prototype={_updateTitle:function()
{var node=this._node;switch(node.nodeType){case 1:var tag=node.tagName;if(this._closeTag){this._setTitle(["</"+tag+">","shadow-xml-view-tag"]);return;}
var titleItems=["<"+tag,"shadow-xml-view-tag"];var attributes=node.attributes;for(var i=0;i<attributes.length;++i){var attributeNode=attributes.item(i);titleItems.push("\u00a0","shadow-xml-view-tag",attributeNode.name,"shadow-xml-view-attribute-name","=\"","shadow-xml-view-tag",attributeNode.value,"shadow-xml-view-attribute-value","\"","shadow-xml-view-tag")}
if(!this.expanded){if(node.childElementCount){titleItems.push(">","shadow-xml-view-tag","\u2026","shadow-xml-view-comment","</"+tag,"shadow-xml-view-tag");}else if(this._node.textContent){titleItems.push(">","shadow-xml-view-tag",node.textContent,"shadow-xml-view-text","</"+tag,"shadow-xml-view-tag");}else{titleItems.push(" /","shadow-xml-view-tag");}}
titleItems.push(">","shadow-xml-view-tag");this._setTitle(titleItems);return;case 3:this._setTitle([node.nodeValue,"shadow-xml-view-text"]);return;case 4:this._setTitle(["<![CDATA[","shadow-xml-view-cdata",node.nodeValue,"shadow-xml-view-text","]]>","shadow-xml-view-cdata"]);return;case 7:this._setTitle(["<?"+node.nodeName+" "+node.nodeValue+"?>","shadow-xml-view-processing-instruction"]);return;case 8:this._setTitle(["<!--"+node.nodeValue+"-->","shadow-xml-view-comment"]);return;}},_setTitle:function(items)
{var titleFragment=createDocumentFragment();for(var i=0;i<items.length;i+=2)
titleFragment.createChild("span",items[i+1]).textContent=items[i];this.title=titleFragment;},onattach:function()
{this.listItemElement.classList.toggle("shadow-xml-view-close-tag",this._closeTag);},onexpand:function()
{this._updateTitle();},oncollapse:function()
{this._updateTitle();},onpopulate:function()
{WebInspector.XMLView.Node.populate(this,this._node);this.appendChild(new WebInspector.XMLView.Node(this._node,true));},__proto__:TreeElement.prototype};Runtime.cachedResources["network/eventSourceMessagesView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.event-source-messages-view .data-grid {\n    flex: auto;\n    border: none;\n}\n\n/*# sourceURL=network/eventSourceMessagesView.css */";Runtime.cachedResources["network/networkFilmStripView.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.shadow-network-film-strip-view {\n    overflow-x: hidden;\n    overflow-y: auto;\n    flex-wrap: wrap;\n    align-content: flex-start;\n}\n\n.shadow-network-film-strip-view .label {\n    flex-grow: 1;\n    display: flex;\n    flex-direction: column;\n    margin: auto;\n    align-items: center;\n    font-size: 18px;\n}\n\n.shadow-network-film-strip-view .spinner {\n    background-image: url(Images/spinner.svg);\n    width: 32px;\n    height: 32px;\n}\n\n.shadow-network-film-strip-view .frame {\n    display: inline-flex;\n    flex-direction: column;\n    align-items: center;\n    padding: 6px 9px 3px 9px;\n    margin: 1px;\n    flex: 0 0 auto;\n    border-radius: 8px;\n    height: 114px;\n}\n\n.shadow-network-film-strip-view .frame .event-text {\n    border: solid 1px;\n    display: inline-flex;\n    flex-direction: row;\n    align-items: center;\n    flex: 0 0 90px;\n    text-align: center;\n    width: 72px;\n    padding: 6px;\n}\n\n.shadow-network-film-strip-view .frame.dcl-event .event-text {\n    border-color: rgba(0,0,255,0.3);\n    color: blue;\n}\n\n.shadow-network-film-strip-view .frame.load-event .event-text {\n    border: solid 1px rgba(255,0,0,0.3);\n    color: red;\n}\n\n.shadow-network-film-strip-view .frame-limit-reached {\n    font-size: 24px;\n    color: #888;\n    justify-content: center;\n    display: inline-flex;\n    flex-direction: column;\n    flex: 0 0 auto;\n}\n\n.shadow-network-film-strip-view .frame.selected {\n    background-color: #fd8;\n}\n\n.shadow-network-film-strip-view .frame .thumbnail {\n    flex: 0 0 90px;\n    min-width: 48px;\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n}\n\n.shadow-network-film-strip-view .frame .thumbnail img {\n    border: solid 1px #ccc;\n    height: auto;\n    width: auto;\n    margin: auto;\n    max-width: 162px;\n    max-height: 90px;\n    box-shadow: 3px 3px 4px rgba(0, 0, 0, 0.5);\n}\n\n.shadow-network-film-strip-view .frame .time {\n    font-size: 10px;\n    margin-top: 3px;\n}\n\n/*# sourceURL=network/networkFilmStripView.css */";Runtime.cachedResources["network/networkLogView.css"]="/*\n * Copyright (C) 2013 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n *     * Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *     * Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *     * Neither the name of Google Inc. nor the names of its\n * contributors may be used to endorse or promote products derived from\n * this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.network-log-grid.data-grid {\n    border: none;\n    flex: 1 1;\n}\n\n.network-summary-bar {\n    flex: 0 0 19px;\n    padding-left: 5px;\n    line-height: 18px;\n    background-color: #eee;\n    border-top: 1px solid #ccc;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.network-summary-bar label[is=dt-icon-label] {\n    margin-right: 6px;\n}\n\n.network-log-grid.data-grid table.data {\n    background: transparent;\n}\n\n.network-log-grid .odd {\n    background: #eee;\n}\n\n.network-log-grid .network-navigation-row,\n.network-log-grid .network-navigation-row.odd {\n    background: #def;\n}\n\n.network-log-grid.data-grid td {\n    line-height: 17px;\n    height: 41px;\n    border-left: 1px solid #e1e1e1;\n    vertical-align: middle;\n}\n\n.network-log-grid.data-grid.small td {\n    height: 21px;\n}\n\n.network-log-grid.data-grid th {\n    border-bottom: 1px solid rgb(205, 205, 205);\n    border-left: 1px solid rgb(205, 205, 205);\n    background: white;\n}\n\n.network-log-grid.data-grid .header-container {\n    height: 31px;\n}\n\n.network-log-grid.data-grid .data-container {\n    top: 31px;\n}\n\n.network-log-grid.data-grid.small .header-container {\n    height: 23px;\n}\n\n.network-log-grid.data-grid.small .data-container {\n    top: 23px;\n}\n\n.network-log-grid.data-grid select {\n    -webkit-appearance: none;\n    background-color: transparent;\n    border: none;\n    width: 100%;\n    color: inherit;\n}\n\n.network-log-grid.data-grid .name-column {\n    cursor: pointer;\n}\n\n.network-log-grid.data-grid .timeline-column {\n    padding: 1px 0;\n}\n\n#network-container:not(.brief-mode) .network-log-grid.data-grid td.name-column:hover {\n    text-decoration: underline;\n}\n\n.network-log-grid.data-grid.small .network-graph-side {\n    height: 19px;\n}\n\n.network-log-grid.data-grid th.sortable:active {\n    background-image: none !important;\n}\n\n.network-cell-subtitle {\n    font-weight: normal;\n    color: gray;\n}\n\n.network-error-row,\n.network-error-row .network-cell-subtitle {\n    color: rgb(230, 0, 0);\n}\n\n.initiator-column a {\n    color: inherit;\n}\n\n.network-log-grid.data-grid tr.selected,\n.network-log-grid.data-grid tr.selected .network-cell-subtitle,\n.network-log-grid.data-grid tr.selected .network-dim-cell {\n    color: inherit !important;\n}\n\n.network-log-grid.data-grid:focus tr.selected,\n.network-log-grid.data-grid:focus tr.selected .network-cell-subtitle,\n.network-log-grid.data-grid:focus tr.selected .network-dim-cell {\n    color: white !important;\n}\n\n.network-log-grid tr.highlighted-row {\n    -webkit-animation: network-row-highlight-fadeout 2s 0s;\n}\n\n@-webkit-keyframes network-row-highlight-fadeout {\n    from {background-color: rgba(255, 255, 120, 1); }\n    to { background-color: rgba(255, 255, 120, 0); }\n}\n\n.network-header-subtitle {\n    color: gray;\n}\n\n.network-log-grid.data-grid.small .network-cell-subtitle,\n.network-log-grid.data-grid.small .network-header-subtitle {\n    display: none;\n}\n\n/* Resource preview icons */\n\n.network-log-grid.data-grid .icon {\n    content: url(Images/resourcePlainIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon {\n    content: url(Images/resourcePlainIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.script {\n    content: url(Images/resourceJSIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.script {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.document {\n    content: url(Images/resourceDocumentIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.document {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.stylesheet {\n    content: url(Images/resourceCSSIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.stylesheet {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.media {\n    content: url(Images/resourcePlainIcon.png); /* FIXME: media icon */\n}\n\n.network-log-grid.data-grid.small .icon.media {\n    content: url(Images/resourcePlainIconSmall.png); /* FIXME: media icon */\n}\n.network-log-grid.data-grid .icon.texttrack {\n    content: url(Images/resourcePlainIcon.png); /* FIXME: vtt icon */\n}\n\n.network-log-grid.data-grid.small .icon.texttrack {\n    content: url(Images/resourcePlainIconSmall.png); /* FIXME: vtt icon */\n}\n\n.network-log-grid.data-grid .icon.image {\n    position: relative;\n    background-image: url(Images/resourcePlainIcon.png);\n    background-repeat: no-repeat;\n    content: \"\";\n}\n\n.network-log-grid.data-grid.small .icon.image {\n    background-image: url(Images/resourcePlainIconSmall.png);\n    content: \"\";\n}\n\n.network-log-grid.data-grid .icon {\n    float: left;\n    width: 32px;\n    height: 32px;\n    margin-top: 1px;\n    margin-right: 3px;\n}\n\n.network-log-grid.data-grid.small .icon {\n    width: 16px;\n    height: 16px;\n}\n\n.network-log-grid.data-grid .image-network-icon-preview {\n    position: absolute;\n    margin: auto;\n    top: 3px;\n    bottom: 4px;\n    left: 5px;\n    right: 5px;\n    max-width: 18px;\n    max-height: 21px;\n    min-width: 1px;\n    min-height: 1px;\n}\n\n.network-log-grid.data-grid.small .image-network-icon-preview {\n    top: 2px;\n    bottom: 1px;\n    left: 3px;\n    right: 3px;\n    max-width: 8px;\n    max-height: 11px;\n}\n\n/* Graph styles */\n\n.network-graph-side {\n    position: relative;\n    height: 39px;\n    padding: 0;\n    white-space: nowrap;\n    overflow: hidden;\n}\n\n.network-graph-bar-area {\n    position: absolute;\n    top: 0;\n    bottom: 0;\n}\n\n.network-graph-bar-area,\n.network-timeline-grid .resources-dividers,\n.network-timeline-grid .resources-event-dividers,\n.network-timeline-grid .resources-dividers-label-bar {\n    right: 12px;\n    left: 12px;\n}\n\n.network-timeline-grid .resources-event-dividers {\n    margin-left: 1px;\n}\n\n.network-graph-label {\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    height: 13px;\n    line-height: 13px;\n    margin: auto;\n    font-size: 90%;\n    color: rgba(0, 0, 0, 0.75);\n    text-shadow: rgba(255, 255, 255, 0.25) 1px 0 0, rgba(255, 255, 255, 0.25) -1px 0 0, rgba(255, 255, 255, 0.333) 0 1px 0, rgba(255, 255, 255, 0.25) 0 -1px 0;\n    z-index: 150;\n    overflow: hidden;\n    text-align: center;\n    visibility: hidden;\n}\n\n.network-graph-side:hover .network-graph-label {\n    visibility: visible;\n}\n\n.network-graph-label:empty {\n    display: none;\n}\n\n.network-graph-label.waiting {\n    margin-right: 5px;\n}\n\n.network-graph-label.before {\n    color: rgba(0, 0, 0, 0.7);\n    text-shadow: none;\n    text-align: right;\n    margin-right: -1px;\n}\n\n.network-graph-label.before::after {\n    padding-left: 2px;\n    height: 6px;\n    content: url(Images/graphLabelCalloutLeft.png);\n}\n\n.network-graph-label.after {\n    color: rgba(0, 0, 0, 0.7);\n    text-shadow: none;\n    text-align: left;\n    margin-left: -1px;\n}\n\n.network-graph-label.after::before {\n    padding-right: 2px;\n    height: 6px;\n    content: url(Images/graphLabelCalloutRight.png);\n}\n\n.small .network-graph-bar {\n    top: 3px;\n    bottom: 3px;\n}\n\n.network-graph-bar {\n    position: absolute;\n    top: 13px;\n    bottom: 13px;\n    min-width: 3px;\n}\n\n.network-graph-bar:not(.request-timing) {\n    border-width: 1px;\n    border-style: solid;\n    border-color: hsl(0, 0%, 75%);\n    background: linear-gradient(0deg, hsl(0, 0%, 85%), hsl(0, 0%, 95%));\n}\n\n.network-graph-bar.waiting:not(.request-timing) {\n    opacity: 0.5;\n}\n\n/* Resource categories */\n\n.network-graph-bar.request-timing.total,\n.network-graph-bar.request-timing.proxy,\n.network-graph-bar.request-timing.dns,\n.network-graph-bar.request-timing.ssl,\n.network-graph-bar.request-timing.connecting,\n.network-graph-bar.request-timing.blocking {\n    margin: 3px 0;\n}\n\n.network-graph-bar.request-timing.total {\n    border: solid 1px #AAAAAA;\n}\n\n.network-graph-bar.request-timing.receiving {\n    background-color: #03A9F4;\n}\n\n.network-graph-bar.request-timing.waiting {\n    background-color: #00C853;\n}\n\n.network-graph-bar.request-timing.connecting {\n    background-color: #FF9800;\n}\n\n.network-graph-bar.request-timing.ssl {\n    background-color: #9C27B0;\n}\n\n.network-graph-bar.request-timing.dns {\n    background-color: #009688;\n}\n\n.network-graph-bar.request-timing.proxy {\n    background-color: #A1887F;\n}\n\n.network-graph-bar.request-timing.blocking {\n    background-color: #AAAAAA;\n}\n\n.network-graph-bar.cached {\n    background: hsl(0, 0%, 90%);\n}\n\n.network-graph-bar.document {\n    border-color: hsl(215, 49%, 60%);\n    background: linear-gradient(0deg, hsl(215, 72%, 65%), hsl(215, 100%, 80%));\n}\n\n.network-graph-bar.cached.document {\n    background: hsl(215, 99%, 80%);\n}\n\n.network-graph-bar.stylesheet {\n    border-color: hsl(99, 34%, 60%);\n    background: linear-gradient(0deg, hsl(100, 50%, 65%), hsl(90, 50%, 80%));\n}\n\n.network-graph-bar.cached.stylesheet {\n    background: hsl(99, 100%, 80%);\n}\n\n.network-graph-bar.image {\n    border-color: hsl(272, 31%, 60%);\n    background: linear-gradient(0deg, hsl(272, 46%, 65%), hsl(272, 64%, 80%));\n}\n\n.network-graph-bar.cached.image {\n    background: hsl(272, 65%, 80%);\n}\n\n.network-graph-bar.media {\n    border-color: hsl(272, 31%, 60%);\n    background: linear-gradient(0deg, hsl(272, 46%, 65%), hsl(272, 64%, 80%));\n}\n\n.network-graph-bar.cached.media {\n    background: hsl(272, 65%, 80%);\n}\n\n.network-graph-bar.font {\n    border-color: hsl(8, 49%, 60%);\n    background: linear-gradient(0deg, hsl(8, 72%, 65%), hsl(8, 100%, 80%));\n}\n\n.network-graph-bar.cached.font {\n    background: hsl(8, 100%, 80%);\n}\n\n.network-graph-bar.texttrack {\n    border-color: hsl(8, 49%, 60%);\n    background: linear-gradient(0deg, hsl(8, 72%, 65%), hsl(8, 100%, 80%));\n}\n\n.network-graph-bar.cached.texttrack {\n    background: hsl(8, 100%, 80%);\n}\n\n.network-graph-bar.script {\n    border-color: hsl(31, 49%, 60%);\n    background: linear-gradient(0deg, hsl(31, 72%, 65%), hsl(31, 100%, 80%));\n}\n\n.network-graph-bar.cached.script {\n    background: hsl(31, 100%, 80%);\n}\n\n.network-graph-bar.xhr {\n    border-color: hsl(53, 49%, 60%);\n    background: linear-gradient(0deg, hsl(53, 72%, 65%), hsl(53, 100%, 80%));\n}\n\n.network-graph-bar.cached.xhr {\n    background: hsl(53, 100%, 80%);\n}\n\n.network-graph-bar.websocket {\n    border-color: hsl(0, 0%, 60%);\n    background: linear-gradient(0deg, hsl(0, 0%, 65%), hsl(0, 0%, 80%));\n}\n\n.network-graph-bar.cached.websocket {\n    background: hsl(0, 0%, 80%);\n}\n\n.network-dim-cell {\n    color: grey;\n}\n\n/* Dividers */\n\n.network-timeline-grid {\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    right: 14px; /* Keep in sync with td.corner width */\n    pointer-events: none;\n}\n\n.network-event-divider {\n    position: absolute;\n    width: 2px;\n    margin-left: -1px;\n    top: 31px;\n    bottom: 0;\n    z-index: 300;\n}\n\n.network-event-divider.invisible {\n    visibility: hidden;\n}\n\n.network-timeline-grid.small .network-event-divider {\n    top: 23px;\n}\n\n.network-orange-divider {\n    background-color: rgba(255, 120, 0, 0.5);\n}\n\n.network-red-divider {\n    background-color: rgba(255, 0, 0, 0.5);\n}\n\n.network-summary-bar .summary-red {\n    color: red;\n}\n\n.network-blue-divider {\n    background-color: rgba(0, 0, 255, 0.5);\n}\n\n.network-summary-bar .summary-blue {\n    color: blue;\n}\n\n.network-log-grid.data-grid .resources-dividers {\n    z-index: 0;\n}\n\n.network-log-grid.data-grid .resources-dividers-label-bar {\n    background-color: transparent;\n    border: none;\n    height: 30px;\n    pointer-events: none;\n}\n\n.network-timeline-grid.small .resources-dividers-label-bar {\n    height: 23px;\n}\n\n.network-timeline-grid .resources-divider-label {\n    top: 0;\n    margin-top: -5px;\n}\n\n.network-timeline-grid .resources-dividers-label-bar .resources-divider {\n    top: 23px;\n}\n\n.network-timeline-grid.small .resources-dividers-label-bar .resources-divider {\n    top: 15px;\n}\n\n.network-timeline-grid .resources-divider:first-child .resources-divider-label {\n    display: none;\n}\n\n.network-timeline-grid .resources-dividers-label-bar .resources-divider:first-child {\n    background-color: transparent;\n}\n\n#network-container {\n    overflow-y: auto;\n    overflow-x: hidden;\n}\n\n/* Brief mode peculiarities. */\n#network-container.brief-mode .network-timeline-grid {\n    display: none;\n}\n\n/*# sourceURL=network/networkLogView.css */";Runtime.cachedResources["network/networkPanel.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.network-details-view {\n    background: rgb(203, 203, 203);\n}\n\n.network-close-button {\n    margin: auto -1px auto 4px;\n}\n\n.network-details-view .network-item-view::shadow .tabbed-pane-header {\n    flex: 0 0 23px;\n    padding-top: 0;\n    white-space: nowrap;\n}\n\n.network-details-view-tall-header .network-item-view::shadow .tabbed-pane-header {\n    flex-basis: 31px;\n    padding-top: 8px;\n}\n\n.network-item-view {\n    display: none;\n    background: white;\n}\n\n.network-item-view.visible {\n    display: flex;\n}\n\n.network-item-view::shadow .tabbed-pane-header {\n    border-bottom: 1px solid rgb(205, 205, 205);\n    background-color: transparent;\n}\n\n.resource-timing-view {\n    display: none;\n    margin: 6px;\n    color: rgb(30%, 30%, 30%);\n}\n\n/* Network timing is shared between popover and network item view pane */\n\n.network-timing-table {\n    width: 380px;\n    border-spacing: 0;\n    padding-left: 10px;\n    padding-right: 10px;\n}\n\n.network-timing-table-header td {\n    color: #bbb;\n    border-top: 5px solid transparent;\n    border-bottom: 5px solid transparent;\n}\n\n.network-timing-table-header td:last-child {\n    text-align: right;\n}\n\n.network-timing-table col.labels {\n    width: 120px;\n}\n\n.network-timing-table col.duration {\n    width: 80px;\n}\n\n.network-timing-table td {\n    padding: 2px 0;\n}\n\n.network-timing-table td.caution {\n    font-weight: bold;\n    color: rgb(255, 128, 0);\n    padding: 2px 0;\n}\n\n.network-timing-footer td {\n    border-top: 8px solid transparent;\n}\n\n.network-timing-footer td:last-child {\n    font-weight: bold;\n    text-align: right;\n}\n\n.network-timing-row {\n    position: relative;\n    height: 15px;\n}\n\n.network-timing-bar {\n    position: absolute;\n    min-width: 1px;\n    top: 0;\n    bottom: 0;\n}\n\n.network-timing-bar-title {\n    color: #222;\n    white-space: nowrap;\n    text-align: right;\n}\n\n.network-timing-bar.total {\n    border: 1px solid rgba(0, 0, 0, 0.1);\n}\n\n.network-timing-bar.blocking {\n    background-color: #AAAAAA;\n}\n\n.network-timing-bar.proxy {\n    background-color: #A1887F;\n}\n\n.network-timing-bar.dns {\n    background-color: #009688;\n}\n\n.network-timing-bar.connecting,\n.network-timing-bar.serviceworker,\n.network-timing-bar.serviceworker-preparation {\n    background-color: #FF9800;\n}\n\n.network-timing-bar.ssl {\n    background-color: #9C27B0;\n}\n\n.network-timing-bar.sending {\n    background-color: #B0BEC5;\n}\n\n.network-timing-bar.waiting {\n    background-color: #00C853;\n}\n\n.network-timing-bar.receiving {\n    background-color: #03A9F4;\n}\n\n.network-timing-bar.proxy,\n.network-timing-bar.dns,\n.network-timing-bar.ssl,\n.network-timing-bar.connecting,\n.network-timing-bar.blocking {\n    height: 10px;\n    margin: auto;\n}\n\n.resource-timing-view.visible {\n    display: block;\n}\n\n.resource-timing-view .network-timing-table {\n    width: 100%;\n}\n\n.network-filters-header {\n    flex: 0 0 23px;\n    padding-right: 4px;\n}\n\n.network-filters-header .filter-text-filter {\n    flex-grow: 1;\n    max-width: 312px;\n}\n\n#network-overview-container {\n    overflow: hidden;\n    flex: auto;\n    display: flex;\n    position: relative;\n    border-bottom: 1px solid #CDCDCD;\n}\n\n.network-overview-canvas-container {\n    position: absolute;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    z-index: 200;\n}\n\n.network-overview-canvas-container canvas {\n    width: 100%;\n    height: 100%;\n}\n\n#network-overview-grid {\n    flex: auto;\n}\n\n.network .network-overview {\n    flex: 0 0 100px;\n}\n\n.network-overview .overview-grid-window,\n.network-overview .overview-grid-dividers-background {\n    height: 100%;\n}\n\n.network-overview .resources-dividers-label-bar {\n    background-color: rgba(255, 255, 255, 0.95);\n}\n\n.network-overview .resources-dividers-label-bar .resources-divider {\n    background-color: transparent;\n}\n\n.network-overview .resources-dividers {\n    z-index: 250;\n}\n\n.network .network-film-strip-view {\n    flex: 0 0 117px;\n    border-bottom: solid 1px #cdcdcd;\n}\n\n.request-view.json {\n    padding: 5px;\n}\n\n.request-view.html iframe {\n    width: 100%;\n    height: 100%;\n    position: absolute;\n}\n\n/*# sourceURL=network/networkPanel.css */";Runtime.cachedResources["network/requestCookiesView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.request-cookies-view {\n    display: none;\n    overflow: auto;\n    margin: 12px;\n    height: 100%;\n}\n\n.request-cookies-view.visible {\n    display: flex;\n}\n\n.request-cookies-view .data-grid {\n    flex: auto;\n    height: 100%;\n}\n\n.request-cookies-view .data-grid .row-group {\n    font-weight: bold;\n    font-size: 11px;\n}\n\n/*# sourceURL=network/requestCookiesView.css */";Runtime.cachedResources["network/requestHeadersView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.request-headers-view {\n    -webkit-user-select: text;\n    overflow: auto;\n}\n\n.request-headers-view .outline-disclosure {\n    -webkit-padding-start: 4px;\n    flex-grow: 1;\n    overflow-y: auto;\n}\n\n.request-headers-view .outline-disclosure > .parent {\n    -webkit-user-select: none;\n    font-weight: bold;\n    color: #616161;\n    margin-top: -1px;\n    height: 20px;\n    border-top: solid 1px #e0e0e0;\n    display: flex;\n    align-items: center;\n}\n\n.request-headers-view .outline-disclosure li.parent::before {\n    position: static;\n    width: 9px;\n    height: 9px;\n    -webkit-mask-position: -4px -98px;\n    background-image: none;\n    opacity: 1;\n}\n\n.request-headers-view .outline-disclosure li.parent.expanded::before {\n    -webkit-mask-position: -20px -98px;\n}\n\n.request-headers-view .properties-tree li.parent {\n    margin-left: 10px;\n}\n\n.request-headers-view .outline-disclosure .children li {\n    white-space: nowrap;\n}\n\n.request-headers-view .outline-disclosure .caution {\n    margin-left: 4px;\n    display: inline-block;\n    font-weight: bold;\n}\n\n.request-headers-view .outline-disclosure li.expanded .header-count {\n    display: none;\n}\n\n.request-headers-view .outline-disclosure li .header-toggle {\n    display: none;\n}\n\n.request-headers-view .outline-disclosure li .status-from-cache {\n    color: gray;\n}\n\n.request-headers-view .outline-disclosure li.expanded .header-toggle {\n    display: inline;\n    margin-left: 30px;\n    font-weight: normal;\n    color: rgb(45%, 45%, 45%);\n}\n\n.request-headers-view .outline-disclosure li .header-toggle:hover {\n    color: rgb(20%, 20%, 45%);\n    cursor: pointer;\n}\n\n.request-headers-view .outline-disclosure .header-name {\n    color: rgb(33%, 33%, 33%);\n    display: inline-block;\n    margin-right: 0.5em;\n    font-weight: bold;\n    vertical-align: top;\n    white-space: pre-wrap;\n}\n\n.request-headers-view .outline-disclosure .header-value {\n    display: inline;\n    margin-right: 1em;\n    white-space: pre-wrap;\n    word-break: break-all;\n    margin-top: 1px;\n}\n\n.resource-status-image {\n    margin-top: -2px;\n    margin-right: 3px;\n}\n\n.request-headers-view .filter-input {\n    outline: none !important;\n    border: none;\n    border-bottom: solid 1px #ccc;\n    flex: 0 0 19px;\n    padding: 0 4px;\n}\n\n/*# sourceURL=network/requestHeadersView.css */";Runtime.cachedResources["network/webSocketFrameView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.websocket-frame-view {\n    -webkit-user-select: text;\n}\n\n.websocket-frame-view .data-grid {\n    flex: auto;\n    border: none;\n}\n\n.websocket-frame-view .data-grid .data {\n    background-image: none;\n}\n\n.websocket-frame-view-td {\n    border-bottom: 1px solid #ccc;\n}\n\n.websocket-frame-view .data-grid tr.selected {\n    background-color: #def;\n}\n\n.websocket-frame-view .data-grid td,\n.websocket-frame-view .data-grid th {\n    border-left-color: #ccc;\n}\n\n.websocket-frame-view-row-outcoming {\n    background-color: rgb(226, 247, 218);\n}\n\n.websocket-frame-view-row-opcode {\n    background-color: rgb(255, 255, 232);\n    color: rgb(170, 111, 71);\n}\n\n.websocket-frame-view-row-error {\n    background-color: rgb(255, 237, 237);\n    color: rgb(182, 0, 0);\n}\n\n/*# sourceURL=network/webSocketFrameView.css */";Runtime.cachedResources["network/xmlView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.shadow-xml-view {\n    -webkit-user-select: text;\n    overflow: auto;\n    padding: 2px 4px;\n}\n\n.shadow-xml-view ol {\n    list-style: none;\n    padding: 0;\n    margin: 0;\n    -webkit-padding-start: 16px; /* step width + arrow width */\n}\n\n.shadow-xml-view > ol {\n    -webkit-padding-start: 0;\n}\n\n.shadow-xml-view ol.children:not(.expanded) {\n    display: none;\n}\n\n.shadow-xml-view li {\n  display: flex;\n  align-items: center;\n}\n\n.shadow-xml-view li.parent::before {\n  -webkit-user-select: none;\n  -webkit-mask-image: url(Images/statusbarButtonGlyphs.png);\n  -webkit-mask-size: 320px 144px;\n  -webkit-mask-position: -4px -97px;\n  background-color: rgb(110, 110, 110);\n  content: \"\";\n  width: 10px; /* arrow width */\n  height: 10px;\n}\n\n.shadow-xml-view li.parent.expanded::before {\n  -webkit-mask-position: -20px -97px;\n}\n\n@media (-webkit-min-device-pixel-ratio: 1.5) {\n.shadow-xml-view li.parent::before {\n    -webkit-mask-image: url(Images/statusbarButtonGlyphs_2x.png);\n}\n} /* media */\n\n.shadow-xml-view li:not(.parent) {\n    margin-left: 10px; /* arrow width */\n}\n\n.shadow-xml-view li.shadow-xml-view-close-tag {\n    margin-left: -6px; /* step width */\n}\n\n.shadow-xml-view-tag {\n    color: rgb(136, 18, 128);\n}\n\n.shadow-xml-view-comment {\n    color: rgb(35, 110, 37);\n}\n\n.shadow-xml-view-processing-instruction {\n    color: rgb(35, 110, 37);\n}\n\n.shadow-xml-view-attribute-name {\n    color: rgb(153, 69, 0);\n}\n\n.shadow-xml-view-attribute-value {\n    color: rgb(26, 26, 166);\n}\n\n.shadow-xml-view-text {\n    color: rgb(0, 0, 0);\n    white-space: pre;\n}\n\n.shadow-xml-view-cdata {\n    color: rgb(0, 0, 0);\n}\n\n/*# sourceURL=network/xmlView.css */";