#!/bin/sh
export PATH='/usr/obj/hs-cryptohash-0.7.10/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: cryptohash
version: 0.7.10
id: cryptohash-0.7.10-e76e63944c715935129200705251e88c

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability:
homepage: http://github.com/vincenthz/hs-cryptohash
package-url:
synopsis: collection of crypto hashes, fast, pure and practical
description: A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
             with performance close to the fastest implementations available in others languages.
             .
             The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cryptohash
exposed: True
exposed-modules: Crypto.Hash.SHA1 Crypto.Hash.SHA224
                 Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                 Crypto.Hash.SHA512t Crypto.Hash.SHA3 Crypto.Hash.MD2
                 Crypto.Hash.MD4 Crypto.Hash.MD5 Crypto.Hash.RIPEMD160
                 Crypto.Hash.Skein256 Crypto.Hash.Skein512 Crypto.Hash.Tiger
                 Crypto.Hash.Whirlpool Crypto.MAC.HMAC
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.10
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.10
hs-libraries: HScryptohash-0.7.10
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         cereal-0.4.1.0-9d42a4c31bc1d35f6a410f5e79e67215
         crypto-api-0.13.2-bcd8d1b88ec2398781ed0f4d7c219c08
         tagged-0.7.3-4aece88b76fce3c636457239733a4dfa
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.10/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
