/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DefaultExpressionModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.ExpressionEventHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class DefaultWatchExpressionModelProxy
extends DefaultExpressionModelProxy
implements IDebugContextListener {
    private IWorkbenchWindow fWindow;

    public DefaultWatchExpressionModelProxy(IWatchExpression expression, IWorkbenchWindow window) {
        super((IExpression)expression);
        this.fWindow = window;
        DebugContextManager.getDefault().addDebugContextListener(this, window);
    }

    public void installed() {
        ISelection activeContext;
        super.installed();
        IWorkbenchPart part = this.getPresentationContext().getPart();
        if (part != null && (activeContext = DebugContextManager.getDefault().getActiveContext(part.getSite().getWorkbenchWindow())) != null) {
            this.contextActivated(activeContext, null);
        }
    }

    public synchronized void dispose() {
        super.dispose();
        DebugContextManager.getDefault().removeDebugContextListener(this, this.fWindow);
        this.fWindow = null;
    }

    protected DebugEventHandler[] createEventHandlers() {
        return new DebugEventHandler[]{new ExpressionEventHandler(this)};
    }

    public void contextActivated(ISelection selection, IWorkbenchPart part) {
        if (this.fWindow != null && selection instanceof IStructuredSelection) {
            IDebugElement context = null;
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() < 2) {
                Object object = ss.getFirstElement();
                if (object instanceof IDebugElement) {
                    context = (IDebugElement)object;
                } else if (object instanceof ILaunch) {
                    context = ((ILaunch)object).getDebugTarget();
                }
            }
            ((IWatchExpression)this.getExpression()).setExpressionContext(context);
        }
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
    }
}

