/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.containment;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.models.sql.routines.Function;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;


public class RoutineContainmentProvider extends AbstractContainmentProvider {
	public EObject getContainer(EObject obj) {
		return ((Routine) obj).getSchema();
   }
   
	public EStructuralFeature getContainmentFeature(EObject obj) {
      if (this.getContainer(obj) == null)
         return null;
      else
         return SQLSchemaPackage.eINSTANCE.getSchema_Routines();
   }
	
	public String getGroupId(EObject obj) {
		if(obj instanceof Procedure) {
			return GroupID.PROCEDURE;
		}
		
		if(obj instanceof Function) {
			return GroupID.FUNCTION;			
		}
		
		return null;
	}	
}
