/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public final class J2EEUtils {
    public static final int WEB = 1;
    public static final int EJB = 2;
    public static final int APPCLIENT = 4;
    public static final int EAR = 8;
    static /* synthetic */ Class class$0;

    public static IVirtualComponent getVirtualComponent(IProject project) {
        return ComponentCore.createComponent((IProject)project);
    }

    public static IVirtualComponent getVirtualComponent(String projectName) {
        IProject project = null;
        if (projectName != null && projectName.length() > 0) {
            project = ProjectUtilities.getProject((String)projectName);
        }
        return ComponentCore.createComponent(project);
    }

    public static int getJ2EEVersion(IProject p) {
        String ver = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)p);
        return J2EEVersionUtil.convertVersionStringToInt((String)ver);
    }

    public static int getJ2EEVersion(IVirtualComponent ch) {
        int j2eeVer = -1;
        if (ch != null) {
            IProject project = ch.getProject();
            j2eeVer = J2EEUtils.getJ2EEVersion(project);
        }
        return j2eeVer;
    }

    public static String getJ2EEVersionAsString(IProject p) {
        String ver = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)p);
        return ver != null ? ver : null;
    }

    public static IVirtualComponent[] getAllComponents() {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)projects[i]);
            if (vc != null) {
                v.add(vc);
            }
            ++i;
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getAllEARComponents() {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IVirtualComponent[] components = J2EEUtils.getEARComponentsFromProject(projects[i]);
                int j = 0;
                while (j < components.length) {
                    if (components[j] != null) {
                        v.add(components[j]);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getAllWebComponents() {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IVirtualComponent[] components = J2EEUtils.getWebComponents(projects[i]);
                int j = 0;
                while (j < components.length) {
                    if (components[j] != null) {
                        v.add(components[j]);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getAllEJBComponents() {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IVirtualComponent[] components = J2EEUtils.getEJBComponents(projects[i]);
                int j = 0;
                while (j < components.length) {
                    if (components[j] != null) {
                        v.add(components[j]);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getEARComponentsFromProject(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null && J2EEUtils.isEARComponent(component)) {
                v.add(component);
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getWebComponents(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null && J2EEUtils.isWebComponent(component)) {
                v.add(component);
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static String[] getWebComponentNames(IProject project) {
        IVirtualComponent[] vcs = J2EEUtils.getWebComponents(project);
        return J2EEUtils.toComponentNamesArray(vcs);
    }

    public static String[] getEARComponentNames(IProject project) {
        IVirtualComponent[] vcs = J2EEUtils.getEARComponentsFromProject(project);
        return J2EEUtils.toComponentNamesArray(vcs);
    }

    public static IVirtualComponent[] getComponentsByType(IProject project, int componentType) {
        ArrayList v = new ArrayList();
        if ((1 & componentType) == 1) {
            IVirtualComponent[] webVC = J2EEUtils.getWebComponents(project);
            J2EEUtils.addToArrayListHelper(webVC, v);
        }
        if ((2 & componentType) == 2) {
            IVirtualComponent[] ejbVC = J2EEUtils.getEJBComponents(project);
            J2EEUtils.addToArrayListHelper(ejbVC, v);
        }
        if ((4 & componentType) == 4) {
            IVirtualComponent[] appClientVC = J2EEUtils.getAppClientComponents(project);
            J2EEUtils.addToArrayListHelper(appClientVC, v);
        }
        if ((8 & componentType) == 8) {
            IVirtualComponent[] earVC = J2EEUtils.getEARComponentsFromProject(project);
            J2EEUtils.addToArrayListHelper(earVC, v);
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getComponentsByType(IProject project, String componentTypeId) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            if (vc != null && J2EEProjectUtilities.isProjectOfType((IProject)project, (String)componentTypeId)) {
                v.add(vc);
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static String[] getProjectsContainingComponentOfType(String componentTypeId) {
        Vector<String> v = new Vector<String>();
        IVirtualComponent[] comps = J2EEUtils.getAllComponents();
        int i = 0;
        while (i < comps.length) {
            String name;
            if (J2EEProjectUtilities.isProjectOfType((IProject)comps[i].getProject(), (String)componentTypeId) && !v.contains(name = comps[i].getProject().getName())) {
                v.add(name);
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    private static void addToArrayListHelper(IVirtualComponent[] vcs, List al) {
        int i = 0;
        while (i < vcs.length) {
            al.add(vcs[i]);
            ++i;
        }
    }

    public static IProject[] getAllFlexibleProjects() {
        ArrayList<IProject> v = new ArrayList<IProject>();
        try {
            IProject[] projects = ProjectUtilities.getAllProjects();
            int i = 0;
            while (i < projects.length) {
                if (ModuleCoreNature.getModuleCoreNature((IProject)projects[i]) != null) {
                    v.add(projects[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IProject[0]);
    }

    public static boolean exists(String projectName, String componentName) {
        IProject project = null;
        if (projectName == null || projectName.length() <= 0) {
            return false;
        }
        project = ProjectUtilities.getProject((String)projectName);
        return J2EEUtils.exists(project);
    }

    public static boolean exists(IProject project) {
        if (project != null) {
            if (!project.exists()) {
                return false;
            }
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            return vc.exists();
        }
        return false;
    }

    public static IVirtualComponent[] getReferencingEARComponents(IProject project) {
        ArrayList<IVirtualComponent> ears = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent targetVC = ComponentCore.createComponent((IProject)project);
            IVirtualComponent[] earVC = J2EEUtils.getAllEARComponents();
            int i = 0;
            while (i < earVC.length) {
                IVirtualReference[] refs = earVC[i].getReferences();
                int k = 0;
                while (k < refs.length) {
                    if (targetVC.equals(refs[k].getReferencedComponent())) {
                        ears.add(refs[k].getEnclosingComponent());
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return ears.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getReferencingEJBComponentsFromEAR(IProject project) {
        ArrayList<IVirtualComponent> ejbComps = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                if (J2EEUtils.isEJBComponent(refs[i].getReferencedComponent())) {
                    ejbComps.add(refs[i].getReferencedComponent());
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return ejbComps.toArray(new IVirtualComponent[0]);
    }

    public static Vector getBeanNames(EJBJar jar) {
        List sessionBeans = jar.getSessionBeans();
        Vector names = new Vector();
        J2EEUtils.getBeanNames(names, sessionBeans);
        return names;
    }

    private static void getBeanNames(Vector names, List beans) {
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            Session sessionBean;
            EnterpriseBean bean = (EnterpriseBean)iterator.next();
            if (!bean.isSession() || (sessionBean = (Session)bean).getSessionType().getValue() != 1) continue;
            names.add(bean.getName());
        }
    }

    public static IProject getProjectFromEJB(EnterpriseBean ejb) {
        return ProjectUtilities.getProject((EObject)ejb);
    }

    public static IVirtualComponent getDefault13EARComponent() {
        IVirtualComponent[] allEARComponents = J2EEUtils.getAllEARComponents();
        int j = 0;
        while (j < allEARComponents.length) {
            int j2eeVersion = J2EEUtils.getJ2EEVersion(allEARComponents[j]);
            if (j2eeVersion == 13) {
                return allEARComponents[j];
            }
            ++j;
        }
        return null;
    }

    public static IVirtualComponent getDefault14EARComponent() {
        IVirtualComponent[] allEARComponents = J2EEUtils.getAllEARComponents();
        int j = 0;
        while (j < allEARComponents.length) {
            int j2eeVersion = J2EEUtils.getJ2EEVersion(allEARComponents[j]);
            if (j2eeVersion == 14) {
                return allEARComponents[j];
            }
            ++j;
        }
        return null;
    }

    public static IVirtualComponent getEARComponentofJ2EEVersion(int versionId) {
        IVirtualComponent[] components = J2EEUtils.getAllEARComponents();
        int i = 0;
        while (i < components.length) {
            if (J2EEUtils.getJ2EEVersion(components[i]) == versionId) {
                return components[i];
            }
            ++i;
        }
        return null;
    }

    public static String getLabelFromJ2EEVersion(String j2eeVersionInt) {
        if (j2eeVersionInt == null || j2eeVersionInt.length() == 0) {
            return "";
        }
        int j2eeVersion = Integer.parseInt(j2eeVersionInt);
        switch (j2eeVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return "";
    }

    public static String getJ2EEVersionFromLabel(String j2eeLabel) {
        String j2ee12String = String.valueOf(12);
        String j2ee13String = String.valueOf(13);
        String j2ee14String = String.valueOf(14);
        if (j2eeLabel.equals("1.2")) {
            return j2ee12String;
        }
        if (j2eeLabel.equals("1.3")) {
            return j2ee13String;
        }
        if (j2eeLabel.equals("1.4")) {
            return j2ee14String;
        }
        return "";
    }

    public static String getJ2EEIntVersionAsString(String aVersion) {
        if (aVersion.equals("1.4")) {
            return new Integer(14).toString();
        }
        if (aVersion.equals("1.3")) {
            return new Integer(13).toString();
        }
        if (aVersion.equals("1.2")) {
            return new Integer(12).toString();
        }
        return new Integer(14).toString();
    }

    public static IProject[] getEARProjects() {
        Vector<IProject> v = new Vector<IProject>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (ResourceUtils.isEARProject(projects[i])) {
                    v.add(projects[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v.toArray(new IProject[0]);
    }

    public static IProject getDefaultEARProject(IProject serviceProject, IServer server) {
        IProject[] earProjects = null;
        IProject ear = null;
        if (serviceProject != null && serviceProject.exists()) {
            block14: {
                boolean isWebEJBOrAppClient;
                boolean bl = isWebEJBOrAppClient = ResourceUtils.isWebProject(serviceProject) || ResourceUtils.isEJBProject(serviceProject) || ResourceUtils.isAppClientProject(serviceProject);
                if (isWebEJBOrAppClient) break block14;
                return null;
            }
            try {
                IProject[] ears = J2EEUtils.getEARProjects();
                if (ears != null && ears.length >= 1) {
                    ArrayList<Object> preferredEARList = new ArrayList<Object>();
                    ArrayList<IProject> secondaryEARList = new ArrayList<IProject>();
                    int i = 0;
                    while (i < ears.length) {
                        ear = ears[i];
                        IModule module = ResourceUtils.getModule(ear);
                        if (module != null) {
                            if (server != null || ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)new NullProgressMonitor())) {
                                preferredEARList.add(ear);
                            } else {
                                secondaryEARList.add(ear);
                            }
                        }
                        ++i;
                    }
                    int j = 0;
                    while (j < secondaryEARList.size()) {
                        preferredEARList.add(secondaryEARList.get(j));
                        ++j;
                    }
                    if (preferredEARList != null) {
                        earProjects = preferredEARList.toArray(new IProject[0]);
                    }
                }
            }
            catch (Exception ce) {
                ILog log = EnvironmentService.getEclipseLog();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jst.ws.internal.common.J2EEUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                log.log(4, 5039, (Object)clazz, "getEARProjects", (Throwable)ce);
            }
        }
        return earProjects[0];
    }

    public static IVirtualComponent[] getEJBComponents(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        try {
            if (component != null && J2EEUtils.isEJBComponent(component)) {
                v.add(component);
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getAppClientComponents(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null && J2EEUtils.isAppClientComponent(component)) {
                v.add(component);
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getReferencingEJB20ComponentsFromEAR(IProject project) {
        ArrayList<IVirtualComponent> ejbComps = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                if (J2EEUtils.isEJB20Component(refs[i].getReferencedComponent())) {
                    ejbComps.add(refs[i].getReferencedComponent());
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return ejbComps.toArray(new IVirtualComponent[0]);
    }

    public static IProject[] combineProjectArrays(IProject[] projectArray1, IProject[] projectArray2) {
        if (projectArray1 == null && projectArray2 == null) {
            return null;
        }
        if (projectArray1 != null && projectArray2 == null) {
            return projectArray1;
        }
        if (projectArray1 == null && projectArray2 != null) {
            return projectArray2;
        }
        IProject[] combinedProjects = new IProject[projectArray1.length + projectArray2.length];
        System.arraycopy(projectArray1, 0, combinedProjects, 0, projectArray1.length);
        if (projectArray2.length > 0) {
            System.arraycopy(projectArray2, 0, combinedProjects, projectArray1.length, projectArray2.length);
        }
        return combinedProjects;
    }

    public static IVirtualComponent[] getReferencingWebComponentsFromEAR(IProject project) {
        ArrayList<IVirtualComponent> webComps = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                if (J2EEUtils.isWebComponent(refs[i].getReferencedComponent())) {
                    webComps.add(refs[i].getReferencedComponent());
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return webComps.toArray(new IVirtualComponent[0]);
    }

    public static boolean isEJB20Component(IVirtualComponent ejbComponent) {
        return J2EEUtils.isEJB20Component(ejbComponent.getProject());
    }

    /*
     * Exception decompiling
     */
    public static boolean isEJB20Component(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 67->73)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isComponentAssociated(IProject earProject, IProject project) {
        IVirtualComponent vc1 = ComponentCore.createComponent((IProject)earProject);
        IVirtualComponent vc2 = ComponentCore.createComponent((IProject)project);
        return J2EEUtils.isComponentAssociated(vc1, vc2);
    }

    private static boolean isComponentAssociated(IVirtualComponent ear, IVirtualComponent component) {
        boolean isAssociated = false;
        IVirtualReference[] compRefs = ear.getReferences();
        if (compRefs != null) {
            int i = 0;
            while (i < compRefs.length) {
                IVirtualReference vref = compRefs[i];
                if (component.equals(vref.getReferencedComponent())) {
                    isAssociated = true;
                }
                ++i;
            }
        }
        return isAssociated;
    }

    public static void associateComponentToEAR(IProject project, IProject earProject) {
        IDataModel addComponentToEARDataModel = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        addComponentToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        List modList = (List)addComponentToEARDataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        IVirtualComponent targetComp = ComponentCore.createComponent((IProject)project);
        modList.add(targetComp);
        addComponentToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
        try {
            addComponentToEARDataModel.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    public static IStatus canAssociateProjectToEAR(IProject project, IProject earProject) {
        IStatus status = Status.OK_STATUS;
        boolean isWeb = J2EEUtils.isWebComponent(project);
        boolean isEJB = J2EEUtils.isEJBComponent(project);
        boolean isAppClient = J2EEUtils.isAppClientComponent(project);
        boolean isEAR = J2EEUtils.isEARComponent(earProject);
        if ((isWeb || isEJB || isAppClient) && isEAR) {
            try {
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                IFacetedProject fEarProject = ProjectFacetsManager.create((IProject)earProject);
                IProjectFacet earPf = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
                IProjectFacetVersion earPfv = fEarProject.getInstalledVersion(earPf);
                String earVersion = earPfv.getVersionString();
                String webVersion = null;
                String ejbVersion = null;
                String acVersion = null;
                if (isWeb) {
                    IProjectFacet webPf = ProjectFacetsManager.getProjectFacet((String)"jst.web");
                    IProjectFacetVersion webPfv = fProject.getInstalledVersion(webPf);
                    webVersion = webPfv.getVersionString();
                } else if (isEJB) {
                    IProjectFacet ejbPf = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
                    IProjectFacetVersion ejbPfv = fProject.getInstalledVersion(ejbPf);
                    ejbVersion = ejbPfv.getVersionString();
                } else if (isAppClient) {
                    IProjectFacet acPf = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
                    IProjectFacetVersion acPfv = fProject.getInstalledVersion(acPf);
                    acVersion = acPfv.getVersionString();
                }
                if (isWeb && webVersion.equals("2.2") || isEJB && ejbVersion.equals("1.1") || isAppClient && acVersion.equals("1.2")) {
                    if (!J2EEUtils.greaterThanOrEqualTo(earVersion, "1.2")) {
                        status = StatusUtils.errorStatus((String)"1.2");
                    }
                } else if (isWeb && webVersion.equals("2.3") || isEJB && ejbVersion.equals("2.0") || isAppClient && acVersion.equals("1.3")) {
                    if (!J2EEUtils.greaterThanOrEqualTo(earVersion, "1.3")) {
                        status = StatusUtils.errorStatus((String)"1.3");
                    }
                } else if ((isWeb && webVersion.equals("2.4") || isEJB && ejbVersion.equals("2.1") || isAppClient && acVersion.equals("1.4")) && !J2EEUtils.greaterThanOrEqualTo(earVersion, "1.4")) {
                    status = StatusUtils.errorStatus((String)"1.4");
                }
            }
            catch (CoreException coreException) {}
        }
        return status;
    }

    private static boolean greaterThanOrEqualTo(String versionA, String versionB) {
        int sizeB;
        if (versionA.equals(versionB)) {
            return true;
        }
        StringTokenizer stA = new StringTokenizer(versionA, ".");
        StringTokenizer stB = new StringTokenizer(versionB, ".");
        int sizeA = stA.countTokens();
        int size = sizeA < (sizeB = stB.countTokens()) ? sizeA : sizeB;
        int i = 0;
        while (i < size) {
            int b;
            int a = Integer.parseInt(stA.nextToken());
            if (a != (b = Integer.parseInt(stB.nextToken()))) {
                return a > b;
            }
            ++i;
        }
        return sizeA > sizeB;
    }

    public static IPath getWebInfPath(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder webInfDir = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF"));
        IPath modulePath = webInfDir.getWorkspaceRelativePath();
        if (!webInfDir.exists()) {
            try {
                webInfDir.create(0, null);
            }
            catch (CoreException coreException) {}
        }
        return modulePath;
    }

    public static IPath getFirstWebContentPath(IProject project) {
        IPath modulePath = null;
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
                modulePath = vc.getRootFolder().getWorkspaceRelativePath();
            }
        }
        catch (Exception exception) {}
        return modulePath;
    }

    public static IPath getWebContentPath(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IPath modulePath = component.getRootFolder().getWorkspaceRelativePath();
        return modulePath;
    }

    public static IContainer getFirstWebContentContainer(IProject project) {
        IContainer container = null;
        IPath modulePath = J2EEUtils.getFirstWebContentPath(project);
        IResource res = ResourceUtils.findResource(modulePath);
        if (res != null) {
            container = res.getParent();
        }
        return container;
    }

    public static IContainer getWebContentContainer(IProject project) {
        IContainer container = null;
        IPath modulePath = J2EEUtils.getWebContentPath(project);
        IResource res = ResourceUtils.findResource(modulePath);
        if (res instanceof IContainer) {
            container = (IContainer)res;
        }
        return container;
    }

    public static String getFirstWebModuleName(IProject project) {
        String moduleName = null;
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            moduleName = vc.getName();
        }
        catch (Exception exception) {}
        return moduleName;
    }

    public static boolean isWebComponent(IVirtualComponent comp) {
        return J2EEProjectUtilities.isDynamicWebProject((IProject)comp.getProject());
    }

    public static boolean isEARComponent(IVirtualComponent comp) {
        return J2EEProjectUtilities.isEARProject((IProject)comp.getProject());
    }

    public static boolean isEJBComponent(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null) {
            return J2EEUtils.isEJBComponent(vc);
        }
        return false;
    }

    public static boolean isEJBComponent(IVirtualComponent comp) {
        return J2EEProjectUtilities.isEJBProject((IProject)comp.getProject());
    }

    public static boolean isAppClientComponent(IVirtualComponent comp) {
        return J2EEProjectUtilities.isApplicationClientProject((IProject)comp.getProject());
    }

    public static boolean isJavaComponent(IVirtualComponent comp) {
        return J2EEProjectUtilities.isUtilityProject((IProject)comp.getProject());
    }

    public static String getComponentTypeId(IProject project) {
        return J2EEProjectUtilities.getJ2EEProjectType((IProject)project);
    }

    public static String[] toComponentNamesArray(IVirtualComponent[] components) {
        String[] ecNames = new String[components.length];
        int i = 0;
        while (i < components.length) {
            ecNames[i] = components[i].getName();
            ++i;
        }
        return ecNames;
    }

    public static IProject[] toProjectArray(IVirtualComponent[] components) {
        IProject[] projects = new IProject[components.length];
        int i = 0;
        while (i < components.length) {
            projects[i] = components[i].getProject();
            ++i;
        }
        return projects;
    }

    public static Integer getServletVersionForJ2EEVersion(String j2eeLevel) {
        int aVersion = Integer.valueOf(j2eeLevel);
        switch (aVersion) {
            case 12: {
                return new Integer(22);
            }
            case 13: {
                return new Integer(23);
            }
            case 14: {
                return new Integer(24);
            }
        }
        return new Integer(23);
    }

    public static Integer getEJBVersionForJ2EEVersion(String j2eeLevel) {
        int aVersion = Integer.valueOf(j2eeLevel);
        switch (aVersion) {
            case 12: {
                return new Integer(11);
            }
            case 13: {
                return new Integer(20);
            }
            case 14: {
                return new Integer(21);
            }
        }
        return new Integer(20);
    }

    public static boolean isJavaComponent(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null) {
            return J2EEUtils.isJavaComponent(vc);
        }
        try {
            IProjectFacetVersion pfv;
            Set facets;
            IFacetedProject fProject;
            if (project.exists() && ((fProject = ProjectFacetsManager.create((IProject)project)) != null ? (facets = fProject.getProjectFacets()).size() == 1 && (pfv = (IProjectFacetVersion)facets.iterator().next()).getProjectFacet().getId().equals("jst.java") : ResourceUtils.isJavaProject(project))) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean isWebComponent(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null) {
            return J2EEUtils.isWebComponent(vc);
        }
        return false;
    }

    public static boolean isAppClientComponent(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null) {
            return J2EEUtils.isAppClientComponent(vc);
        }
        return false;
    }

    public static boolean isEARComponent(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null) {
            return J2EEUtils.isEARComponent(vc);
        }
        return false;
    }

    public static IFolder getOutputContainerRoot(IVirtualComponent component) {
        return (IFolder)J2EEProjectUtilities.getOutputContainers((IProject)component.getProject())[0];
    }
}

