/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class AP1932
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1932(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String content_type = HTTPUtils.getHttpHeaderAttribute(entryContext.getMessageEntry().getHTTPHeaders(), "Content-Type");
        if (content_type == null || !content_type.equalsIgnoreCase("multipart/related")) {
            this.result = "notApplicable";
        } else {
            String subType = HTTPUtils.getHttpHeaderSubAttribute(entryContext.getMessageEntry().getHTTPHeaders(), "Content-Type", "type");
            if (subType == null || !subType.equalsIgnoreCase("text/xml")) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("The \"type\" parameter value is \"" + subType + "\"", entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

