/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CompoundMethodChooser;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.InstanceField;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.JavaClassAndMethodChooser;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.StaticField;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy {
    private static final boolean DEBUG_METHOD_LOOKUP = SystemProperties.getBoolean("hier.lookup.debug");
    public static final ObjectType EXCEPTION_TYPE = ObjectTypeFactory.getInstance("java.lang.Exception");
    public static final ObjectType ERROR_TYPE = ObjectTypeFactory.getInstance("java.lang.Error");
    public static final ObjectType RUNTIME_EXCEPTION_TYPE = ObjectTypeFactory.getInstance("java.lang.RuntimeException");
    static Map<ReferenceType, Map<ReferenceType, Boolean>> subtypeCache = new HashMap<ReferenceType, Map<ReferenceType, Boolean>>();
    public static final JavaClassAndMethodChooser ANY_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            return true;
        }
    };
    public static final JavaClassAndMethodChooser CONCRETE_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            Method method = javaClassAndMethod.getMethod();
            int accessFlags = method.getAccessFlags();
            return Hierarchy.accessFlagsAreConcrete(accessFlags);
        }
    };
    public static final JavaClassAndMethodChooser STATIC_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            return javaClassAndMethod.getMethod().isStatic();
        }
    };
    public static final JavaClassAndMethodChooser INSTANCE_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            return !javaClassAndMethod.getMethod().isStatic();
        }
    };

    public static boolean isSubtype(String clsName, String possibleSupertypeClassName) throws ClassNotFoundException {
        ObjectType cls = ObjectTypeFactory.getInstance(clsName);
        ObjectType superCls = ObjectTypeFactory.getInstance(possibleSupertypeClassName);
        return Hierarchy.isSubtype(cls, superCls);
    }

    public static boolean isSubtype(ReferenceType t, ReferenceType possibleSupertype) throws ClassNotFoundException {
        Boolean result;
        Map<ReferenceType, Boolean> subtypes = subtypeCache.get(possibleSupertype);
        if (subtypes == null) {
            subtypes = new HashMap<ReferenceType, Boolean>();
            subtypeCache.put(possibleSupertype, subtypes);
        }
        if ((result = subtypes.get(t)) == null) {
            result = t.isAssignmentCompatibleWith(possibleSupertype);
            subtypes.put(t, result);
        }
        return result;
    }

    public static boolean isUniversalExceptionHandler(ObjectType catchType) {
        return catchType == null || catchType.equals(Type.THROWABLE);
    }

    public static boolean isUncheckedException(ObjectType type) throws ClassNotFoundException {
        return Hierarchy.isSubtype(type, RUNTIME_EXCEPTION_TYPE) || Hierarchy.isSubtype(type, ERROR_TYPE);
    }

    public static boolean isMonitorWait(String methodName, String methodSig) {
        return methodName.equals("wait") && (methodSig.equals("()V") || methodSig.equals("(J)V") || methodSig.equals("(JI)V"));
    }

    public static boolean isMonitorWait(Instruction ins, ConstantPoolGen cpg) {
        if (!(ins instanceof InvokeInstruction)) {
            return false;
        }
        if (ins.getOpcode() == 184) {
            return false;
        }
        InvokeInstruction inv = (InvokeInstruction)ins;
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        return Hierarchy.isMonitorWait(methodName, methodSig);
    }

    public static boolean isMonitorNotify(String methodName, String methodSig) {
        return (methodName.equals("notify") || methodName.equals("notifyAll")) && methodSig.equals("()V");
    }

    public static boolean isMonitorNotify(Instruction ins, ConstantPoolGen cpg) {
        if (!(ins instanceof InvokeInstruction)) {
            return false;
        }
        if (ins.getOpcode() == 184) {
            return false;
        }
        InvokeInstruction inv = (InvokeInstruction)ins;
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        return Hierarchy.isMonitorNotify(methodName, methodSig);
    }

    public static JavaClassAndMethod findExactMethod(InvokeInstruction inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy.findExactMethod(inv, cpg, ANY_METHOD);
    }

    public static JavaClassAndMethod findExactMethod(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser chooser) throws ClassNotFoundException {
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        JavaClass jclass = Repository.lookupClass(className);
        return Hierarchy.findMethod(jclass, methodName, methodSig, chooser);
    }

    public static JavaClassAndMethod visitSuperClassMethods(JavaClassAndMethod method, JavaClassAndMethodChooser chooser) throws ClassNotFoundException {
        return Hierarchy.findMethod(method.getJavaClass().getSuperClasses(), method.getMethod().getName(), method.getMethod().getSignature(), chooser);
    }

    public static JavaClassAndMethod visitSuperInterfaceMethods(JavaClassAndMethod method, JavaClassAndMethodChooser chooser) throws ClassNotFoundException {
        return Hierarchy.findMethod(method.getJavaClass().getAllInterfaces(), method.getMethod().getName(), method.getMethod().getSignature(), chooser);
    }

    public static JavaClassAndMethod findInvocationLeastUpperBound(InvokeInstruction inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy.findInvocationLeastUpperBound(inv, cpg, ANY_METHOD);
    }

    public static JavaClassAndMethod findInvocationLeastUpperBound(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser methodChooser) throws ClassNotFoundException {
        JavaClassAndMethod result;
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println(new StringBuffer().append("Find prototype method for ").append(SignatureConverter.convertMethodSignature(inv, cpg)).toString());
        }
        short opcode = inv.getOpcode();
        if (methodChooser != ANY_METHOD) {
            methodChooser = new CompoundMethodChooser(new JavaClassAndMethodChooser[]{methodChooser, opcode == 184 ? STATIC_METHOD : INSTANCE_METHOD});
        }
        if (opcode == 183) {
            result = Hierarchy.findExactMethod(inv, cpg, methodChooser);
        } else {
            String className = inv.getClassName(cpg);
            String methodName = inv.getName(cpg);
            String methodSig = inv.getSignature(cpg);
            if (DEBUG_METHOD_LOOKUP) {
                System.out.println(new StringBuffer().append("[Class name is ").append(className).append("]").toString());
                System.out.println(new StringBuffer().append("[Method name is ").append(methodName).append("]").toString());
                System.out.println(new StringBuffer().append("[Method signature is ").append(methodSig).append("]").toString());
            }
            if (className.startsWith("[")) {
                className = "java.lang.Object";
            }
            if (opcode == 182 || opcode == 184) {
                if (DEBUG_METHOD_LOOKUP) {
                    System.out.println("[invokevirtual or invokestatic]");
                }
                if ((result = Hierarchy.findMethod(Repository.lookupClass(className), methodName, methodSig, methodChooser)) == null) {
                    if (DEBUG_METHOD_LOOKUP) {
                        System.out.println("[not in class, checking superclasses...]");
                    }
                    JavaClass[] superClassList = Repository.getSuperClasses(className);
                    result = Hierarchy.findMethod(superClassList, methodName, methodSig, methodChooser);
                }
            } else {
                result = Hierarchy.findMethod(Repository.lookupClass(className), methodName, methodSig, methodChooser);
                if (result == null) {
                    JavaClass[] interfaceList = Repository.getInterfaces(className);
                    result = Hierarchy.findMethod(interfaceList, methodName, methodSig, methodChooser);
                }
            }
        }
        return result;
    }

    public static ObjectType[] findDeclaredExceptions(InvokeInstruction inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        JavaClassAndMethod method = Hierarchy.findInvocationLeastUpperBound(inv, cpg);
        if (method == null) {
            return null;
        }
        ExceptionTable exTable = method.getMethod().getExceptionTable();
        if (exTable == null) {
            return new ObjectType[0];
        }
        String[] exNameList = exTable.getExceptionNames();
        ObjectType[] result = new ObjectType[exNameList.length];
        for (int i = 0; i < exNameList.length; ++i) {
            result[i] = ObjectTypeFactory.getInstance(exNameList[i]);
        }
        return result;
    }

    @CheckForNull
    public static JavaClassAndMethod findMethod(JavaClass javaClass, String methodName, String methodSig) {
        return Hierarchy.findMethod(javaClass, methodName, methodSig, ANY_METHOD);
    }

    @CheckForNull
    public static JavaClassAndMethod findMethod(JavaClass javaClass, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        Method[] methodList;
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println(new StringBuffer().append("Check ").append(javaClass.getClassName()).toString());
        }
        for (Method method : methodList = javaClass.getMethods()) {
            JavaClassAndMethod m;
            if (!method.getName().equals(methodName) || !method.getSignature().equals(methodSig) || !chooser.choose(m = new JavaClassAndMethod(javaClass, method))) continue;
            if (DEBUG_METHOD_LOOKUP) {
                System.out.println(new StringBuffer().append("\t==> FOUND: ").append(method).toString());
            }
            return m;
        }
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("\t==> NOT FOUND");
        }
        return null;
    }

    @CheckForNull
    public static JavaClassAndMethod findConcreteMethod(JavaClass javaClass, String methodName, String methodSig) {
        Method[] methodList;
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println(new StringBuffer().append("Check ").append(javaClass.getClassName()).toString());
        }
        for (Method method : methodList = javaClass.getMethods()) {
            if (!method.getName().equals(methodName) || !method.getSignature().equals(methodSig) || !Hierarchy.accessFlagsAreConcrete(method.getAccessFlags())) continue;
            JavaClassAndMethod m = new JavaClassAndMethod(javaClass, method);
            return m;
        }
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("\t==> NOT FOUND");
        }
        return null;
    }

    @CheckForNull
    public static XMethod findXMethod(JavaClass javaClass, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        JavaClassAndMethod result = Hierarchy.findMethod(javaClass, methodName, methodSig, chooser);
        return result == null ? null : XFactory.createXMethod(result.getJavaClass(), result.getMethod());
    }

    public static boolean accessFlagsAreConcrete(int accessFlags) {
        return (accessFlags & 0x400) == 0 && (accessFlags & 0x100) == 0;
    }

    public static JavaClassAndMethod findMethod(JavaClass[] classList, String methodName, String methodSig) {
        return Hierarchy.findMethod(classList, methodName, methodSig, ANY_METHOD);
    }

    public static JavaClassAndMethod findMethod(JavaClass[] classList, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        JavaClass cls;
        JavaClassAndMethod m = null;
        JavaClass[] arr$ = classList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (m = Hierarchy.findMethod(cls = arr$[i$], methodName, methodSig, chooser)) == null; ++i$) {
        }
        return m;
    }

    public static XMethod findXMethod(JavaClass[] classList, String methodName, String methodSig) {
        return Hierarchy.findXMethod(classList, methodName, methodSig, ANY_METHOD);
    }

    public static XMethod findXMethod(JavaClass[] classList, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        for (JavaClass cls : classList) {
            JavaClassAndMethod m = Hierarchy.findMethod(cls, methodName, methodSig);
            if (m == null || !chooser.choose(m)) continue;
            return XFactory.createXMethod(cls, m.getMethod());
        }
        return null;
    }

    public static Set<JavaClassAndMethod> resolveMethodCallTargets(InvokeInstruction invokeInstruction, TypeFrame typeFrame, ConstantPoolGen cpg) throws DataflowAnalysisException, ClassNotFoundException {
        boolean receiverTypeIsExact;
        Type receiverType;
        short opcode = invokeInstruction.getOpcode();
        if (opcode == 184) {
            HashSet<JavaClassAndMethod> result = new HashSet<JavaClassAndMethod>();
            JavaClassAndMethod targetMethod = Hierarchy.findInvocationLeastUpperBound(invokeInstruction, cpg, CONCRETE_METHOD);
            if (targetMethod != null) {
                result.add(targetMethod);
            }
            return result;
        }
        if (!typeFrame.isValid()) {
            return new HashSet<JavaClassAndMethod>();
        }
        if (opcode == 183) {
            receiverType = ObjectTypeFactory.getInstance(invokeInstruction.getClassName(cpg));
            receiverTypeIsExact = false;
        } else {
            int instanceStackLocation = typeFrame.getInstanceStackLocation(invokeInstruction, cpg);
            receiverType = (Type)typeFrame.getStackValue(instanceStackLocation);
            if (!(receiverType instanceof ReferenceType)) {
                return new HashSet<JavaClassAndMethod>();
            }
            receiverTypeIsExact = typeFrame.isExact(instanceStackLocation);
        }
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println(new StringBuffer().append("[receiver type is ").append(receiverType).append(", ").append(receiverTypeIsExact ? "exact]" : " not exact]").toString());
        }
        return Hierarchy.resolveMethodCallTargets(receiverType, invokeInstruction, cpg, receiverTypeIsExact);
    }

    public static Set<JavaClassAndMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy.resolveMethodCallTargets(receiverType, invokeInstruction, cpg, false);
    }

    public static Set<JavaClassAndMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg, boolean receiverTypeIsExact) throws ClassNotFoundException {
        boolean virtualCall;
        HashSet<JavaClassAndMethod> result = new HashSet<JavaClassAndMethod>();
        if (invokeInstruction.getOpcode() == 184) {
            throw new IllegalArgumentException();
        }
        String methodName = invokeInstruction.getName(cpg);
        String methodSig = invokeInstruction.getSignature(cpg);
        if (receiverType instanceof ArrayType) {
            JavaClass javaLangObject = AnalysisContext.currentAnalysisContext().lookupClass("java.lang.Object");
            JavaClassAndMethod classAndMethod = Hierarchy.findMethod(javaLangObject, methodName, methodSig, INSTANCE_METHOD);
            if (classAndMethod != null) {
                result.add(classAndMethod);
            }
            return result;
        }
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        JavaClass receiverClass = analysisContext.lookupClass(((ObjectType)receiverType).getClassName());
        JavaClassAndMethod upperBound = Hierarchy.findMethod(receiverClass, methodName, methodSig, CONCRETE_METHOD);
        if (upperBound == null) {
            JavaClass[] superClassList = receiverClass.getSuperClasses();
            upperBound = Hierarchy.findMethod(superClassList, methodName, methodSig, CONCRETE_METHOD);
        }
        if (upperBound != null) {
            if (DEBUG_METHOD_LOOKUP) {
                System.out.println(new StringBuffer().append("Adding upper bound: ").append(SignatureConverter.convertMethodSignature(upperBound.getJavaClass(), upperBound.getMethod())).toString());
            }
            result.add(upperBound);
        }
        boolean bl = virtualCall = invokeInstruction.getOpcode() != 183 && !receiverTypeIsExact;
        if (virtualCall) {
            Set<JavaClass> subTypeSet = analysisContext.getSubtypes().getTransitiveSubtypes(receiverClass);
            for (JavaClass subtype : subTypeSet) {
                JavaClassAndMethod concreteSubtypeMethod = Hierarchy.findMethod(subtype, methodName, methodSig, CONCRETE_METHOD);
                if (concreteSubtypeMethod == null) continue;
                result.add(concreteSubtypeMethod);
            }
        }
        return result;
    }

    public static Field findField(String className, String fieldName) throws ClassNotFoundException {
        for (JavaClass jclass = Repository.lookupClass(className); jclass != null; jclass = jclass.getSuperClass()) {
            Field[] fieldList;
            for (Field field : fieldList = jclass.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public static XField findXField(String className, String fieldName, String fieldSig) throws ClassNotFoundException {
        JavaClass classDefiningField;
        AccessFlags field = null;
        block0: for (classDefiningField = Repository.lookupClass(className); classDefiningField != null; classDefiningField = classDefiningField.getSuperClass()) {
            Field[] fieldList;
            for (Field aFieldList : fieldList = classDefiningField.getFields()) {
                field = aFieldList;
                if (((FieldOrMethod)field).getName().equals(fieldName) && ((FieldOrMethod)field).getSignature().equals(fieldSig)) break block0;
            }
        }
        if (classDefiningField == null || field == null) {
            return null;
        }
        String realClassName = classDefiningField.getClassName();
        int accessFlags = field.getAccessFlags();
        return field.isStatic() ? new StaticField(realClassName, fieldName, fieldSig, accessFlags) : new InstanceField(realClassName, fieldName, fieldSig, accessFlags);
    }

    public static XField findXField(FieldInstruction fins, @NonNull ConstantPoolGen cpg) throws ClassNotFoundException {
        String className = fins.getClassName(cpg);
        String fieldName = fins.getFieldName(cpg);
        String fieldSig = fins.getSignature(cpg);
        XField xfield = Hierarchy.findXField(className, fieldName, fieldSig);
        short opcode = fins.getOpcode();
        if (xfield != null && xfield.isStatic() == (opcode == 178 || opcode == 179)) {
            return xfield;
        }
        return null;
    }

    public static boolean isInnerClassAccess(INVOKESTATIC inv, ConstantPoolGen cpg) {
        String methodName = inv.getName(cpg);
        return methodName.startsWith("access$");
    }

    public static InnerClassAccess getInnerClassAccess(INVOKESTATIC inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        InnerClassAccess access = AnalysisContext.currentAnalysisContext().getInnerClassAccessMap().getInnerClassAccess(className, methodName);
        return access != null && access.getMethodSignature().equals(methodSig) ? access : null;
    }
}

