/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientListProcessor
extends MulticastProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientListProcessor.class);
    private final Iterator<Object> iter;
    private boolean ignoreInvalidEndpoints;
    private ProducerCache producerCache;

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<Object> iter) {
        super(camelContext, null);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<Object> iter, AggregationStrategy aggregationStrategy) {
        super(camelContext, null, aggregationStrategy);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    @Deprecated
    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<Object> iter, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork) {
        super(camelContext, null, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, shareUnitOfWork, false);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<Object> iter, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate) {
        super(camelContext, null, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, shareUnitOfWork, parallelAggregate);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        int index = 0;
        while (this.iter.hasNext()) {
            Producer producer;
            Endpoint endpoint;
            Object recipient = this.iter.next();
            try {
                endpoint = RecipientListProcessor.resolveEndpoint(exchange, recipient);
                producer = this.producerCache.acquireProducer(endpoint);
            }
            catch (Exception e) {
                if (this.isIgnoreInvalidEndpoints()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", (Throwable)e);
                    continue;
                }
                throw e;
            }
            result.add(this.createProcessorExchangePair(index++, endpoint, producer, exchange));
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Endpoint endpoint, Producer producer, Exchange exchange) {
        Processor prepared = producer;
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        if (this.isShareUnitOfWork()) {
            this.prepareSharedUnitOfWork(copy, exchange);
        }
        RecipientListProcessor.setToEndpoint(copy, prepared);
        RouteContext routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
        prepared = this.createErrorHandler(routeContext, copy, prepared);
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(copy);
            }
            catch (Exception e) {
                copy.setException(e);
            }
        }
        return new RecipientProcessorExchangePair(index, this.producerCache, endpoint, producer, prepared, copy);
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(this, this.getCamelContext());
        }
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache);
        super.doStop();
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.producerCache);
        super.doShutdown();
    }

    @Override
    public String toString() {
        return "RecipientList";
    }

    @Override
    public String getTraceLabel() {
        return "recipientList";
    }

    static final class RecipientProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Endpoint endpoint;
        private final Producer producer;
        private Processor prepared;
        private final Exchange exchange;
        private final ProducerCache producerCache;

        private RecipientProcessorExchangePair(int index, ProducerCache producerCache, Endpoint endpoint, Producer producer, Processor prepared, Exchange exchange) {
            this.index = index;
            this.producerCache = producerCache;
            this.endpoint = endpoint;
            this.producer = producer;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public Producer getProducer() {
            return this.producer;
        }

        @Override
        public Processor getProcessor() {
            return this.prepared;
        }

        @Override
        public void begin() {
            LOG.trace("RecipientProcessorExchangePair #{} begin: {}", (Object)this.index, (Object)this.exchange);
            this.exchange.setProperty("CamelRecipientListEndpoint", this.endpoint.getEndpointUri());
            MessageHelper.resetStreamCache(this.exchange.getIn());
        }

        @Override
        public void done() {
            block2: {
                LOG.trace("RecipientProcessorExchangePair #{} done: {}", (Object)this.index, (Object)this.exchange);
                try {
                    this.producerCache.releaseProducer(this.endpoint, this.producer);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("Error releasing producer: " + this.producer + ". This exception will be ignored.", (Throwable)e);
                }
            }
        }
    }
}

